/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 364
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SToken yy57;
  EOrder yy162;
  EJoinType yy204;
  SAlterOption yy221;
  int32_t yy228;
  EFillMode yy270;
  EOperatorType yy324;
  int64_t yy389;
  SNode* yy392;
  SDataType yy448;
  bool yy481;
  ENullOrder yy529;
  SNodeList* yy600;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             641
#define YYNRULE              466
#define YYNTOKEN             242
#define YY_MAX_SHIFT         640
#define YY_MIN_SHIFTREDUCE   933
#define YY_MAX_SHIFTREDUCE   1398
#define YY_ERROR_ACTION      1399
#define YY_ACCEPT_ACTION     1400
#define YY_NO_ACTION         1401
#define YY_MIN_REDUCE        1402
#define YY_MAX_REDUCE        1867
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2192)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1697, 1845, 1522,  309,  412, 1697,  413, 1434,  326, 1400,
 /*    10 */   137, 1694,   37,   35, 1490, 1844, 1694, 1710,  417, 1842,
 /*    20 */   318,  556, 1208,  556, 1230,   38,   36,   34,   33,   32,
 /*    30 */   325,  324,  109,  420,  109,  413, 1434, 1690, 1696,  451,
 /*    40 */  1222,  456, 1690, 1696, 1726,   30,  240, 1206,  559, 1533,
 /*    50 */  1793, 1533,  540,  559,   22,  556,  555, 1680,   14,  539,
 /*    60 */    37,   35, 1335,  322, 1214, 1215,  157,  335,  318, 1710,
 /*    70 */  1208,  134,  520,  365, 1790,   38,   36,   34,   33,   32,
 /*    80 */  1535,    1, 1214, 1533, 1739,   67,  555,   85, 1711,  542,
 /*    90 */  1713, 1714,  538,   58,  559, 1206, 1726, 1779,  113,   76,
 /*   100 */   371,  292, 1775,  637,  519,  556,   14, 1528, 1845, 1680,
 /*   110 */  1425,  539, 1214, 1845, 1845,  543,  369, 1277, 1278,  963,
 /*   120 */  1526,  560,  152,  470,  555, 1631, 1842,  154,  152,    2,
 /*   130 */   430, 1842, 1842, 1533,  206,   82, 1739,  290,  478,   86,
 /*   140 */  1711,  542, 1713, 1714,  538, 1369,  559,   40,  118, 1779,
 /*   150 */  1680,  637,  198,  311, 1775,  148, 1525,  967,  968, 1209,
 /*   160 */    58, 1207,   70,  328,  473, 1277, 1278,  232,   56,  467,
 /*   170 */   364,  134,  363, 1233,  197,  495, 1806, 1223,  330, 1218,
 /*   180 */  1535, 1578, 1580, 1212, 1213,   41, 1259, 1260, 1262, 1263,
 /*   190 */  1264, 1265, 1266,  535,  557, 1274, 1275, 1276, 1279,   53,
 /*   200 */  1232, 1226,   52, 1579, 1580,   26,   59, 1209, 1845, 1207,
 /*   210 */   510,  155,  557, 1274, 1275,   38,   36,   34,   33,   32,
 /*   220 */    37,   35,  153,  155, 1424, 1710, 1842,  402,  318,   67,
 /*   230 */  1208, 1212, 1213,  302, 1259, 1260, 1262, 1263, 1264, 1265,
 /*   240 */  1266,  535,  557, 1274, 1275, 1276, 1279,  516, 1726,  465,
 /*   250 */   464, 1529, 1726,  489,  463, 1206,  509,  114,  460, 1668,
 /*   260 */   540,  459,  458,  457, 1680, 1680,   14,  539,   37,   35,
 /*   270 */  1112, 1113, 1214,  166,  165,  117,  318,  155, 1208, 1299,
 /*   280 */   520, 1511,  303,   58,  301,  300,  356,  453,   58,    2,
 /*   290 */   155,  455, 1739,  508, 1845,   85, 1711,  542, 1713, 1714,
 /*   300 */   538, 1304,  559, 1206,  344, 1779,  358,  354,  152,  292,
 /*   310 */  1775,  637, 1842,  454,  115,   38,   36,   34,   33,   32,
 /*   320 */  1214, 1845,  136, 1524, 1414, 1277, 1278, 1509,  518,  149,
 /*   330 */  1786, 1787, 1233, 1791, 1694,  152,   27,    8,  430, 1842,
 /*   340 */  1070,  582,  581,  580, 1074,  579, 1076, 1077,  578, 1079,
 /*   350 */   575, 1403, 1085,  572, 1087, 1088,  569,  566,   81,  637,
 /*   360 */  1690, 1696,   38,   36,   34,   33,   32, 1209,   78, 1207,
 /*   370 */  1359,  559,   99, 1277, 1278,   98,   97,   96,   95,   94,
 /*   380 */    93,   92,   91,   90,  593, 1349,   38,   36,   34,   33,
 /*   390 */    32, 1212, 1213,  522, 1259, 1260, 1262, 1263, 1264, 1265,
 /*   400 */  1266,  535,  557, 1274, 1275, 1276, 1279,  502, 1357, 1358,
 /*   410 */  1360, 1361,  980,  155,  979, 1209,   99, 1207,  155,   98,
 /*   420 */    97,   96,   95,   94,   93,   92,   91,   90,   37,   35,
 /*   430 */  1280,   11,   10, 1710,  462,  461,  318,  162, 1208, 1212,
 /*   440 */  1213,  981, 1259, 1260, 1262, 1263, 1264, 1265, 1266,  535,
 /*   450 */   557, 1274, 1275, 1276, 1279,   38,   36,   34,   33,   32,
 /*   460 */  1726,  479,   65, 1206, 1845,   64,  593,  155,  540,  980,
 /*   470 */   147,  979, 1585, 1680, 1231,  539,   37,   35, 1843,  308,
 /*   480 */  1214, 1461, 1842, 1572,  318, 1793, 1208, 1423, 1583, 1214,
 /*   490 */    38,   36,   34,   33,   32, 1422,  449,    9,  981, 1234,
 /*   500 */  1739, 1395, 1845,   87, 1711,  542, 1713, 1714,  538, 1789,
 /*   510 */   559, 1206, 1311, 1779,  199,  134,  152, 1778, 1775,  637,
 /*   520 */  1842,  543,  133, 1585, 1536, 1246, 1342, 1680, 1214,  321,
 /*   530 */   323, 1630, 1232, 1277, 1278, 1680,  293,  609,  607, 1583,
 /*   540 */  1421,  615,  614,  613,  333,    9,  612,  611,  610,  119,
 /*   550 */   605,  604,  603,  602,  601,  600,  599,  598,  127,  594,
 /*   560 */  1246, 1402,   38,   36,   34,   33,   32,  637, 1297,  505,
 /*   570 */    69,  291, 1285,  967,  968, 1209, 1420, 1207, 1232, 1419,
 /*   580 */  1680, 1277, 1278, 1394,   28,  108,  107,  106,  105,  104,
 /*   590 */   103,  102,  101,  100,   38,   36,   34,   33,   32, 1212,
 /*   600 */  1213, 1510, 1259, 1260, 1262, 1263, 1264, 1265, 1266,  535,
 /*   610 */   557, 1274, 1275, 1276, 1279,  556, 1680, 1585, 1585, 1680,
 /*   620 */  1298,  331,  585, 1209,  329, 1207,  370,  231, 1518,  134,
 /*   630 */    34,   33,   32, 1583, 1584, 1418,   37,   35, 1535,  511,
 /*   640 */   506,  200, 1303, 1533,  318,  591, 1208, 1212, 1213, 1417,
 /*   650 */  1259, 1260, 1262, 1263, 1264, 1265, 1266,  535,  557, 1274,
 /*   660 */  1275, 1276, 1279,  556,  125,  124,  588,  587,  586,  411,
 /*   670 */   419, 1206,  415,  415,  372, 1680,  556,   29,  316, 1292,
 /*   680 */  1293, 1294, 1295, 1296, 1300, 1301, 1302,  387, 1214, 1680,
 /*   690 */   185, 1533,  556,  263,  591,  597, 1563, 1505, 1416, 1261,
 /*   700 */  1190, 1191,  140,  388, 1533,    2, 1413,  556,  447,  443,
 /*   710 */   439,  435,  184,  125,  124,  588,  587,  586,  429, 1793,
 /*   720 */  1533, 1698, 1710, 1334,  289, 1232, 1230,  637, 1412, 1700,
 /*   730 */  1411,  455, 1694,  395,    7, 1533,  407,   68, 1680,  556,
 /*   740 */   182, 1277, 1278, 1788,  556, 1261, 1680, 1410, 1409, 1726,
 /*   750 */  1530,  380, 1235,  454,  408, 1657,  382,  540, 1690, 1696,
 /*   760 */   135,  524, 1680,  556,  539,  269, 1702, 1533, 1680,  559,
 /*   770 */  1680, 1621, 1533,  556,  487,  496,  589,  267,   55, 1576,
 /*   780 */   527,   54,  164, 1209,  553, 1207,  373, 1680, 1680, 1739,
 /*   790 */   596, 1533,  287, 1711,  542, 1713, 1714,  538,  167,  559,
 /*   800 */   181, 1533,  173, 1464,  178, 1520,  425, 1212, 1213, 1408,
 /*   810 */  1259, 1260, 1262, 1263, 1264, 1265, 1266,  535,  557, 1274,
 /*   820 */  1275, 1276, 1279,   58,  590,  171,  406, 1576, 1516,  401,
 /*   830 */   400,  399,  398,  397,  394,  393,  392,  391,  390,  386,
 /*   840 */   385,  384,  383,  377,  376,  375,  374,  203, 1032, 1680,
 /*   850 */    38,   36,   34,   33,   32,  556,  556, 1208,  556,  516,
 /*   860 */  1407,   84, 1406,  465,  464, 1034,  554,  253,  463,  332,
 /*   870 */  1405,  114,  460, 1798, 1330,  459,  458,  457,  608, 1451,
 /*   880 */   212,  534, 1206, 1533, 1533,  190, 1533,  117,  188,  486,
 /*   890 */  1710, 1508, 1261,   62,   61,  368,  293, 1217,  161, 1214,
 /*   900 */  1680,  466, 1680,  192,  362,  516,  191, 1330,  194,  196,
 /*   910 */  1680,  193,  195, 1446, 1444,  288,  584, 1726,  352,  359,
 /*   920 */   350,  346,  342,  158,  337,  519,  115,  477, 1297, 1415,
 /*   930 */  1680, 1333,  539,  117, 1216,  468,  471,  123,  637, 1004,
 /*   940 */   475,  150, 1786, 1787,  532, 1791,  235,   11,   10,   48,
 /*   950 */   525,  216, 1491,  155,  448,  503, 1005, 1739, 1710,  480,
 /*   960 */    86, 1711,  542, 1713, 1714,  538, 1440,  559, 1397, 1398,
 /*   970 */  1779,  528,  115,   39,  311, 1775,  148,  223,  491,   39,
 /*   980 */  1298, 1727, 1710,  334,  591, 1726,   39,  151, 1786, 1787,
 /*   990 */  1356, 1791,  218,  540, 1209,  242, 1207, 1807, 1680, 1435,
 /*  1000 */   539, 1573, 1303,  125,  124,  588,  587,  586, 1809, 1726,
 /*  1010 */   121, 1220,  633,  517, 1305,  234,  237,  540, 1212, 1213,
 /*  1020 */  1267,  239, 1680, 1710,  539, 1739,    3, 1163,  272, 1711,
 /*  1030 */   542, 1713, 1714,  538,  122,  559,  244,   29,  316, 1292,
 /*  1040 */  1293, 1294, 1295, 1296, 1300, 1301, 1302,  123, 1219, 1739,
 /*  1050 */  1726,  548,   86, 1711,  542, 1713, 1714,  538,  540,  559,
 /*  1060 */    48,  564, 1779, 1680, 1710,  539,  311, 1775, 1858, 1289,
 /*  1070 */   122,  123,  110,  122,    5,  250,  336, 1813, 1230,  339,
 /*  1080 */   343,  298, 1174, 1032,  299,  259,  389,  163, 1063,  396,
 /*  1090 */  1739, 1726, 1623,   86, 1711,  542, 1713, 1714,  538,  540,
 /*  1100 */   559,  262, 1091, 1779, 1680,  404,  539,  311, 1775, 1858,
 /*  1110 */   403, 1095, 1102, 1100,  126,  405,  409, 1236, 1836,  410,
 /*  1120 */   418, 1239,  421,  170,  172, 1238,  422,  423, 1240,  426,
 /*  1130 */   424, 1739,  175,  177,   86, 1711,  542, 1713, 1714,  538,
 /*  1140 */  1710,  559,  427, 1237, 1779,  428,  180,  450,  311, 1775,
 /*  1150 */  1858,  431,  452,   66,  183, 1523,  187, 1519,  481, 1797,
 /*  1160 */   189,  128,  307,   89,  260,  129, 1521, 1726,  482,  485,
 /*  1170 */   201,  204,  488, 1517,  130,  540,  131,  490,  207, 1235,
 /*  1180 */  1680,  210,  539, 1810,  504,  546,    6,  492, 1662, 1820,
 /*  1190 */  1661, 1819,  513, 1800,  222,  520,  142,  499,  500,  224,
 /*  1200 */   498,  225,  493, 1710,  501, 1330,  310, 1739,  497,  226,
 /*  1210 */   278, 1711,  542, 1713, 1714,  538,  507,  559,  214,  217,
 /*  1220 */  1710,  116, 1234,   42, 1841,   18,  526,  529,  227,  523,
 /*  1230 */  1726,  233,  312, 1861,  544,  545, 1845,  320,  540, 1794,
 /*  1240 */  1629,  549,  246, 1680, 1628,  539,  551, 1726,  261,  550,
 /*  1250 */   154,   77, 1534,  248, 1842,  540,   75,  562,  520,  264,
 /*  1260 */  1680,  228,  539, 1760, 1577, 1506,  256,   49,  636,  266,
 /*  1270 */  1739,  270, 1674,  278, 1711,  542, 1713, 1714,  538,  279,
 /*  1280 */   559,  271,  268, 1710,  141,  236, 1673, 1739,  530,   60,
 /*  1290 */    87, 1711,  542, 1713, 1714,  538,  238,  559, 1672, 1845,
 /*  1300 */  1779, 1710,  338, 1669,  531, 1775,  340,  341, 1201, 1202,
 /*  1310 */  1726,  159,  345,  152, 1667,  347,  348, 1842,  537,  349,
 /*  1320 */  1666, 1665,  351, 1680,  353,  539, 1664,  355, 1726, 1663,
 /*  1330 */   357, 1647,  160,  360,  361, 1177,  540, 1176, 1641, 1640,
 /*  1340 */   366, 1680,  367,  539, 1639, 1638, 1149, 1616,   63, 1615,
 /*  1350 */  1739,  378, 1710,  286, 1711,  542, 1713, 1714,  538,  536,
 /*  1360 */   559,  533, 1751, 1614, 1613, 1612, 1611, 1610, 1739,  379,
 /*  1370 */   640,  138, 1711,  542, 1713, 1714,  538,  381,  559, 1726,
 /*  1380 */  1609, 1608, 1607, 1606,  258, 1605, 1604,  540, 1603, 1602,
 /*  1390 */  1601, 1600, 1680,  516,  539, 1599,  145, 1598, 1597, 1596,
 /*  1400 */   120, 1595,  631,  627,  623,  619,  257, 1594, 1593, 1592,
 /*  1410 */  1591, 1590, 1589, 1710, 1151, 1588,  521, 1859, 1587, 1739,
 /*  1420 */  1586,  117,   87, 1711,  542, 1713, 1714,  538, 1463,  559,
 /*  1430 */  1431,   83, 1779,  168,  251,  146,  970, 1776,  969,  111,
 /*  1440 */  1726,  520, 1430,  169,  414, 1655, 1649,  416,  540, 1637,
 /*  1450 */   112,  174, 1636, 1680,  176,  539, 1626, 1512,  179, 1462,
 /*  1460 */   115, 1460,  434,  998,  433, 1458, 1710,  552,  438, 1456,
 /*  1470 */   432, 1454,  437,  436,  441,  229, 1786,  515,  442,  514,
 /*  1480 */  1739,  440, 1845,  282, 1711,  542, 1713, 1714,  538, 1710,
 /*  1490 */   559,  444,  445, 1726, 1443,  494,  154,  446,  208, 1442,
 /*  1500 */  1842,  540, 1429, 1514,  186, 1106, 1680,  516,  539, 1105,
 /*  1510 */  1513, 1031, 1452, 1030, 1029, 1028, 1726, 1182,  606,  202,
 /*  1520 */   608, 1025,  512,   47,  540, 1024,  304, 1023, 1447, 1680,
 /*  1530 */   305,  539,  469, 1739, 1445,  117,  138, 1711,  542, 1713,
 /*  1540 */  1714,  538,  315,  559,  306, 1710, 1428,  472,  474, 1427,
 /*  1550 */    88,  476, 1654, 1184,   51,  520, 1739, 1648,  483,  287,
 /*  1560 */  1711,  542, 1713, 1714,  538, 1635,  559, 1634, 1633, 1625,
 /*  1570 */    71,   15, 1726,    4,  115,  209,   39, 1371,   23,  213,
 /*  1580 */   537,  205, 1860,  484,   45, 1680,  211,  539,   50,  229,
 /*  1590 */  1786,  515,  139,  514,  220,  215, 1845,  132, 1710, 1355,
 /*  1600 */   219,   24,  221, 1348, 1700,   72,  230, 1710,  143, 1327,
 /*  1610 */   152,   25, 1739, 1326, 1842,  286, 1711,  542, 1713, 1714,
 /*  1620 */   538, 1710,  559,   44, 1752, 1726, 1388,   17, 1383, 1377,
 /*  1630 */    10, 1382,  313,  540, 1726, 1387, 1386,  314, 1680,   19,
 /*  1640 */   539, 1269,  540, 1268,   31, 1290,  144, 1680, 1726,  539,
 /*  1650 */   156,  317,   16,   12,   13,   20,  540,   43, 1254,   21,
 /*  1660 */   319, 1680, 1710,  539, 1624, 1739,  541,  247,  287, 1711,
 /*  1670 */   542, 1713, 1714,  538, 1739,  559,  241,  287, 1711,  542,
 /*  1680 */  1713, 1714,  538, 1710,  559, 1353,  243,  547, 1739, 1726,
 /*  1690 */   245,  273, 1711,  542, 1713, 1714,  538,  540,  559,   73,
 /*  1700 */    74,   78, 1680, 1699,  539,  252, 1742, 1224, 1271,  249,
 /*  1710 */  1726, 1092,  558,   46,  561,  563,  327, 1089,  540,  565,
 /*  1720 */   567,  568,  570, 1680, 1086,  539,  571,  573, 1080, 1739,
 /*  1730 */   574,  576,  274, 1711,  542, 1713, 1714,  538, 1078,  559,
 /*  1740 */  1069, 1710, 1084,  583,  577, 1101, 1083,   79, 1082, 1081,
 /*  1750 */  1739,   80, 1710,  281, 1711,  542, 1713, 1714,  538,   57,
 /*  1760 */   559,  254, 1097, 1710,  996,  592, 1020,  595, 1726,  255,
 /*  1770 */  1038, 1013, 1018, 1017, 1016, 1035,  540, 1015, 1014, 1726,
 /*  1780 */  1012, 1680, 1011,  539, 1033, 1008, 1007,  540, 1006, 1003,
 /*  1790 */  1726, 1002, 1680, 1001,  539, 1459,  617,  616,  540,  618,
 /*  1800 */  1457,  620,  621, 1680,  622,  539, 1455,  624, 1739,  625,
 /*  1810 */   626,  283, 1711,  542, 1713, 1714,  538, 1453,  559, 1739,
 /*  1820 */   629,  628,  275, 1711,  542, 1713, 1714,  538, 1710,  559,
 /*  1830 */  1739,  630, 1441,  284, 1711,  542, 1713, 1714,  538,  632,
 /*  1840 */   559, 1426,  634,  635, 1710, 1210,  265,  638,  639, 1401,
 /*  1850 */  1401, 1401, 1401, 1401, 1401, 1726, 1401, 1401, 1401, 1401,
 /*  1860 */  1401, 1401, 1401,  540, 1401, 1401, 1401, 1401, 1680, 1401,
 /*  1870 */   539, 1726, 1401, 1401, 1401, 1401, 1401, 1401, 1401,  540,
 /*  1880 */  1401, 1401, 1401, 1401, 1680, 1401,  539, 1401, 1401, 1401,
 /*  1890 */  1401, 1401, 1401, 1710, 1401, 1739, 1401, 1401,  276, 1711,
 /*  1900 */   542, 1713, 1714,  538, 1401,  559, 1401, 1710, 1401, 1401,
 /*  1910 */  1401, 1739, 1401, 1401,  285, 1711,  542, 1713, 1714,  538,
 /*  1920 */  1726,  559, 1401, 1401, 1401, 1401, 1401, 1401,  540, 1401,
 /*  1930 */  1401, 1401, 1401, 1680, 1726,  539, 1401, 1401, 1401, 1401,
 /*  1940 */  1401, 1401,  540, 1401, 1401, 1401, 1401, 1680, 1710,  539,
 /*  1950 */  1401, 1401, 1401, 1401, 1401, 1401, 1401, 1401, 1401, 1401,
 /*  1960 */  1739, 1401, 1401,  277, 1711,  542, 1713, 1714,  538, 1710,
 /*  1970 */   559, 1401, 1401, 1401, 1739, 1726, 1401, 1722, 1711,  542,
 /*  1980 */  1713, 1714,  538,  540,  559, 1401, 1401, 1401, 1680, 1401,
 /*  1990 */   539, 1401, 1401, 1401, 1401, 1401, 1726, 1401, 1401, 1401,
 /*  2000 */  1401, 1401, 1401, 1401,  540, 1401, 1401, 1401, 1401, 1680,
 /*  2010 */  1401,  539, 1401, 1401, 1401, 1739, 1401, 1401, 1721, 1711,
 /*  2020 */   542, 1713, 1714,  538, 1401,  559, 1401, 1710, 1401, 1401,
 /*  2030 */  1401, 1401, 1401, 1401, 1401, 1401, 1739, 1401, 1710, 1720,
 /*  2040 */  1711,  542, 1713, 1714,  538, 1401,  559, 1401, 1401, 1710,
 /*  2050 */  1401, 1401, 1401, 1401, 1726, 1401, 1401, 1401, 1401, 1401,
 /*  2060 */  1401, 1401,  540, 1401, 1401, 1726, 1401, 1680, 1401,  539,
 /*  2070 */  1401, 1401, 1401,  540, 1401, 1401, 1726, 1401, 1680, 1401,
 /*  2080 */   539, 1401, 1401, 1401,  540, 1401, 1401, 1401, 1401, 1680,
 /*  2090 */  1710,  539, 1401, 1401, 1739, 1401, 1401,  296, 1711,  542,
 /*  2100 */  1713, 1714,  538, 1401,  559, 1739, 1401, 1401,  295, 1711,
 /*  2110 */   542, 1713, 1714,  538, 1710,  559, 1739, 1726, 1401,  297,
 /*  2120 */  1711,  542, 1713, 1714,  538,  540,  559, 1401, 1401, 1401,
 /*  2130 */  1680, 1401,  539, 1401, 1401, 1401, 1401, 1401, 1401, 1401,
 /*  2140 */  1401, 1726, 1401, 1401, 1401, 1401, 1401, 1401, 1401,  540,
 /*  2150 */  1401, 1401, 1401, 1401, 1680, 1401,  539, 1739, 1401, 1401,
 /*  2160 */   294, 1711,  542, 1713, 1714,  538, 1401,  559, 1401, 1401,
 /*  2170 */  1401, 1401, 1401, 1401, 1401, 1401, 1401, 1401, 1401, 1401,
 /*  2180 */  1401, 1739, 1401, 1401,  280, 1711,  542, 1713, 1714,  538,
 /*  2190 */  1401,  559,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   274,  341,  273,  277,  248,  274,  250,  251,  277,  242,
 /*    10 */   257,  285,   12,   13,  261,  355,  285,  245,   14,  359,
 /*    20 */    20,  252,   22,  252,   20,   12,   13,   14,   15,   16,
 /*    30 */    12,   13,  263,  248,  263,  250,  251,  311,  312,  270,
 /*    40 */    22,  270,  311,  312,  272,  326,  327,   47,  322,  280,
 /*    50 */   313,  280,  280,  322,   41,  252,   20,  285,   58,  287,
 /*    60 */    12,   13,   14,  264,   64,   47,  263,  300,   20,  245,
 /*    70 */    22,  272,  300,  300,  337,   12,   13,   14,   15,   16,
 /*    80 */   281,   81,   64,  280,  312,  256,   20,  315,  316,  317,
 /*    90 */   318,  319,  320,   81,  322,   47,  272,  325,  269,  254,
 /*   100 */   252,  329,  330,  103,  280,  252,   58,  278,  341,  285,
 /*   110 */   245,  287,   64,  341,  341,  287,  263,  117,  118,    4,
 /*   120 */   275,  103,  355,    4,   20,  297,  359,  355,  355,   81,
 /*   130 */    57,  359,  359,  280,   55,  254,  312,  289,   19,  315,
 /*   140 */   316,  317,  318,  319,  320,   82,  322,   81,  267,  325,
 /*   150 */   285,  103,   33,  329,  330,  331,  275,   42,   43,  159,
 /*   160 */    81,  161,   83,  264,   45,  117,  118,  343,    3,   50,
 /*   170 */   158,  272,  160,   20,   55,  351,  352,  159,  283,  161,
 /*   180 */   281,  286,  287,  183,  184,   81,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  198,   80,
 /*   200 */    20,  183,   83,  286,  287,    2,    4,  159,  341,  161,
 /*   210 */    20,  211,  194,  195,  196,   12,   13,   14,   15,   16,
 /*   220 */    12,   13,  355,  211,  245,  245,  359,   75,   20,  256,
 /*   230 */    22,  183,  184,   35,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,  197,  198,  252,  272,   60,
 /*   250 */    61,  278,  272,  300,   65,   47,  280,   68,   69,    0,
 /*   260 */   280,   72,   73,   74,  285,  285,   58,  287,   12,   13,
 /*   270 */   117,  118,   64,  121,  122,  280,   20,  211,   22,  142,
 /*   280 */   300,    0,   84,   81,   86,   87,  154,   89,   81,   81,
 /*   290 */   211,   93,  312,  317,  341,  315,  316,  317,  318,  319,
 /*   300 */   320,  164,  322,   47,   45,  325,  174,  175,  355,  329,
 /*   310 */   330,  103,  359,  115,  319,   12,   13,   14,   15,   16,
 /*   320 */    64,  341,  244,  274,  246,  117,  118,    0,  333,  334,
 /*   330 */   335,  336,   20,  338,  285,  355,  199,   81,   57,  359,
 /*   340 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   350 */   104,    0,  106,  107,  108,  109,  110,  111,   81,  103,
 /*   360 */   311,  312,   12,   13,   14,   15,   16,  159,   91,  161,
 /*   370 */   183,  322,   21,  117,  118,   24,   25,   26,   27,   28,
 /*   380 */    29,   30,   31,   32,   57,   82,   12,   13,   14,   15,
 /*   390 */    16,  183,  184,  228,  186,  187,  188,  189,  190,  191,
 /*   400 */   192,  193,  194,  195,  196,  197,  198,  220,  221,  222,
 /*   410 */   223,  224,   20,  211,   22,  159,   21,  161,  211,   24,
 /*   420 */    25,   26,   27,   28,   29,   30,   31,   32,   12,   13,
 /*   430 */    14,    1,    2,  245,  258,  259,   20,   55,   22,  183,
 /*   440 */   184,   49,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   450 */   194,  195,  196,  197,  198,   12,   13,   14,   15,   16,
 /*   460 */   272,  300,   80,   47,  341,   83,   57,  211,  280,   20,
 /*   470 */   271,   22,  272,  285,   20,  287,   12,   13,  355,  279,
 /*   480 */    64,    0,  359,  284,   20,  313,   22,  245,  288,   64,
 /*   490 */    12,   13,   14,   15,   16,  245,   47,   81,   49,   20,
 /*   500 */   312,  151,  341,  315,  316,  317,  318,  319,  320,  337,
 /*   510 */   322,   47,   82,  325,  113,  272,  355,  329,  330,  103,
 /*   520 */   359,  287,  148,  272,  281,   82,   14,  285,   64,  295,
 /*   530 */   279,  297,   20,  117,  118,  285,   58,  258,  259,  288,
 /*   540 */   245,   60,   61,   62,   63,   81,   65,   66,   67,   68,
 /*   550 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   560 */    82,    0,   12,   13,   14,   15,   16,  103,   90,  146,
 /*   570 */   169,  170,   14,   42,   43,  159,  245,  161,   20,  245,
 /*   580 */   285,  117,  118,  233,    2,   24,   25,   26,   27,   28,
 /*   590 */    29,   30,   31,   32,   12,   13,   14,   15,   16,  183,
 /*   600 */   184,    0,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   610 */   194,  195,  196,  197,  198,  252,  285,  272,  272,  285,
 /*   620 */   142,  264,   92,  159,  279,  161,  263,  148,  273,  272,
 /*   630 */    14,   15,   16,  288,  288,  245,   12,   13,  281,  216,
 /*   640 */   217,  112,  164,  280,   20,   93,   22,  183,  184,  245,
 /*   650 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   660 */   196,  197,  198,  252,  112,  113,  114,  115,  116,  249,
 /*   670 */   249,   47,  252,  252,  263,  285,  252,  199,  200,  201,
 /*   680 */   202,  203,  204,  205,  206,  207,  208,  263,   64,  285,
 /*   690 */    33,  280,  252,  265,   93,  260,  268,  262,  245,  187,
 /*   700 */   171,  172,   45,  263,  280,   81,  245,  252,   51,   52,
 /*   710 */    53,   54,   55,  112,  113,  114,  115,  116,  263,  313,
 /*   720 */   280,  274,  245,    4,   18,   20,   20,  103,  245,   44,
 /*   730 */   245,   93,  285,   27,   37,  280,   30,   80,  285,  252,
 /*   740 */    83,  117,  118,  337,  252,  187,  285,  245,  245,  272,
 /*   750 */   263,   45,   20,  115,   48,  263,   50,  280,  311,  312,
 /*   760 */    18,   41,  285,  252,  287,   23,   81,  280,  285,  322,
 /*   770 */   285,  280,  280,  252,  263,  298,  282,   35,   36,  285,
 /*   780 */    41,   39,  291,  159,  263,  161,   80,  285,  285,  312,
 /*   790 */    64,  280,  315,  316,  317,  318,  319,  320,   56,  322,
 /*   800 */   143,  280,  145,    0,  147,  273,  149,  183,  184,  245,
 /*   810 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   820 */   196,  197,  198,   81,  282,  168,  120,  285,  273,  123,
 /*   830 */   124,  125,  126,  127,  128,  129,  130,  131,  132,  133,
 /*   840 */   134,  135,  136,  137,  138,  139,  140,  273,   47,  285,
 /*   850 */    12,   13,   14,   15,   16,  252,  252,   22,  252,  252,
 /*   860 */   245,  119,  245,   60,   61,   64,  263,  263,   65,  263,
 /*   870 */   245,   68,   69,  209,  210,   72,   73,   74,   41,    0,
 /*   880 */   148,  273,   47,  280,  280,   85,  280,  280,   88,  304,
 /*   890 */   245,    0,  187,  151,  152,  153,   58,   47,  156,   64,
 /*   900 */   285,   22,  285,   85,  162,  252,   88,  210,   85,   85,
 /*   910 */   285,   88,   88,    0,    0,  173,  273,  272,  176,   82,
 /*   920 */   178,  179,  180,  181,  182,  280,  319,   21,   90,  246,
 /*   930 */   285,  212,  287,  280,   47,   22,   22,   41,  103,   47,
 /*   940 */    34,  334,  335,  336,   58,  338,  362,    1,    2,   41,
 /*   950 */   230,   41,  261,  211,  253,  353,   64,  312,  245,  308,
 /*   960 */   315,  316,  317,  318,  319,  320,    0,  322,  117,  118,
 /*   970 */   325,  232,  319,   41,  329,  330,  331,  348,   82,   41,
 /*   980 */   142,  272,  245,  253,   93,  272,   41,  334,  335,  336,
 /*   990 */    82,  338,   82,  280,  159,   41,  161,  352,  285,  251,
 /*  1000 */   287,  284,  164,  112,  113,  114,  115,  116,  314,  272,
 /*  1010 */    41,  161,   46,  339,   82,  356,  356,  280,  183,  184,
 /*  1020 */    82,  356,  285,  245,  287,  312,  342,   82,  315,  316,
 /*  1030 */   317,  318,  319,  320,   41,  322,   82,  199,  200,  201,
 /*  1040 */   202,  203,  204,  205,  206,  207,  208,   41,  161,  312,
 /*  1050 */   272,   82,  315,  316,  317,  318,  319,  320,  280,  322,
 /*  1060 */    41,   41,  325,  285,  245,  287,  329,  330,  331,  183,
 /*  1070 */    41,   41,   41,   41,  213,   82,  310,  340,   20,  252,
 /*  1080 */    45,  309,  157,   47,  258,  302,  252,   40,   82,  292,
 /*  1090 */   312,  272,  252,  315,  316,  317,  318,  319,  320,  280,
 /*  1100 */   322,   82,   82,  325,  285,  142,  287,  329,  330,  331,
 /*  1110 */   290,   82,   82,   82,   82,  290,  252,   20,  340,  247,
 /*  1120 */   247,   20,  306,  256,  256,   20,  287,  299,   20,  299,
 /*  1130 */   301,  312,  256,  256,  315,  316,  317,  318,  319,  320,
 /*  1140 */   245,  322,  280,   20,  325,  293,  256,  247,  329,  330,
 /*  1150 */   331,  252,  272,  256,  256,  272,  272,  272,  167,  340,
 /*  1160 */   272,  272,  247,  252,  306,  272,  272,  272,  305,  287,
 /*  1170 */   254,  254,  252,  272,  272,  280,  272,  299,  254,   20,
 /*  1180 */   285,  254,  287,  314,  219,  218,  225,  280,  285,  347,
 /*  1190 */   285,  347,  150,  350,  349,  300,  347,  285,  227,  346,
 /*  1200 */   226,  345,  293,  245,  285,  210,  285,  312,  214,  344,
 /*  1210 */   315,  316,  317,  318,  319,  320,  285,  322,  296,  296,
 /*  1220 */   245,  280,   20,   40,  358,   81,  229,  231,  310,  358,
 /*  1230 */   272,  357,  234,  363,  285,  285,  341,  285,  280,  313,
 /*  1240 */   296,  145,  280,  285,  296,  287,  293,  272,  268,  294,
 /*  1250 */   355,   81,  280,  254,  359,  280,  254,  276,  300,  252,
 /*  1260 */   285,  332,  287,  328,  285,  262,  254,  303,  247,  255,
 /*  1270 */   312,  266,    0,  315,  316,  317,  318,  319,  320,  266,
 /*  1280 */   322,  266,  243,  245,  307,  357,    0,  312,  358,   40,
 /*  1290 */   315,  316,  317,  318,  319,  320,  357,  322,    0,  341,
 /*  1300 */   325,  245,   72,    0,  329,  330,   47,  177,   47,   47,
 /*  1310 */   272,   47,  177,  355,    0,   47,   47,  359,  280,  177,
 /*  1320 */     0,    0,  177,  285,   47,  287,    0,   22,  272,    0,
 /*  1330 */    47,    0,   81,  164,  163,  161,  280,  159,    0,    0,
 /*  1340 */   155,  285,  154,  287,    0,    0,   44,    0,  141,    0,
 /*  1350 */   312,  136,  245,  315,  316,  317,  318,  319,  320,  321,
 /*  1360 */   322,  323,  324,    0,    0,    0,    0,    0,  312,   47,
 /*  1370 */    19,  315,  316,  317,  318,  319,  320,  136,  322,  272,
 /*  1380 */     0,    0,    0,    0,   33,    0,    0,  280,    0,    0,
 /*  1390 */     0,    0,  285,  252,  287,    0,   45,    0,    0,    0,
 /*  1400 */    40,    0,   51,   52,   53,   54,   55,    0,    0,    0,
 /*  1410 */     0,    0,    0,  245,   22,    0,  360,  361,    0,  312,
 /*  1420 */     0,  280,  315,  316,  317,  318,  319,  320,    0,  322,
 /*  1430 */     0,   80,  325,   40,   83,   41,   14,  330,   14,   37,
 /*  1440 */   272,  300,    0,   38,   44,    0,    0,   44,  280,    0,
 /*  1450 */    37,   37,    0,  285,  150,  287,    0,    0,   37,    0,
 /*  1460 */   319,    0,   37,   59,   45,    0,  245,  116,   37,    0,
 /*  1470 */    47,    0,   45,   47,   45,  334,  335,  336,   37,  338,
 /*  1480 */   312,   47,  341,  315,  316,  317,  318,  319,  320,  245,
 /*  1490 */   322,   47,   45,  272,    0,  144,  355,   37,  147,    0,
 /*  1500 */   359,  280,    0,    0,   88,   47,  285,  252,  287,   22,
 /*  1510 */     0,   47,    0,   47,   47,   47,  272,  166,   41,  168,
 /*  1520 */    41,   47,  354,   90,  280,   47,   22,   47,    0,  285,
 /*  1530 */    22,  287,   48,  312,    0,  280,  315,  316,  317,  318,
 /*  1540 */   319,  320,  298,  322,   22,  245,    0,   47,   22,    0,
 /*  1550 */    20,   22,    0,   47,  148,  300,  312,    0,   22,  315,
 /*  1560 */   316,  317,  318,  319,  320,    0,  322,    0,    0,    0,
 /*  1570 */    81,  215,  272,   41,  319,   37,   41,   82,   81,   81,
 /*  1580 */   280,  145,  361,  148,   41,  285,  143,  287,  148,  334,
 /*  1590 */   335,  336,   81,  338,   41,   82,  341,  165,  245,   82,
 /*  1600 */    81,   81,   44,   82,   44,   81,   44,  245,   44,   82,
 /*  1610 */   355,   41,  312,   82,  359,  315,  316,  317,  318,  319,
 /*  1620 */   320,  245,  322,   41,  324,  272,   82,   41,   47,   82,
 /*  1630 */     2,   47,   47,  280,  272,   47,   47,   47,  285,   41,
 /*  1640 */   287,   82,  280,   82,   81,  183,   44,  285,  272,  287,
 /*  1650 */    44,  298,  215,   81,  215,   81,  280,  209,   22,   81,
 /*  1660 */   298,  285,  245,  287,    0,  312,  185,   37,  315,  316,
 /*  1670 */   317,  318,  319,  320,  312,  322,   82,  315,  316,  317,
 /*  1680 */   318,  319,  320,  245,  322,   82,   81,  146,  312,  272,
 /*  1690 */    81,  315,  316,  317,  318,  319,  320,  280,  322,   81,
 /*  1700 */    81,   91,  285,   44,  287,   44,   81,   22,   82,  143,
 /*  1710 */   272,   82,   81,   81,   92,   47,   47,   82,  280,   81,
 /*  1720 */    47,   81,   47,  285,   82,  287,   81,   47,   82,  312,
 /*  1730 */    81,   47,  315,  316,  317,  318,  319,  320,   82,  322,
 /*  1740 */    22,  245,  105,   93,   81,   47,  105,   81,  105,  105,
 /*  1750 */   312,   81,  245,  315,  316,  317,  318,  319,  320,   81,
 /*  1760 */   322,   41,   22,  245,   59,   58,   47,   79,  272,   41,
 /*  1770 */    64,   22,   47,   47,   47,   64,  280,   47,   47,  272,
 /*  1780 */    47,  285,   47,  287,   47,   47,   47,  280,   47,   47,
 /*  1790 */   272,   47,  285,   47,  287,    0,   45,   47,  280,   37,
 /*  1800 */     0,   47,   45,  285,   37,  287,    0,   47,  312,   45,
 /*  1810 */    37,  315,  316,  317,  318,  319,  320,    0,  322,  312,
 /*  1820 */    45,   47,  315,  316,  317,  318,  319,  320,  245,  322,
 /*  1830 */   312,   37,    0,  315,  316,  317,  318,  319,  320,   47,
 /*  1840 */   322,    0,   22,   21,  245,   22,   22,   21,   20,  364,
 /*  1850 */   364,  364,  364,  364,  364,  272,  364,  364,  364,  364,
 /*  1860 */   364,  364,  364,  280,  364,  364,  364,  364,  285,  364,
 /*  1870 */   287,  272,  364,  364,  364,  364,  364,  364,  364,  280,
 /*  1880 */   364,  364,  364,  364,  285,  364,  287,  364,  364,  364,
 /*  1890 */   364,  364,  364,  245,  364,  312,  364,  364,  315,  316,
 /*  1900 */   317,  318,  319,  320,  364,  322,  364,  245,  364,  364,
 /*  1910 */   364,  312,  364,  364,  315,  316,  317,  318,  319,  320,
 /*  1920 */   272,  322,  364,  364,  364,  364,  364,  364,  280,  364,
 /*  1930 */   364,  364,  364,  285,  272,  287,  364,  364,  364,  364,
 /*  1940 */   364,  364,  280,  364,  364,  364,  364,  285,  245,  287,
 /*  1950 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*  1960 */   312,  364,  364,  315,  316,  317,  318,  319,  320,  245,
 /*  1970 */   322,  364,  364,  364,  312,  272,  364,  315,  316,  317,
 /*  1980 */   318,  319,  320,  280,  322,  364,  364,  364,  285,  364,
 /*  1990 */   287,  364,  364,  364,  364,  364,  272,  364,  364,  364,
 /*  2000 */   364,  364,  364,  364,  280,  364,  364,  364,  364,  285,
 /*  2010 */   364,  287,  364,  364,  364,  312,  364,  364,  315,  316,
 /*  2020 */   317,  318,  319,  320,  364,  322,  364,  245,  364,  364,
 /*  2030 */   364,  364,  364,  364,  364,  364,  312,  364,  245,  315,
 /*  2040 */   316,  317,  318,  319,  320,  364,  322,  364,  364,  245,
 /*  2050 */   364,  364,  364,  364,  272,  364,  364,  364,  364,  364,
 /*  2060 */   364,  364,  280,  364,  364,  272,  364,  285,  364,  287,
 /*  2070 */   364,  364,  364,  280,  364,  364,  272,  364,  285,  364,
 /*  2080 */   287,  364,  364,  364,  280,  364,  364,  364,  364,  285,
 /*  2090 */   245,  287,  364,  364,  312,  364,  364,  315,  316,  317,
 /*  2100 */   318,  319,  320,  364,  322,  312,  364,  364,  315,  316,
 /*  2110 */   317,  318,  319,  320,  245,  322,  312,  272,  364,  315,
 /*  2120 */   316,  317,  318,  319,  320,  280,  322,  364,  364,  364,
 /*  2130 */   285,  364,  287,  364,  364,  364,  364,  364,  364,  364,
 /*  2140 */   364,  272,  364,  364,  364,  364,  364,  364,  364,  280,
 /*  2150 */   364,  364,  364,  364,  285,  364,  287,  312,  364,  364,
 /*  2160 */   315,  316,  317,  318,  319,  320,  364,  322,  364,  364,
 /*  2170 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*  2180 */   364,  312,  364,  364,  315,  316,  317,  318,  319,  320,
 /*  2190 */   364,  322,
};
#define YY_SHIFT_COUNT    (640)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1841)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   742,    0,    0,   48,  208,  208,  208,  208,  256,  256,
 /*    10 */   208,  208,  416,  464,  624,  464,  464,  464,  464,  464,
 /*    20 */   464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
 /*    30 */   464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
 /*    40 */    66,   66,  104,  104,  104,   18,   18,   18,   18,   12,
 /*    50 */    79,  207,   36,   36,  115,  115,  202,  153,  207,  207,
 /*    60 */    36,   36,   36,   36,   36,   36,   36,   36,   73,   36,
 /*    70 */    36,  180,  190,  312,  180,   36,   36,  180,   36,  180,
 /*    80 */   180,  180,   36,  409,  706,  478,  838,  838,  395,  189,
 /*    90 */   835,  835,  835,  835,  835,  835,  835,  835,  835,  835,
 /*   100 */   835,  835,  835,  835,  835,  835,  835,  835,  835,  198,
 /*   110 */   153,    4,    4,  281,  801,  479,  479,  479,  327,  801,
 /*   120 */   454,  312,  180,  180,  425,  425,  530,  726,  246,  246,
 /*   130 */   246,  246,  246,  246,  246, 1351,  351,  803,  350,  187,
 /*   140 */   449,  401,  423,  512,  558,  392,  531,  638,  732,  664,
 /*   150 */   697,  664,  165,  165,  165,  719,  705,  861, 1058, 1035,
 /*   160 */  1036,  925, 1058, 1058, 1047,  963,  963, 1058, 1097, 1097,
 /*   170 */  1101,   73,  312,   73, 1105, 1108,   73, 1105,   73,  454,
 /*   180 */  1123,   73,   73, 1058,   73, 1097,  180,  180,  180,  180,
 /*   190 */   180,  180,  180,  180,  180,  180,  180, 1058, 1097,  425,
 /*   200 */   425, 1101,  409,  991,  312,  409, 1058, 1105,  409,  454,
 /*   210 */  1123,  409, 1159,  425,  965,  967,  425,  965,  967,  425,
 /*   220 */   425,  180,  961, 1042,  965,  971,  974,  994,  861,  995,
 /*   230 */   454, 1202, 1183,  996,  997,  998,  996,  997,  996,  997,
 /*   240 */  1144,  967,  425,  425,  967,  425, 1096,  454, 1123,  409,
 /*   250 */   530,  409,  454, 1170,  425,  726, 1058,  409, 1097, 2192,
 /*   260 */  2192, 2192, 2192, 2192, 2192, 2192,  481,  657,  561,  119,
 /*   270 */   601,  891,   63,   13,  303,  203,  582,  374,  443,  552,
 /*   280 */   550,  550,  550,  550,  550,  550,  550,  550,  132,  382,
 /*   290 */   152,  529,  430,  137,  616,  616,  616,  616,  259,  837,
 /*   300 */   800,  818,  823,  824,  879,  913,  914,  906,  896,  908,
 /*   310 */   910,  946,  851,  720,  739,  932,  886,  938,  685,  945,
 /*   320 */   954,  969,  993, 1006,  850,  887, 1019, 1020, 1029, 1030,
 /*   330 */  1031, 1032,  277,  892,  966, 1272, 1286, 1249, 1298, 1230,
 /*   340 */  1303, 1259, 1130, 1261, 1262, 1264, 1135, 1314, 1268, 1269,
 /*   350 */  1142, 1320, 1145, 1321, 1277, 1326, 1305, 1329, 1283, 1331,
 /*   360 */  1251, 1169, 1171, 1174, 1178, 1338, 1339, 1185, 1188, 1344,
 /*   370 */  1345, 1302, 1347, 1207, 1349, 1363, 1364, 1365, 1366, 1215,
 /*   380 */  1322, 1367, 1241, 1380, 1381, 1382, 1383, 1385, 1386, 1388,
 /*   390 */  1389, 1390, 1391, 1395, 1397, 1398, 1399, 1360, 1401, 1407,
 /*   400 */  1408, 1409, 1410, 1411, 1392, 1412, 1415, 1418, 1420, 1428,
 /*   410 */  1430, 1393, 1402, 1394, 1422, 1400, 1424, 1403, 1442, 1405,
 /*   420 */  1413, 1445, 1446, 1449, 1414, 1304, 1452, 1456, 1421, 1457,
 /*   430 */  1404, 1459, 1461, 1423, 1419, 1425, 1465, 1426, 1427, 1431,
 /*   440 */  1469, 1434, 1429, 1441, 1471, 1444, 1447, 1460, 1494, 1499,
 /*   450 */  1502, 1503, 1433, 1416, 1458, 1487, 1510, 1464, 1466, 1467,
 /*   460 */  1468, 1477, 1479, 1474, 1478, 1480, 1512, 1504, 1528, 1508,
 /*   470 */  1484, 1534, 1522, 1500, 1546, 1526, 1549, 1529, 1530, 1552,
 /*   480 */  1406, 1506, 1557, 1432, 1536, 1435, 1436, 1565, 1567, 1568,
 /*   490 */  1440, 1569, 1489, 1538, 1443, 1532, 1535, 1356, 1497, 1495,
 /*   500 */  1498, 1513, 1543, 1517, 1511, 1519, 1520, 1521, 1553, 1558,
 /*   510 */  1560, 1524, 1570, 1437, 1527, 1531, 1562, 1448, 1582, 1564,
 /*   520 */  1544, 1586, 1439, 1547, 1581, 1584, 1585, 1588, 1589, 1590,
 /*   530 */  1547, 1628, 1462, 1598, 1559, 1563, 1561, 1602, 1572, 1574,
 /*   540 */  1606, 1636, 1481, 1578, 1594, 1603, 1605, 1609, 1541, 1618,
 /*   550 */  1664, 1630, 1566, 1619, 1610, 1659, 1661, 1625, 1626, 1631,
 /*   560 */  1685, 1632, 1622, 1629, 1668, 1669, 1638, 1635, 1673, 1640,
 /*   570 */  1642, 1675, 1645, 1646, 1680, 1649, 1656, 1684, 1663, 1637,
 /*   580 */  1641, 1643, 1644, 1718, 1650, 1666, 1670, 1698, 1678, 1720,
 /*   590 */  1720, 1740, 1705, 1707, 1719, 1706, 1688, 1728, 1725, 1726,
 /*   600 */  1727, 1730, 1731, 1749, 1733, 1735, 1711, 1477, 1737, 1479,
 /*   610 */  1738, 1739, 1741, 1742, 1744, 1746, 1795, 1750, 1751, 1762,
 /*   620 */  1800, 1754, 1757, 1767, 1806, 1760, 1764, 1773, 1817, 1774,
 /*   630 */  1775, 1794, 1832, 1792, 1841, 1820, 1822, 1823, 1824, 1826,
 /*   640 */  1828,
};
#define YY_REDUCE_COUNT (265)
#define YY_REDUCE_MIN   (-340)
#define YY_REDUCE_MAX   (1869)
static const short yy_reduce_ofst[] = {
 /*     0 */  -233, -228,  -20, -176,  645,  737,  778,  819,  895,  958,
 /*    10 */   188,  975, 1038, 1056, 1107,  477, 1168, 1221, 1244, 1300,
 /*    20 */  1353, 1362,  713, 1376, 1417, 1438, 1496, 1507, 1518, 1583,
 /*    30 */  1599, 1648, 1662, 1703, 1724, 1782, 1793, 1804, 1845, 1869,
 /*    40 */  1141, 1255,   -5,  607,  653, -274, -269,   49,  447, -227,
 /*    50 */   -47,  161, -231, -229, -244, -215, -340, -105, -133,  123,
 /*    60 */  -197, -147,  363,  411,  424,  440,  455,  487, -171,  492,
 /*    70 */   511,  200,  -24,  234, -201,  521,  603,  251,  604, -101,
 /*    80 */   345,  357,  606, -119, -152, -281, -281, -281,   78, -247,
 /*    90 */  -135,  -21,  242,  250,  295,  331,  334,  390,  404,  453,
 /*   100 */   461,  483,  485,  502,  503,  564,  615,  617,  625,  199,
 /*   110 */   -83,  420,  421,  -27,  176, -263,  172,  406, -155,  279,
 /*   120 */   491, -172,  243,  346,  494,  542,  428,  435, -271,  355,
 /*   130 */   532,  555,  574,  608,  643,  585,  683,  691,  584,  602,
 /*   140 */   701,  651,  629,  709,  709,  730,  748,  717,  694,  674,
 /*   150 */   674,  674,  659,  660,  665,  684,  709,  766,  827,  772,
 /*   160 */   826,  783,  834,  840,  797,  820,  825,  864,  872,  873,
 /*   170 */   816,  867,  839,  868,  828,  829,  876,  830,  877,  862,
 /*   180 */   852,  890,  897,  899,  898,  900,  880,  883,  884,  885,
 /*   190 */   888,  889,  893,  894,  901,  902,  904,  911,  915,  903,
 /*   200 */   905,  858,  916,  863,  882,  917,  920,  878,  924,  907,
 /*   210 */   909,  927,  869,  912,  842,  922,  919,  844,  923,  921,
 /*   220 */   931,  709,  843,  845,  849,  853,  856,  865,  918,  674,
 /*   230 */   941,  926,  929,  866,  874,  870,  871,  928,  930,  939,
 /*   240 */   935,  944,  949,  950,  948,  952,  955,  962,  953,  999,
 /*   250 */   980, 1002,  972,  981,  979, 1003, 1007, 1012, 1021,  964,
 /*   260 */   977, 1005, 1013, 1015, 1014, 1039,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*    10 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*    20 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*    30 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*    40 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*    50 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*    60 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1468, 1399,
 /*    70 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*    80 */  1399, 1399, 1399, 1466, 1617, 1399, 1781, 1399, 1399, 1399,
 /*    90 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   100 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   110 */  1399, 1399, 1399, 1468, 1399, 1792, 1792, 1792, 1466, 1399,
 /*   120 */  1399, 1399, 1399, 1399, 1399, 1399, 1562, 1399, 1399, 1399,
 /*   130 */  1399, 1399, 1399, 1399, 1399, 1650, 1399, 1399, 1862, 1399,
 /*   140 */  1399, 1656, 1816, 1399, 1399, 1399, 1399, 1515, 1808, 1784,
 /*   150 */  1798, 1785, 1847, 1847, 1847, 1801, 1399, 1812, 1399, 1399,
 /*   160 */  1399, 1642, 1399, 1399, 1622, 1619, 1619, 1399, 1399, 1399,
 /*   170 */  1399, 1468, 1399, 1468, 1399, 1399, 1468, 1399, 1468, 1399,
 /*   180 */  1399, 1468, 1468, 1399, 1468, 1399, 1399, 1399, 1399, 1399,
 /*   190 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   200 */  1399, 1399, 1466, 1652, 1399, 1466, 1399, 1399, 1466, 1399,
 /*   210 */  1399, 1466, 1399, 1399, 1823, 1821, 1399, 1823, 1821, 1399,
 /*   220 */  1399, 1399, 1835, 1831, 1823, 1839, 1837, 1814, 1812, 1798,
 /*   230 */  1399, 1399, 1399, 1853, 1849, 1865, 1853, 1849, 1853, 1849,
 /*   240 */  1399, 1821, 1399, 1399, 1821, 1399, 1627, 1399, 1399, 1466,
 /*   250 */  1399, 1466, 1399, 1531, 1399, 1399, 1399, 1466, 1399, 1644,
 /*   260 */  1658, 1565, 1565, 1565, 1469, 1404, 1399, 1399, 1399, 1399,
 /*   270 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1527,
 /*   280 */  1725, 1834, 1833, 1757, 1756, 1755, 1753, 1724, 1399, 1399,
 /*   290 */  1399, 1399, 1399, 1399, 1718, 1719, 1717, 1716, 1399, 1399,
 /*   300 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   310 */  1399, 1782, 1399, 1850, 1854, 1399, 1399, 1399, 1701, 1399,
 /*   320 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   330 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   340 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   350 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   360 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   370 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   380 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   390 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   400 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   410 */  1399, 1399, 1399, 1433, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   420 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   430 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   440 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   450 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   460 */  1399, 1496, 1495, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   470 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   480 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   490 */  1399, 1399, 1399, 1399, 1399, 1805, 1815, 1399, 1399, 1399,
 /*   500 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   510 */  1701, 1399, 1832, 1399, 1791, 1787, 1399, 1399, 1783, 1399,
 /*   520 */  1399, 1848, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   530 */  1399, 1777, 1399, 1750, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   540 */  1399, 1399, 1712, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   550 */  1399, 1399, 1399, 1399, 1399, 1700, 1399, 1741, 1399, 1399,
 /*   560 */  1399, 1399, 1399, 1399, 1399, 1399, 1559, 1399, 1399, 1399,
 /*   570 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1544,
 /*   580 */  1542, 1541, 1540, 1399, 1537, 1399, 1399, 1399, 1399, 1568,
 /*   590 */  1567, 1399, 1399, 1399, 1399, 1399, 1399, 1488, 1399, 1399,
 /*   600 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1479, 1399, 1478,
 /*   610 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   620 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   630 */  1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399,
 /*   640 */  1399,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  235,  /*  NK_BITNOT => ID */
  235,  /*     INSERT => ID */
  235,  /*     VALUES => ID */
  235,  /*     IMPORT => ID */
  235,  /*    NK_SEMI => ID */
  235,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DURATION",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "MAX_DELAY",
  /*  113 */ "WATERMARK",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "FIRST",
  /*  118 */ "LAST",
  /*  119 */ "SHOW",
  /*  120 */ "DATABASES",
  /*  121 */ "TABLES",
  /*  122 */ "STABLES",
  /*  123 */ "MNODES",
  /*  124 */ "MODULES",
  /*  125 */ "QNODES",
  /*  126 */ "FUNCTIONS",
  /*  127 */ "INDEXES",
  /*  128 */ "ACCOUNTS",
  /*  129 */ "APPS",
  /*  130 */ "CONNECTIONS",
  /*  131 */ "LICENCE",
  /*  132 */ "GRANTS",
  /*  133 */ "QUERIES",
  /*  134 */ "SCORES",
  /*  135 */ "TOPICS",
  /*  136 */ "VARIABLES",
  /*  137 */ "BNODES",
  /*  138 */ "SNODES",
  /*  139 */ "CLUSTER",
  /*  140 */ "TRANSACTIONS",
  /*  141 */ "DISTRIBUTED",
  /*  142 */ "LIKE",
  /*  143 */ "INDEX",
  /*  144 */ "FULLTEXT",
  /*  145 */ "FUNCTION",
  /*  146 */ "INTERVAL",
  /*  147 */ "TOPIC",
  /*  148 */ "AS",
  /*  149 */ "CONSUMER",
  /*  150 */ "GROUP",
  /*  151 */ "DESC",
  /*  152 */ "DESCRIBE",
  /*  153 */ "RESET",
  /*  154 */ "QUERY",
  /*  155 */ "CACHE",
  /*  156 */ "EXPLAIN",
  /*  157 */ "ANALYZE",
  /*  158 */ "VERBOSE",
  /*  159 */ "NK_BOOL",
  /*  160 */ "RATIO",
  /*  161 */ "NK_FLOAT",
  /*  162 */ "COMPACT",
  /*  163 */ "VNODES",
  /*  164 */ "IN",
  /*  165 */ "OUTPUTTYPE",
  /*  166 */ "AGGREGATE",
  /*  167 */ "BUFSIZE",
  /*  168 */ "STREAM",
  /*  169 */ "INTO",
  /*  170 */ "TRIGGER",
  /*  171 */ "AT_ONCE",
  /*  172 */ "WINDOW_CLOSE",
  /*  173 */ "KILL",
  /*  174 */ "CONNECTION",
  /*  175 */ "TRANSACTION",
  /*  176 */ "BALANCE",
  /*  177 */ "VGROUP",
  /*  178 */ "MERGE",
  /*  179 */ "REDISTRIBUTE",
  /*  180 */ "SPLIT",
  /*  181 */ "SYNCDB",
  /*  182 */ "DELETE",
  /*  183 */ "NULL",
  /*  184 */ "NK_QUESTION",
  /*  185 */ "NK_ARROW",
  /*  186 */ "ROWTS",
  /*  187 */ "TBNAME",
  /*  188 */ "QSTARTTS",
  /*  189 */ "QENDTS",
  /*  190 */ "WSTARTTS",
  /*  191 */ "WENDTS",
  /*  192 */ "WDURATION",
  /*  193 */ "CAST",
  /*  194 */ "NOW",
  /*  195 */ "TODAY",
  /*  196 */ "TIMEZONE",
  /*  197 */ "COUNT",
  /*  198 */ "LAST_ROW",
  /*  199 */ "BETWEEN",
  /*  200 */ "IS",
  /*  201 */ "NK_LT",
  /*  202 */ "NK_GT",
  /*  203 */ "NK_LE",
  /*  204 */ "NK_GE",
  /*  205 */ "NK_NE",
  /*  206 */ "MATCH",
  /*  207 */ "NMATCH",
  /*  208 */ "CONTAINS",
  /*  209 */ "JOIN",
  /*  210 */ "INNER",
  /*  211 */ "SELECT",
  /*  212 */ "DISTINCT",
  /*  213 */ "WHERE",
  /*  214 */ "PARTITION",
  /*  215 */ "BY",
  /*  216 */ "SESSION",
  /*  217 */ "STATE_WINDOW",
  /*  218 */ "SLIDING",
  /*  219 */ "FILL",
  /*  220 */ "VALUE",
  /*  221 */ "NONE",
  /*  222 */ "PREV",
  /*  223 */ "LINEAR",
  /*  224 */ "NEXT",
  /*  225 */ "HAVING",
  /*  226 */ "RANGE",
  /*  227 */ "EVERY",
  /*  228 */ "ORDER",
  /*  229 */ "SLIMIT",
  /*  230 */ "SOFFSET",
  /*  231 */ "LIMIT",
  /*  232 */ "OFFSET",
  /*  233 */ "ASC",
  /*  234 */ "NULLS",
  /*  235 */ "ID",
  /*  236 */ "NK_BITNOT",
  /*  237 */ "INSERT",
  /*  238 */ "VALUES",
  /*  239 */ "IMPORT",
  /*  240 */ "NK_SEMI",
  /*  241 */ "FILE",
  /*  242 */ "cmd",
  /*  243 */ "account_options",
  /*  244 */ "alter_account_options",
  /*  245 */ "literal",
  /*  246 */ "alter_account_option",
  /*  247 */ "user_name",
  /*  248 */ "privileges",
  /*  249 */ "priv_level",
  /*  250 */ "priv_type_list",
  /*  251 */ "priv_type",
  /*  252 */ "db_name",
  /*  253 */ "dnode_endpoint",
  /*  254 */ "not_exists_opt",
  /*  255 */ "db_options",
  /*  256 */ "exists_opt",
  /*  257 */ "alter_db_options",
  /*  258 */ "integer_list",
  /*  259 */ "variable_list",
  /*  260 */ "retention_list",
  /*  261 */ "alter_db_option",
  /*  262 */ "retention",
  /*  263 */ "full_table_name",
  /*  264 */ "column_def_list",
  /*  265 */ "tags_def_opt",
  /*  266 */ "table_options",
  /*  267 */ "multi_create_clause",
  /*  268 */ "tags_def",
  /*  269 */ "multi_drop_clause",
  /*  270 */ "alter_table_clause",
  /*  271 */ "alter_table_options",
  /*  272 */ "column_name",
  /*  273 */ "type_name",
  /*  274 */ "signed_literal",
  /*  275 */ "create_subtable_clause",
  /*  276 */ "specific_tags_opt",
  /*  277 */ "literal_list",
  /*  278 */ "drop_table_clause",
  /*  279 */ "col_name_list",
  /*  280 */ "table_name",
  /*  281 */ "column_def",
  /*  282 */ "duration_list",
  /*  283 */ "rollup_func_list",
  /*  284 */ "alter_table_option",
  /*  285 */ "duration_literal",
  /*  286 */ "rollup_func_name",
  /*  287 */ "function_name",
  /*  288 */ "col_name",
  /*  289 */ "db_name_cond_opt",
  /*  290 */ "like_pattern_opt",
  /*  291 */ "table_name_cond",
  /*  292 */ "from_db_opt",
  /*  293 */ "index_name",
  /*  294 */ "index_options",
  /*  295 */ "func_list",
  /*  296 */ "sliding_opt",
  /*  297 */ "func",
  /*  298 */ "expression_list",
  /*  299 */ "topic_name",
  /*  300 */ "query_expression",
  /*  301 */ "cgroup_name",
  /*  302 */ "analyze_opt",
  /*  303 */ "explain_options",
  /*  304 */ "agg_func_opt",
  /*  305 */ "bufsize_opt",
  /*  306 */ "stream_name",
  /*  307 */ "stream_options",
  /*  308 */ "into_opt",
  /*  309 */ "dnode_list",
  /*  310 */ "where_clause_opt",
  /*  311 */ "signed",
  /*  312 */ "literal_func",
  /*  313 */ "table_alias",
  /*  314 */ "column_alias",
  /*  315 */ "expression",
  /*  316 */ "pseudo_column",
  /*  317 */ "column_reference",
  /*  318 */ "function_expression",
  /*  319 */ "subquery",
  /*  320 */ "star_func",
  /*  321 */ "star_func_para_list",
  /*  322 */ "noarg_func",
  /*  323 */ "other_para_list",
  /*  324 */ "star_func_para",
  /*  325 */ "predicate",
  /*  326 */ "compare_op",
  /*  327 */ "in_op",
  /*  328 */ "in_predicate_value",
  /*  329 */ "boolean_value_expression",
  /*  330 */ "boolean_primary",
  /*  331 */ "common_expression",
  /*  332 */ "from_clause",
  /*  333 */ "table_reference_list",
  /*  334 */ "table_reference",
  /*  335 */ "table_primary",
  /*  336 */ "joined_table",
  /*  337 */ "alias_opt",
  /*  338 */ "parenthesized_joined_table",
  /*  339 */ "join_type",
  /*  340 */ "search_condition",
  /*  341 */ "query_specification",
  /*  342 */ "set_quantifier_opt",
  /*  343 */ "select_list",
  /*  344 */ "partition_by_clause_opt",
  /*  345 */ "range_opt",
  /*  346 */ "every_opt",
  /*  347 */ "fill_opt",
  /*  348 */ "twindow_clause_opt",
  /*  349 */ "group_by_clause_opt",
  /*  350 */ "having_clause_opt",
  /*  351 */ "select_sublist",
  /*  352 */ "select_item",
  /*  353 */ "fill_mode",
  /*  354 */ "group_by_list",
  /*  355 */ "query_expression_body",
  /*  356 */ "order_by_clause_opt",
  /*  357 */ "slimit_clause_opt",
  /*  358 */ "limit_clause_opt",
  /*  359 */ "query_primary",
  /*  360 */ "sort_specification_list",
  /*  361 */ "sort_specification",
  /*  362 */ "ordering_specification_opt",
  /*  363 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_endpoint ::= NK_ID",
 /*  48 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  72 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 166 */ "table_options ::= table_options WATERMARK duration_list",
 /* 167 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 168 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 169 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 170 */ "alter_table_options ::= alter_table_option",
 /* 171 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 172 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 173 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 174 */ "duration_list ::= duration_literal",
 /* 175 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 176 */ "rollup_func_list ::= rollup_func_name",
 /* 177 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 178 */ "rollup_func_name ::= function_name",
 /* 179 */ "rollup_func_name ::= FIRST",
 /* 180 */ "rollup_func_name ::= LAST",
 /* 181 */ "col_name_list ::= col_name",
 /* 182 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 183 */ "col_name ::= column_name",
 /* 184 */ "cmd ::= SHOW DNODES",
 /* 185 */ "cmd ::= SHOW USERS",
 /* 186 */ "cmd ::= SHOW DATABASES",
 /* 187 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 188 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 189 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 190 */ "cmd ::= SHOW MNODES",
 /* 191 */ "cmd ::= SHOW MODULES",
 /* 192 */ "cmd ::= SHOW QNODES",
 /* 193 */ "cmd ::= SHOW FUNCTIONS",
 /* 194 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 195 */ "cmd ::= SHOW STREAMS",
 /* 196 */ "cmd ::= SHOW ACCOUNTS",
 /* 197 */ "cmd ::= SHOW APPS",
 /* 198 */ "cmd ::= SHOW CONNECTIONS",
 /* 199 */ "cmd ::= SHOW LICENCE",
 /* 200 */ "cmd ::= SHOW GRANTS",
 /* 201 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 202 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 203 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 204 */ "cmd ::= SHOW QUERIES",
 /* 205 */ "cmd ::= SHOW SCORES",
 /* 206 */ "cmd ::= SHOW TOPICS",
 /* 207 */ "cmd ::= SHOW VARIABLES",
 /* 208 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 209 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 210 */ "cmd ::= SHOW BNODES",
 /* 211 */ "cmd ::= SHOW SNODES",
 /* 212 */ "cmd ::= SHOW CLUSTER",
 /* 213 */ "cmd ::= SHOW TRANSACTIONS",
 /* 214 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 215 */ "db_name_cond_opt ::=",
 /* 216 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 217 */ "like_pattern_opt ::=",
 /* 218 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 219 */ "table_name_cond ::= table_name",
 /* 220 */ "from_db_opt ::=",
 /* 221 */ "from_db_opt ::= FROM db_name",
 /* 222 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 223 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 224 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 225 */ "index_options ::=",
 /* 226 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 227 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 228 */ "func_list ::= func",
 /* 229 */ "func_list ::= func_list NK_COMMA func",
 /* 230 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 231 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 232 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 233 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 234 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 235 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 236 */ "cmd ::= DESC full_table_name",
 /* 237 */ "cmd ::= DESCRIBE full_table_name",
 /* 238 */ "cmd ::= RESET QUERY CACHE",
 /* 239 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 240 */ "analyze_opt ::=",
 /* 241 */ "analyze_opt ::= ANALYZE",
 /* 242 */ "explain_options ::=",
 /* 243 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 244 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 245 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 246 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 247 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 248 */ "agg_func_opt ::=",
 /* 249 */ "agg_func_opt ::= AGGREGATE",
 /* 250 */ "bufsize_opt ::=",
 /* 251 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 252 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 253 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 254 */ "into_opt ::=",
 /* 255 */ "into_opt ::= INTO full_table_name",
 /* 256 */ "stream_options ::=",
 /* 257 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 258 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 259 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 260 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 261 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 262 */ "cmd ::= KILL QUERY NK_STRING",
 /* 263 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 264 */ "cmd ::= BALANCE VGROUP",
 /* 265 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 266 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 267 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 268 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 269 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 270 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 271 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 272 */ "cmd ::= query_expression",
 /* 273 */ "literal ::= NK_INTEGER",
 /* 274 */ "literal ::= NK_FLOAT",
 /* 275 */ "literal ::= NK_STRING",
 /* 276 */ "literal ::= NK_BOOL",
 /* 277 */ "literal ::= TIMESTAMP NK_STRING",
 /* 278 */ "literal ::= duration_literal",
 /* 279 */ "literal ::= NULL",
 /* 280 */ "literal ::= NK_QUESTION",
 /* 281 */ "duration_literal ::= NK_VARIABLE",
 /* 282 */ "signed ::= NK_INTEGER",
 /* 283 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 284 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 285 */ "signed ::= NK_FLOAT",
 /* 286 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 287 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 288 */ "signed_literal ::= signed",
 /* 289 */ "signed_literal ::= NK_STRING",
 /* 290 */ "signed_literal ::= NK_BOOL",
 /* 291 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 292 */ "signed_literal ::= duration_literal",
 /* 293 */ "signed_literal ::= NULL",
 /* 294 */ "signed_literal ::= literal_func",
 /* 295 */ "literal_list ::= signed_literal",
 /* 296 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 297 */ "db_name ::= NK_ID",
 /* 298 */ "table_name ::= NK_ID",
 /* 299 */ "column_name ::= NK_ID",
 /* 300 */ "function_name ::= NK_ID",
 /* 301 */ "table_alias ::= NK_ID",
 /* 302 */ "column_alias ::= NK_ID",
 /* 303 */ "user_name ::= NK_ID",
 /* 304 */ "index_name ::= NK_ID",
 /* 305 */ "topic_name ::= NK_ID",
 /* 306 */ "stream_name ::= NK_ID",
 /* 307 */ "cgroup_name ::= NK_ID",
 /* 308 */ "expression ::= literal",
 /* 309 */ "expression ::= pseudo_column",
 /* 310 */ "expression ::= column_reference",
 /* 311 */ "expression ::= function_expression",
 /* 312 */ "expression ::= subquery",
 /* 313 */ "expression ::= NK_LP expression NK_RP",
 /* 314 */ "expression ::= NK_PLUS expression",
 /* 315 */ "expression ::= NK_MINUS expression",
 /* 316 */ "expression ::= expression NK_PLUS expression",
 /* 317 */ "expression ::= expression NK_MINUS expression",
 /* 318 */ "expression ::= expression NK_STAR expression",
 /* 319 */ "expression ::= expression NK_SLASH expression",
 /* 320 */ "expression ::= expression NK_REM expression",
 /* 321 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 322 */ "expression_list ::= expression",
 /* 323 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 324 */ "column_reference ::= column_name",
 /* 325 */ "column_reference ::= table_name NK_DOT column_name",
 /* 326 */ "pseudo_column ::= ROWTS",
 /* 327 */ "pseudo_column ::= TBNAME",
 /* 328 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 329 */ "pseudo_column ::= QSTARTTS",
 /* 330 */ "pseudo_column ::= QENDTS",
 /* 331 */ "pseudo_column ::= WSTARTTS",
 /* 332 */ "pseudo_column ::= WENDTS",
 /* 333 */ "pseudo_column ::= WDURATION",
 /* 334 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 335 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 336 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 337 */ "function_expression ::= literal_func",
 /* 338 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 339 */ "literal_func ::= NOW",
 /* 340 */ "noarg_func ::= NOW",
 /* 341 */ "noarg_func ::= TODAY",
 /* 342 */ "noarg_func ::= TIMEZONE",
 /* 343 */ "star_func ::= COUNT",
 /* 344 */ "star_func ::= FIRST",
 /* 345 */ "star_func ::= LAST",
 /* 346 */ "star_func ::= LAST_ROW",
 /* 347 */ "star_func_para_list ::= NK_STAR",
 /* 348 */ "star_func_para_list ::= other_para_list",
 /* 349 */ "other_para_list ::= star_func_para",
 /* 350 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 351 */ "star_func_para ::= expression",
 /* 352 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 353 */ "predicate ::= expression compare_op expression",
 /* 354 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 355 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 356 */ "predicate ::= expression IS NULL",
 /* 357 */ "predicate ::= expression IS NOT NULL",
 /* 358 */ "predicate ::= expression in_op in_predicate_value",
 /* 359 */ "compare_op ::= NK_LT",
 /* 360 */ "compare_op ::= NK_GT",
 /* 361 */ "compare_op ::= NK_LE",
 /* 362 */ "compare_op ::= NK_GE",
 /* 363 */ "compare_op ::= NK_NE",
 /* 364 */ "compare_op ::= NK_EQ",
 /* 365 */ "compare_op ::= LIKE",
 /* 366 */ "compare_op ::= NOT LIKE",
 /* 367 */ "compare_op ::= MATCH",
 /* 368 */ "compare_op ::= NMATCH",
 /* 369 */ "compare_op ::= CONTAINS",
 /* 370 */ "in_op ::= IN",
 /* 371 */ "in_op ::= NOT IN",
 /* 372 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 373 */ "boolean_value_expression ::= boolean_primary",
 /* 374 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 375 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 376 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 377 */ "boolean_primary ::= predicate",
 /* 378 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 379 */ "common_expression ::= expression",
 /* 380 */ "common_expression ::= boolean_value_expression",
 /* 381 */ "from_clause ::= FROM table_reference_list",
 /* 382 */ "table_reference_list ::= table_reference",
 /* 383 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 384 */ "table_reference ::= table_primary",
 /* 385 */ "table_reference ::= joined_table",
 /* 386 */ "table_primary ::= table_name alias_opt",
 /* 387 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 388 */ "table_primary ::= subquery alias_opt",
 /* 389 */ "table_primary ::= parenthesized_joined_table",
 /* 390 */ "alias_opt ::=",
 /* 391 */ "alias_opt ::= table_alias",
 /* 392 */ "alias_opt ::= AS table_alias",
 /* 393 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 394 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 395 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 396 */ "join_type ::=",
 /* 397 */ "join_type ::= INNER",
 /* 398 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 399 */ "set_quantifier_opt ::=",
 /* 400 */ "set_quantifier_opt ::= DISTINCT",
 /* 401 */ "set_quantifier_opt ::= ALL",
 /* 402 */ "select_list ::= NK_STAR",
 /* 403 */ "select_list ::= select_sublist",
 /* 404 */ "select_sublist ::= select_item",
 /* 405 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 406 */ "select_item ::= common_expression",
 /* 407 */ "select_item ::= common_expression column_alias",
 /* 408 */ "select_item ::= common_expression AS column_alias",
 /* 409 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 410 */ "where_clause_opt ::=",
 /* 411 */ "where_clause_opt ::= WHERE search_condition",
 /* 412 */ "partition_by_clause_opt ::=",
 /* 413 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 414 */ "twindow_clause_opt ::=",
 /* 415 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 416 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 417 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 418 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 419 */ "sliding_opt ::=",
 /* 420 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 421 */ "fill_opt ::=",
 /* 422 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 423 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 424 */ "fill_mode ::= NONE",
 /* 425 */ "fill_mode ::= PREV",
 /* 426 */ "fill_mode ::= NULL",
 /* 427 */ "fill_mode ::= LINEAR",
 /* 428 */ "fill_mode ::= NEXT",
 /* 429 */ "group_by_clause_opt ::=",
 /* 430 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 431 */ "group_by_list ::= expression",
 /* 432 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 433 */ "having_clause_opt ::=",
 /* 434 */ "having_clause_opt ::= HAVING search_condition",
 /* 435 */ "range_opt ::=",
 /* 436 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 437 */ "every_opt ::=",
 /* 438 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 439 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 440 */ "query_expression_body ::= query_primary",
 /* 441 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 442 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 443 */ "query_primary ::= query_specification",
 /* 444 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 445 */ "order_by_clause_opt ::=",
 /* 446 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 447 */ "slimit_clause_opt ::=",
 /* 448 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 449 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 450 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 451 */ "limit_clause_opt ::=",
 /* 452 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 453 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 454 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 455 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 456 */ "search_condition ::= common_expression",
 /* 457 */ "sort_specification_list ::= sort_specification",
 /* 458 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 459 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 460 */ "ordering_specification_opt ::=",
 /* 461 */ "ordering_specification_opt ::= ASC",
 /* 462 */ "ordering_specification_opt ::= DESC",
 /* 463 */ "null_ordering_opt ::=",
 /* 464 */ "null_ordering_opt ::= NULLS FIRST",
 /* 465 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 242: /* cmd */
    case 245: /* literal */
    case 255: /* db_options */
    case 257: /* alter_db_options */
    case 262: /* retention */
    case 263: /* full_table_name */
    case 266: /* table_options */
    case 270: /* alter_table_clause */
    case 271: /* alter_table_options */
    case 274: /* signed_literal */
    case 275: /* create_subtable_clause */
    case 278: /* drop_table_clause */
    case 281: /* column_def */
    case 285: /* duration_literal */
    case 286: /* rollup_func_name */
    case 288: /* col_name */
    case 289: /* db_name_cond_opt */
    case 290: /* like_pattern_opt */
    case 291: /* table_name_cond */
    case 292: /* from_db_opt */
    case 294: /* index_options */
    case 296: /* sliding_opt */
    case 297: /* func */
    case 300: /* query_expression */
    case 303: /* explain_options */
    case 307: /* stream_options */
    case 308: /* into_opt */
    case 310: /* where_clause_opt */
    case 311: /* signed */
    case 312: /* literal_func */
    case 315: /* expression */
    case 316: /* pseudo_column */
    case 317: /* column_reference */
    case 318: /* function_expression */
    case 319: /* subquery */
    case 324: /* star_func_para */
    case 325: /* predicate */
    case 328: /* in_predicate_value */
    case 329: /* boolean_value_expression */
    case 330: /* boolean_primary */
    case 331: /* common_expression */
    case 332: /* from_clause */
    case 333: /* table_reference_list */
    case 334: /* table_reference */
    case 335: /* table_primary */
    case 336: /* joined_table */
    case 338: /* parenthesized_joined_table */
    case 340: /* search_condition */
    case 341: /* query_specification */
    case 345: /* range_opt */
    case 346: /* every_opt */
    case 347: /* fill_opt */
    case 348: /* twindow_clause_opt */
    case 350: /* having_clause_opt */
    case 352: /* select_item */
    case 355: /* query_expression_body */
    case 357: /* slimit_clause_opt */
    case 358: /* limit_clause_opt */
    case 359: /* query_primary */
    case 361: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy392)); 
}
      break;
    case 243: /* account_options */
    case 244: /* alter_account_options */
    case 246: /* alter_account_option */
    case 305: /* bufsize_opt */
{
 
}
      break;
    case 247: /* user_name */
    case 249: /* priv_level */
    case 252: /* db_name */
    case 253: /* dnode_endpoint */
    case 272: /* column_name */
    case 280: /* table_name */
    case 287: /* function_name */
    case 293: /* index_name */
    case 299: /* topic_name */
    case 301: /* cgroup_name */
    case 306: /* stream_name */
    case 313: /* table_alias */
    case 314: /* column_alias */
    case 320: /* star_func */
    case 322: /* noarg_func */
    case 337: /* alias_opt */
{
 
}
      break;
    case 248: /* privileges */
    case 250: /* priv_type_list */
    case 251: /* priv_type */
{
 
}
      break;
    case 254: /* not_exists_opt */
    case 256: /* exists_opt */
    case 302: /* analyze_opt */
    case 304: /* agg_func_opt */
    case 342: /* set_quantifier_opt */
{
 
}
      break;
    case 258: /* integer_list */
    case 259: /* variable_list */
    case 260: /* retention_list */
    case 264: /* column_def_list */
    case 265: /* tags_def_opt */
    case 267: /* multi_create_clause */
    case 268: /* tags_def */
    case 269: /* multi_drop_clause */
    case 276: /* specific_tags_opt */
    case 277: /* literal_list */
    case 279: /* col_name_list */
    case 282: /* duration_list */
    case 283: /* rollup_func_list */
    case 295: /* func_list */
    case 298: /* expression_list */
    case 309: /* dnode_list */
    case 321: /* star_func_para_list */
    case 323: /* other_para_list */
    case 343: /* select_list */
    case 344: /* partition_by_clause_opt */
    case 349: /* group_by_clause_opt */
    case 351: /* select_sublist */
    case 354: /* group_by_list */
    case 356: /* order_by_clause_opt */
    case 360: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy600)); 
}
      break;
    case 261: /* alter_db_option */
    case 284: /* alter_table_option */
{
 
}
      break;
    case 273: /* type_name */
{
 
}
      break;
    case 326: /* compare_op */
    case 327: /* in_op */
{
 
}
      break;
    case 339: /* join_type */
{
 
}
      break;
    case 353: /* fill_mode */
{
 
}
      break;
    case 362: /* ordering_specification_opt */
{
 
}
      break;
    case 363: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  242,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  242,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  243,    0 }, /* (2) account_options ::= */
  {  243,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  243,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  243,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  243,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  243,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  243,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  243,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  243,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  243,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  244,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  244,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  246,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  246,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  246,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  246,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  246,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  246,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  246,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  246,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  246,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  246,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  242,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  242,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  242,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  242,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  242,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  242,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  248,   -1 }, /* (30) privileges ::= ALL */
  {  248,   -1 }, /* (31) privileges ::= priv_type_list */
  {  250,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  250,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  251,   -1 }, /* (34) priv_type ::= READ */
  {  251,   -1 }, /* (35) priv_type ::= WRITE */
  {  249,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  249,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  242,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  242,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  242,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  242,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  242,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  242,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  242,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  242,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  253,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  253,   -1 }, /* (47) dnode_endpoint ::= NK_ID */
  {  253,   -1 }, /* (48) dnode_endpoint ::= NK_IPTOKEN */
  {  242,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  242,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  242,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  242,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  242,   -2 }, /* (61) cmd ::= USE db_name */
  {  242,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  254,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  254,    0 }, /* (64) not_exists_opt ::= */
  {  256,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  256,    0 }, /* (66) exists_opt ::= */
  {  255,    0 }, /* (67) db_options ::= */
  {  255,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  255,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  255,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  255,   -3 }, /* (71) db_options ::= db_options DURATION NK_INTEGER */
  {  255,   -3 }, /* (72) db_options ::= db_options DURATION NK_VARIABLE */
  {  255,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  255,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  255,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  255,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  255,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  255,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  255,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  255,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  255,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  255,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  255,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  255,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  255,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  255,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  255,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  257,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  257,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  261,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  261,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  261,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  261,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  261,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  261,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  261,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  261,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  261,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  258,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  258,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  259,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  259,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  260,   -1 }, /* (103) retention_list ::= retention */
  {  260,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  262,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  242,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  242,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  242,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  242,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  242,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  242,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  242,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  270,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  270,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  270,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  270,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  270,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  270,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  270,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  270,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  270,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  270,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  267,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  267,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  275,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  269,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  269,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  278,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  276,    0 }, /* (129) specific_tags_opt ::= */
  {  276,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  263,   -1 }, /* (131) full_table_name ::= table_name */
  {  263,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  264,   -1 }, /* (133) column_def_list ::= column_def */
  {  264,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  281,   -2 }, /* (135) column_def ::= column_name type_name */
  {  281,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  273,   -1 }, /* (137) type_name ::= BOOL */
  {  273,   -1 }, /* (138) type_name ::= TINYINT */
  {  273,   -1 }, /* (139) type_name ::= SMALLINT */
  {  273,   -1 }, /* (140) type_name ::= INT */
  {  273,   -1 }, /* (141) type_name ::= INTEGER */
  {  273,   -1 }, /* (142) type_name ::= BIGINT */
  {  273,   -1 }, /* (143) type_name ::= FLOAT */
  {  273,   -1 }, /* (144) type_name ::= DOUBLE */
  {  273,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  273,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  273,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  273,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  273,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  273,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  273,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  273,   -1 }, /* (152) type_name ::= JSON */
  {  273,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  273,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  273,   -1 }, /* (155) type_name ::= BLOB */
  {  273,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  273,   -1 }, /* (157) type_name ::= DECIMAL */
  {  273,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  273,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  265,    0 }, /* (160) tags_def_opt ::= */
  {  265,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  268,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  266,    0 }, /* (163) table_options ::= */
  {  266,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  266,   -3 }, /* (165) table_options ::= table_options MAX_DELAY duration_list */
  {  266,   -3 }, /* (166) table_options ::= table_options WATERMARK duration_list */
  {  266,   -5 }, /* (167) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  266,   -3 }, /* (168) table_options ::= table_options TTL NK_INTEGER */
  {  266,   -5 }, /* (169) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  271,   -1 }, /* (170) alter_table_options ::= alter_table_option */
  {  271,   -2 }, /* (171) alter_table_options ::= alter_table_options alter_table_option */
  {  284,   -2 }, /* (172) alter_table_option ::= COMMENT NK_STRING */
  {  284,   -2 }, /* (173) alter_table_option ::= TTL NK_INTEGER */
  {  282,   -1 }, /* (174) duration_list ::= duration_literal */
  {  282,   -3 }, /* (175) duration_list ::= duration_list NK_COMMA duration_literal */
  {  283,   -1 }, /* (176) rollup_func_list ::= rollup_func_name */
  {  283,   -3 }, /* (177) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  286,   -1 }, /* (178) rollup_func_name ::= function_name */
  {  286,   -1 }, /* (179) rollup_func_name ::= FIRST */
  {  286,   -1 }, /* (180) rollup_func_name ::= LAST */
  {  279,   -1 }, /* (181) col_name_list ::= col_name */
  {  279,   -3 }, /* (182) col_name_list ::= col_name_list NK_COMMA col_name */
  {  288,   -1 }, /* (183) col_name ::= column_name */
  {  242,   -2 }, /* (184) cmd ::= SHOW DNODES */
  {  242,   -2 }, /* (185) cmd ::= SHOW USERS */
  {  242,   -2 }, /* (186) cmd ::= SHOW DATABASES */
  {  242,   -4 }, /* (187) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  242,   -4 }, /* (188) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  242,   -3 }, /* (189) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  242,   -2 }, /* (190) cmd ::= SHOW MNODES */
  {  242,   -2 }, /* (191) cmd ::= SHOW MODULES */
  {  242,   -2 }, /* (192) cmd ::= SHOW QNODES */
  {  242,   -2 }, /* (193) cmd ::= SHOW FUNCTIONS */
  {  242,   -5 }, /* (194) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  242,   -2 }, /* (195) cmd ::= SHOW STREAMS */
  {  242,   -2 }, /* (196) cmd ::= SHOW ACCOUNTS */
  {  242,   -2 }, /* (197) cmd ::= SHOW APPS */
  {  242,   -2 }, /* (198) cmd ::= SHOW CONNECTIONS */
  {  242,   -2 }, /* (199) cmd ::= SHOW LICENCE */
  {  242,   -2 }, /* (200) cmd ::= SHOW GRANTS */
  {  242,   -4 }, /* (201) cmd ::= SHOW CREATE DATABASE db_name */
  {  242,   -4 }, /* (202) cmd ::= SHOW CREATE TABLE full_table_name */
  {  242,   -4 }, /* (203) cmd ::= SHOW CREATE STABLE full_table_name */
  {  242,   -2 }, /* (204) cmd ::= SHOW QUERIES */
  {  242,   -2 }, /* (205) cmd ::= SHOW SCORES */
  {  242,   -2 }, /* (206) cmd ::= SHOW TOPICS */
  {  242,   -2 }, /* (207) cmd ::= SHOW VARIABLES */
  {  242,   -3 }, /* (208) cmd ::= SHOW LOCAL VARIABLES */
  {  242,   -4 }, /* (209) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  242,   -2 }, /* (210) cmd ::= SHOW BNODES */
  {  242,   -2 }, /* (211) cmd ::= SHOW SNODES */
  {  242,   -2 }, /* (212) cmd ::= SHOW CLUSTER */
  {  242,   -2 }, /* (213) cmd ::= SHOW TRANSACTIONS */
  {  242,   -4 }, /* (214) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  289,    0 }, /* (215) db_name_cond_opt ::= */
  {  289,   -2 }, /* (216) db_name_cond_opt ::= db_name NK_DOT */
  {  290,    0 }, /* (217) like_pattern_opt ::= */
  {  290,   -2 }, /* (218) like_pattern_opt ::= LIKE NK_STRING */
  {  291,   -1 }, /* (219) table_name_cond ::= table_name */
  {  292,    0 }, /* (220) from_db_opt ::= */
  {  292,   -2 }, /* (221) from_db_opt ::= FROM db_name */
  {  242,   -8 }, /* (222) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  242,  -10 }, /* (223) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  242,   -6 }, /* (224) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  294,    0 }, /* (225) index_options ::= */
  {  294,   -9 }, /* (226) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  294,  -11 }, /* (227) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  295,   -1 }, /* (228) func_list ::= func */
  {  295,   -3 }, /* (229) func_list ::= func_list NK_COMMA func */
  {  297,   -4 }, /* (230) func ::= function_name NK_LP expression_list NK_RP */
  {  242,   -6 }, /* (231) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  242,   -7 }, /* (232) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  242,   -7 }, /* (233) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  242,   -4 }, /* (234) cmd ::= DROP TOPIC exists_opt topic_name */
  {  242,   -7 }, /* (235) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  242,   -2 }, /* (236) cmd ::= DESC full_table_name */
  {  242,   -2 }, /* (237) cmd ::= DESCRIBE full_table_name */
  {  242,   -3 }, /* (238) cmd ::= RESET QUERY CACHE */
  {  242,   -4 }, /* (239) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  302,    0 }, /* (240) analyze_opt ::= */
  {  302,   -1 }, /* (241) analyze_opt ::= ANALYZE */
  {  303,    0 }, /* (242) explain_options ::= */
  {  303,   -3 }, /* (243) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  303,   -3 }, /* (244) explain_options ::= explain_options RATIO NK_FLOAT */
  {  242,   -6 }, /* (245) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  242,  -10 }, /* (246) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  242,   -4 }, /* (247) cmd ::= DROP FUNCTION exists_opt function_name */
  {  304,    0 }, /* (248) agg_func_opt ::= */
  {  304,   -1 }, /* (249) agg_func_opt ::= AGGREGATE */
  {  305,    0 }, /* (250) bufsize_opt ::= */
  {  305,   -2 }, /* (251) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  242,   -8 }, /* (252) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  242,   -4 }, /* (253) cmd ::= DROP STREAM exists_opt stream_name */
  {  308,    0 }, /* (254) into_opt ::= */
  {  308,   -2 }, /* (255) into_opt ::= INTO full_table_name */
  {  307,    0 }, /* (256) stream_options ::= */
  {  307,   -3 }, /* (257) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  307,   -3 }, /* (258) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  307,   -4 }, /* (259) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  307,   -3 }, /* (260) stream_options ::= stream_options WATERMARK duration_literal */
  {  242,   -3 }, /* (261) cmd ::= KILL CONNECTION NK_INTEGER */
  {  242,   -3 }, /* (262) cmd ::= KILL QUERY NK_STRING */
  {  242,   -3 }, /* (263) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  242,   -2 }, /* (264) cmd ::= BALANCE VGROUP */
  {  242,   -4 }, /* (265) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  242,   -4 }, /* (266) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  242,   -3 }, /* (267) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  309,   -2 }, /* (268) dnode_list ::= DNODE NK_INTEGER */
  {  309,   -3 }, /* (269) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  242,   -3 }, /* (270) cmd ::= SYNCDB db_name REPLICA */
  {  242,   -4 }, /* (271) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  242,   -1 }, /* (272) cmd ::= query_expression */
  {  245,   -1 }, /* (273) literal ::= NK_INTEGER */
  {  245,   -1 }, /* (274) literal ::= NK_FLOAT */
  {  245,   -1 }, /* (275) literal ::= NK_STRING */
  {  245,   -1 }, /* (276) literal ::= NK_BOOL */
  {  245,   -2 }, /* (277) literal ::= TIMESTAMP NK_STRING */
  {  245,   -1 }, /* (278) literal ::= duration_literal */
  {  245,   -1 }, /* (279) literal ::= NULL */
  {  245,   -1 }, /* (280) literal ::= NK_QUESTION */
  {  285,   -1 }, /* (281) duration_literal ::= NK_VARIABLE */
  {  311,   -1 }, /* (282) signed ::= NK_INTEGER */
  {  311,   -2 }, /* (283) signed ::= NK_PLUS NK_INTEGER */
  {  311,   -2 }, /* (284) signed ::= NK_MINUS NK_INTEGER */
  {  311,   -1 }, /* (285) signed ::= NK_FLOAT */
  {  311,   -2 }, /* (286) signed ::= NK_PLUS NK_FLOAT */
  {  311,   -2 }, /* (287) signed ::= NK_MINUS NK_FLOAT */
  {  274,   -1 }, /* (288) signed_literal ::= signed */
  {  274,   -1 }, /* (289) signed_literal ::= NK_STRING */
  {  274,   -1 }, /* (290) signed_literal ::= NK_BOOL */
  {  274,   -2 }, /* (291) signed_literal ::= TIMESTAMP NK_STRING */
  {  274,   -1 }, /* (292) signed_literal ::= duration_literal */
  {  274,   -1 }, /* (293) signed_literal ::= NULL */
  {  274,   -1 }, /* (294) signed_literal ::= literal_func */
  {  277,   -1 }, /* (295) literal_list ::= signed_literal */
  {  277,   -3 }, /* (296) literal_list ::= literal_list NK_COMMA signed_literal */
  {  252,   -1 }, /* (297) db_name ::= NK_ID */
  {  280,   -1 }, /* (298) table_name ::= NK_ID */
  {  272,   -1 }, /* (299) column_name ::= NK_ID */
  {  287,   -1 }, /* (300) function_name ::= NK_ID */
  {  313,   -1 }, /* (301) table_alias ::= NK_ID */
  {  314,   -1 }, /* (302) column_alias ::= NK_ID */
  {  247,   -1 }, /* (303) user_name ::= NK_ID */
  {  293,   -1 }, /* (304) index_name ::= NK_ID */
  {  299,   -1 }, /* (305) topic_name ::= NK_ID */
  {  306,   -1 }, /* (306) stream_name ::= NK_ID */
  {  301,   -1 }, /* (307) cgroup_name ::= NK_ID */
  {  315,   -1 }, /* (308) expression ::= literal */
  {  315,   -1 }, /* (309) expression ::= pseudo_column */
  {  315,   -1 }, /* (310) expression ::= column_reference */
  {  315,   -1 }, /* (311) expression ::= function_expression */
  {  315,   -1 }, /* (312) expression ::= subquery */
  {  315,   -3 }, /* (313) expression ::= NK_LP expression NK_RP */
  {  315,   -2 }, /* (314) expression ::= NK_PLUS expression */
  {  315,   -2 }, /* (315) expression ::= NK_MINUS expression */
  {  315,   -3 }, /* (316) expression ::= expression NK_PLUS expression */
  {  315,   -3 }, /* (317) expression ::= expression NK_MINUS expression */
  {  315,   -3 }, /* (318) expression ::= expression NK_STAR expression */
  {  315,   -3 }, /* (319) expression ::= expression NK_SLASH expression */
  {  315,   -3 }, /* (320) expression ::= expression NK_REM expression */
  {  315,   -3 }, /* (321) expression ::= column_reference NK_ARROW NK_STRING */
  {  298,   -1 }, /* (322) expression_list ::= expression */
  {  298,   -3 }, /* (323) expression_list ::= expression_list NK_COMMA expression */
  {  317,   -1 }, /* (324) column_reference ::= column_name */
  {  317,   -3 }, /* (325) column_reference ::= table_name NK_DOT column_name */
  {  316,   -1 }, /* (326) pseudo_column ::= ROWTS */
  {  316,   -1 }, /* (327) pseudo_column ::= TBNAME */
  {  316,   -3 }, /* (328) pseudo_column ::= table_name NK_DOT TBNAME */
  {  316,   -1 }, /* (329) pseudo_column ::= QSTARTTS */
  {  316,   -1 }, /* (330) pseudo_column ::= QENDTS */
  {  316,   -1 }, /* (331) pseudo_column ::= WSTARTTS */
  {  316,   -1 }, /* (332) pseudo_column ::= WENDTS */
  {  316,   -1 }, /* (333) pseudo_column ::= WDURATION */
  {  318,   -4 }, /* (334) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  318,   -4 }, /* (335) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  318,   -6 }, /* (336) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  318,   -1 }, /* (337) function_expression ::= literal_func */
  {  312,   -3 }, /* (338) literal_func ::= noarg_func NK_LP NK_RP */
  {  312,   -1 }, /* (339) literal_func ::= NOW */
  {  322,   -1 }, /* (340) noarg_func ::= NOW */
  {  322,   -1 }, /* (341) noarg_func ::= TODAY */
  {  322,   -1 }, /* (342) noarg_func ::= TIMEZONE */
  {  320,   -1 }, /* (343) star_func ::= COUNT */
  {  320,   -1 }, /* (344) star_func ::= FIRST */
  {  320,   -1 }, /* (345) star_func ::= LAST */
  {  320,   -1 }, /* (346) star_func ::= LAST_ROW */
  {  321,   -1 }, /* (347) star_func_para_list ::= NK_STAR */
  {  321,   -1 }, /* (348) star_func_para_list ::= other_para_list */
  {  323,   -1 }, /* (349) other_para_list ::= star_func_para */
  {  323,   -3 }, /* (350) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  324,   -1 }, /* (351) star_func_para ::= expression */
  {  324,   -3 }, /* (352) star_func_para ::= table_name NK_DOT NK_STAR */
  {  325,   -3 }, /* (353) predicate ::= expression compare_op expression */
  {  325,   -5 }, /* (354) predicate ::= expression BETWEEN expression AND expression */
  {  325,   -6 }, /* (355) predicate ::= expression NOT BETWEEN expression AND expression */
  {  325,   -3 }, /* (356) predicate ::= expression IS NULL */
  {  325,   -4 }, /* (357) predicate ::= expression IS NOT NULL */
  {  325,   -3 }, /* (358) predicate ::= expression in_op in_predicate_value */
  {  326,   -1 }, /* (359) compare_op ::= NK_LT */
  {  326,   -1 }, /* (360) compare_op ::= NK_GT */
  {  326,   -1 }, /* (361) compare_op ::= NK_LE */
  {  326,   -1 }, /* (362) compare_op ::= NK_GE */
  {  326,   -1 }, /* (363) compare_op ::= NK_NE */
  {  326,   -1 }, /* (364) compare_op ::= NK_EQ */
  {  326,   -1 }, /* (365) compare_op ::= LIKE */
  {  326,   -2 }, /* (366) compare_op ::= NOT LIKE */
  {  326,   -1 }, /* (367) compare_op ::= MATCH */
  {  326,   -1 }, /* (368) compare_op ::= NMATCH */
  {  326,   -1 }, /* (369) compare_op ::= CONTAINS */
  {  327,   -1 }, /* (370) in_op ::= IN */
  {  327,   -2 }, /* (371) in_op ::= NOT IN */
  {  328,   -3 }, /* (372) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  329,   -1 }, /* (373) boolean_value_expression ::= boolean_primary */
  {  329,   -2 }, /* (374) boolean_value_expression ::= NOT boolean_primary */
  {  329,   -3 }, /* (375) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  329,   -3 }, /* (376) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  330,   -1 }, /* (377) boolean_primary ::= predicate */
  {  330,   -3 }, /* (378) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  331,   -1 }, /* (379) common_expression ::= expression */
  {  331,   -1 }, /* (380) common_expression ::= boolean_value_expression */
  {  332,   -2 }, /* (381) from_clause ::= FROM table_reference_list */
  {  333,   -1 }, /* (382) table_reference_list ::= table_reference */
  {  333,   -3 }, /* (383) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  334,   -1 }, /* (384) table_reference ::= table_primary */
  {  334,   -1 }, /* (385) table_reference ::= joined_table */
  {  335,   -2 }, /* (386) table_primary ::= table_name alias_opt */
  {  335,   -4 }, /* (387) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  335,   -2 }, /* (388) table_primary ::= subquery alias_opt */
  {  335,   -1 }, /* (389) table_primary ::= parenthesized_joined_table */
  {  337,    0 }, /* (390) alias_opt ::= */
  {  337,   -1 }, /* (391) alias_opt ::= table_alias */
  {  337,   -2 }, /* (392) alias_opt ::= AS table_alias */
  {  338,   -3 }, /* (393) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  338,   -3 }, /* (394) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  336,   -6 }, /* (395) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  339,    0 }, /* (396) join_type ::= */
  {  339,   -1 }, /* (397) join_type ::= INNER */
  {  341,  -12 }, /* (398) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  342,    0 }, /* (399) set_quantifier_opt ::= */
  {  342,   -1 }, /* (400) set_quantifier_opt ::= DISTINCT */
  {  342,   -1 }, /* (401) set_quantifier_opt ::= ALL */
  {  343,   -1 }, /* (402) select_list ::= NK_STAR */
  {  343,   -1 }, /* (403) select_list ::= select_sublist */
  {  351,   -1 }, /* (404) select_sublist ::= select_item */
  {  351,   -3 }, /* (405) select_sublist ::= select_sublist NK_COMMA select_item */
  {  352,   -1 }, /* (406) select_item ::= common_expression */
  {  352,   -2 }, /* (407) select_item ::= common_expression column_alias */
  {  352,   -3 }, /* (408) select_item ::= common_expression AS column_alias */
  {  352,   -3 }, /* (409) select_item ::= table_name NK_DOT NK_STAR */
  {  310,    0 }, /* (410) where_clause_opt ::= */
  {  310,   -2 }, /* (411) where_clause_opt ::= WHERE search_condition */
  {  344,    0 }, /* (412) partition_by_clause_opt ::= */
  {  344,   -3 }, /* (413) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  348,    0 }, /* (414) twindow_clause_opt ::= */
  {  348,   -6 }, /* (415) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  348,   -4 }, /* (416) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  348,   -6 }, /* (417) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  348,   -8 }, /* (418) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  296,    0 }, /* (419) sliding_opt ::= */
  {  296,   -4 }, /* (420) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  347,    0 }, /* (421) fill_opt ::= */
  {  347,   -4 }, /* (422) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  347,   -6 }, /* (423) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  353,   -1 }, /* (424) fill_mode ::= NONE */
  {  353,   -1 }, /* (425) fill_mode ::= PREV */
  {  353,   -1 }, /* (426) fill_mode ::= NULL */
  {  353,   -1 }, /* (427) fill_mode ::= LINEAR */
  {  353,   -1 }, /* (428) fill_mode ::= NEXT */
  {  349,    0 }, /* (429) group_by_clause_opt ::= */
  {  349,   -3 }, /* (430) group_by_clause_opt ::= GROUP BY group_by_list */
  {  354,   -1 }, /* (431) group_by_list ::= expression */
  {  354,   -3 }, /* (432) group_by_list ::= group_by_list NK_COMMA expression */
  {  350,    0 }, /* (433) having_clause_opt ::= */
  {  350,   -2 }, /* (434) having_clause_opt ::= HAVING search_condition */
  {  345,    0 }, /* (435) range_opt ::= */
  {  345,   -6 }, /* (436) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  346,    0 }, /* (437) every_opt ::= */
  {  346,   -4 }, /* (438) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  300,   -4 }, /* (439) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  355,   -1 }, /* (440) query_expression_body ::= query_primary */
  {  355,   -4 }, /* (441) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  355,   -3 }, /* (442) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  359,   -1 }, /* (443) query_primary ::= query_specification */
  {  359,   -6 }, /* (444) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  356,    0 }, /* (445) order_by_clause_opt ::= */
  {  356,   -3 }, /* (446) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  357,    0 }, /* (447) slimit_clause_opt ::= */
  {  357,   -2 }, /* (448) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  357,   -4 }, /* (449) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  357,   -4 }, /* (450) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  358,    0 }, /* (451) limit_clause_opt ::= */
  {  358,   -2 }, /* (452) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  358,   -4 }, /* (453) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  358,   -4 }, /* (454) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  319,   -3 }, /* (455) subquery ::= NK_LP query_expression NK_RP */
  {  340,   -1 }, /* (456) search_condition ::= common_expression */
  {  360,   -1 }, /* (457) sort_specification_list ::= sort_specification */
  {  360,   -3 }, /* (458) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  361,   -3 }, /* (459) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  362,    0 }, /* (460) ordering_specification_opt ::= */
  {  362,   -1 }, /* (461) ordering_specification_opt ::= ASC */
  {  362,   -1 }, /* (462) ordering_specification_opt ::= DESC */
  {  363,    0 }, /* (463) null_ordering_opt ::= */
  {  363,   -2 }, /* (464) null_ordering_opt ::= NULLS FIRST */
  {  363,   -2 }, /* (465) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,243,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,244,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,243,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,245,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,246,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,244,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,246,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,245,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy57, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy57, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy57); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy389, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy389, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy389 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy389 = yymsp[0].minor.yy389; }
  yymsp[0].minor.yy389 = yylhsminor.yy389;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy389 = yymsp[-2].minor.yy389 | yymsp[0].minor.yy389; }
  yymsp[-2].minor.yy389 = yylhsminor.yy389;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy389 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy389 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy57 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy57 = yylhsminor.yy57;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy57 = yymsp[-2].minor.yy57; }
  yymsp[-2].minor.yy57 = yylhsminor.yy57;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy57, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy57); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 297: /* db_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 298: /* table_name ::= NK_ID */ yytestcase(yyruleno==298);
      case 299: /* column_name ::= NK_ID */ yytestcase(yyruleno==299);
      case 300: /* function_name ::= NK_ID */ yytestcase(yyruleno==300);
      case 301: /* table_alias ::= NK_ID */ yytestcase(yyruleno==301);
      case 302: /* column_alias ::= NK_ID */ yytestcase(yyruleno==302);
      case 303: /* user_name ::= NK_ID */ yytestcase(yyruleno==303);
      case 304: /* index_name ::= NK_ID */ yytestcase(yyruleno==304);
      case 305: /* topic_name ::= NK_ID */ yytestcase(yyruleno==305);
      case 306: /* stream_name ::= NK_ID */ yytestcase(yyruleno==306);
      case 307: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==307);
      case 340: /* noarg_func ::= NOW */ yytestcase(yyruleno==340);
      case 341: /* noarg_func ::= TODAY */ yytestcase(yyruleno==341);
      case 342: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==342);
      case 343: /* star_func ::= COUNT */ yytestcase(yyruleno==343);
      case 344: /* star_func ::= FIRST */ yytestcase(yyruleno==344);
      case 345: /* star_func ::= LAST */ yytestcase(yyruleno==345);
      case 346: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==346);
{ yylhsminor.yy57 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy57 = yylhsminor.yy57;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy481, &yymsp[-1].minor.yy57, yymsp[0].minor.yy392); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy481, &yymsp[0].minor.yy57); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy57); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy57, yymsp[0].minor.yy392); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy481 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 240: /* analyze_opt ::= */ yytestcase(yyruleno==240);
      case 248: /* agg_func_opt ::= */ yytestcase(yyruleno==248);
      case 399: /* set_quantifier_opt ::= */ yytestcase(yyruleno==399);
{ yymsp[1].minor.yy481 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy481 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy392 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 71: /* db_options ::= db_options DURATION NK_INTEGER */
      case 72: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_KEEP, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_RETENTIONS, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy392 = createAlterDatabaseOptions(pCxt); yylhsminor.yy392 = setAlterDatabaseOption(pCxt, yylhsminor.yy392, &yymsp[0].minor.yy221); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy392 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy392, &yymsp[0].minor.yy221); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy221.type = DB_OPTION_KEEP; yymsp[-1].minor.yy221.pList = yymsp[0].minor.yy600; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_PAGES; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_STRICT; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_WAL; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy600 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 269: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==269);
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy600 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 176: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==176);
      case 181: /* col_name_list ::= col_name */ yytestcase(yyruleno==181);
      case 228: /* func_list ::= func */ yytestcase(yyruleno==228);
      case 295: /* literal_list ::= signed_literal */ yytestcase(yyruleno==295);
      case 349: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==349);
      case 404: /* select_sublist ::= select_item */ yytestcase(yyruleno==404);
      case 457: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==457);
{ yylhsminor.yy600 = createNodeList(pCxt, yymsp[0].minor.yy392); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 177: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==177);
      case 182: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==182);
      case 229: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==229);
      case 296: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==296);
      case 350: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==350);
      case 405: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==405);
      case 458: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==458);
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, yymsp[0].minor.yy392); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy392 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy481, yymsp[-5].minor.yy392, yymsp[-3].minor.yy600, yymsp[-1].minor.yy600, yymsp[0].minor.yy392); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy481, yymsp[0].minor.yy392); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 272: /* cmd ::= query_expression */ yytestcase(yyruleno==272);
{ pCxt->pRootNode = yymsp[0].minor.yy392; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy392 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy392 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy392, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy57); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy392 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy57, &yymsp[0].minor.yy57); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy392 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy392, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy57); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy392 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy57, &yymsp[0].minor.yy57); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy392 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy392, &yymsp[-2].minor.yy57, yymsp[0].minor.yy392); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy392 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy481, yymsp[-8].minor.yy392, yymsp[-6].minor.yy392, yymsp[-5].minor.yy600, yymsp[-2].minor.yy600, yymsp[0].minor.yy392); }
  yymsp[-9].minor.yy392 = yylhsminor.yy392;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy392 = createDropTableClause(pCxt, yymsp[-1].minor.yy481, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 412: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==412);
      case 429: /* group_by_clause_opt ::= */ yytestcase(yyruleno==429);
      case 445: /* order_by_clause_opt ::= */ yytestcase(yyruleno==445);
{ yymsp[1].minor.yy600 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy600 = yymsp[-1].minor.yy600; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy392 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy57, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy392 = createRealTableNode(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57, NULL); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy392 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448, NULL); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy392 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy57, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 348: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==348);
      case 403: /* select_list ::= select_sublist */ yytestcase(yyruleno==403);
{ yylhsminor.yy600 = yymsp[0].minor.yy600; }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy600 = yymsp[-1].minor.yy600; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy392 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 165: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 166: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 167: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-4].minor.yy392, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy600); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 168: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 169: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-4].minor.yy392, TABLE_OPTION_SMA, yymsp[-1].minor.yy600); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 170: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy392 = createAlterTableOptions(pCxt); yylhsminor.yy392 = setTableOption(pCxt, yylhsminor.yy392, yymsp[0].minor.yy221.type, &yymsp[0].minor.yy221.val); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 171: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy221.type, &yymsp[0].minor.yy221.val); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 172: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy221.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 173: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy221.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 174: /* duration_list ::= duration_literal */
      case 322: /* expression_list ::= expression */ yytestcase(yyruleno==322);
{ yylhsminor.yy600 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 175: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 323: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==323);
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, releaseRawExprNode(pCxt, yymsp[0].minor.yy392)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 178: /* rollup_func_name ::= function_name */
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[0].minor.yy57, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 179: /* rollup_func_name ::= FIRST */
      case 180: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==180);
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 183: /* col_name ::= column_name */
{ yylhsminor.yy392 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy57); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 184: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 185: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 186: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 187: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, OP_TYPE_LIKE); }
        break;
      case 188: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, OP_TYPE_LIKE); }
        break;
      case 189: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy392, NULL, OP_TYPE_LIKE); }
        break;
      case 190: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 191: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 192: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 193: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 194: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy392, yymsp[-1].minor.yy392, OP_TYPE_EQUAL); }
        break;
      case 195: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 196: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 197: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 198: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 199: /* cmd ::= SHOW LICENCE */
      case 200: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==200);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 201: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy57); }
        break;
      case 202: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy392); }
        break;
      case 203: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy392); }
        break;
      case 204: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 205: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 206: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 207: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 208: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 209: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 210: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 211: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 212: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 213: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 214: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy392); }
        break;
      case 215: /* db_name_cond_opt ::= */
      case 220: /* from_db_opt ::= */ yytestcase(yyruleno==220);
{ yymsp[1].minor.yy392 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 216: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy57); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 217: /* like_pattern_opt ::= */
      case 225: /* index_options ::= */ yytestcase(yyruleno==225);
      case 254: /* into_opt ::= */ yytestcase(yyruleno==254);
      case 410: /* where_clause_opt ::= */ yytestcase(yyruleno==410);
      case 414: /* twindow_clause_opt ::= */ yytestcase(yyruleno==414);
      case 419: /* sliding_opt ::= */ yytestcase(yyruleno==419);
      case 421: /* fill_opt ::= */ yytestcase(yyruleno==421);
      case 433: /* having_clause_opt ::= */ yytestcase(yyruleno==433);
      case 435: /* range_opt ::= */ yytestcase(yyruleno==435);
      case 437: /* every_opt ::= */ yytestcase(yyruleno==437);
      case 447: /* slimit_clause_opt ::= */ yytestcase(yyruleno==447);
      case 451: /* limit_clause_opt ::= */ yytestcase(yyruleno==451);
{ yymsp[1].minor.yy392 = NULL; }
        break;
      case 218: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 219: /* table_name_cond ::= table_name */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy57); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 221: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy57); }
        break;
      case 222: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy481, &yymsp[-3].minor.yy57, &yymsp[-1].minor.yy57, NULL, yymsp[0].minor.yy392); }
        break;
      case 223: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy481, &yymsp[-5].minor.yy57, &yymsp[-3].minor.yy57, yymsp[-1].minor.yy600, NULL); }
        break;
      case 224: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy481, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57); }
        break;
      case 226: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy392 = createIndexOption(pCxt, yymsp[-6].minor.yy600, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), NULL, yymsp[0].minor.yy392); }
        break;
      case 227: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy392 = createIndexOption(pCxt, yymsp[-8].minor.yy600, releaseRawExprNode(pCxt, yymsp[-4].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), yymsp[0].minor.yy392); }
        break;
      case 230: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[-3].minor.yy57, yymsp[-1].minor.yy600); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 231: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy481, &yymsp[-2].minor.yy57, yymsp[0].minor.yy392, NULL, NULL); }
        break;
      case 232: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy481, &yymsp[-3].minor.yy57, NULL, &yymsp[0].minor.yy57, NULL); }
        break;
      case 233: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy481, &yymsp[-3].minor.yy57, NULL, NULL, yymsp[0].minor.yy392); }
        break;
      case 234: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy481, &yymsp[0].minor.yy57); }
        break;
      case 235: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy481, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57); }
        break;
      case 236: /* cmd ::= DESC full_table_name */
      case 237: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==237);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy392); }
        break;
      case 238: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 239: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy481, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 241: /* analyze_opt ::= ANALYZE */
      case 249: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==249);
      case 400: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==400);
{ yymsp[0].minor.yy481 = true; }
        break;
      case 242: /* explain_options ::= */
{ yymsp[1].minor.yy392 = createDefaultExplainOptions(pCxt); }
        break;
      case 243: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy392 = setExplainVerbose(pCxt, yymsp[-2].minor.yy392, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 244: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy392 = setExplainRatio(pCxt, yymsp[-2].minor.yy392, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 245: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy600); }
        break;
      case 246: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy481, yymsp[-8].minor.yy481, &yymsp[-5].minor.yy57, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy448, yymsp[0].minor.yy228); }
        break;
      case 247: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy481, &yymsp[0].minor.yy57); }
        break;
      case 250: /* bufsize_opt ::= */
{ yymsp[1].minor.yy228 = 0; }
        break;
      case 251: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy228 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 252: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy481, &yymsp[-4].minor.yy57, yymsp[-2].minor.yy392, yymsp[-3].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 253: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy481, &yymsp[0].minor.yy57); }
        break;
      case 255: /* into_opt ::= INTO full_table_name */
      case 381: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==381);
      case 411: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==411);
      case 434: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==434);
{ yymsp[-1].minor.yy392 = yymsp[0].minor.yy392; }
        break;
      case 256: /* stream_options ::= */
{ yymsp[1].minor.yy392 = createStreamOptions(pCxt); }
        break;
      case 257: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 258: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 259: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy392)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy392)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); yylhsminor.yy392 = yymsp[-3].minor.yy392; }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 260: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 261: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 262: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 263: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 264: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 265: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 266: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy600); }
        break;
      case 267: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 268: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy600 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 270: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy57); }
        break;
      case 271: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 273: /* literal ::= NK_INTEGER */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 274: /* literal ::= NK_FLOAT */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 275: /* literal ::= NK_STRING */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 276: /* literal ::= NK_BOOL */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 277: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 278: /* literal ::= duration_literal */
      case 288: /* signed_literal ::= signed */ yytestcase(yyruleno==288);
      case 308: /* expression ::= literal */ yytestcase(yyruleno==308);
      case 309: /* expression ::= pseudo_column */ yytestcase(yyruleno==309);
      case 310: /* expression ::= column_reference */ yytestcase(yyruleno==310);
      case 311: /* expression ::= function_expression */ yytestcase(yyruleno==311);
      case 312: /* expression ::= subquery */ yytestcase(yyruleno==312);
      case 337: /* function_expression ::= literal_func */ yytestcase(yyruleno==337);
      case 373: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==373);
      case 377: /* boolean_primary ::= predicate */ yytestcase(yyruleno==377);
      case 379: /* common_expression ::= expression */ yytestcase(yyruleno==379);
      case 380: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==380);
      case 382: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==382);
      case 384: /* table_reference ::= table_primary */ yytestcase(yyruleno==384);
      case 385: /* table_reference ::= joined_table */ yytestcase(yyruleno==385);
      case 389: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==389);
      case 440: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==440);
      case 443: /* query_primary ::= query_specification */ yytestcase(yyruleno==443);
{ yylhsminor.yy392 = yymsp[0].minor.yy392; }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 279: /* literal ::= NULL */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 280: /* literal ::= NK_QUESTION */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 281: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 282: /* signed ::= NK_INTEGER */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 283: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 284: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 285: /* signed ::= NK_FLOAT */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 286: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 287: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 289: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 290: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 291: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 292: /* signed_literal ::= duration_literal */
      case 294: /* signed_literal ::= literal_func */ yytestcase(yyruleno==294);
      case 351: /* star_func_para ::= expression */ yytestcase(yyruleno==351);
      case 406: /* select_item ::= common_expression */ yytestcase(yyruleno==406);
      case 456: /* search_condition ::= common_expression */ yytestcase(yyruleno==456);
{ yylhsminor.yy392 = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 293: /* signed_literal ::= NULL */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 313: /* expression ::= NK_LP expression NK_RP */
      case 378: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==378);
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 314: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy392));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 315: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy392), NULL));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 316: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 317: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 318: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 319: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 320: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 321: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 324: /* column_reference ::= column_name */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy57, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy57)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 325: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57, createColumnNode(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 326: /* pseudo_column ::= ROWTS */
      case 327: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==327);
      case 329: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==329);
      case 330: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==330);
      case 331: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==331);
      case 332: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==332);
      case 333: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==333);
      case 339: /* literal_func ::= NOW */ yytestcase(yyruleno==339);
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 328: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy57)))); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 334: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 335: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==335);
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy57, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy57, yymsp[-1].minor.yy600)); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 336: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-1].minor.yy448)); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 338: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy57, NULL)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 347: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy600 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 352: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 409: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==409);
{ yylhsminor.yy392 = createColumnNode(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 353: /* predicate ::= expression compare_op expression */
      case 358: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==358);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy324, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 354: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 355: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 356: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), NULL));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 357: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), NULL));
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 359: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy324 = OP_TYPE_LOWER_THAN; }
        break;
      case 360: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy324 = OP_TYPE_GREATER_THAN; }
        break;
      case 361: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy324 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 362: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy324 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 363: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy324 = OP_TYPE_NOT_EQUAL; }
        break;
      case 364: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy324 = OP_TYPE_EQUAL; }
        break;
      case 365: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy324 = OP_TYPE_LIKE; }
        break;
      case 366: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy324 = OP_TYPE_NOT_LIKE; }
        break;
      case 367: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy324 = OP_TYPE_MATCH; }
        break;
      case 368: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy324 = OP_TYPE_NMATCH; }
        break;
      case 369: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy324 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 370: /* in_op ::= IN */
{ yymsp[0].minor.yy324 = OP_TYPE_IN; }
        break;
      case 371: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy324 = OP_TYPE_NOT_IN; }
        break;
      case 372: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy600)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 374: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy392), NULL));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 375: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 376: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 383: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy392 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, NULL); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 386: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy392 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy57, &yymsp[0].minor.yy57); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 387: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy392 = createRealTableNode(pCxt, &yymsp[-3].minor.yy57, &yymsp[-1].minor.yy57, &yymsp[0].minor.yy57); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 388: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy392 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392), &yymsp[0].minor.yy57); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 390: /* alias_opt ::= */
{ yymsp[1].minor.yy57 = nil_token;  }
        break;
      case 391: /* alias_opt ::= table_alias */
{ yylhsminor.yy57 = yymsp[0].minor.yy57; }
  yymsp[0].minor.yy57 = yylhsminor.yy57;
        break;
      case 392: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy57 = yymsp[0].minor.yy57; }
        break;
      case 393: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 394: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==394);
{ yymsp[-2].minor.yy392 = yymsp[-1].minor.yy392; }
        break;
      case 395: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy392 = createJoinTableNode(pCxt, yymsp[-4].minor.yy204, yymsp[-5].minor.yy392, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 396: /* join_type ::= */
{ yymsp[1].minor.yy204 = JOIN_TYPE_INNER; }
        break;
      case 397: /* join_type ::= INNER */
{ yymsp[0].minor.yy204 = JOIN_TYPE_INNER; }
        break;
      case 398: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy392 = createSelectStmt(pCxt, yymsp[-10].minor.yy481, yymsp[-9].minor.yy600, yymsp[-8].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addWhereClause(pCxt, yymsp[-11].minor.yy392, yymsp[-7].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addPartitionByClause(pCxt, yymsp[-11].minor.yy392, yymsp[-6].minor.yy600);
                                                                                    yymsp[-11].minor.yy392 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy392, yymsp[-2].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addGroupByClause(pCxt, yymsp[-11].minor.yy392, yymsp[-1].minor.yy600);
                                                                                    yymsp[-11].minor.yy392 = addHavingClause(pCxt, yymsp[-11].minor.yy392, yymsp[0].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addRangeClause(pCxt, yymsp[-11].minor.yy392, yymsp[-5].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addEveryClause(pCxt, yymsp[-11].minor.yy392, yymsp[-4].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addFillClause(pCxt, yymsp[-11].minor.yy392, yymsp[-3].minor.yy392);
                                                                                  }
        break;
      case 401: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy481 = false; }
        break;
      case 402: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy600 = NULL; }
        break;
      case 407: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy392 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392), &yymsp[0].minor.yy57); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 408: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy392 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), &yymsp[0].minor.yy57); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 413: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 430: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==430);
      case 446: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==446);
{ yymsp[-2].minor.yy600 = yymsp[0].minor.yy600; }
        break;
      case 415: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy392 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 416: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy392 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 417: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy392 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), NULL, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 418: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy392 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy392), releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 420: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 438: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==438);
{ yymsp[-3].minor.yy392 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy392); }
        break;
      case 422: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy392 = createFillNode(pCxt, yymsp[-1].minor.yy270, NULL); }
        break;
      case 423: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy392 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 424: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy270 = FILL_MODE_NONE; }
        break;
      case 425: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy270 = FILL_MODE_PREV; }
        break;
      case 426: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy270 = FILL_MODE_NULL; }
        break;
      case 427: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy270 = FILL_MODE_LINEAR; }
        break;
      case 428: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy270 = FILL_MODE_NEXT; }
        break;
      case 431: /* group_by_list ::= expression */
{ yylhsminor.yy600 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 432: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 436: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy392 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 439: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy392 = addOrderByClause(pCxt, yymsp[-3].minor.yy392, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy392 = addSlimitClause(pCxt, yylhsminor.yy392, yymsp[-1].minor.yy392);
                                                                                    yylhsminor.yy392 = addLimitClause(pCxt, yylhsminor.yy392, yymsp[0].minor.yy392);
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 441: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy392 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 442: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy392 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 444: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy392 = yymsp[-4].minor.yy392; }
  yy_destructor(yypParser,356,&yymsp[-3].minor);
  yy_destructor(yypParser,357,&yymsp[-2].minor);
  yy_destructor(yypParser,358,&yymsp[-1].minor);
        break;
      case 448: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 452: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==452);
{ yymsp[-1].minor.yy392 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 449: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 453: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==453);
{ yymsp[-3].minor.yy392 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 450: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 454: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==454);
{ yymsp[-3].minor.yy392 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 455: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy392); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 459: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy392 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), yymsp[-1].minor.yy162, yymsp[0].minor.yy529); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 460: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy162 = ORDER_ASC; }
        break;
      case 461: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy162 = ORDER_ASC; }
        break;
      case 462: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy162 = ORDER_DESC; }
        break;
      case 463: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy529 = NULL_ORDER_DEFAULT; }
        break;
      case 464: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy529 = NULL_ORDER_FIRST; }
        break;
      case 465: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy529 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
