/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 461
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy32;
  SToken yy77;
  int32_t yy248;
  int8_t yy287;
  ENullOrder yy385;
  EJoinType yy560;
  SNode* yy600;
  SNodeList* yy601;
  SAlterOption yy661;
  EOperatorType yy666;
  int64_t yy717;
  EFillMode yy798;
  bool yy841;
  SDataType yy888;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             714
#define YYNRULE              545
#define YYNRULE_WITH_ACTION  545
#define YYNTOKEN             325
#define YY_MAX_SHIFT         713
#define YY_MIN_SHIFTREDUCE   1061
#define YY_MAX_SHIFTREDUCE   1605
#define YY_ERROR_ACTION      1606
#define YY_ACCEPT_ACTION     1607
#define YY_NO_ACTION         1608
#define YY_MIN_REDUCE        1609
#define YY_MAX_REDUCE        2153
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3069)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    35,  276,  460, 1876,  461, 1645,  469,  367,  461, 1645,
 /*    10 */  1808, 1810,   45,   43, 1535, 1954, 1874,  590, 1751,  466,
 /*    20 */   362,  407, 1385,   38,   37,  462, 1950,   44,   42,   41,
 /*    30 */    40,   39,  169, 1465,  459, 1383,  229,  464, 1651, 1792,
 /*    40 */   571,  602,   38,   37, 2124,  602,   44,   42,   41,   40,
 /*    50 */    39,    8,  602,  334, 1862, 1946, 1952,  345, 1460,  570,
 /*    60 */   175,  320,  187,   18, 2125,  572,  613,   38,   37, 1967,
 /*    70 */  1391,   44,   42,   41,   40,   39,  468, 1411,  583,  464,
 /*    80 */  1651,   38,   37,   45,   43,   44,   42,   41,   40,   39,
 /*    90 */  2129,  362,  171, 1385, 1609,   14,  136,  327,   81, 2026,
 /*   100 */  1985,   80,   60,   27, 1465, 1802, 1383, 1412,  586,  134,
 /*   110 */   159, 1572, 1621, 1936,  603,  619,   48,  710,  125,  124,
 /*   120 */   123,  122,  121,  120,  119,  118,  117,   48,  126, 1460,
 /*   130 */   100,  160, 1467, 1468,   18,  499, 1716,  443, 1494, 1966,
 /*   140 */    64, 1391,  478, 2002,  135, 1762,  103, 1968,  623, 1970,
 /*   150 */  1971,  618, 1754,  613, 1410, 2129, 1815,  146,  172, 2124,
 /*   160 */  2055, 1440, 1450,  355,  356, 2051,   14, 1466, 1469,  257,
 /*   170 */  2063,  582, 1813,  127,  581, 2128,  566, 2124,  177, 2125,
 /*   180 */  2127, 2129, 1386, 1595, 1384, 2124, 2081,  528,  710, 1263,
 /*   190 */  1264,  260,  570,  175, 1495,  191,  190, 2125,  572,   49,
 /*   200 */   526, 2128,  524, 1467, 1468, 2125, 2126, 1389, 1390,   53,
 /*   210 */  1439, 1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449,  615,
 /*   220 */   611, 1458, 1459, 1461, 1462, 1463, 1464,    2,   60,   60,
 /*   230 */    89,   60, 1440, 1450, 2070, 1410,  156,  116, 1466, 1469,
 /*   240 */   115,  114,  113,  112,  111,  110,  109,  108,  107,  648,
 /*   250 */   259,  227,  178, 1386, 2070, 1384, 1528,   38,   37, 1632,
 /*   260 */  2067,   44,   42,   41,   40,   39,   34,  360, 1489, 1490,
 /*   270 */  1491, 1492, 1493, 1497, 1498, 1499, 1500,  178, 1389, 1390,
 /*   280 */  2066, 1439, 1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449,
 /*   290 */   615,  611, 1458, 1459, 1461, 1462, 1463, 1464,    2,  396,
 /*   300 */    11,   45,   43, 1936, 1954, 1385, 1539, 1631, 1985,  362,
 /*   310 */   408, 1385, 1410,   86,  322, 1950,  565,  532, 1383,  530,
 /*   320 */   398,  394, 1465,  409, 1383, 1220,  645,  644,  643, 1224,
 /*   330 */   642, 1226, 1227,  641, 1229,  638, 1678, 1235,  635, 1237,
 /*   340 */  1238,  632,  629,  213, 1946, 1952,  357, 1460, 1180,  178,
 /*   350 */   401, 1936,   18, 1391, 1815,  613,  564, 1532,  164, 1391,
 /*   360 */  1113,  366, 1112, 1410,  495,  491,  487,  483,  210, 1630,
 /*   370 */  1813, 1629,   45,   43, 1470,  212, 1316, 1317,  178,  178,
 /*   380 */   362,  178, 1385, 1182,   14,   44,   42,   41,   40,   39,
 /*   390 */   657, 1114,  547, 1465, 1409, 1383, 2124, 1113, 1628, 1112,
 /*   400 */   710,  514,  513,  512,   85, 1094,  710,  208, 1610,  131,
 /*   410 */   508, 2130,  175, 1936,  507, 1936, 2125,  572, 1460,  506,
 /*   420 */   511, 1467, 1468, 1602, 1627,  505,  267,  268, 1114,  116,
 /*   430 */  1391,  266,  115,  114,  113,  112,  111,  110,  109,  108,
 /*   440 */   107,  583, 1936, 1411, 1096, 1626, 1099, 1100, 1391, 1876,
 /*   450 */  1440, 1450,  603, 1441, 1815,   46, 1466, 1469,   11,  353,
 /*   460 */     9,  331, 1873,  590,  603, 1386,   54, 1384, 1936,  575,
 /*   470 */  1813, 1386,  134, 1384,  207,  201, 1625,  710,  180,  206,
 /*   480 */    38,   37,  474, 1762,   44,   42,   41,   40,   39, 1936,
 /*   490 */  1389, 1390, 1467, 1468,   84, 1762, 1389, 1390,  199, 1439,
 /*   500 */  1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449,  615,  611,
 /*   510 */  1458, 1459, 1461, 1462, 1463, 1464,    2, 1758, 1601, 1412,
 /*   520 */  1936, 1440, 1450,  583, 1142, 1624,  571, 1466, 1469,  603,
 /*   530 */  2124,  585,  173, 2063, 2064,  603,  132, 2068, 1413,  514,
 /*   540 */   513,  512, 1386,  405, 1384,  570,  175,  131,  508,  406,
 /*   550 */  2125,  572,  507, 1623,  134, 1330, 1331,  506,  511, 1143,
 /*   560 */  1762, 1967, 1620,  505, 1809, 1810, 1762, 1389, 1390, 1936,
 /*   570 */  1439, 1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449,  615,
 /*   580 */   611, 1458, 1459, 1461, 1462, 1463, 1464,    2,   45,   43,
 /*   590 */  1329, 1332, 1985, 1740,   84,  354,  362, 1936, 1385, 1531,
 /*   600 */   620, 1607,  605,  157, 2027, 1936, 1936,  619,  130, 1465,
 /*   610 */   228, 1383, 1764,   11,  174, 2063, 2064, 1757,  132, 2068,
 /*   620 */    38,   37, 1967, 2070,   44,   42,   41,   40,   39,  519,
 /*   630 */   561, 1966, 1413,  603, 1460, 2002,  669, 1562,  103, 1968,
 /*   640 */   623, 1970, 1971,  618,  529,  613, 1391,  126,  137, 2065,
 /*   650 */   143, 2026, 2055, 1985,  504,  478,  356, 2051,  226,   45,
 /*   660 */    43,  620,  259,  603, 1762,  377, 1936,  362,  619, 1385,
 /*   670 */   607,   46, 2027,  522, 1619, 1362, 1363,  415,  516, 1618,
 /*   680 */  1465,  184, 1383,  225, 1753,   60,  558, 1560, 1561, 1563,
 /*   690 */  1564,  576, 1966,  710, 1762, 1950, 2002,  510,  509,  161,
 /*   700 */  1968,  623, 1970, 1971,  618, 1460,  613,  547, 1467, 1468,
 /*   710 */  1738, 2124,  542,  368,  567,  562,  556, 1391, 1936,   67,
 /*   720 */  1739,  157,   66, 1936, 1946, 1952, 2130,  175, 1475, 1747,
 /*   730 */  1764, 2125,  572, 1617, 1410,  613,  649, 1440, 1450, 1806,
 /*   740 */   548, 2092,   14, 1466, 1469,  603,   38,   37, 1496, 1749,
 /*   750 */    44,   42,   41,   40,   39,   31,  169, 2128, 1386,  429,
 /*   760 */  1384,   38,   37,  503,  710,   44,   42,   41,   40,   39,
 /*   770 */  1745,  400,  657,  399, 1616,  237, 1762, 1936, 1863, 1467,
 /*   780 */  1468, 1737, 1615, 1389, 1390,  502, 1439, 1442, 1443, 1444,
 /*   790 */  1445, 1446, 1447, 1448, 1449,  615,  611, 1458, 1459, 1461,
 /*   800 */  1462, 1463, 1464,    2,   41,   40,   39,  603, 1440, 1450,
 /*   810 */   319,   50, 1408,    3, 1466, 1469,  365,   94, 1936,  437,
 /*   820 */    32,  430,  450,  232,  157,  449, 1936,  655,  614, 1386,
 /*   830 */  1501, 1384, 1614, 1764, 1551,  178,  681,  679, 1762, 1755,
 /*   840 */   421, 1955,  451,  647,  157,  423,  148,  147,  652,  651,
 /*   850 */   650,  145, 1950, 1765, 1389, 1390, 1410, 1439, 1442, 1443,
 /*   860 */  1444, 1445, 1446, 1447, 1448, 1449,  615,  611, 1458, 1459,
 /*   870 */  1461, 1462, 1463, 1464,    2, 1441, 1936,  670, 1413, 1732,
 /*   880 */   158, 1946, 1952,   33, 1845,  296,  335, 1675,  655,   38,
 /*   890 */    37, 1858,  613,   44,   42,   41,   40,   39,  411,  294,
 /*   900 */    70, 1815,  183,   69, 1858, 1858, 1622,  148,  147,  652,
 /*   910 */   651,  650,  145,   13,   12,  185,  189, 1814, 1099, 1100,
 /*   920 */    99,  195,  456,  454,  653, 2095,  654, 1806,  447, 1806,
 /*   930 */    96,  442,  441,  440,  439,  436,  435,  434,  433,  432,
 /*   940 */   428,  427,  426,  425,  336,  418,  417,  416,  589,  413,
 /*   950 */   412,  333,  687,  686,  685,  684,  372,   60,  683,  682,
 /*   960 */   138,  677,  676,  675,  674,  673,  672,  671,  150,  667,
 /*   970 */   666,  665,  371,  370,  662,  661,  660,  659,  658, 1613,
 /*   980 */   254,  603,  655, 1612,  290,  603,  375, 1792,  374,  578,
 /*   990 */   547, 2075, 1528,  603, 2124,  476,  102, 1441, 1717,  477,
 /*  1000 */  1967,  148,  147,  652,  651,  650,  145, 1759, 1508, 2130,
 /*  1010 */   175,  140, 1762,  128, 2125,  572, 1762,  218,  574,   71,
 /*  1020 */   216,  236,  220, 1936, 1762,  219,   52, 1936,  547,  603,
 /*  1030 */   547, 1985, 2124,  546, 2124,  424,   78,   77,  404,  586,
 /*  1040 */   583,  182,  603,  142, 1936, 1394,  619, 2130,  175, 2130,
 /*  1050 */   175,  559, 2125,  572, 2125,  572,  543, 1923,  535,  318,
 /*  1060 */  1762,  603,  392,  235,  390,  386,  382,  379,  376,   79,
 /*  1070 */  1966,  134, 1967, 1762, 2002,  587, 1393,  103, 1968,  623,
 /*  1080 */  1970, 1971,  618,  603,  613,  222,   62,  224,  221,  172,
 /*  1090 */   223, 2055, 1762, 1665,  211,  356, 2051,  271,  603,  603,
 /*  1100 */   547, 1658,   87, 1985, 2124,  384, 1656,  178,  603,  610,
 /*  1110 */   339,  620,  598,  600, 1762,  515, 1936, 2082,  619, 2130,
 /*  1120 */   175, 1957,  601,  517, 2125,  572, 1967,  603,  520, 1762,
 /*  1130 */  1762,  176, 2063, 2064,  241,  132, 2068,  248, 1559, 1762,
 /*  1140 */    47,  277, 1966, 1604, 1605, 1986, 2002,  264,  373,  103,
 /*  1150 */  1968,  623, 1970, 1971,  618,  663,  613, 1985, 1762,   68,
 /*  1160 */   144, 2144, 1867, 2055,  146,  620, 1646,  356, 2051, 1959,
 /*  1170 */  1936,  340,  619,  338,  337,   62,  501, 1161, 2089,  664,
 /*  1180 */   503, 1652, 1803,  603,   47,   47,  243, 1967,   13,   12,
 /*  1190 */  2085,  627, 1327,  584, 1397,  144, 1966,  369,  256,  269,
 /*  1200 */  2002, 1159,  502,  103, 1968,  623, 1970, 1971,  618,  253,
 /*  1210 */   613,  595,  273,  579, 1762, 2144, 1213, 2055, 1985,    1,
 /*  1220 */   146,  356, 2051,  129,    4, 1396,  620, 1502,  359,  358,
 /*  1230 */   705, 1936, 2102,  619,  378, 1349, 1451,  289, 1399,  144,
 /*  1240 */   383,  332,  284, 1241,  188,  410, 1413, 1245,  414, 1465,
 /*  1250 */  1967, 1392, 1868, 1486,  445,  419, 1408, 1966,  438,  444,
 /*  1260 */   431, 2002, 1860,  446,  103, 1968,  623, 1970, 1971,  618,
 /*  1270 */  1967,  613, 1252,  452, 1460, 1250, 2144,  453, 2055,  192,
 /*  1280 */   455, 1985,  356, 2051,  457, 1414, 1391,  458,  467,  620,
 /*  1290 */  1416,  149,  470,  554, 1936,  198,  619,  200, 1411,  471,
 /*  1300 */  1415, 1985,  472, 1417,  473,  203,  205,  475,   82,  620,
 /*  1310 */    83,  479, 1116,  209, 1936,  496,  619,  497,  500,  498,
 /*  1320 */  1966, 1752,  321,  106, 2002,  534,  215,  103, 1968,  623,
 /*  1330 */  1970, 1971,  618,  609,  613,  536,  285,  230, 1748, 2144,
 /*  1340 */  1966, 2055,  217,  151, 2002,  356, 2051,  103, 1968,  623,
 /*  1350 */  1970, 1971,  618,  152,  613, 1750, 2118, 1746,  153, 2144,
 /*  1360 */   154, 2055, 1913, 1912,  537,  356, 2051,  538,  233,  541,
 /*  1370 */   713,  544,  560, 1967,  551, 2086, 2074, 2101,  593,  557,
 /*  1380 */  2100,  346, 2096,    7,  283,  563,  569,  249,  239,  242,
 /*  1390 */  2077,  165,  247,  552,  550,  250,  549,  347, 1400,  168,
 /*  1400 */  1395,  580,  577, 1528, 1985,  703,  699,  695,  691,  281,
 /*  1410 */   251, 2147,  620,  255,  252, 2123,  133, 1936, 1412,  619,
 /*  1420 */  2071,  588,  261, 1403, 1405,  350,  591,  596,  286,  287,
 /*  1430 */   592, 1884, 1967, 1883, 1882,  352,  611, 1458, 1459, 1461,
 /*  1440 */  1462, 1463, 1464, 1966,  288,  101, 1763, 2002,  274,  597,
 /*  1450 */   103, 1968,  623, 1970, 1971,  618,   59,  613,   91,   93,
 /*  1460 */  2036,   95, 2030, 1985, 2055,  625,  280, 1807,  356, 2051,
 /*  1470 */  1733,  620,  291,  706,  707,  709, 1936,  315,  619,   51,
 /*  1480 */   295,  599, 1930,  323,  324,  293, 1967, 1929,  300,   75,
 /*  1490 */  1928,  314,  304, 1927,   76, 1924,  380,  381, 1377, 1378,
 /*  1500 */   181, 1922, 1966,  385,  387,  388, 2002,  389, 1921,  103,
 /*  1510 */  1968,  623, 1970, 1971,  618,  391,  613, 1985, 1920,  393,
 /*  1520 */   262, 2028, 1919, 2055,  395,  620,  397,  356, 2051, 1918,
 /*  1530 */  1936, 1352,  619, 1895, 1351, 1894,  402, 1356, 1893,  231,
 /*  1540 */   403, 1892, 1853, 1307, 1852, 1850,  139, 1967, 1849, 1848,
 /*  1550 */  1851, 1847, 1846, 1844, 1843, 1842, 1966,  186,  420, 1841,
 /*  1560 */  2002,  422, 1840,  103, 1968,  623, 1970, 1971,  618, 1839,
 /*  1570 */   613, 1838, 1837, 1836, 1835,  606, 1834, 2055, 1985, 1833,
 /*  1580 */  1832,  356, 2051, 1831, 1830, 1829,  620, 1828, 1827, 1826,
 /*  1590 */  1825, 1936, 1824,  619,  448, 1817, 1816, 1309,  141, 1823,
 /*  1600 */  1822, 1821, 1820, 1819, 1818, 1967, 1680, 1679, 1677, 1641,
 /*  1610 */   196,  170, 1188, 1956, 1640,  193,  194, 1966, 1908, 1102,
 /*  1620 */    73, 2002,  197, 1902,  104, 1968,  623, 1970, 1971,  618,
 /*  1630 */  1101,  613, 1891,  463, 1890,  204, 1985,   74, 2055, 1870,
 /*  1640 */   465, 1741, 2054, 2051,  620, 1676, 1674,  480, 1672, 1936,
 /*  1650 */   202,  619,  482, 1670,  484, 1135,  486,  488,  481, 1967,
 /*  1660 */   490, 1668,  492,  485,  494, 1655, 1654, 1637,  489, 1743,
 /*  1670 */  1257, 1256,  493, 1742,   61, 1966, 1171, 1179, 1178, 2002,
 /*  1680 */   678,  680,  104, 1968,  623, 1970, 1971,  618, 1967,  613,
 /*  1690 */  1985, 1177, 1176, 1173, 1172, 1170, 2055, 1666,  620,  214,
 /*  1700 */   608, 2051,  341, 1936, 1659,  619,  342, 1657,  343,  521,
 /*  1710 */  1636,  523,  518, 1635,  525, 1634,  527, 1367,  105, 1985,
 /*  1720 */  1366,  531, 1369,   26, 1907, 1358,   55,  617, 1901,  621,
 /*  1730 */   539,  155, 1936, 2002,  619, 1889,  104, 1968,  623, 1970,
 /*  1740 */  1971,  618, 1887,  613, 2129,   28, 1967,   19,   16,  553,
 /*  1750 */  2055, 1574,  246,  555,  326, 2051,   58,   63, 1966,  238,
 /*  1760 */   245, 1957, 2002,   30,  240,  312, 1968,  623, 1970, 1971,
 /*  1770 */   618,  616,  613,  604, 2020,   21,  163, 1985, 1589,   20,
 /*  1780 */    17, 1588,  348, 1558,  244,  620,   29, 1593, 1550, 1594,
 /*  1790 */  1936,   88,  619,  540,  234, 1595,  344, 1592,  349, 1888,
 /*  1800 */  1967,   57,  545,  258,   56, 1525,  166, 1524,    5, 1886,
 /*  1810 */     6, 1885,   22,  594,  263,  265, 1966, 1556,  270, 1869,
 /*  1820 */  2002,   65,   90,  162, 1968,  623, 1970, 1971,  618,   92,
 /*  1830 */   613, 1985,   96,  275,  272,   23,   12, 1401, 1432,  620,
 /*  1840 */  2005,  167,  179,  612, 1936, 1455,  619, 1453,   36,  626,
 /*  1850 */   624, 1234,  364,   15, 1967,  630, 1452, 1424, 1487,   24,
 /*  1860 */    25,  622, 1242,  628,  633, 1239,  631,  636,  639, 1236,
 /*  1870 */  1966,  634, 1477, 1230, 2002,  573, 2145,  104, 1968,  623,
 /*  1880 */  1970, 1971,  618,  637,  613, 1985, 1228,  640, 1219, 1233,
 /*  1890 */   278, 2055,  646,  620, 1232,   97, 2052, 1231, 1936,   98,
 /*  1900 */   619,   10, 1251, 1476, 1247,   72, 1967, 1133,  656, 1167,
 /*  1910 */  1166, 1165, 1164, 1163, 1162, 1160, 1158, 1186, 1157, 1156,
 /*  1920 */   668, 1154, 1967, 1153, 1966, 1152, 1151, 1183, 2002,  279,
 /*  1930 */  1150,  161, 1968,  623, 1970, 1971,  618, 1985,  613, 1139,
 /*  1940 */  1149, 1148, 1181, 1145, 1144,  620, 1141, 1140, 1138, 1673,
 /*  1950 */  1936,  688,  619, 1985,  690, 1671,  692,  694,  689, 1669,
 /*  1960 */   696,  620,  693,  698, 1667,  700, 1936,  697,  619, 1653,
 /*  1970 */   701,  702,  704, 2093, 1091, 1633, 1966,  712,  282,  708,
 /*  1980 */  2002, 1608, 1387,  306, 1968,  623, 1970, 1971,  618,  711,
 /*  1990 */   613, 1608, 1966,  292, 1608, 1608, 2002, 1608, 1608,  162,
 /*  2000 */  1968,  623, 1970, 1971,  618, 1608,  613, 1608, 1608, 1608,
 /*  2010 */  1608, 1967, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  2020 */  1608, 1608, 1608, 1608, 1608, 1608, 1608,  568, 1608, 1967,
 /*  2030 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  2040 */  1608, 1608, 1985, 1608, 1608, 1608, 1608,  351, 1608, 1608,
 /*  2050 */   620, 1608, 2146, 1608, 1608, 1936, 1608,  619, 1608, 1608,
 /*  2060 */  1985, 1608, 1608, 1608, 1608, 1608, 1608, 1608,  617, 1608,
 /*  2070 */  1608, 1608, 1608, 1936, 1608,  619, 1608, 1608, 1608, 1608,
 /*  2080 */  1608, 1966, 1608, 1967, 1608, 2002, 1608, 1608,  313, 1968,
 /*  2090 */   623, 1970, 1971,  618, 1608,  613, 1608, 1608, 1608, 1966,
 /*  2100 */  1967, 1608, 1608, 2002, 1608, 1608,  312, 1968,  623, 1970,
 /*  2110 */  1971,  618, 1608,  613, 1985, 2021, 1608, 1608, 1608,  361,
 /*  2120 */  1608, 1608,  620, 1608, 1608, 1608, 1608, 1936, 1608,  619,
 /*  2130 */  1608, 1985, 1608, 1608, 1608, 1608,  363, 1608, 1608,  620,
 /*  2140 */  1608, 1608, 1608, 1608, 1936, 1608,  619, 1608, 1608, 1608,
 /*  2150 */  1608, 1608, 1967, 1966, 1608, 1608, 1608, 2002, 1608, 1608,
 /*  2160 */   313, 1968,  623, 1970, 1971,  618, 1608,  613, 1967, 1608,
 /*  2170 */  1966, 1608, 1608, 1608, 2002, 1608, 1608,  313, 1968,  623,
 /*  2180 */  1970, 1971,  618, 1985,  613, 1608, 1608, 1608, 1608, 1608,
 /*  2190 */  1608,  620, 1608, 1608, 1608, 1608, 1936, 1608,  619, 1985,
 /*  2200 */  1608, 1608, 1608, 1608, 1608, 1608, 1608,  620, 1608, 1608,
 /*  2210 */  1608, 1608, 1936, 1608,  619, 1608, 1608, 1608, 1608, 1608,
 /*  2220 */  1967, 1608,  533, 1608, 1608, 1608, 2002, 1608, 1608,  308,
 /*  2230 */  1968,  623, 1970, 1971,  618, 1608,  613, 1608, 1966, 1608,
 /*  2240 */  1608, 1608, 2002, 1608, 1608,  297, 1968,  623, 1970, 1971,
 /*  2250 */   618, 1985,  613, 1608, 1608, 1608, 1608, 1608, 1608,  620,
 /*  2260 */  1608, 1608, 1608, 1608, 1936, 1608,  619, 1608, 1608, 1608,
 /*  2270 */  1608, 1608, 1608, 1608, 1967, 1608, 1608, 1608, 1608, 1608,
 /*  2280 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  2290 */  1966, 1608, 1608, 1608, 2002, 1967, 1608,  298, 1968,  623,
 /*  2300 */  1970, 1971,  618, 1608,  613, 1985, 1608, 1608, 1608, 1608,
 /*  2310 */  1608, 1608, 1608,  620, 1608, 1608, 1608, 1608, 1936, 1608,
 /*  2320 */   619, 1608, 1608, 1608, 1608, 1608, 1985, 1608, 1608, 1608,
 /*  2330 */  1608, 1608, 1608, 1608,  620, 1608, 1608, 1608, 1608, 1936,
 /*  2340 */  1608,  619, 1608, 1608, 1966, 1608, 1608, 1608, 2002, 1608,
 /*  2350 */  1608,  299, 1968,  623, 1970, 1971,  618, 1608,  613, 1608,
 /*  2360 */  1608, 1608, 1608, 1608, 1608, 1966, 1608, 1608, 1608, 2002,
 /*  2370 */  1608, 1967,  305, 1968,  623, 1970, 1971,  618, 1608,  613,
 /*  2380 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1967,
 /*  2390 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  2400 */  1608, 1608, 1985, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  2410 */   620, 1608, 1608, 1608, 1608, 1936, 1608,  619, 1608, 1608,
 /*  2420 */  1985, 1608, 1608, 1608, 1608, 1608, 1608, 1608,  620, 1608,
 /*  2430 */  1608, 1608, 1608, 1936, 1608,  619, 1608, 1608, 1608, 1608,
 /*  2440 */  1608, 1966, 1608, 1967, 1608, 2002, 1608, 1608,  309, 1968,
 /*  2450 */   623, 1970, 1971,  618, 1608,  613, 1608, 1608, 1608, 1966,
 /*  2460 */  1967, 1608, 1608, 2002, 1608, 1608,  301, 1968,  623, 1970,
 /*  2470 */  1971,  618, 1608,  613, 1985, 1608, 1608, 1608, 1608, 1608,
 /*  2480 */  1608, 1608,  620, 1608, 1608, 1608, 1608, 1936, 1608,  619,
 /*  2490 */  1608, 1985, 1608, 1608, 1608, 1608, 1608, 1608, 1608,  620,
 /*  2500 */  1608, 1608, 1608, 1608, 1936, 1608,  619, 1608, 1608, 1608,
 /*  2510 */  1608, 1608, 1967, 1966, 1608, 1608, 1608, 2002, 1608, 1608,
 /*  2520 */   310, 1968,  623, 1970, 1971,  618, 1608,  613, 1967, 1608,
 /*  2530 */  1966, 1608, 1608, 1608, 2002, 1608, 1608,  302, 1968,  623,
 /*  2540 */  1970, 1971,  618, 1985,  613, 1608, 1608, 1608, 1608, 1608,
 /*  2550 */  1608,  620, 1608, 1608, 1608, 1608, 1936, 1608,  619, 1985,
 /*  2560 */  1608, 1608, 1608, 1608, 1608, 1608, 1608,  620, 1608, 1608,
 /*  2570 */  1608, 1608, 1936, 1608,  619, 1608, 1608, 1608, 1608, 1608,
 /*  2580 */  1967, 1608, 1966, 1608, 1608, 1608, 2002, 1608, 1608,  311,
 /*  2590 */  1968,  623, 1970, 1971,  618, 1608,  613, 1608, 1966, 1608,
 /*  2600 */  1608, 1608, 2002, 1967, 1608,  303, 1968,  623, 1970, 1971,
 /*  2610 */   618, 1985,  613, 1608, 1608, 1608, 1608, 1608, 1608,  620,
 /*  2620 */  1608, 1608, 1608, 1608, 1936, 1608,  619, 1608, 1608, 1608,
 /*  2630 */  1608, 1608, 1608, 1608, 1985, 1608, 1608, 1608, 1608, 1608,
 /*  2640 */  1608, 1608,  620, 1608, 1608, 1608, 1608, 1936, 1608,  619,
 /*  2650 */  1966, 1608, 1608, 1608, 2002, 1967, 1608,  316, 1968,  623,
 /*  2660 */  1970, 1971,  618, 1608,  613, 1608, 1608, 1608, 1608, 1608,
 /*  2670 */  1608, 1608, 1608, 1966, 1608, 1608, 1608, 2002, 1608, 1608,
 /*  2680 */   317, 1968,  623, 1970, 1971,  618, 1985,  613, 1608, 1608,
 /*  2690 */  1608, 1608, 1608, 1608,  620, 1608, 1608, 1608, 1608, 1936,
 /*  2700 */  1608,  619, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  2710 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1967, 1608,
 /*  2720 */  1608, 1608, 1608, 1608, 1608, 1966, 1608, 1608, 1608, 2002,
 /*  2730 */  1608, 1608, 1979, 1968,  623, 1970, 1971,  618, 1608,  613,
 /*  2740 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1985,
 /*  2750 */  1608, 1608, 1608, 1608, 1608, 1608, 1608,  620, 1608, 1608,
 /*  2760 */  1608, 1608, 1936, 1608,  619, 1608, 1608, 1608, 1608, 1608,
 /*  2770 */  1967, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  2780 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1966, 1967,
 /*  2790 */  1608, 1608, 2002, 1608, 1608, 1978, 1968,  623, 1970, 1971,
 /*  2800 */   618, 1985,  613, 1608, 1608, 1608, 1608, 1608, 1608,  620,
 /*  2810 */  1608, 1608, 1608, 1608, 1936, 1608,  619, 1608, 1608, 1608,
 /*  2820 */  1985, 1608, 1608, 1608, 1608, 1608, 1608, 1608,  620, 1608,
 /*  2830 */  1608, 1608, 1608, 1936, 1608,  619, 1608, 1608, 1608, 1608,
 /*  2840 */  1966, 1967, 1608, 1608, 2002, 1608, 1608, 1977, 1968,  623,
 /*  2850 */  1970, 1971,  618, 1608,  613, 1608, 1608, 1967, 1608, 1966,
 /*  2860 */  1608, 1608, 1608, 2002, 1608, 1608,  328, 1968,  623, 1970,
 /*  2870 */  1971,  618, 1985,  613, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  2880 */   620, 1608, 1608, 1608, 1608, 1936, 1608,  619, 1985, 1608,
 /*  2890 */  1608, 1608, 1608, 1608, 1608, 1608,  620, 1608, 1608, 1608,
 /*  2900 */  1608, 1936, 1608,  619, 1608, 1608, 1608, 1608, 1608, 1967,
 /*  2910 */  1608, 1966, 1608, 1608, 1608, 2002, 1608, 1608,  329, 1968,
 /*  2920 */   623, 1970, 1971,  618, 1608,  613, 1608, 1966, 1608, 1608,
 /*  2930 */  1608, 2002, 1967, 1608,  325, 1968,  623, 1970, 1971,  618,
 /*  2940 */  1985,  613, 1608, 1608, 1608, 1608, 1608, 1608,  620, 1608,
 /*  2950 */  1608, 1608, 1608, 1936, 1608,  619, 1608, 1608, 1608, 1608,
 /*  2960 */  1608, 1608, 1608, 1985, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  2970 */  1608,  620, 1608, 1608, 1608, 1608, 1936, 1608,  619, 1966,
 /*  2980 */  1608, 1608, 1608, 2002, 1967, 1608,  330, 1968,  623, 1970,
 /*  2990 */  1971,  618, 1608,  613, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  3000 */  1608, 1608,  621, 1608, 1608, 1608, 2002, 1608, 1608,  308,
 /*  3010 */  1968,  623, 1970, 1971,  618, 1985,  613, 1608, 1608, 1608,
 /*  3020 */  1608, 1608, 1608,  620, 1608, 1608, 1608, 1608, 1936, 1608,
 /*  3030 */   619, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  3040 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*  3050 */  1608, 1608, 1608, 1608, 1966, 1608, 1608, 1608, 2002, 1608,
 /*  3060 */  1608,  307, 1968,  623, 1970, 1971,  618, 1608,  613,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   420,  421,  332,  374,  334,  335,  332,  370,  334,  335,
 /*    10 */   373,  374,   12,   13,   14,  361,  387,  388,  360,   14,
 /*    20 */    20,  336,   22,    8,    9,   20,  372,   12,   13,   14,
 /*    30 */    15,   16,  359,   33,  333,   35,  352,  336,  337,  355,
 /*    40 */   431,   20,    8,    9,  435,   20,   12,   13,   14,   15,
 /*    50 */    16,   39,   20,  380,  381,  401,  402,  403,   58,  450,
 /*    60 */   451,  376,   58,   63,  455,  456,  412,    8,    9,  328,
 /*    70 */    70,   12,   13,   14,   15,   16,  333,   20,  336,  336,
 /*    80 */   337,    8,    9,   12,   13,   12,   13,   14,   15,   16,
 /*    90 */     3,   20,  358,   22,    0,   95,  415,   63,   94,  418,
 /*   100 */   359,   97,   95,   44,   33,  371,   35,   20,  367,  367,
 /*   110 */   327,   96,  329,  372,  336,  374,   95,  117,   24,   25,
 /*   120 */    26,   27,   28,   29,   30,   31,   32,   95,  350,   58,
 /*   130 */   340,  343,  132,  133,   63,  357,  348,   79,  104,  398,
 /*   140 */     4,   70,   62,  402,  354,  367,  405,  406,  407,  408,
 /*   150 */   409,  410,  362,  412,   20,  431,  359,   44,  417,  435,
 /*   160 */   419,  161,  162,  366,  423,  424,   95,  167,  168,  427,
 /*   170 */   428,  429,  375,  431,  432,  451,   20,  435,  437,  455,
 /*   180 */   456,  431,  182,   96,  184,  435,  445,   21,  117,  132,
 /*   190 */   133,   58,  450,  451,  160,  137,  138,  455,  456,   95,
 /*   200 */    34,  451,   36,  132,  133,  455,  456,  207,  208,   96,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,   95,   95,
 /*   230 */    97,   95,  161,  162,  404,   20,  163,   21,  167,  168,
 /*   240 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  106,
 /*   250 */   163,  127,  245,  182,  404,  184,  244,    8,    9,  328,
 /*   260 */   430,   12,   13,   14,   15,   16,  232,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  245,  207,  208,
 /*   280 */   430,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  177,
 /*   300 */   229,   12,   13,  372,  361,   22,   14,  328,  359,   20,
 /*   310 */    22,   22,   20,  189,  190,  372,  367,  193,   35,  195,
 /*   320 */   198,  199,   33,   35,   35,  108,  109,  110,  111,  112,
 /*   330 */   113,  114,  115,  116,  117,  118,    0,  120,  121,  122,
 /*   340 */   123,  124,  125,   33,  401,  402,  403,   58,   35,  245,
 /*   350 */   389,  372,   63,   70,  359,  412,  407,    4,   48,   70,
 /*   360 */    20,  366,   22,   20,   54,   55,   56,   57,   58,  328,
 /*   370 */   375,  328,   12,   13,   14,   35,  161,  162,  245,  245,
 /*   380 */    20,  245,   22,   70,   95,   12,   13,   14,   15,   16,
 /*   390 */    62,   51,  431,   33,   20,   35,  435,   20,  328,   22,
 /*   400 */   117,   65,   66,   67,   94,    4,  117,   97,    0,   73,
 /*   410 */    74,  450,  451,  372,   78,  372,  455,  456,   58,   83,
 /*   420 */    84,  132,  133,  174,  328,   89,  126,  127,   51,   21,
 /*   430 */    70,  131,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   440 */    32,  336,  372,   20,   43,  328,   45,   46,   70,  374,
 /*   450 */   161,  162,  336,  161,  359,   95,  167,  168,  229,  384,
 /*   460 */   231,  366,  387,  388,  336,  182,  350,  184,  372,   44,
 /*   470 */   375,  182,  367,  184,  164,  165,  328,  117,  350,  169,
 /*   480 */     8,    9,  172,  367,   12,   13,   14,   15,   16,  372,
 /*   490 */   207,  208,  132,  133,  342,  367,  207,  208,  188,  210,
 /*   500 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   510 */   221,  222,  223,  224,  225,  226,  227,  365,  269,   20,
 /*   520 */   372,  161,  162,  336,   35,  328,  431,  167,  168,  336,
 /*   530 */   435,  426,  427,  428,  429,  336,  431,  432,   20,   65,
 /*   540 */    66,   67,  182,  350,  184,  450,  451,   73,   74,  350,
 /*   550 */   455,  456,   78,  328,  367,  132,  133,   83,   84,   70,
 /*   560 */   367,  328,  328,   89,  373,  374,  367,  207,  208,  372,
 /*   570 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   580 */   220,  221,  222,  223,  224,  225,  226,  227,   12,   13,
 /*   590 */   167,  168,  359,    0,  342,  351,   20,  372,   22,  246,
 /*   600 */   367,  325,  416,  359,  418,  372,  372,  374,  356,   33,
 /*   610 */   126,   35,  368,  229,  427,  428,  429,  365,  431,  432,
 /*   620 */     8,    9,  328,  404,   12,   13,   14,   15,   16,    4,
 /*   630 */   166,  398,   20,  336,   58,  402,   70,  207,  405,  406,
 /*   640 */   407,  408,  409,  410,   19,  412,   70,  350,  415,  430,
 /*   650 */   417,  418,  419,  359,  357,   62,  423,  424,   33,   12,
 /*   660 */    13,  367,  163,  336,  367,  389,  372,   20,  374,   22,
 /*   670 */   416,   95,  418,   48,  328,  191,  192,  350,   53,  328,
 /*   680 */    33,  163,   35,   58,  361,   95,  256,  257,  258,  259,
 /*   690 */   260,  266,  398,  117,  367,  372,  402,  345,  346,  405,
 /*   700 */   406,  407,  408,  409,  410,   58,  412,  431,  132,  133,
 /*   710 */     0,  435,  393,  351,  250,  251,  252,   70,  372,   94,
 /*   720 */     0,  359,   97,  372,  401,  402,  450,  451,   14,  360,
 /*   730 */   368,  455,  456,  328,   20,  412,  369,  161,  162,  372,
 /*   740 */   446,  447,   95,  167,  168,  336,    8,    9,  160,  360,
 /*   750 */    12,   13,   14,   15,   16,    2,  359,    3,  182,  350,
 /*   760 */   184,    8,    9,  107,  117,   12,   13,   14,   15,   16,
 /*   770 */   360,  181,   62,  183,  328,  163,  367,  372,  381,  132,
 /*   780 */   133,    0,  328,  207,  208,  129,  210,  211,  212,  213,
 /*   790 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   800 */   224,  225,  226,  227,   14,   15,   16,  336,  161,  162,
 /*   810 */    18,   42,   20,   44,  167,  168,  351,  340,  372,   27,
 /*   820 */   232,  350,   30,  360,  359,   33,  372,  107,  360,  182,
 /*   830 */   242,  184,  328,  368,   96,  245,  345,  346,  367,  362,
 /*   840 */    48,  361,   50,  360,  359,   53,  126,  127,  128,  129,
 /*   850 */   130,  131,  372,  368,  207,  208,   20,  210,  211,  212,
 /*   860 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   870 */   223,  224,  225,  226,  227,  161,  372,  347,   20,  349,
 /*   880 */    18,  401,  402,    2,    0,   23,   94,    0,  107,    8,
 /*   890 */     9,  367,  412,   12,   13,   14,   15,   16,  106,   37,
 /*   900 */    38,  359,  378,   41,  367,  367,  329,  126,  127,  128,
 /*   910 */   129,  130,  131,    1,    2,  378,  378,  375,   45,   46,
 /*   920 */    95,   59,   60,   61,  369,  382,  369,  372,  136,  372,
 /*   930 */   105,  139,  140,  141,  142,  143,  144,  145,  146,  147,
 /*   940 */   148,  149,  150,  151,  152,  153,  154,  155,  389,  157,
 /*   950 */   158,  159,   65,   66,   67,   68,   69,   95,   71,   72,
 /*   960 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   970 */    83,   84,   85,   86,   87,   88,   89,   90,   91,  328,
 /*   980 */   459,  336,  107,  328,  352,  336,  389,  355,  389,   44,
 /*   990 */   431,  243,  244,  336,  435,  350,  134,  161,  348,  350,
 /*  1000 */   328,  126,  127,  128,  129,  130,  131,  350,   96,  450,
 /*  1010 */   451,   42,  367,   44,  455,  456,  367,   99,  264,  106,
 /*  1020 */   102,  163,   99,  372,  367,  102,  163,  372,  431,  336,
 /*  1030 */   431,  359,  435,  170,  435,  151,  174,  175,  176,  367,
 /*  1040 */   336,  179,  336,  350,  372,   35,  374,  450,  451,  450,
 /*  1050 */   451,  448,  455,  456,  455,  456,  350,    0,  389,  197,
 /*  1060 */   367,  336,  200,   58,  202,  203,  204,  205,  206,  156,
 /*  1070 */   398,  367,  328,  367,  402,  350,   35,  405,  406,  407,
 /*  1080 */   408,  409,  410,  336,  412,   99,   44,   99,  102,  417,
 /*  1090 */   102,  419,  367,    0,  338,  423,  424,  350,  336,  336,
 /*  1100 */   431,    0,   97,  359,  435,   48,    0,  245,  336,   63,
 /*  1110 */    37,  367,  350,  350,  367,   22,  372,  445,  374,  450,
 /*  1120 */   451,   47,  350,   22,  455,  456,  328,  336,   22,  367,
 /*  1130 */   367,  427,  428,  429,   44,  431,  432,  442,   96,  367,
 /*  1140 */    44,  350,  398,  132,  133,  359,  402,   44,  338,  405,
 /*  1150 */   406,  407,  408,  409,  410,   13,  412,  359,  367,   44,
 /*  1160 */    44,  417,  382,  419,   44,  367,  335,  423,  424,   95,
 /*  1170 */   372,   98,  374,  100,  101,   44,  103,   35,  434,   13,
 /*  1180 */   107,    0,  371,  336,   44,   44,   96,  328,    1,    2,
 /*  1190 */   382,   44,   96,  433,  184,   44,  398,  350,  452,   96,
 /*  1200 */   402,   35,  129,  405,  406,  407,  408,  409,  410,  425,
 /*  1210 */   412,   96,   96,  268,  367,  417,   96,  419,  359,  436,
 /*  1220 */    44,  423,  424,   44,  247,  184,  367,   96,   12,   13,
 /*  1230 */    49,  372,  434,  374,  400,  180,   96,   96,   22,   44,
 /*  1240 */    48,  399,  391,   96,   42,  379,   20,   96,  379,   33,
 /*  1250 */   328,   35,  382,  207,  160,  377,   20,  398,  379,  377,
 /*  1260 */   336,  402,  336,  377,  405,  406,  407,  408,  409,  410,
 /*  1270 */   328,  412,   96,   93,   58,   96,  417,  344,  419,  336,
 /*  1280 */   336,  359,  423,  424,  336,   20,   70,  330,  330,  367,
 /*  1290 */    20,   96,  395,  434,  372,  342,  374,  342,   20,  374,
 /*  1300 */    20,  359,  337,   20,  390,  342,  342,  337,  342,  367,
 /*  1310 */   342,  336,   52,  342,  372,  339,  374,  339,  359,  330,
 /*  1320 */   398,  359,  330,  336,  402,  196,  359,  405,  406,  407,
 /*  1330 */   408,  409,  410,  117,  412,  397,  395,  340,  359,  417,
 /*  1340 */   398,  419,  359,  359,  402,  423,  424,  405,  406,  407,
 /*  1350 */   408,  409,  410,  359,  412,  359,  434,  359,  359,  417,
 /*  1360 */   359,  419,  372,  372,  187,  423,  424,  394,  340,  374,
 /*  1370 */    19,  336,  255,  328,  372,  382,  434,  441,  254,  372,
 /*  1380 */   441,  372,  382,  261,   33,  372,  173,  440,  385,  385,
 /*  1390 */   444,  441,  443,  263,  262,  439,  248,  270,  182,   48,
 /*  1400 */   184,  267,  265,  244,  359,   54,   55,   56,   57,   58,
 /*  1410 */   438,  460,  367,  453,  400,  454,  367,  372,   20,  374,
 /*  1420 */   404,  336,  340,  207,  208,  337,  372,  165,  385,  385,
 /*  1430 */   372,  372,  328,  372,  372,  372,  220,  221,  222,  223,
 /*  1440 */   224,  225,  226,  398,  355,   94,  367,  402,   97,  383,
 /*  1450 */   405,  406,  407,  408,  409,  410,   95,  412,  340,  340,
 /*  1460 */   422,   95,  417,  359,  419,  363,  340,  372,  423,  424,
 /*  1470 */   349,  367,  336,   36,  331,  330,  372,  396,  374,  392,
 /*  1480 */   326,  130,    0,  386,  386,  341,  328,    0,  353,  189,
 /*  1490 */     0,  353,  353,    0,   42,    0,   35,  201,   35,   35,
 /*  1500 */    35,    0,  398,  201,   35,   35,  402,  201,    0,  405,
 /*  1510 */   406,  407,  408,  409,  410,  201,  412,  359,    0,   35,
 /*  1520 */   169,  417,    0,  419,   22,  367,   35,  423,  424,    0,
 /*  1530 */   372,  184,  374,    0,  182,    0,  178,  186,    0,  188,
 /*  1540 */   177,    0,    0,   47,    0,    0,   42,  328,    0,    0,
 /*  1550 */     0,    0,    0,    0,    0,    0,  398,  151,   35,    0,
 /*  1560 */   402,  151,    0,  405,  406,  407,  408,  409,  410,    0,
 /*  1570 */   412,    0,    0,    0,    0,  417,    0,  419,  359,    0,
 /*  1580 */     0,  423,  424,    0,    0,    0,  367,    0,    0,    0,
 /*  1590 */     0,  372,    0,  374,  135,    0,    0,   22,   42,    0,
 /*  1600 */     0,    0,    0,    0,    0,  328,    0,    0,    0,    0,
 /*  1610 */    42,   44,   35,   47,    0,   58,   58,  398,    0,   14,
 /*  1620 */    39,  402,   40,    0,  405,  406,  407,  408,  409,  410,
 /*  1630 */    14,  412,    0,   47,    0,  173,  359,   39,  419,    0,
 /*  1640 */    47,    0,  423,  424,  367,    0,    0,   35,    0,  372,
 /*  1650 */    39,  374,   39,    0,   35,   64,   39,   35,   48,  328,
 /*  1660 */    39,    0,   35,   48,   39,    0,    0,    0,   48,    0,
 /*  1670 */    35,   22,   48,    0,  104,  398,   22,   35,   35,  402,
 /*  1680 */    44,   44,  405,  406,  407,  408,  409,  410,  328,  412,
 /*  1690 */   359,   35,   35,   35,   35,   35,  419,    0,  367,  102,
 /*  1700 */   423,  424,   22,  372,    0,  374,   22,    0,   22,   35,
 /*  1710 */     0,   35,   50,    0,   35,    0,   22,   35,   20,  359,
 /*  1720 */    35,  194,   96,   95,    0,   35,  163,  367,    0,  398,
 /*  1730 */    22,  185,  372,  402,  374,    0,  405,  406,  407,  408,
 /*  1740 */   409,  410,    0,  412,    3,   95,  328,   44,  249,  228,
 /*  1750 */   419,   96,   47,  253,  423,  424,   44,    3,  398,   95,
 /*  1760 */    44,   47,  402,   44,   96,  405,  406,  407,  408,  409,
 /*  1770 */   410,  411,  412,  413,  414,   44,   95,  359,   35,  249,
 /*  1780 */   249,   35,   35,   96,   95,  367,   95,   35,   96,   96,
 /*  1790 */   372,   95,  374,  163,  165,   96,  163,   35,   35,    0,
 /*  1800 */   328,   44,  171,   47,  243,   96,   47,   96,  170,    0,
 /*  1810 */   170,    0,   95,  166,   96,   95,  398,   96,   95,    0,
 /*  1820 */   402,   95,   39,  405,  406,  407,  408,  409,  410,   95,
 /*  1830 */   412,  359,  105,   47,  164,   44,    2,   22,   22,  367,
 /*  1840 */    95,   47,   47,   95,  372,   96,  374,   96,   95,   35,
 /*  1850 */   106,  119,   35,   95,  328,   35,   96,   96,  207,   95,
 /*  1860 */    95,  209,   96,   95,   35,   96,   95,   35,   35,   96,
 /*  1870 */   398,   95,  228,   96,  402,  457,  458,  405,  406,  407,
 /*  1880 */   408,  409,  410,   95,  412,  359,   96,   95,   22,  119,
 /*  1890 */    44,  419,  107,  367,  119,   95,  424,  119,  372,   95,
 /*  1900 */   374,  230,   35,  228,   22,   95,  328,   64,   63,   35,
 /*  1910 */    35,   35,   35,   35,   35,   35,   35,   70,   35,   35,
 /*  1920 */    92,   35,  328,   35,  398,   35,   22,   70,  402,   44,
 /*  1930 */    35,  405,  406,  407,  408,  409,  410,  359,  412,   22,
 /*  1940 */    35,   35,   35,   35,   35,  367,   35,   35,   35,    0,
 /*  1950 */   372,   35,  374,  359,   39,    0,   35,   39,   48,    0,
 /*  1960 */    35,  367,   48,   39,    0,   35,  372,   48,  374,    0,
 /*  1970 */    48,   39,   35,  447,   35,    0,  398,   20,   22,   21,
 /*  1980 */   402,  461,   22,  405,  406,  407,  408,  409,  410,   21,
 /*  1990 */   412,  461,  398,   22,  461,  461,  402,  461,  461,  405,
 /*  2000 */   406,  407,  408,  409,  410,  461,  412,  461,  461,  461,
 /*  2010 */   461,  328,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2020 */   461,  461,  461,  461,  461,  461,  461,  449,  461,  328,
 /*  2030 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2040 */   461,  461,  359,  461,  461,  461,  461,  364,  461,  461,
 /*  2050 */   367,  461,  458,  461,  461,  372,  461,  374,  461,  461,
 /*  2060 */   359,  461,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2070 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2080 */   461,  398,  461,  328,  461,  402,  461,  461,  405,  406,
 /*  2090 */   407,  408,  409,  410,  461,  412,  461,  461,  461,  398,
 /*  2100 */   328,  461,  461,  402,  461,  461,  405,  406,  407,  408,
 /*  2110 */   409,  410,  461,  412,  359,  414,  461,  461,  461,  364,
 /*  2120 */   461,  461,  367,  461,  461,  461,  461,  372,  461,  374,
 /*  2130 */   461,  359,  461,  461,  461,  461,  364,  461,  461,  367,
 /*  2140 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2150 */   461,  461,  328,  398,  461,  461,  461,  402,  461,  461,
 /*  2160 */   405,  406,  407,  408,  409,  410,  461,  412,  328,  461,
 /*  2170 */   398,  461,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2180 */   408,  409,  410,  359,  412,  461,  461,  461,  461,  461,
 /*  2190 */   461,  367,  461,  461,  461,  461,  372,  461,  374,  359,
 /*  2200 */   461,  461,  461,  461,  461,  461,  461,  367,  461,  461,
 /*  2210 */   461,  461,  372,  461,  374,  461,  461,  461,  461,  461,
 /*  2220 */   328,  461,  398,  461,  461,  461,  402,  461,  461,  405,
 /*  2230 */   406,  407,  408,  409,  410,  461,  412,  461,  398,  461,
 /*  2240 */   461,  461,  402,  461,  461,  405,  406,  407,  408,  409,
 /*  2250 */   410,  359,  412,  461,  461,  461,  461,  461,  461,  367,
 /*  2260 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2270 */   461,  461,  461,  461,  328,  461,  461,  461,  461,  461,
 /*  2280 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2290 */   398,  461,  461,  461,  402,  328,  461,  405,  406,  407,
 /*  2300 */   408,  409,  410,  461,  412,  359,  461,  461,  461,  461,
 /*  2310 */   461,  461,  461,  367,  461,  461,  461,  461,  372,  461,
 /*  2320 */   374,  461,  461,  461,  461,  461,  359,  461,  461,  461,
 /*  2330 */   461,  461,  461,  461,  367,  461,  461,  461,  461,  372,
 /*  2340 */   461,  374,  461,  461,  398,  461,  461,  461,  402,  461,
 /*  2350 */   461,  405,  406,  407,  408,  409,  410,  461,  412,  461,
 /*  2360 */   461,  461,  461,  461,  461,  398,  461,  461,  461,  402,
 /*  2370 */   461,  328,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2380 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  328,
 /*  2390 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2400 */   461,  461,  359,  461,  461,  461,  461,  461,  461,  461,
 /*  2410 */   367,  461,  461,  461,  461,  372,  461,  374,  461,  461,
 /*  2420 */   359,  461,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2430 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2440 */   461,  398,  461,  328,  461,  402,  461,  461,  405,  406,
 /*  2450 */   407,  408,  409,  410,  461,  412,  461,  461,  461,  398,
 /*  2460 */   328,  461,  461,  402,  461,  461,  405,  406,  407,  408,
 /*  2470 */   409,  410,  461,  412,  359,  461,  461,  461,  461,  461,
 /*  2480 */   461,  461,  367,  461,  461,  461,  461,  372,  461,  374,
 /*  2490 */   461,  359,  461,  461,  461,  461,  461,  461,  461,  367,
 /*  2500 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2510 */   461,  461,  328,  398,  461,  461,  461,  402,  461,  461,
 /*  2520 */   405,  406,  407,  408,  409,  410,  461,  412,  328,  461,
 /*  2530 */   398,  461,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2540 */   408,  409,  410,  359,  412,  461,  461,  461,  461,  461,
 /*  2550 */   461,  367,  461,  461,  461,  461,  372,  461,  374,  359,
 /*  2560 */   461,  461,  461,  461,  461,  461,  461,  367,  461,  461,
 /*  2570 */   461,  461,  372,  461,  374,  461,  461,  461,  461,  461,
 /*  2580 */   328,  461,  398,  461,  461,  461,  402,  461,  461,  405,
 /*  2590 */   406,  407,  408,  409,  410,  461,  412,  461,  398,  461,
 /*  2600 */   461,  461,  402,  328,  461,  405,  406,  407,  408,  409,
 /*  2610 */   410,  359,  412,  461,  461,  461,  461,  461,  461,  367,
 /*  2620 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2630 */   461,  461,  461,  461,  359,  461,  461,  461,  461,  461,
 /*  2640 */   461,  461,  367,  461,  461,  461,  461,  372,  461,  374,
 /*  2650 */   398,  461,  461,  461,  402,  328,  461,  405,  406,  407,
 /*  2660 */   408,  409,  410,  461,  412,  461,  461,  461,  461,  461,
 /*  2670 */   461,  461,  461,  398,  461,  461,  461,  402,  461,  461,
 /*  2680 */   405,  406,  407,  408,  409,  410,  359,  412,  461,  461,
 /*  2690 */   461,  461,  461,  461,  367,  461,  461,  461,  461,  372,
 /*  2700 */   461,  374,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2710 */   461,  461,  461,  461,  461,  461,  461,  461,  328,  461,
 /*  2720 */   461,  461,  461,  461,  461,  398,  461,  461,  461,  402,
 /*  2730 */   461,  461,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2740 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  359,
 /*  2750 */   461,  461,  461,  461,  461,  461,  461,  367,  461,  461,
 /*  2760 */   461,  461,  372,  461,  374,  461,  461,  461,  461,  461,
 /*  2770 */   328,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2780 */   461,  461,  461,  461,  461,  461,  461,  461,  398,  328,
 /*  2790 */   461,  461,  402,  461,  461,  405,  406,  407,  408,  409,
 /*  2800 */   410,  359,  412,  461,  461,  461,  461,  461,  461,  367,
 /*  2810 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2820 */   359,  461,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2830 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2840 */   398,  328,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2850 */   408,  409,  410,  461,  412,  461,  461,  328,  461,  398,
 /*  2860 */   461,  461,  461,  402,  461,  461,  405,  406,  407,  408,
 /*  2870 */   409,  410,  359,  412,  461,  461,  461,  461,  461,  461,
 /*  2880 */   367,  461,  461,  461,  461,  372,  461,  374,  359,  461,
 /*  2890 */   461,  461,  461,  461,  461,  461,  367,  461,  461,  461,
 /*  2900 */   461,  372,  461,  374,  461,  461,  461,  461,  461,  328,
 /*  2910 */   461,  398,  461,  461,  461,  402,  461,  461,  405,  406,
 /*  2920 */   407,  408,  409,  410,  461,  412,  461,  398,  461,  461,
 /*  2930 */   461,  402,  328,  461,  405,  406,  407,  408,  409,  410,
 /*  2940 */   359,  412,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2950 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2960 */   461,  461,  461,  359,  461,  461,  461,  461,  461,  461,
 /*  2970 */   461,  367,  461,  461,  461,  461,  372,  461,  374,  398,
 /*  2980 */   461,  461,  461,  402,  328,  461,  405,  406,  407,  408,
 /*  2990 */   409,  410,  461,  412,  461,  461,  461,  461,  461,  461,
 /*  3000 */   461,  461,  398,  461,  461,  461,  402,  461,  461,  405,
 /*  3010 */   406,  407,  408,  409,  410,  359,  412,  461,  461,  461,
 /*  3020 */   461,  461,  461,  367,  461,  461,  461,  461,  372,  461,
 /*  3030 */   374,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  3040 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  3050 */   461,  461,  461,  461,  398,  461,  461,  461,  402,  461,
 /*  3060 */   461,  405,  406,  407,  408,  409,  410,  461,  412,  325,
 /*  3070 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3080 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3090 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3100 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3110 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3120 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3130 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3140 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3150 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3160 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3170 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3180 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3190 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3200 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3210 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3220 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3230 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3240 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3250 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3260 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3270 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3280 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3290 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3300 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3310 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3320 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3330 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3340 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3350 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3360 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3370 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3380 */   325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
 /*  3390 */   325,  325,  325,  325,
};
#define YY_SHIFT_COUNT    (713)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1975)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   862,    0,   71,    0,  289,  289,  289,  289,  289,  289,
 /*    10 */   289,  289,  289,  289,  289,  360,  576,  576,  647,  576,
 /*    20 */   576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
 /*    30 */   576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
 /*    40 */   576,  576,  576,  576,  576,  576,  576,  576,   32,  134,
 /*    50 */    21,  590,  133,    7,  104,    7,   21,   21, 1216, 1216,
 /*    60 */     7, 1216, 1216,  136,    7,  423,   25,   25,  423,  401,
 /*    70 */   401,  215,   57,    5,    5,   25,   25,   25,   25,   25,
 /*    80 */    25,   25,   25,   25,   25,   80,   25,   25,  156,   25,
 /*    90 */    25,   25,  343,   25,   25,  343,   25,  343,  343,  343,
 /*   100 */    25,  328,  792,   34,   34,  216,  474,  283,  283,  283,
 /*   110 */   283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
 /*   120 */   283,  283,  283,  283,  283,  283, 1073,   87,  215,   57,
 /*   130 */   593,  313,  499,  499,  499,  710,  229,  229,  313,  374,
 /*   140 */   374,  374,  143,  384,  343,  378,  343,  378,  378,  143,
 /*   150 */   566,  217,  217,  217,  217,  217,  217,  217, 1351,  408,
 /*   160 */   336,  612,  249,  430,  340,  464,  292,  714,  377,  518,
 /*   170 */   873,  656,  858,  748,   12,  754,  748,  769,  353,  836,
 /*   180 */   977, 1192, 1055, 1202, 1226, 1202, 1094, 1236, 1236, 1202,
 /*   190 */  1094, 1094, 1180, 1236, 1236, 1236, 1265, 1265, 1270,   80,
 /*   200 */  1278,   80, 1280, 1283,   80, 1280,   80,   80,   80, 1236,
 /*   210 */    80, 1260, 1260, 1265,  343,  343,  343,  343,  343,  343,
 /*   220 */   343,  343,  343,  343,  343, 1236, 1265,  378,  378, 1129,
 /*   230 */  1270,  328, 1177, 1278,  328, 1236, 1226, 1226,  378, 1117,
 /*   240 */  1124,  378, 1117, 1124,  378,  378,  343, 1122, 1213, 1117,
 /*   250 */  1130, 1132, 1148,  977, 1127, 1134, 1137, 1159,  374, 1398,
 /*   260 */  1236, 1280,  328, 1124,  378,  378,  378,  378,  378, 1124,
 /*   270 */   378, 1262,  328,  143,  328,  374, 1361, 1366,  378,  566,
 /*   280 */  1236,  328, 1437, 1265, 3069, 3069, 3069, 3069, 3069, 3069,
 /*   290 */  3069, 3069, 3069,  887,  310,   94,  625,   15,   59,  738,
 /*   300 */   720,  753,  881,   73,  781,  472,  472,  472,  472,  472,
 /*   310 */   472,  472,  472,  472,  875,  124,  373,  373,  122,    4,
 /*   320 */    58,  166,  484,  300,  300,  790,  912,  588,  790,  790,
 /*   330 */   790,  113, 1057,  288,  969,  913,  884,  918,  923,  986,
 /*   340 */   988, 1093, 1101, 1106, 1005, 1042, 1090, 1011,  425,  945,
 /*   350 */   863, 1096, 1103, 1115, 1116, 1120, 1187, 1131, 1010, 1041,
 /*   360 */  1046, 1140, 1074, 1141, 1147, 1151, 1176, 1179, 1195,  825,
 /*   370 */  1142, 1166,  489, 1181, 1482, 1487, 1300, 1490, 1493, 1452,
 /*   380 */  1495, 1461, 1296, 1463, 1464, 1465, 1302, 1501, 1469, 1470,
 /*   390 */  1306, 1508, 1314, 1518, 1484, 1522, 1502, 1529, 1491, 1347,
 /*   400 */  1352, 1533, 1535, 1358, 1363, 1538, 1541, 1496, 1542, 1544,
 /*   410 */  1545, 1504, 1548, 1549, 1550, 1551, 1552, 1553, 1554, 1555,
 /*   420 */  1406, 1523, 1559, 1410, 1562, 1569, 1571, 1572, 1573, 1574,
 /*   430 */  1576, 1579, 1580, 1583, 1584, 1585, 1587, 1588, 1589, 1556,
 /*   440 */  1590, 1592, 1599, 1600, 1601, 1575, 1602, 1603, 1604, 1459,
 /*   450 */  1595, 1596, 1577, 1606, 1557, 1607, 1558, 1608, 1609, 1568,
 /*   460 */  1581, 1567, 1566, 1605, 1586, 1616, 1593, 1614, 1582, 1598,
 /*   470 */  1618, 1623, 1632, 1611, 1462, 1634, 1639, 1641, 1591, 1645,
 /*   480 */  1646, 1612, 1610, 1613, 1648, 1619, 1615, 1617, 1653, 1622,
 /*   490 */  1620, 1621, 1661, 1627, 1624, 1625, 1665, 1666, 1667, 1669,
 /*   500 */  1570, 1597, 1635, 1649, 1673, 1642, 1643, 1656, 1657, 1636,
 /*   510 */  1637, 1658, 1659, 1654, 1660, 1697, 1680, 1704, 1684, 1662,
 /*   520 */  1707, 1686, 1674, 1710, 1676, 1713, 1679, 1715, 1694, 1698,
 /*   530 */  1682, 1685, 1527, 1626, 1628, 1724, 1563, 1690, 1728, 1546,
 /*   540 */  1708, 1630, 1629, 1735, 1742, 1633, 1631, 1741, 1703, 1499,
 /*   550 */  1650, 1655, 1664, 1638, 1521, 1640, 1500, 1668, 1712, 1687,
 /*   560 */  1681, 1689, 1691, 1692, 1716, 1705, 1714, 1696, 1719, 1530,
 /*   570 */  1693, 1699, 1754, 1731, 1531, 1743, 1746, 1747, 1752, 1762,
 /*   580 */  1763, 1709, 1711, 1756, 1561, 1757, 1759, 1799, 1809, 1811,
 /*   590 */  1717, 1718, 1721, 1720, 1723, 1647, 1726, 1819, 1783, 1670,
 /*   600 */  1734, 1727, 1566, 1786, 1791, 1644, 1671, 1675, 1834, 1815,
 /*   610 */  1651, 1745, 1749, 1748, 1751, 1753, 1760, 1794, 1758, 1764,
 /*   620 */  1795, 1761, 1816, 1652, 1765, 1744, 1766, 1814, 1817, 1768,
 /*   630 */  1769, 1820, 1771, 1773, 1829, 1776, 1777, 1832, 1788, 1790,
 /*   640 */  1833, 1792, 1732, 1770, 1775, 1778, 1866, 1785, 1800, 1846,
 /*   650 */  1804, 1867, 1810, 1846, 1846, 1882, 1843, 1845, 1874, 1875,
 /*   660 */  1876, 1877, 1878, 1879, 1880, 1881, 1883, 1884, 1847, 1828,
 /*   670 */  1885, 1886, 1888, 1890, 1904, 1895, 1905, 1906, 1857, 1636,
 /*   680 */  1907, 1637, 1908, 1909, 1911, 1912, 1917, 1913, 1949, 1916,
 /*   690 */  1910, 1915, 1955, 1921, 1914, 1918, 1959, 1925, 1919, 1924,
 /*   700 */  1964, 1930, 1922, 1932, 1969, 1937, 1939, 1975, 1956, 1958,
 /*   710 */  1960, 1971, 1968, 1957,
};
#define YY_REDUCE_COUNT (292)
#define YY_REDUCE_MIN   (-420)
#define YY_REDUCE_MAX   (2656)
static const short yy_reduce_ofst[] = {
 /*     0 */   276, -259,  233,  672,  744,  798,  859,  922,  942, 1045,
 /*    10 */  1104, 1158, 1219, 1277, 1331, 1360,  294, 1418, 1472, 1526,
 /*    20 */  1578, 1594, 1683, 1701, 1755, 1772, 1824, 1840, 1892, 1946,
 /*    30 */  1967, 2043, 2061, 2115, 2132, 2184, 2200, 2252, 2275, 2327,
 /*    40 */  2390, 2442, 2461, 2513, 2529, 2581, 2604, 2656, -258,   95,
 /*    50 */   105,  -39,  559,  597,  599,  669,  187,  704, -346,  -57,
 /*    60 */  -391,  323,  480, -276, -250,   75, -222,  297, -371, -330,
 /*    70 */  -326, -327, -363, -299, -257,  116,  128,  193,  199,  327,
 /*    80 */   409,  471,  645,  649,  657,  252,  693,  706,  -51,  725,
 /*    90 */   747,  762,  244,  763,  772, -203,  791,  465,   -5,  362,
 /*   100 */   847, -210, -315, -420, -420, -217, -212,  -69,  -21,   41,
 /*   110 */    43,   70,   96,  117,  148,  197,  225,  234,  346,  351,
 /*   120 */   405,  446,  454,  504,  651,  655, -266, -170,  397,  191,
 /*   130 */   152,  352, -170, -150,  219,  477,  186,  254,  491,  524,
 /*   140 */   537,  538, -316, -319,  485,  367,  542,  555,  557,  632,
 /*   150 */   530, -342,  369,  389,  410,  463,  468,  483,  319,  577,
 /*   160 */   650,  543,  521,  603,  756,  695,  786,  786,  810,  780,
 /*   170 */   831,  811,  808,  760,  760,  746,  760,  784,  783,  786,
 /*   180 */   834,  842,  851,  866,  870,  869,  878,  924,  926,  879,
 /*   190 */   882,  886,  933,  943,  944,  948,  957,  958,  897,  953,
 /*   200 */   925,  955,  965,  914,  963,  970,  964,  966,  968,  975,
 /*   210 */   971,  976,  978,  989,  959,  962,  967,  979,  983,  984,
 /*   220 */   994,  996,  998,  999, 1001,  987,  992,  990,  991,  938,
 /*   230 */   941,  997,  973,  995, 1028, 1035,  993, 1000, 1002,  936,
 /*   240 */  1003, 1007,  939, 1004, 1009, 1013,  786,  946,  949,  950,
 /*   250 */   947,  956,  972, 1014,  951,  961,  960,  760, 1049, 1016,
 /*   260 */  1085, 1088, 1082, 1043, 1054, 1058, 1059, 1061, 1062, 1044,
 /*   270 */  1063, 1066, 1118, 1089, 1119, 1079, 1038, 1102, 1095, 1121,
 /*   280 */  1136, 1126, 1143, 1145, 1087, 1081, 1097, 1098, 1135, 1138,
 /*   290 */  1139, 1144, 1154,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*    10 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*    20 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*    30 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*    40 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*    50 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*    60 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*    70 */  1606, 1861, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*    80 */  1606, 1606, 1606, 1606, 1606, 1684, 1606, 1606, 1606, 1606,
 /*    90 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   100 */  1606, 1682, 1854, 2057, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   110 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   120 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 2069, 1606, 1606,
 /*   130 */  1684, 1606, 2069, 2069, 2069, 1682, 2029, 2029, 1606, 1606,
 /*   140 */  1606, 1606, 1791, 1606, 1606, 1606, 1606, 1606, 1606, 1791,
 /*   150 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1903, 1606,
 /*   160 */  1606, 2094, 2148, 1606, 1606, 2097, 1606, 1606, 1606, 1866,
 /*   170 */  1606, 1744, 2084, 2061, 2075, 2132, 2062, 2059, 2078, 1606,
 /*   180 */  2088, 1606, 1896, 1859, 1606, 1859, 1856, 1606, 1606, 1859,
 /*   190 */  1856, 1856, 1735, 1606, 1606, 1606, 1606, 1606, 1606, 1684,
 /*   200 */  1606, 1684, 1606, 1606, 1684, 1606, 1684, 1684, 1684, 1606,
 /*   210 */  1684, 1663, 1663, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   220 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1916,
 /*   230 */  1606, 1682, 1905, 1606, 1682, 1606, 1606, 1606, 1606, 2105,
 /*   240 */  2103, 1606, 2105, 2103, 1606, 1606, 1606, 2117, 2113, 2105,
 /*   250 */  2121, 2119, 2090, 2088, 2151, 2138, 2134, 2075, 1606, 1606,
 /*   260 */  1606, 1606, 1682, 2103, 1606, 1606, 1606, 1606, 1606, 2103,
 /*   270 */  1606, 1606, 1682, 1606, 1682, 1606, 1606, 1760, 1606, 1606,
 /*   280 */  1606, 1682, 1638, 1606, 1898, 1909, 1881, 1881, 1794, 1794,
 /*   290 */  1794, 1685, 1611, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   300 */  1606, 1606, 1606, 1606, 1606, 2116, 2115, 1984, 1606, 2033,
 /*   310 */  2032, 2031, 2022, 1983, 1756, 1606, 1982, 1981, 1606, 1606,
 /*   320 */  1606, 1606, 1606, 1872, 1871, 1975, 1606, 1606, 1976, 1974,
 /*   330 */  1973, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   340 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 2135, 2139,
 /*   350 */  1606, 1606, 1606, 1606, 1606, 1606, 2058, 1606, 1606, 1606,
 /*   360 */  1606, 1606, 1958, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   370 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   380 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   390 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   400 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   410 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   420 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   430 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   440 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   450 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   460 */  1606, 1643, 1963, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   470 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   480 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   490 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   500 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1723,
 /*   510 */  1722, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   520 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   530 */  1606, 1606, 1606, 1966, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   540 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 2131, 2091, 1606,
 /*   550 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   560 */  1606, 1606, 1606, 1606, 1606, 1606, 1958, 1606, 2114, 1606,
 /*   570 */  1606, 2129, 1606, 2133, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   580 */  1606, 2068, 2064, 1606, 1606, 2060, 1606, 1606, 1606, 1606,
 /*   590 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   600 */  1606, 1606, 1957, 1606, 2019, 1606, 1606, 1606, 2053, 1606,
 /*   610 */  1606, 2004, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   620 */  1606, 1966, 1606, 1969, 1606, 1606, 1606, 1606, 1606, 1788,
 /*   630 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   640 */  1606, 1606, 1773, 1771, 1770, 1769, 1606, 1766, 1606, 1801,
 /*   650 */  1606, 1606, 1606, 1797, 1796, 1606, 1606, 1606, 1606, 1606,
 /*   660 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   670 */  1703, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1695,
 /*   680 */  1606, 1694, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   690 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   700 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*   710 */  1606, 1606, 1606, 1606,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  271,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  271,  /*      AFTER => ABORT */
  271,  /*     ATTACH => ABORT */
  271,  /*     BEFORE => ABORT */
  271,  /*      BEGIN => ABORT */
  271,  /*     BITAND => ABORT */
  271,  /*     BITNOT => ABORT */
  271,  /*      BITOR => ABORT */
  271,  /*     BLOCKS => ABORT */
  271,  /*     CHANGE => ABORT */
  271,  /*      COMMA => ABORT */
  271,  /*    COMPACT => ABORT */
  271,  /*     CONCAT => ABORT */
  271,  /*   CONFLICT => ABORT */
  271,  /*       COPY => ABORT */
  271,  /*   DEFERRED => ABORT */
  271,  /* DELIMITERS => ABORT */
  271,  /*     DETACH => ABORT */
  271,  /*     DIVIDE => ABORT */
  271,  /*        DOT => ABORT */
  271,  /*       EACH => ABORT */
  271,  /*       FAIL => ABORT */
  271,  /*       FILE => ABORT */
  271,  /*        FOR => ABORT */
  271,  /*       GLOB => ABORT */
  271,  /*         ID => ABORT */
  271,  /*  IMMEDIATE => ABORT */
  271,  /*     IMPORT => ABORT */
  271,  /*  INITIALLY => ABORT */
  271,  /*    INSTEAD => ABORT */
  271,  /*     ISNULL => ABORT */
  271,  /*        KEY => ABORT */
  271,  /*    MODULES => ABORT */
  271,  /*  NK_BITNOT => ABORT */
  271,  /*    NK_SEMI => ABORT */
  271,  /*    NOTNULL => ABORT */
  271,  /*         OF => ABORT */
  271,  /*       PLUS => ABORT */
  271,  /*  PRIVILEGE => ABORT */
  271,  /*      RAISE => ABORT */
  271,  /*    REPLACE => ABORT */
  271,  /*   RESTRICT => ABORT */
  271,  /*        ROW => ABORT */
  271,  /*       SEMI => ABORT */
  271,  /*       STAR => ABORT */
  271,  /*  STATEMENT => ABORT */
  271,  /*     STRICT => ABORT */
  271,  /*     STRING => ABORT */
  271,  /*      TIMES => ABORT */
  271,  /*     UPDATE => ABORT */
  271,  /*     VALUES => ABORT */
  271,  /*   VARIABLE => ABORT */
  271,  /*       VIEW => ABORT */
  271,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "COUNT",
  /*  168 */ "LAST_ROW",
  /*  169 */ "TOPIC",
  /*  170 */ "WITH",
  /*  171 */ "META",
  /*  172 */ "CONSUMER",
  /*  173 */ "GROUP",
  /*  174 */ "DESC",
  /*  175 */ "DESCRIBE",
  /*  176 */ "RESET",
  /*  177 */ "QUERY",
  /*  178 */ "CACHE",
  /*  179 */ "EXPLAIN",
  /*  180 */ "ANALYZE",
  /*  181 */ "VERBOSE",
  /*  182 */ "NK_BOOL",
  /*  183 */ "RATIO",
  /*  184 */ "NK_FLOAT",
  /*  185 */ "OUTPUTTYPE",
  /*  186 */ "AGGREGATE",
  /*  187 */ "BUFSIZE",
  /*  188 */ "STREAM",
  /*  189 */ "INTO",
  /*  190 */ "TRIGGER",
  /*  191 */ "AT_ONCE",
  /*  192 */ "WINDOW_CLOSE",
  /*  193 */ "IGNORE",
  /*  194 */ "EXPIRED",
  /*  195 */ "FILL_HISTORY",
  /*  196 */ "SUBTABLE",
  /*  197 */ "KILL",
  /*  198 */ "CONNECTION",
  /*  199 */ "TRANSACTION",
  /*  200 */ "BALANCE",
  /*  201 */ "VGROUP",
  /*  202 */ "MERGE",
  /*  203 */ "REDISTRIBUTE",
  /*  204 */ "SPLIT",
  /*  205 */ "DELETE",
  /*  206 */ "INSERT",
  /*  207 */ "NULL",
  /*  208 */ "NK_QUESTION",
  /*  209 */ "NK_ARROW",
  /*  210 */ "ROWTS",
  /*  211 */ "QSTART",
  /*  212 */ "QEND",
  /*  213 */ "QDURATION",
  /*  214 */ "WSTART",
  /*  215 */ "WEND",
  /*  216 */ "WDURATION",
  /*  217 */ "IROWTS",
  /*  218 */ "ISFILLED",
  /*  219 */ "CAST",
  /*  220 */ "NOW",
  /*  221 */ "TODAY",
  /*  222 */ "TIMEZONE",
  /*  223 */ "CLIENT_VERSION",
  /*  224 */ "SERVER_VERSION",
  /*  225 */ "SERVER_STATUS",
  /*  226 */ "CURRENT_USER",
  /*  227 */ "CASE",
  /*  228 */ "END",
  /*  229 */ "WHEN",
  /*  230 */ "THEN",
  /*  231 */ "ELSE",
  /*  232 */ "BETWEEN",
  /*  233 */ "IS",
  /*  234 */ "NK_LT",
  /*  235 */ "NK_GT",
  /*  236 */ "NK_LE",
  /*  237 */ "NK_GE",
  /*  238 */ "NK_NE",
  /*  239 */ "MATCH",
  /*  240 */ "NMATCH",
  /*  241 */ "CONTAINS",
  /*  242 */ "IN",
  /*  243 */ "JOIN",
  /*  244 */ "INNER",
  /*  245 */ "SELECT",
  /*  246 */ "DISTINCT",
  /*  247 */ "WHERE",
  /*  248 */ "PARTITION",
  /*  249 */ "BY",
  /*  250 */ "SESSION",
  /*  251 */ "STATE_WINDOW",
  /*  252 */ "EVENT_WINDOW",
  /*  253 */ "START",
  /*  254 */ "SLIDING",
  /*  255 */ "FILL",
  /*  256 */ "VALUE",
  /*  257 */ "NONE",
  /*  258 */ "PREV",
  /*  259 */ "LINEAR",
  /*  260 */ "NEXT",
  /*  261 */ "HAVING",
  /*  262 */ "RANGE",
  /*  263 */ "EVERY",
  /*  264 */ "ORDER",
  /*  265 */ "SLIMIT",
  /*  266 */ "SOFFSET",
  /*  267 */ "LIMIT",
  /*  268 */ "OFFSET",
  /*  269 */ "ASC",
  /*  270 */ "NULLS",
  /*  271 */ "ABORT",
  /*  272 */ "AFTER",
  /*  273 */ "ATTACH",
  /*  274 */ "BEFORE",
  /*  275 */ "BEGIN",
  /*  276 */ "BITAND",
  /*  277 */ "BITNOT",
  /*  278 */ "BITOR",
  /*  279 */ "BLOCKS",
  /*  280 */ "CHANGE",
  /*  281 */ "COMMA",
  /*  282 */ "COMPACT",
  /*  283 */ "CONCAT",
  /*  284 */ "CONFLICT",
  /*  285 */ "COPY",
  /*  286 */ "DEFERRED",
  /*  287 */ "DELIMITERS",
  /*  288 */ "DETACH",
  /*  289 */ "DIVIDE",
  /*  290 */ "DOT",
  /*  291 */ "EACH",
  /*  292 */ "FAIL",
  /*  293 */ "FILE",
  /*  294 */ "FOR",
  /*  295 */ "GLOB",
  /*  296 */ "ID",
  /*  297 */ "IMMEDIATE",
  /*  298 */ "IMPORT",
  /*  299 */ "INITIALLY",
  /*  300 */ "INSTEAD",
  /*  301 */ "ISNULL",
  /*  302 */ "KEY",
  /*  303 */ "MODULES",
  /*  304 */ "NK_BITNOT",
  /*  305 */ "NK_SEMI",
  /*  306 */ "NOTNULL",
  /*  307 */ "OF",
  /*  308 */ "PLUS",
  /*  309 */ "PRIVILEGE",
  /*  310 */ "RAISE",
  /*  311 */ "REPLACE",
  /*  312 */ "RESTRICT",
  /*  313 */ "ROW",
  /*  314 */ "SEMI",
  /*  315 */ "STAR",
  /*  316 */ "STATEMENT",
  /*  317 */ "STRICT",
  /*  318 */ "STRING",
  /*  319 */ "TIMES",
  /*  320 */ "UPDATE",
  /*  321 */ "VALUES",
  /*  322 */ "VARIABLE",
  /*  323 */ "VIEW",
  /*  324 */ "WAL",
  /*  325 */ "cmd",
  /*  326 */ "account_options",
  /*  327 */ "alter_account_options",
  /*  328 */ "literal",
  /*  329 */ "alter_account_option",
  /*  330 */ "user_name",
  /*  331 */ "sysinfo_opt",
  /*  332 */ "privileges",
  /*  333 */ "priv_level",
  /*  334 */ "priv_type_list",
  /*  335 */ "priv_type",
  /*  336 */ "db_name",
  /*  337 */ "topic_name",
  /*  338 */ "dnode_endpoint",
  /*  339 */ "force_opt",
  /*  340 */ "not_exists_opt",
  /*  341 */ "db_options",
  /*  342 */ "exists_opt",
  /*  343 */ "alter_db_options",
  /*  344 */ "speed_opt",
  /*  345 */ "integer_list",
  /*  346 */ "variable_list",
  /*  347 */ "retention_list",
  /*  348 */ "alter_db_option",
  /*  349 */ "retention",
  /*  350 */ "full_table_name",
  /*  351 */ "column_def_list",
  /*  352 */ "tags_def_opt",
  /*  353 */ "table_options",
  /*  354 */ "multi_create_clause",
  /*  355 */ "tags_def",
  /*  356 */ "multi_drop_clause",
  /*  357 */ "alter_table_clause",
  /*  358 */ "alter_table_options",
  /*  359 */ "column_name",
  /*  360 */ "type_name",
  /*  361 */ "signed_literal",
  /*  362 */ "create_subtable_clause",
  /*  363 */ "specific_cols_opt",
  /*  364 */ "expression_list",
  /*  365 */ "drop_table_clause",
  /*  366 */ "col_name_list",
  /*  367 */ "table_name",
  /*  368 */ "column_def",
  /*  369 */ "duration_list",
  /*  370 */ "rollup_func_list",
  /*  371 */ "alter_table_option",
  /*  372 */ "duration_literal",
  /*  373 */ "rollup_func_name",
  /*  374 */ "function_name",
  /*  375 */ "col_name",
  /*  376 */ "db_name_cond_opt",
  /*  377 */ "like_pattern_opt",
  /*  378 */ "table_name_cond",
  /*  379 */ "from_db_opt",
  /*  380 */ "tag_list_opt",
  /*  381 */ "tag_item",
  /*  382 */ "column_alias",
  /*  383 */ "index_options",
  /*  384 */ "func_list",
  /*  385 */ "sliding_opt",
  /*  386 */ "sma_stream_opt",
  /*  387 */ "func",
  /*  388 */ "sma_func_name",
  /*  389 */ "query_or_subquery",
  /*  390 */ "cgroup_name",
  /*  391 */ "analyze_opt",
  /*  392 */ "explain_options",
  /*  393 */ "agg_func_opt",
  /*  394 */ "bufsize_opt",
  /*  395 */ "stream_name",
  /*  396 */ "stream_options",
  /*  397 */ "subtable_opt",
  /*  398 */ "expression",
  /*  399 */ "dnode_list",
  /*  400 */ "where_clause_opt",
  /*  401 */ "signed",
  /*  402 */ "literal_func",
  /*  403 */ "literal_list",
  /*  404 */ "table_alias",
  /*  405 */ "expr_or_subquery",
  /*  406 */ "pseudo_column",
  /*  407 */ "column_reference",
  /*  408 */ "function_expression",
  /*  409 */ "case_when_expression",
  /*  410 */ "star_func",
  /*  411 */ "star_func_para_list",
  /*  412 */ "noarg_func",
  /*  413 */ "other_para_list",
  /*  414 */ "star_func_para",
  /*  415 */ "when_then_list",
  /*  416 */ "case_when_else_opt",
  /*  417 */ "common_expression",
  /*  418 */ "when_then_expr",
  /*  419 */ "predicate",
  /*  420 */ "compare_op",
  /*  421 */ "in_op",
  /*  422 */ "in_predicate_value",
  /*  423 */ "boolean_value_expression",
  /*  424 */ "boolean_primary",
  /*  425 */ "from_clause_opt",
  /*  426 */ "table_reference_list",
  /*  427 */ "table_reference",
  /*  428 */ "table_primary",
  /*  429 */ "joined_table",
  /*  430 */ "alias_opt",
  /*  431 */ "subquery",
  /*  432 */ "parenthesized_joined_table",
  /*  433 */ "join_type",
  /*  434 */ "search_condition",
  /*  435 */ "query_specification",
  /*  436 */ "set_quantifier_opt",
  /*  437 */ "select_list",
  /*  438 */ "partition_by_clause_opt",
  /*  439 */ "range_opt",
  /*  440 */ "every_opt",
  /*  441 */ "fill_opt",
  /*  442 */ "twindow_clause_opt",
  /*  443 */ "group_by_clause_opt",
  /*  444 */ "having_clause_opt",
  /*  445 */ "select_item",
  /*  446 */ "partition_list",
  /*  447 */ "partition_item",
  /*  448 */ "fill_mode",
  /*  449 */ "group_by_list",
  /*  450 */ "query_expression",
  /*  451 */ "query_simple",
  /*  452 */ "order_by_clause_opt",
  /*  453 */ "slimit_clause_opt",
  /*  454 */ "limit_clause_opt",
  /*  455 */ "union_query_expression",
  /*  456 */ "query_simple_or_subquery",
  /*  457 */ "sort_specification_list",
  /*  458 */ "sort_specification",
  /*  459 */ "ordering_specification_opt",
  /*  460 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "db_name_cond_opt ::=",
 /* 246 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 247 */ "like_pattern_opt ::=",
 /* 248 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 249 */ "table_name_cond ::= table_name",
 /* 250 */ "from_db_opt ::=",
 /* 251 */ "from_db_opt ::= FROM db_name",
 /* 252 */ "tag_list_opt ::=",
 /* 253 */ "tag_list_opt ::= tag_item",
 /* 254 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 255 */ "tag_item ::= TBNAME",
 /* 256 */ "tag_item ::= QTAGS",
 /* 257 */ "tag_item ::= column_name",
 /* 258 */ "tag_item ::= column_name column_alias",
 /* 259 */ "tag_item ::= column_name AS column_alias",
 /* 260 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 261 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 262 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "func_list ::= func",
 /* 265 */ "func_list ::= func_list NK_COMMA func",
 /* 266 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 267 */ "sma_func_name ::= function_name",
 /* 268 */ "sma_func_name ::= COUNT",
 /* 269 */ "sma_func_name ::= FIRST",
 /* 270 */ "sma_func_name ::= LAST",
 /* 271 */ "sma_func_name ::= LAST_ROW",
 /* 272 */ "sma_stream_opt ::=",
 /* 273 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 274 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 275 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 276 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 277 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 278 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 279 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 280 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 281 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 282 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 283 */ "cmd ::= DESC full_table_name",
 /* 284 */ "cmd ::= DESCRIBE full_table_name",
 /* 285 */ "cmd ::= RESET QUERY CACHE",
 /* 286 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 287 */ "analyze_opt ::=",
 /* 288 */ "analyze_opt ::= ANALYZE",
 /* 289 */ "explain_options ::=",
 /* 290 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 291 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 292 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 293 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 294 */ "agg_func_opt ::=",
 /* 295 */ "agg_func_opt ::= AGGREGATE",
 /* 296 */ "bufsize_opt ::=",
 /* 297 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 298 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 299 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 300 */ "stream_options ::=",
 /* 301 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 302 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 303 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 304 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 305 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 306 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 307 */ "subtable_opt ::=",
 /* 308 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 309 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 310 */ "cmd ::= KILL QUERY NK_STRING",
 /* 311 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 312 */ "cmd ::= BALANCE VGROUP",
 /* 313 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 314 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 315 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 316 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 317 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 318 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 319 */ "cmd ::= query_or_subquery",
 /* 320 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 321 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 322 */ "literal ::= NK_INTEGER",
 /* 323 */ "literal ::= NK_FLOAT",
 /* 324 */ "literal ::= NK_STRING",
 /* 325 */ "literal ::= NK_BOOL",
 /* 326 */ "literal ::= TIMESTAMP NK_STRING",
 /* 327 */ "literal ::= duration_literal",
 /* 328 */ "literal ::= NULL",
 /* 329 */ "literal ::= NK_QUESTION",
 /* 330 */ "duration_literal ::= NK_VARIABLE",
 /* 331 */ "signed ::= NK_INTEGER",
 /* 332 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 333 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 334 */ "signed ::= NK_FLOAT",
 /* 335 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 336 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 337 */ "signed_literal ::= signed",
 /* 338 */ "signed_literal ::= NK_STRING",
 /* 339 */ "signed_literal ::= NK_BOOL",
 /* 340 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 341 */ "signed_literal ::= duration_literal",
 /* 342 */ "signed_literal ::= NULL",
 /* 343 */ "signed_literal ::= literal_func",
 /* 344 */ "signed_literal ::= NK_QUESTION",
 /* 345 */ "literal_list ::= signed_literal",
 /* 346 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 347 */ "db_name ::= NK_ID",
 /* 348 */ "table_name ::= NK_ID",
 /* 349 */ "column_name ::= NK_ID",
 /* 350 */ "function_name ::= NK_ID",
 /* 351 */ "table_alias ::= NK_ID",
 /* 352 */ "column_alias ::= NK_ID",
 /* 353 */ "user_name ::= NK_ID",
 /* 354 */ "topic_name ::= NK_ID",
 /* 355 */ "stream_name ::= NK_ID",
 /* 356 */ "cgroup_name ::= NK_ID",
 /* 357 */ "expr_or_subquery ::= expression",
 /* 358 */ "expression ::= literal",
 /* 359 */ "expression ::= pseudo_column",
 /* 360 */ "expression ::= column_reference",
 /* 361 */ "expression ::= function_expression",
 /* 362 */ "expression ::= case_when_expression",
 /* 363 */ "expression ::= NK_LP expression NK_RP",
 /* 364 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 365 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 366 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 367 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 369 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 370 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 371 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 372 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 373 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 374 */ "expression_list ::= expr_or_subquery",
 /* 375 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 376 */ "column_reference ::= column_name",
 /* 377 */ "column_reference ::= table_name NK_DOT column_name",
 /* 378 */ "pseudo_column ::= ROWTS",
 /* 379 */ "pseudo_column ::= TBNAME",
 /* 380 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 381 */ "pseudo_column ::= QSTART",
 /* 382 */ "pseudo_column ::= QEND",
 /* 383 */ "pseudo_column ::= QDURATION",
 /* 384 */ "pseudo_column ::= WSTART",
 /* 385 */ "pseudo_column ::= WEND",
 /* 386 */ "pseudo_column ::= WDURATION",
 /* 387 */ "pseudo_column ::= IROWTS",
 /* 388 */ "pseudo_column ::= ISFILLED",
 /* 389 */ "pseudo_column ::= QTAGS",
 /* 390 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 391 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 392 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 393 */ "function_expression ::= literal_func",
 /* 394 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 395 */ "literal_func ::= NOW",
 /* 396 */ "noarg_func ::= NOW",
 /* 397 */ "noarg_func ::= TODAY",
 /* 398 */ "noarg_func ::= TIMEZONE",
 /* 399 */ "noarg_func ::= DATABASE",
 /* 400 */ "noarg_func ::= CLIENT_VERSION",
 /* 401 */ "noarg_func ::= SERVER_VERSION",
 /* 402 */ "noarg_func ::= SERVER_STATUS",
 /* 403 */ "noarg_func ::= CURRENT_USER",
 /* 404 */ "noarg_func ::= USER",
 /* 405 */ "star_func ::= COUNT",
 /* 406 */ "star_func ::= FIRST",
 /* 407 */ "star_func ::= LAST",
 /* 408 */ "star_func ::= LAST_ROW",
 /* 409 */ "star_func_para_list ::= NK_STAR",
 /* 410 */ "star_func_para_list ::= other_para_list",
 /* 411 */ "other_para_list ::= star_func_para",
 /* 412 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 413 */ "star_func_para ::= expr_or_subquery",
 /* 414 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 415 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 416 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 417 */ "when_then_list ::= when_then_expr",
 /* 418 */ "when_then_list ::= when_then_list when_then_expr",
 /* 419 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 420 */ "case_when_else_opt ::=",
 /* 421 */ "case_when_else_opt ::= ELSE common_expression",
 /* 422 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 423 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 424 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 425 */ "predicate ::= expr_or_subquery IS NULL",
 /* 426 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 427 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 428 */ "compare_op ::= NK_LT",
 /* 429 */ "compare_op ::= NK_GT",
 /* 430 */ "compare_op ::= NK_LE",
 /* 431 */ "compare_op ::= NK_GE",
 /* 432 */ "compare_op ::= NK_NE",
 /* 433 */ "compare_op ::= NK_EQ",
 /* 434 */ "compare_op ::= LIKE",
 /* 435 */ "compare_op ::= NOT LIKE",
 /* 436 */ "compare_op ::= MATCH",
 /* 437 */ "compare_op ::= NMATCH",
 /* 438 */ "compare_op ::= CONTAINS",
 /* 439 */ "in_op ::= IN",
 /* 440 */ "in_op ::= NOT IN",
 /* 441 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 442 */ "boolean_value_expression ::= boolean_primary",
 /* 443 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 444 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 445 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 446 */ "boolean_primary ::= predicate",
 /* 447 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 448 */ "common_expression ::= expr_or_subquery",
 /* 449 */ "common_expression ::= boolean_value_expression",
 /* 450 */ "from_clause_opt ::=",
 /* 451 */ "from_clause_opt ::= FROM table_reference_list",
 /* 452 */ "table_reference_list ::= table_reference",
 /* 453 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 454 */ "table_reference ::= table_primary",
 /* 455 */ "table_reference ::= joined_table",
 /* 456 */ "table_primary ::= table_name alias_opt",
 /* 457 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 458 */ "table_primary ::= subquery alias_opt",
 /* 459 */ "table_primary ::= parenthesized_joined_table",
 /* 460 */ "alias_opt ::=",
 /* 461 */ "alias_opt ::= table_alias",
 /* 462 */ "alias_opt ::= AS table_alias",
 /* 463 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 464 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 465 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 466 */ "join_type ::=",
 /* 467 */ "join_type ::= INNER",
 /* 468 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 469 */ "set_quantifier_opt ::=",
 /* 470 */ "set_quantifier_opt ::= DISTINCT",
 /* 471 */ "set_quantifier_opt ::= ALL",
 /* 472 */ "select_list ::= select_item",
 /* 473 */ "select_list ::= select_list NK_COMMA select_item",
 /* 474 */ "select_item ::= NK_STAR",
 /* 475 */ "select_item ::= common_expression",
 /* 476 */ "select_item ::= common_expression column_alias",
 /* 477 */ "select_item ::= common_expression AS column_alias",
 /* 478 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 479 */ "where_clause_opt ::=",
 /* 480 */ "where_clause_opt ::= WHERE search_condition",
 /* 481 */ "partition_by_clause_opt ::=",
 /* 482 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 483 */ "partition_list ::= partition_item",
 /* 484 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 485 */ "partition_item ::= expr_or_subquery",
 /* 486 */ "partition_item ::= expr_or_subquery column_alias",
 /* 487 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 488 */ "twindow_clause_opt ::=",
 /* 489 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 490 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 491 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 492 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 493 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 494 */ "sliding_opt ::=",
 /* 495 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 496 */ "fill_opt ::=",
 /* 497 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 498 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 499 */ "fill_mode ::= NONE",
 /* 500 */ "fill_mode ::= PREV",
 /* 501 */ "fill_mode ::= NULL",
 /* 502 */ "fill_mode ::= LINEAR",
 /* 503 */ "fill_mode ::= NEXT",
 /* 504 */ "group_by_clause_opt ::=",
 /* 505 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 506 */ "group_by_list ::= expr_or_subquery",
 /* 507 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 508 */ "having_clause_opt ::=",
 /* 509 */ "having_clause_opt ::= HAVING search_condition",
 /* 510 */ "range_opt ::=",
 /* 511 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 512 */ "every_opt ::=",
 /* 513 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 514 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 515 */ "query_simple ::= query_specification",
 /* 516 */ "query_simple ::= union_query_expression",
 /* 517 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 518 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 519 */ "query_simple_or_subquery ::= query_simple",
 /* 520 */ "query_simple_or_subquery ::= subquery",
 /* 521 */ "query_or_subquery ::= query_expression",
 /* 522 */ "query_or_subquery ::= subquery",
 /* 523 */ "order_by_clause_opt ::=",
 /* 524 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 525 */ "slimit_clause_opt ::=",
 /* 526 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 527 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 528 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 529 */ "limit_clause_opt ::=",
 /* 530 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 531 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 532 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 533 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 534 */ "subquery ::= NK_LP subquery NK_RP",
 /* 535 */ "search_condition ::= common_expression",
 /* 536 */ "sort_specification_list ::= sort_specification",
 /* 537 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 538 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 539 */ "ordering_specification_opt ::=",
 /* 540 */ "ordering_specification_opt ::= ASC",
 /* 541 */ "ordering_specification_opt ::= DESC",
 /* 542 */ "null_ordering_opt ::=",
 /* 543 */ "null_ordering_opt ::= NULLS FIRST",
 /* 544 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 325: /* cmd */
    case 328: /* literal */
    case 341: /* db_options */
    case 343: /* alter_db_options */
    case 349: /* retention */
    case 350: /* full_table_name */
    case 353: /* table_options */
    case 357: /* alter_table_clause */
    case 358: /* alter_table_options */
    case 361: /* signed_literal */
    case 362: /* create_subtable_clause */
    case 365: /* drop_table_clause */
    case 368: /* column_def */
    case 372: /* duration_literal */
    case 373: /* rollup_func_name */
    case 375: /* col_name */
    case 376: /* db_name_cond_opt */
    case 377: /* like_pattern_opt */
    case 378: /* table_name_cond */
    case 379: /* from_db_opt */
    case 381: /* tag_item */
    case 383: /* index_options */
    case 385: /* sliding_opt */
    case 386: /* sma_stream_opt */
    case 387: /* func */
    case 389: /* query_or_subquery */
    case 392: /* explain_options */
    case 396: /* stream_options */
    case 397: /* subtable_opt */
    case 398: /* expression */
    case 400: /* where_clause_opt */
    case 401: /* signed */
    case 402: /* literal_func */
    case 405: /* expr_or_subquery */
    case 406: /* pseudo_column */
    case 407: /* column_reference */
    case 408: /* function_expression */
    case 409: /* case_when_expression */
    case 414: /* star_func_para */
    case 416: /* case_when_else_opt */
    case 417: /* common_expression */
    case 418: /* when_then_expr */
    case 419: /* predicate */
    case 422: /* in_predicate_value */
    case 423: /* boolean_value_expression */
    case 424: /* boolean_primary */
    case 425: /* from_clause_opt */
    case 426: /* table_reference_list */
    case 427: /* table_reference */
    case 428: /* table_primary */
    case 429: /* joined_table */
    case 431: /* subquery */
    case 432: /* parenthesized_joined_table */
    case 434: /* search_condition */
    case 435: /* query_specification */
    case 439: /* range_opt */
    case 440: /* every_opt */
    case 441: /* fill_opt */
    case 442: /* twindow_clause_opt */
    case 444: /* having_clause_opt */
    case 445: /* select_item */
    case 447: /* partition_item */
    case 450: /* query_expression */
    case 451: /* query_simple */
    case 453: /* slimit_clause_opt */
    case 454: /* limit_clause_opt */
    case 455: /* union_query_expression */
    case 456: /* query_simple_or_subquery */
    case 458: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy600)); 
}
      break;
    case 326: /* account_options */
    case 327: /* alter_account_options */
    case 329: /* alter_account_option */
    case 344: /* speed_opt */
    case 394: /* bufsize_opt */
{
 
}
      break;
    case 330: /* user_name */
    case 333: /* priv_level */
    case 336: /* db_name */
    case 337: /* topic_name */
    case 338: /* dnode_endpoint */
    case 359: /* column_name */
    case 367: /* table_name */
    case 374: /* function_name */
    case 382: /* column_alias */
    case 388: /* sma_func_name */
    case 390: /* cgroup_name */
    case 395: /* stream_name */
    case 404: /* table_alias */
    case 410: /* star_func */
    case 412: /* noarg_func */
    case 430: /* alias_opt */
{
 
}
      break;
    case 331: /* sysinfo_opt */
{
 
}
      break;
    case 332: /* privileges */
    case 334: /* priv_type_list */
    case 335: /* priv_type */
{
 
}
      break;
    case 339: /* force_opt */
    case 340: /* not_exists_opt */
    case 342: /* exists_opt */
    case 391: /* analyze_opt */
    case 393: /* agg_func_opt */
    case 436: /* set_quantifier_opt */
{
 
}
      break;
    case 345: /* integer_list */
    case 346: /* variable_list */
    case 347: /* retention_list */
    case 351: /* column_def_list */
    case 352: /* tags_def_opt */
    case 354: /* multi_create_clause */
    case 355: /* tags_def */
    case 356: /* multi_drop_clause */
    case 363: /* specific_cols_opt */
    case 364: /* expression_list */
    case 366: /* col_name_list */
    case 369: /* duration_list */
    case 370: /* rollup_func_list */
    case 380: /* tag_list_opt */
    case 384: /* func_list */
    case 399: /* dnode_list */
    case 403: /* literal_list */
    case 411: /* star_func_para_list */
    case 413: /* other_para_list */
    case 415: /* when_then_list */
    case 437: /* select_list */
    case 438: /* partition_by_clause_opt */
    case 443: /* group_by_clause_opt */
    case 446: /* partition_list */
    case 449: /* group_by_list */
    case 452: /* order_by_clause_opt */
    case 457: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy601)); 
}
      break;
    case 348: /* alter_db_option */
    case 371: /* alter_table_option */
{
 
}
      break;
    case 360: /* type_name */
{
 
}
      break;
    case 420: /* compare_op */
    case 421: /* in_op */
{
 
}
      break;
    case 433: /* join_type */
{
 
}
      break;
    case 448: /* fill_mode */
{
 
}
      break;
    case 459: /* ordering_specification_opt */
{
 
}
      break;
    case 460: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   325,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   325,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   326,  /* (2) account_options ::= */
   326,  /* (3) account_options ::= account_options PPS literal */
   326,  /* (4) account_options ::= account_options TSERIES literal */
   326,  /* (5) account_options ::= account_options STORAGE literal */
   326,  /* (6) account_options ::= account_options STREAMS literal */
   326,  /* (7) account_options ::= account_options QTIME literal */
   326,  /* (8) account_options ::= account_options DBS literal */
   326,  /* (9) account_options ::= account_options USERS literal */
   326,  /* (10) account_options ::= account_options CONNS literal */
   326,  /* (11) account_options ::= account_options STATE literal */
   327,  /* (12) alter_account_options ::= alter_account_option */
   327,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   329,  /* (14) alter_account_option ::= PASS literal */
   329,  /* (15) alter_account_option ::= PPS literal */
   329,  /* (16) alter_account_option ::= TSERIES literal */
   329,  /* (17) alter_account_option ::= STORAGE literal */
   329,  /* (18) alter_account_option ::= STREAMS literal */
   329,  /* (19) alter_account_option ::= QTIME literal */
   329,  /* (20) alter_account_option ::= DBS literal */
   329,  /* (21) alter_account_option ::= USERS literal */
   329,  /* (22) alter_account_option ::= CONNS literal */
   329,  /* (23) alter_account_option ::= STATE literal */
   325,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   325,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   325,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   325,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   325,  /* (28) cmd ::= DROP USER user_name */
   331,  /* (29) sysinfo_opt ::= */
   331,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   325,  /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
   325,  /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
   332,  /* (33) privileges ::= ALL */
   332,  /* (34) privileges ::= priv_type_list */
   332,  /* (35) privileges ::= SUBSCRIBE */
   334,  /* (36) priv_type_list ::= priv_type */
   334,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   335,  /* (38) priv_type ::= READ */
   335,  /* (39) priv_type ::= WRITE */
   333,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   333,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   333,  /* (42) priv_level ::= topic_name */
   325,  /* (43) cmd ::= CREATE DNODE dnode_endpoint */
   325,  /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   325,  /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
   325,  /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
   325,  /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   325,  /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   325,  /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
   325,  /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   338,  /* (51) dnode_endpoint ::= NK_STRING */
   338,  /* (52) dnode_endpoint ::= NK_ID */
   338,  /* (53) dnode_endpoint ::= NK_IPTOKEN */
   339,  /* (54) force_opt ::= */
   339,  /* (55) force_opt ::= FORCE */
   325,  /* (56) cmd ::= ALTER LOCAL NK_STRING */
   325,  /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   325,  /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   325,  /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   325,  /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   325,  /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   325,  /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   325,  /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   325,  /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   325,  /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   325,  /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   325,  /* (67) cmd ::= DROP DATABASE exists_opt db_name */
   325,  /* (68) cmd ::= USE db_name */
   325,  /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
   325,  /* (70) cmd ::= FLUSH DATABASE db_name */
   325,  /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
   340,  /* (72) not_exists_opt ::= IF NOT EXISTS */
   340,  /* (73) not_exists_opt ::= */
   342,  /* (74) exists_opt ::= IF EXISTS */
   342,  /* (75) exists_opt ::= */
   341,  /* (76) db_options ::= */
   341,  /* (77) db_options ::= db_options BUFFER NK_INTEGER */
   341,  /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
   341,  /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
   341,  /* (80) db_options ::= db_options COMP NK_INTEGER */
   341,  /* (81) db_options ::= db_options DURATION NK_INTEGER */
   341,  /* (82) db_options ::= db_options DURATION NK_VARIABLE */
   341,  /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
   341,  /* (84) db_options ::= db_options MINROWS NK_INTEGER */
   341,  /* (85) db_options ::= db_options KEEP integer_list */
   341,  /* (86) db_options ::= db_options KEEP variable_list */
   341,  /* (87) db_options ::= db_options PAGES NK_INTEGER */
   341,  /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
   341,  /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   341,  /* (90) db_options ::= db_options PRECISION NK_STRING */
   341,  /* (91) db_options ::= db_options REPLICA NK_INTEGER */
   341,  /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
   341,  /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   341,  /* (94) db_options ::= db_options RETENTIONS retention_list */
   341,  /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
   341,  /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   341,  /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   341,  /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   341,  /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   341,  /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   341,  /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   341,  /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   341,  /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   341,  /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   341,  /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   341,  /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   343,  /* (107) alter_db_options ::= alter_db_option */
   343,  /* (108) alter_db_options ::= alter_db_options alter_db_option */
   348,  /* (109) alter_db_option ::= BUFFER NK_INTEGER */
   348,  /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
   348,  /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
   348,  /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   348,  /* (113) alter_db_option ::= KEEP integer_list */
   348,  /* (114) alter_db_option ::= KEEP variable_list */
   348,  /* (115) alter_db_option ::= PAGES NK_INTEGER */
   348,  /* (116) alter_db_option ::= REPLICA NK_INTEGER */
   348,  /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   348,  /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   345,  /* (119) integer_list ::= NK_INTEGER */
   345,  /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   346,  /* (121) variable_list ::= NK_VARIABLE */
   346,  /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   347,  /* (123) retention_list ::= retention */
   347,  /* (124) retention_list ::= retention_list NK_COMMA retention */
   349,  /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   344,  /* (126) speed_opt ::= */
   344,  /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
   325,  /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   325,  /* (129) cmd ::= CREATE TABLE multi_create_clause */
   325,  /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   325,  /* (131) cmd ::= DROP TABLE multi_drop_clause */
   325,  /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
   325,  /* (133) cmd ::= ALTER TABLE alter_table_clause */
   325,  /* (134) cmd ::= ALTER STABLE alter_table_clause */
   357,  /* (135) alter_table_clause ::= full_table_name alter_table_options */
   357,  /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   357,  /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   357,  /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   357,  /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   357,  /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   357,  /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
   357,  /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   357,  /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   357,  /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   354,  /* (145) multi_create_clause ::= create_subtable_clause */
   354,  /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
   362,  /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   356,  /* (148) multi_drop_clause ::= drop_table_clause */
   356,  /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   365,  /* (150) drop_table_clause ::= exists_opt full_table_name */
   363,  /* (151) specific_cols_opt ::= */
   363,  /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   350,  /* (153) full_table_name ::= table_name */
   350,  /* (154) full_table_name ::= db_name NK_DOT table_name */
   351,  /* (155) column_def_list ::= column_def */
   351,  /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
   368,  /* (157) column_def ::= column_name type_name */
   368,  /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
   360,  /* (159) type_name ::= BOOL */
   360,  /* (160) type_name ::= TINYINT */
   360,  /* (161) type_name ::= SMALLINT */
   360,  /* (162) type_name ::= INT */
   360,  /* (163) type_name ::= INTEGER */
   360,  /* (164) type_name ::= BIGINT */
   360,  /* (165) type_name ::= FLOAT */
   360,  /* (166) type_name ::= DOUBLE */
   360,  /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   360,  /* (168) type_name ::= TIMESTAMP */
   360,  /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   360,  /* (170) type_name ::= TINYINT UNSIGNED */
   360,  /* (171) type_name ::= SMALLINT UNSIGNED */
   360,  /* (172) type_name ::= INT UNSIGNED */
   360,  /* (173) type_name ::= BIGINT UNSIGNED */
   360,  /* (174) type_name ::= JSON */
   360,  /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   360,  /* (176) type_name ::= MEDIUMBLOB */
   360,  /* (177) type_name ::= BLOB */
   360,  /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   360,  /* (179) type_name ::= DECIMAL */
   360,  /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   360,  /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   352,  /* (182) tags_def_opt ::= */
   352,  /* (183) tags_def_opt ::= tags_def */
   355,  /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   353,  /* (185) table_options ::= */
   353,  /* (186) table_options ::= table_options COMMENT NK_STRING */
   353,  /* (187) table_options ::= table_options MAX_DELAY duration_list */
   353,  /* (188) table_options ::= table_options WATERMARK duration_list */
   353,  /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   353,  /* (190) table_options ::= table_options TTL NK_INTEGER */
   353,  /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   353,  /* (192) table_options ::= table_options DELETE_MARK duration_list */
   358,  /* (193) alter_table_options ::= alter_table_option */
   358,  /* (194) alter_table_options ::= alter_table_options alter_table_option */
   371,  /* (195) alter_table_option ::= COMMENT NK_STRING */
   371,  /* (196) alter_table_option ::= TTL NK_INTEGER */
   369,  /* (197) duration_list ::= duration_literal */
   369,  /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
   370,  /* (199) rollup_func_list ::= rollup_func_name */
   370,  /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   373,  /* (201) rollup_func_name ::= function_name */
   373,  /* (202) rollup_func_name ::= FIRST */
   373,  /* (203) rollup_func_name ::= LAST */
   366,  /* (204) col_name_list ::= col_name */
   366,  /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
   375,  /* (206) col_name ::= column_name */
   325,  /* (207) cmd ::= SHOW DNODES */
   325,  /* (208) cmd ::= SHOW USERS */
   325,  /* (209) cmd ::= SHOW USER PRIVILEGES */
   325,  /* (210) cmd ::= SHOW DATABASES */
   325,  /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   325,  /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   325,  /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
   325,  /* (214) cmd ::= SHOW MNODES */
   325,  /* (215) cmd ::= SHOW QNODES */
   325,  /* (216) cmd ::= SHOW FUNCTIONS */
   325,  /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   325,  /* (218) cmd ::= SHOW STREAMS */
   325,  /* (219) cmd ::= SHOW ACCOUNTS */
   325,  /* (220) cmd ::= SHOW APPS */
   325,  /* (221) cmd ::= SHOW CONNECTIONS */
   325,  /* (222) cmd ::= SHOW LICENCES */
   325,  /* (223) cmd ::= SHOW GRANTS */
   325,  /* (224) cmd ::= SHOW CREATE DATABASE db_name */
   325,  /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
   325,  /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
   325,  /* (227) cmd ::= SHOW QUERIES */
   325,  /* (228) cmd ::= SHOW SCORES */
   325,  /* (229) cmd ::= SHOW TOPICS */
   325,  /* (230) cmd ::= SHOW VARIABLES */
   325,  /* (231) cmd ::= SHOW CLUSTER VARIABLES */
   325,  /* (232) cmd ::= SHOW LOCAL VARIABLES */
   325,  /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   325,  /* (234) cmd ::= SHOW BNODES */
   325,  /* (235) cmd ::= SHOW SNODES */
   325,  /* (236) cmd ::= SHOW CLUSTER */
   325,  /* (237) cmd ::= SHOW TRANSACTIONS */
   325,  /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   325,  /* (239) cmd ::= SHOW CONSUMERS */
   325,  /* (240) cmd ::= SHOW SUBSCRIPTIONS */
   325,  /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   325,  /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   325,  /* (243) cmd ::= SHOW VNODES NK_INTEGER */
   325,  /* (244) cmd ::= SHOW VNODES NK_STRING */
   376,  /* (245) db_name_cond_opt ::= */
   376,  /* (246) db_name_cond_opt ::= db_name NK_DOT */
   377,  /* (247) like_pattern_opt ::= */
   377,  /* (248) like_pattern_opt ::= LIKE NK_STRING */
   378,  /* (249) table_name_cond ::= table_name */
   379,  /* (250) from_db_opt ::= */
   379,  /* (251) from_db_opt ::= FROM db_name */
   380,  /* (252) tag_list_opt ::= */
   380,  /* (253) tag_list_opt ::= tag_item */
   380,  /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   381,  /* (255) tag_item ::= TBNAME */
   381,  /* (256) tag_item ::= QTAGS */
   381,  /* (257) tag_item ::= column_name */
   381,  /* (258) tag_item ::= column_name column_alias */
   381,  /* (259) tag_item ::= column_name AS column_alias */
   325,  /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
   325,  /* (261) cmd ::= DROP INDEX exists_opt full_table_name */
   383,  /* (262) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   383,  /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   384,  /* (264) func_list ::= func */
   384,  /* (265) func_list ::= func_list NK_COMMA func */
   387,  /* (266) func ::= sma_func_name NK_LP expression_list NK_RP */
   388,  /* (267) sma_func_name ::= function_name */
   388,  /* (268) sma_func_name ::= COUNT */
   388,  /* (269) sma_func_name ::= FIRST */
   388,  /* (270) sma_func_name ::= LAST */
   388,  /* (271) sma_func_name ::= LAST_ROW */
   386,  /* (272) sma_stream_opt ::= */
   386,  /* (273) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   386,  /* (274) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   386,  /* (275) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   325,  /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   325,  /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   325,  /* (278) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   325,  /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   325,  /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   325,  /* (281) cmd ::= DROP TOPIC exists_opt topic_name */
   325,  /* (282) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   325,  /* (283) cmd ::= DESC full_table_name */
   325,  /* (284) cmd ::= DESCRIBE full_table_name */
   325,  /* (285) cmd ::= RESET QUERY CACHE */
   325,  /* (286) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   391,  /* (287) analyze_opt ::= */
   391,  /* (288) analyze_opt ::= ANALYZE */
   392,  /* (289) explain_options ::= */
   392,  /* (290) explain_options ::= explain_options VERBOSE NK_BOOL */
   392,  /* (291) explain_options ::= explain_options RATIO NK_FLOAT */
   325,  /* (292) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   325,  /* (293) cmd ::= DROP FUNCTION exists_opt function_name */
   393,  /* (294) agg_func_opt ::= */
   393,  /* (295) agg_func_opt ::= AGGREGATE */
   394,  /* (296) bufsize_opt ::= */
   394,  /* (297) bufsize_opt ::= BUFSIZE NK_INTEGER */
   325,  /* (298) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
   325,  /* (299) cmd ::= DROP STREAM exists_opt stream_name */
   396,  /* (300) stream_options ::= */
   396,  /* (301) stream_options ::= stream_options TRIGGER AT_ONCE */
   396,  /* (302) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   396,  /* (303) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   396,  /* (304) stream_options ::= stream_options WATERMARK duration_literal */
   396,  /* (305) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   396,  /* (306) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   397,  /* (307) subtable_opt ::= */
   397,  /* (308) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   325,  /* (309) cmd ::= KILL CONNECTION NK_INTEGER */
   325,  /* (310) cmd ::= KILL QUERY NK_STRING */
   325,  /* (311) cmd ::= KILL TRANSACTION NK_INTEGER */
   325,  /* (312) cmd ::= BALANCE VGROUP */
   325,  /* (313) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   325,  /* (314) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   325,  /* (315) cmd ::= SPLIT VGROUP NK_INTEGER */
   399,  /* (316) dnode_list ::= DNODE NK_INTEGER */
   399,  /* (317) dnode_list ::= dnode_list DNODE NK_INTEGER */
   325,  /* (318) cmd ::= DELETE FROM full_table_name where_clause_opt */
   325,  /* (319) cmd ::= query_or_subquery */
   325,  /* (320) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   325,  /* (321) cmd ::= INSERT INTO full_table_name query_or_subquery */
   328,  /* (322) literal ::= NK_INTEGER */
   328,  /* (323) literal ::= NK_FLOAT */
   328,  /* (324) literal ::= NK_STRING */
   328,  /* (325) literal ::= NK_BOOL */
   328,  /* (326) literal ::= TIMESTAMP NK_STRING */
   328,  /* (327) literal ::= duration_literal */
   328,  /* (328) literal ::= NULL */
   328,  /* (329) literal ::= NK_QUESTION */
   372,  /* (330) duration_literal ::= NK_VARIABLE */
   401,  /* (331) signed ::= NK_INTEGER */
   401,  /* (332) signed ::= NK_PLUS NK_INTEGER */
   401,  /* (333) signed ::= NK_MINUS NK_INTEGER */
   401,  /* (334) signed ::= NK_FLOAT */
   401,  /* (335) signed ::= NK_PLUS NK_FLOAT */
   401,  /* (336) signed ::= NK_MINUS NK_FLOAT */
   361,  /* (337) signed_literal ::= signed */
   361,  /* (338) signed_literal ::= NK_STRING */
   361,  /* (339) signed_literal ::= NK_BOOL */
   361,  /* (340) signed_literal ::= TIMESTAMP NK_STRING */
   361,  /* (341) signed_literal ::= duration_literal */
   361,  /* (342) signed_literal ::= NULL */
   361,  /* (343) signed_literal ::= literal_func */
   361,  /* (344) signed_literal ::= NK_QUESTION */
   403,  /* (345) literal_list ::= signed_literal */
   403,  /* (346) literal_list ::= literal_list NK_COMMA signed_literal */
   336,  /* (347) db_name ::= NK_ID */
   367,  /* (348) table_name ::= NK_ID */
   359,  /* (349) column_name ::= NK_ID */
   374,  /* (350) function_name ::= NK_ID */
   404,  /* (351) table_alias ::= NK_ID */
   382,  /* (352) column_alias ::= NK_ID */
   330,  /* (353) user_name ::= NK_ID */
   337,  /* (354) topic_name ::= NK_ID */
   395,  /* (355) stream_name ::= NK_ID */
   390,  /* (356) cgroup_name ::= NK_ID */
   405,  /* (357) expr_or_subquery ::= expression */
   398,  /* (358) expression ::= literal */
   398,  /* (359) expression ::= pseudo_column */
   398,  /* (360) expression ::= column_reference */
   398,  /* (361) expression ::= function_expression */
   398,  /* (362) expression ::= case_when_expression */
   398,  /* (363) expression ::= NK_LP expression NK_RP */
   398,  /* (364) expression ::= NK_PLUS expr_or_subquery */
   398,  /* (365) expression ::= NK_MINUS expr_or_subquery */
   398,  /* (366) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   398,  /* (367) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   398,  /* (368) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   398,  /* (369) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   398,  /* (370) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   398,  /* (371) expression ::= column_reference NK_ARROW NK_STRING */
   398,  /* (372) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   398,  /* (373) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   364,  /* (374) expression_list ::= expr_or_subquery */
   364,  /* (375) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   407,  /* (376) column_reference ::= column_name */
   407,  /* (377) column_reference ::= table_name NK_DOT column_name */
   406,  /* (378) pseudo_column ::= ROWTS */
   406,  /* (379) pseudo_column ::= TBNAME */
   406,  /* (380) pseudo_column ::= table_name NK_DOT TBNAME */
   406,  /* (381) pseudo_column ::= QSTART */
   406,  /* (382) pseudo_column ::= QEND */
   406,  /* (383) pseudo_column ::= QDURATION */
   406,  /* (384) pseudo_column ::= WSTART */
   406,  /* (385) pseudo_column ::= WEND */
   406,  /* (386) pseudo_column ::= WDURATION */
   406,  /* (387) pseudo_column ::= IROWTS */
   406,  /* (388) pseudo_column ::= ISFILLED */
   406,  /* (389) pseudo_column ::= QTAGS */
   408,  /* (390) function_expression ::= function_name NK_LP expression_list NK_RP */
   408,  /* (391) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   408,  /* (392) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   408,  /* (393) function_expression ::= literal_func */
   402,  /* (394) literal_func ::= noarg_func NK_LP NK_RP */
   402,  /* (395) literal_func ::= NOW */
   412,  /* (396) noarg_func ::= NOW */
   412,  /* (397) noarg_func ::= TODAY */
   412,  /* (398) noarg_func ::= TIMEZONE */
   412,  /* (399) noarg_func ::= DATABASE */
   412,  /* (400) noarg_func ::= CLIENT_VERSION */
   412,  /* (401) noarg_func ::= SERVER_VERSION */
   412,  /* (402) noarg_func ::= SERVER_STATUS */
   412,  /* (403) noarg_func ::= CURRENT_USER */
   412,  /* (404) noarg_func ::= USER */
   410,  /* (405) star_func ::= COUNT */
   410,  /* (406) star_func ::= FIRST */
   410,  /* (407) star_func ::= LAST */
   410,  /* (408) star_func ::= LAST_ROW */
   411,  /* (409) star_func_para_list ::= NK_STAR */
   411,  /* (410) star_func_para_list ::= other_para_list */
   413,  /* (411) other_para_list ::= star_func_para */
   413,  /* (412) other_para_list ::= other_para_list NK_COMMA star_func_para */
   414,  /* (413) star_func_para ::= expr_or_subquery */
   414,  /* (414) star_func_para ::= table_name NK_DOT NK_STAR */
   409,  /* (415) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   409,  /* (416) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   415,  /* (417) when_then_list ::= when_then_expr */
   415,  /* (418) when_then_list ::= when_then_list when_then_expr */
   418,  /* (419) when_then_expr ::= WHEN common_expression THEN common_expression */
   416,  /* (420) case_when_else_opt ::= */
   416,  /* (421) case_when_else_opt ::= ELSE common_expression */
   419,  /* (422) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   419,  /* (423) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   419,  /* (424) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   419,  /* (425) predicate ::= expr_or_subquery IS NULL */
   419,  /* (426) predicate ::= expr_or_subquery IS NOT NULL */
   419,  /* (427) predicate ::= expr_or_subquery in_op in_predicate_value */
   420,  /* (428) compare_op ::= NK_LT */
   420,  /* (429) compare_op ::= NK_GT */
   420,  /* (430) compare_op ::= NK_LE */
   420,  /* (431) compare_op ::= NK_GE */
   420,  /* (432) compare_op ::= NK_NE */
   420,  /* (433) compare_op ::= NK_EQ */
   420,  /* (434) compare_op ::= LIKE */
   420,  /* (435) compare_op ::= NOT LIKE */
   420,  /* (436) compare_op ::= MATCH */
   420,  /* (437) compare_op ::= NMATCH */
   420,  /* (438) compare_op ::= CONTAINS */
   421,  /* (439) in_op ::= IN */
   421,  /* (440) in_op ::= NOT IN */
   422,  /* (441) in_predicate_value ::= NK_LP literal_list NK_RP */
   423,  /* (442) boolean_value_expression ::= boolean_primary */
   423,  /* (443) boolean_value_expression ::= NOT boolean_primary */
   423,  /* (444) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   423,  /* (445) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   424,  /* (446) boolean_primary ::= predicate */
   424,  /* (447) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   417,  /* (448) common_expression ::= expr_or_subquery */
   417,  /* (449) common_expression ::= boolean_value_expression */
   425,  /* (450) from_clause_opt ::= */
   425,  /* (451) from_clause_opt ::= FROM table_reference_list */
   426,  /* (452) table_reference_list ::= table_reference */
   426,  /* (453) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   427,  /* (454) table_reference ::= table_primary */
   427,  /* (455) table_reference ::= joined_table */
   428,  /* (456) table_primary ::= table_name alias_opt */
   428,  /* (457) table_primary ::= db_name NK_DOT table_name alias_opt */
   428,  /* (458) table_primary ::= subquery alias_opt */
   428,  /* (459) table_primary ::= parenthesized_joined_table */
   430,  /* (460) alias_opt ::= */
   430,  /* (461) alias_opt ::= table_alias */
   430,  /* (462) alias_opt ::= AS table_alias */
   432,  /* (463) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   432,  /* (464) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   429,  /* (465) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   433,  /* (466) join_type ::= */
   433,  /* (467) join_type ::= INNER */
   435,  /* (468) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   436,  /* (469) set_quantifier_opt ::= */
   436,  /* (470) set_quantifier_opt ::= DISTINCT */
   436,  /* (471) set_quantifier_opt ::= ALL */
   437,  /* (472) select_list ::= select_item */
   437,  /* (473) select_list ::= select_list NK_COMMA select_item */
   445,  /* (474) select_item ::= NK_STAR */
   445,  /* (475) select_item ::= common_expression */
   445,  /* (476) select_item ::= common_expression column_alias */
   445,  /* (477) select_item ::= common_expression AS column_alias */
   445,  /* (478) select_item ::= table_name NK_DOT NK_STAR */
   400,  /* (479) where_clause_opt ::= */
   400,  /* (480) where_clause_opt ::= WHERE search_condition */
   438,  /* (481) partition_by_clause_opt ::= */
   438,  /* (482) partition_by_clause_opt ::= PARTITION BY partition_list */
   446,  /* (483) partition_list ::= partition_item */
   446,  /* (484) partition_list ::= partition_list NK_COMMA partition_item */
   447,  /* (485) partition_item ::= expr_or_subquery */
   447,  /* (486) partition_item ::= expr_or_subquery column_alias */
   447,  /* (487) partition_item ::= expr_or_subquery AS column_alias */
   442,  /* (488) twindow_clause_opt ::= */
   442,  /* (489) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   442,  /* (490) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   442,  /* (491) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   442,  /* (492) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   442,  /* (493) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   385,  /* (494) sliding_opt ::= */
   385,  /* (495) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   441,  /* (496) fill_opt ::= */
   441,  /* (497) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   441,  /* (498) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   448,  /* (499) fill_mode ::= NONE */
   448,  /* (500) fill_mode ::= PREV */
   448,  /* (501) fill_mode ::= NULL */
   448,  /* (502) fill_mode ::= LINEAR */
   448,  /* (503) fill_mode ::= NEXT */
   443,  /* (504) group_by_clause_opt ::= */
   443,  /* (505) group_by_clause_opt ::= GROUP BY group_by_list */
   449,  /* (506) group_by_list ::= expr_or_subquery */
   449,  /* (507) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   444,  /* (508) having_clause_opt ::= */
   444,  /* (509) having_clause_opt ::= HAVING search_condition */
   439,  /* (510) range_opt ::= */
   439,  /* (511) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   440,  /* (512) every_opt ::= */
   440,  /* (513) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   450,  /* (514) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   451,  /* (515) query_simple ::= query_specification */
   451,  /* (516) query_simple ::= union_query_expression */
   455,  /* (517) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   455,  /* (518) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   456,  /* (519) query_simple_or_subquery ::= query_simple */
   456,  /* (520) query_simple_or_subquery ::= subquery */
   389,  /* (521) query_or_subquery ::= query_expression */
   389,  /* (522) query_or_subquery ::= subquery */
   452,  /* (523) order_by_clause_opt ::= */
   452,  /* (524) order_by_clause_opt ::= ORDER BY sort_specification_list */
   453,  /* (525) slimit_clause_opt ::= */
   453,  /* (526) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   453,  /* (527) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   453,  /* (528) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   454,  /* (529) limit_clause_opt ::= */
   454,  /* (530) limit_clause_opt ::= LIMIT NK_INTEGER */
   454,  /* (531) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   454,  /* (532) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   431,  /* (533) subquery ::= NK_LP query_expression NK_RP */
   431,  /* (534) subquery ::= NK_LP subquery NK_RP */
   434,  /* (535) search_condition ::= common_expression */
   457,  /* (536) sort_specification_list ::= sort_specification */
   457,  /* (537) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   458,  /* (538) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   459,  /* (539) ordering_specification_opt ::= */
   459,  /* (540) ordering_specification_opt ::= ASC */
   459,  /* (541) ordering_specification_opt ::= DESC */
   460,  /* (542) null_ordering_opt ::= */
   460,  /* (543) null_ordering_opt ::= NULLS FIRST */
   460,  /* (544) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -6,  /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
   -6,  /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -1,  /* (42) priv_level ::= topic_name */
   -3,  /* (43) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -1,  /* (51) dnode_endpoint ::= NK_STRING */
   -1,  /* (52) dnode_endpoint ::= NK_ID */
   -1,  /* (53) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (54) force_opt ::= */
   -1,  /* (55) force_opt ::= FORCE */
   -3,  /* (56) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (67) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (68) cmd ::= USE db_name */
   -4,  /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (70) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
   -3,  /* (72) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (73) not_exists_opt ::= */
   -2,  /* (74) exists_opt ::= IF EXISTS */
    0,  /* (75) exists_opt ::= */
    0,  /* (76) db_options ::= */
   -3,  /* (77) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (80) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (81) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (82) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (84) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (85) db_options ::= db_options KEEP integer_list */
   -3,  /* (86) db_options ::= db_options KEEP variable_list */
   -3,  /* (87) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (90) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (91) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (94) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   -3,  /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   -1,  /* (107) alter_db_options ::= alter_db_option */
   -2,  /* (108) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (109) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (113) alter_db_option ::= KEEP integer_list */
   -2,  /* (114) alter_db_option ::= KEEP variable_list */
   -2,  /* (115) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (116) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -1,  /* (119) integer_list ::= NK_INTEGER */
   -3,  /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (121) variable_list ::= NK_VARIABLE */
   -3,  /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (123) retention_list ::= retention */
   -3,  /* (124) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (126) speed_opt ::= */
   -2,  /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
   -9,  /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (129) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (131) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (133) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (134) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (135) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (145) multi_create_clause ::= create_subtable_clause */
   -2,  /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (148) multi_drop_clause ::= drop_table_clause */
   -2,  /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   -2,  /* (150) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (151) specific_cols_opt ::= */
   -3,  /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (153) full_table_name ::= table_name */
   -3,  /* (154) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (155) column_def_list ::= column_def */
   -3,  /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (157) column_def ::= column_name type_name */
   -4,  /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
   -1,  /* (159) type_name ::= BOOL */
   -1,  /* (160) type_name ::= TINYINT */
   -1,  /* (161) type_name ::= SMALLINT */
   -1,  /* (162) type_name ::= INT */
   -1,  /* (163) type_name ::= INTEGER */
   -1,  /* (164) type_name ::= BIGINT */
   -1,  /* (165) type_name ::= FLOAT */
   -1,  /* (166) type_name ::= DOUBLE */
   -4,  /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (168) type_name ::= TIMESTAMP */
   -4,  /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (170) type_name ::= TINYINT UNSIGNED */
   -2,  /* (171) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (172) type_name ::= INT UNSIGNED */
   -2,  /* (173) type_name ::= BIGINT UNSIGNED */
   -1,  /* (174) type_name ::= JSON */
   -4,  /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (176) type_name ::= MEDIUMBLOB */
   -1,  /* (177) type_name ::= BLOB */
   -4,  /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (179) type_name ::= DECIMAL */
   -4,  /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (182) tags_def_opt ::= */
   -1,  /* (183) tags_def_opt ::= tags_def */
   -4,  /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (185) table_options ::= */
   -3,  /* (186) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (187) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (188) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (190) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (192) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (193) alter_table_options ::= alter_table_option */
   -2,  /* (194) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (195) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (196) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (197) duration_list ::= duration_literal */
   -3,  /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (199) rollup_func_list ::= rollup_func_name */
   -3,  /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (201) rollup_func_name ::= function_name */
   -1,  /* (202) rollup_func_name ::= FIRST */
   -1,  /* (203) rollup_func_name ::= LAST */
   -1,  /* (204) col_name_list ::= col_name */
   -3,  /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (206) col_name ::= column_name */
   -2,  /* (207) cmd ::= SHOW DNODES */
   -2,  /* (208) cmd ::= SHOW USERS */
   -3,  /* (209) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (210) cmd ::= SHOW DATABASES */
   -4,  /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (214) cmd ::= SHOW MNODES */
   -2,  /* (215) cmd ::= SHOW QNODES */
   -2,  /* (216) cmd ::= SHOW FUNCTIONS */
   -5,  /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (218) cmd ::= SHOW STREAMS */
   -2,  /* (219) cmd ::= SHOW ACCOUNTS */
   -2,  /* (220) cmd ::= SHOW APPS */
   -2,  /* (221) cmd ::= SHOW CONNECTIONS */
   -2,  /* (222) cmd ::= SHOW LICENCES */
   -2,  /* (223) cmd ::= SHOW GRANTS */
   -4,  /* (224) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (227) cmd ::= SHOW QUERIES */
   -2,  /* (228) cmd ::= SHOW SCORES */
   -2,  /* (229) cmd ::= SHOW TOPICS */
   -2,  /* (230) cmd ::= SHOW VARIABLES */
   -3,  /* (231) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (232) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (234) cmd ::= SHOW BNODES */
   -2,  /* (235) cmd ::= SHOW SNODES */
   -2,  /* (236) cmd ::= SHOW CLUSTER */
   -2,  /* (237) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (239) cmd ::= SHOW CONSUMERS */
   -2,  /* (240) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (243) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (244) cmd ::= SHOW VNODES NK_STRING */
    0,  /* (245) db_name_cond_opt ::= */
   -2,  /* (246) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (247) like_pattern_opt ::= */
   -2,  /* (248) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (249) table_name_cond ::= table_name */
    0,  /* (250) from_db_opt ::= */
   -2,  /* (251) from_db_opt ::= FROM db_name */
    0,  /* (252) tag_list_opt ::= */
   -1,  /* (253) tag_list_opt ::= tag_item */
   -3,  /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (255) tag_item ::= TBNAME */
   -1,  /* (256) tag_item ::= QTAGS */
   -1,  /* (257) tag_item ::= column_name */
   -2,  /* (258) tag_item ::= column_name column_alias */
   -3,  /* (259) tag_item ::= column_name AS column_alias */
   -8,  /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
   -4,  /* (261) cmd ::= DROP INDEX exists_opt full_table_name */
  -10,  /* (262) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (264) func_list ::= func */
   -3,  /* (265) func_list ::= func_list NK_COMMA func */
   -4,  /* (266) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (267) sma_func_name ::= function_name */
   -1,  /* (268) sma_func_name ::= COUNT */
   -1,  /* (269) sma_func_name ::= FIRST */
   -1,  /* (270) sma_func_name ::= LAST */
   -1,  /* (271) sma_func_name ::= LAST_ROW */
    0,  /* (272) sma_stream_opt ::= */
   -3,  /* (273) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (274) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (275) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (278) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (281) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (282) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (283) cmd ::= DESC full_table_name */
   -2,  /* (284) cmd ::= DESCRIBE full_table_name */
   -3,  /* (285) cmd ::= RESET QUERY CACHE */
   -4,  /* (286) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
    0,  /* (287) analyze_opt ::= */
   -1,  /* (288) analyze_opt ::= ANALYZE */
    0,  /* (289) explain_options ::= */
   -3,  /* (290) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (291) explain_options ::= explain_options RATIO NK_FLOAT */
  -10,  /* (292) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   -4,  /* (293) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (294) agg_func_opt ::= */
   -1,  /* (295) agg_func_opt ::= AGGREGATE */
    0,  /* (296) bufsize_opt ::= */
   -2,  /* (297) bufsize_opt ::= BUFSIZE NK_INTEGER */
  -11,  /* (298) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
   -4,  /* (299) cmd ::= DROP STREAM exists_opt stream_name */
    0,  /* (300) stream_options ::= */
   -3,  /* (301) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (302) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (303) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (304) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (305) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (306) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
    0,  /* (307) subtable_opt ::= */
   -4,  /* (308) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   -3,  /* (309) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (310) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (311) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (312) cmd ::= BALANCE VGROUP */
   -4,  /* (313) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (314) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (315) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (316) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (317) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (318) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (319) cmd ::= query_or_subquery */
   -7,  /* (320) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (321) cmd ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (322) literal ::= NK_INTEGER */
   -1,  /* (323) literal ::= NK_FLOAT */
   -1,  /* (324) literal ::= NK_STRING */
   -1,  /* (325) literal ::= NK_BOOL */
   -2,  /* (326) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (327) literal ::= duration_literal */
   -1,  /* (328) literal ::= NULL */
   -1,  /* (329) literal ::= NK_QUESTION */
   -1,  /* (330) duration_literal ::= NK_VARIABLE */
   -1,  /* (331) signed ::= NK_INTEGER */
   -2,  /* (332) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (333) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (334) signed ::= NK_FLOAT */
   -2,  /* (335) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (336) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (337) signed_literal ::= signed */
   -1,  /* (338) signed_literal ::= NK_STRING */
   -1,  /* (339) signed_literal ::= NK_BOOL */
   -2,  /* (340) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (341) signed_literal ::= duration_literal */
   -1,  /* (342) signed_literal ::= NULL */
   -1,  /* (343) signed_literal ::= literal_func */
   -1,  /* (344) signed_literal ::= NK_QUESTION */
   -1,  /* (345) literal_list ::= signed_literal */
   -3,  /* (346) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (347) db_name ::= NK_ID */
   -1,  /* (348) table_name ::= NK_ID */
   -1,  /* (349) column_name ::= NK_ID */
   -1,  /* (350) function_name ::= NK_ID */
   -1,  /* (351) table_alias ::= NK_ID */
   -1,  /* (352) column_alias ::= NK_ID */
   -1,  /* (353) user_name ::= NK_ID */
   -1,  /* (354) topic_name ::= NK_ID */
   -1,  /* (355) stream_name ::= NK_ID */
   -1,  /* (356) cgroup_name ::= NK_ID */
   -1,  /* (357) expr_or_subquery ::= expression */
   -1,  /* (358) expression ::= literal */
   -1,  /* (359) expression ::= pseudo_column */
   -1,  /* (360) expression ::= column_reference */
   -1,  /* (361) expression ::= function_expression */
   -1,  /* (362) expression ::= case_when_expression */
   -3,  /* (363) expression ::= NK_LP expression NK_RP */
   -2,  /* (364) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (365) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (366) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (367) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (368) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (369) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (370) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (371) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (372) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (373) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (374) expression_list ::= expr_or_subquery */
   -3,  /* (375) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (376) column_reference ::= column_name */
   -3,  /* (377) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (378) pseudo_column ::= ROWTS */
   -1,  /* (379) pseudo_column ::= TBNAME */
   -3,  /* (380) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (381) pseudo_column ::= QSTART */
   -1,  /* (382) pseudo_column ::= QEND */
   -1,  /* (383) pseudo_column ::= QDURATION */
   -1,  /* (384) pseudo_column ::= WSTART */
   -1,  /* (385) pseudo_column ::= WEND */
   -1,  /* (386) pseudo_column ::= WDURATION */
   -1,  /* (387) pseudo_column ::= IROWTS */
   -1,  /* (388) pseudo_column ::= ISFILLED */
   -1,  /* (389) pseudo_column ::= QTAGS */
   -4,  /* (390) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (391) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (392) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (393) function_expression ::= literal_func */
   -3,  /* (394) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (395) literal_func ::= NOW */
   -1,  /* (396) noarg_func ::= NOW */
   -1,  /* (397) noarg_func ::= TODAY */
   -1,  /* (398) noarg_func ::= TIMEZONE */
   -1,  /* (399) noarg_func ::= DATABASE */
   -1,  /* (400) noarg_func ::= CLIENT_VERSION */
   -1,  /* (401) noarg_func ::= SERVER_VERSION */
   -1,  /* (402) noarg_func ::= SERVER_STATUS */
   -1,  /* (403) noarg_func ::= CURRENT_USER */
   -1,  /* (404) noarg_func ::= USER */
   -1,  /* (405) star_func ::= COUNT */
   -1,  /* (406) star_func ::= FIRST */
   -1,  /* (407) star_func ::= LAST */
   -1,  /* (408) star_func ::= LAST_ROW */
   -1,  /* (409) star_func_para_list ::= NK_STAR */
   -1,  /* (410) star_func_para_list ::= other_para_list */
   -1,  /* (411) other_para_list ::= star_func_para */
   -3,  /* (412) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (413) star_func_para ::= expr_or_subquery */
   -3,  /* (414) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (415) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (416) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (417) when_then_list ::= when_then_expr */
   -2,  /* (418) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (419) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (420) case_when_else_opt ::= */
   -2,  /* (421) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (422) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (423) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (424) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (425) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (426) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (427) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (428) compare_op ::= NK_LT */
   -1,  /* (429) compare_op ::= NK_GT */
   -1,  /* (430) compare_op ::= NK_LE */
   -1,  /* (431) compare_op ::= NK_GE */
   -1,  /* (432) compare_op ::= NK_NE */
   -1,  /* (433) compare_op ::= NK_EQ */
   -1,  /* (434) compare_op ::= LIKE */
   -2,  /* (435) compare_op ::= NOT LIKE */
   -1,  /* (436) compare_op ::= MATCH */
   -1,  /* (437) compare_op ::= NMATCH */
   -1,  /* (438) compare_op ::= CONTAINS */
   -1,  /* (439) in_op ::= IN */
   -2,  /* (440) in_op ::= NOT IN */
   -3,  /* (441) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (442) boolean_value_expression ::= boolean_primary */
   -2,  /* (443) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (444) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (445) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (446) boolean_primary ::= predicate */
   -3,  /* (447) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (448) common_expression ::= expr_or_subquery */
   -1,  /* (449) common_expression ::= boolean_value_expression */
    0,  /* (450) from_clause_opt ::= */
   -2,  /* (451) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (452) table_reference_list ::= table_reference */
   -3,  /* (453) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (454) table_reference ::= table_primary */
   -1,  /* (455) table_reference ::= joined_table */
   -2,  /* (456) table_primary ::= table_name alias_opt */
   -4,  /* (457) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (458) table_primary ::= subquery alias_opt */
   -1,  /* (459) table_primary ::= parenthesized_joined_table */
    0,  /* (460) alias_opt ::= */
   -1,  /* (461) alias_opt ::= table_alias */
   -2,  /* (462) alias_opt ::= AS table_alias */
   -3,  /* (463) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (464) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (465) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (466) join_type ::= */
   -1,  /* (467) join_type ::= INNER */
  -12,  /* (468) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (469) set_quantifier_opt ::= */
   -1,  /* (470) set_quantifier_opt ::= DISTINCT */
   -1,  /* (471) set_quantifier_opt ::= ALL */
   -1,  /* (472) select_list ::= select_item */
   -3,  /* (473) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (474) select_item ::= NK_STAR */
   -1,  /* (475) select_item ::= common_expression */
   -2,  /* (476) select_item ::= common_expression column_alias */
   -3,  /* (477) select_item ::= common_expression AS column_alias */
   -3,  /* (478) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (479) where_clause_opt ::= */
   -2,  /* (480) where_clause_opt ::= WHERE search_condition */
    0,  /* (481) partition_by_clause_opt ::= */
   -3,  /* (482) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (483) partition_list ::= partition_item */
   -3,  /* (484) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (485) partition_item ::= expr_or_subquery */
   -2,  /* (486) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (487) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (488) twindow_clause_opt ::= */
   -6,  /* (489) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (490) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (491) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (492) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (493) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (494) sliding_opt ::= */
   -4,  /* (495) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (496) fill_opt ::= */
   -4,  /* (497) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (498) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   -1,  /* (499) fill_mode ::= NONE */
   -1,  /* (500) fill_mode ::= PREV */
   -1,  /* (501) fill_mode ::= NULL */
   -1,  /* (502) fill_mode ::= LINEAR */
   -1,  /* (503) fill_mode ::= NEXT */
    0,  /* (504) group_by_clause_opt ::= */
   -3,  /* (505) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (506) group_by_list ::= expr_or_subquery */
   -3,  /* (507) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (508) having_clause_opt ::= */
   -2,  /* (509) having_clause_opt ::= HAVING search_condition */
    0,  /* (510) range_opt ::= */
   -6,  /* (511) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (512) every_opt ::= */
   -4,  /* (513) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (514) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (515) query_simple ::= query_specification */
   -1,  /* (516) query_simple ::= union_query_expression */
   -4,  /* (517) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (518) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (519) query_simple_or_subquery ::= query_simple */
   -1,  /* (520) query_simple_or_subquery ::= subquery */
   -1,  /* (521) query_or_subquery ::= query_expression */
   -1,  /* (522) query_or_subquery ::= subquery */
    0,  /* (523) order_by_clause_opt ::= */
   -3,  /* (524) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (525) slimit_clause_opt ::= */
   -2,  /* (526) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (527) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (528) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (529) limit_clause_opt ::= */
   -2,  /* (530) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (531) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (532) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (533) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (534) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (535) search_condition ::= common_expression */
   -1,  /* (536) sort_specification_list ::= sort_specification */
   -3,  /* (537) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (538) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (539) ordering_specification_opt ::= */
   -1,  /* (540) ordering_specification_opt ::= ASC */
   -1,  /* (541) ordering_specification_opt ::= DESC */
    0,  /* (542) null_ordering_opt ::= */
   -2,  /* (543) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (544) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,326,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,326,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,329,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,327,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy0, yymsp[0].minor.yy287); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy287 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy287 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy717 = yymsp[0].minor.yy717; }
  yymsp[0].minor.yy717 = yylhsminor.yy717;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy717 = yymsp[-2].minor.yy717 | yymsp[0].minor.yy717; }
  yymsp[-2].minor.yy717 = yylhsminor.yy717;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy77; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 42: /* priv_level ::= topic_name */
      case 267: /* sma_func_name ::= function_name */ yytestcase(yyruleno==267);
      case 461: /* alias_opt ::= table_alias */ yytestcase(yyruleno==461);
{ yylhsminor.yy77 = yymsp[0].minor.yy77; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy77, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy841); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy841); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 268: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==268);
      case 269: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==269);
      case 270: /* sma_func_name ::= LAST */ yytestcase(yyruleno==270);
      case 271: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==271);
      case 347: /* db_name ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* table_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* column_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* function_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* table_alias ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* column_alias ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* user_name ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* topic_name ::= NK_ID */ yytestcase(yyruleno==354);
      case 355: /* stream_name ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==356);
      case 396: /* noarg_func ::= NOW */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= TODAY */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==400);
      case 401: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==401);
      case 402: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==402);
      case 403: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==403);
      case 404: /* noarg_func ::= USER */ yytestcase(yyruleno==404);
      case 405: /* star_func ::= COUNT */ yytestcase(yyruleno==405);
      case 406: /* star_func ::= FIRST */ yytestcase(yyruleno==406);
      case 407: /* star_func ::= LAST */ yytestcase(yyruleno==407);
      case 408: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==408);
{ yylhsminor.yy77 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 287: /* analyze_opt ::= */ yytestcase(yyruleno==287);
      case 294: /* agg_func_opt ::= */ yytestcase(yyruleno==294);
      case 469: /* set_quantifier_opt ::= */ yytestcase(yyruleno==469);
{ yymsp[1].minor.yy841 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 288: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==288);
      case 295: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==295);
      case 470: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==470);
{ yymsp[0].minor.yy841 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy841, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy248); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy841 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy841 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy600 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_KEEP, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_RETENTIONS, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy600 = createAlterDatabaseOptions(pCxt); yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yylhsminor.yy600, &yymsp[0].minor.yy661); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy600, &yymsp[0].minor.yy661); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy661.type = DB_OPTION_KEEP; yymsp[-1].minor.yy661.pList = yymsp[0].minor.yy601; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_PAGES; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_WAL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 317: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==317);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy601 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 253: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==253);
      case 264: /* func_list ::= func */ yytestcase(yyruleno==264);
      case 345: /* literal_list ::= signed_literal */ yytestcase(yyruleno==345);
      case 411: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==411);
      case 417: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==417);
      case 472: /* select_list ::= select_item */ yytestcase(yyruleno==472);
      case 483: /* partition_list ::= partition_item */ yytestcase(yyruleno==483);
      case 536: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==536);
{ yylhsminor.yy601 = createNodeList(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==254);
      case 265: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==265);
      case 346: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==346);
      case 412: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==412);
      case 473: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==473);
      case 484: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==484);
      case 537: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==537);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy600 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 126: /* speed_opt ::= */
      case 296: /* bufsize_opt ::= */ yytestcase(yyruleno==296);
{ yymsp[1].minor.yy248 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 297: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==297);
{ yymsp[-1].minor.yy248 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-5].minor.yy600, yymsp[-3].minor.yy601, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 319: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==319);
{ pCxt->pRootNode = yymsp[0].minor.yy600; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy600); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy600 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy600 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy600, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 418: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==418);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy601 = yylhsminor.yy601;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy600 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy841, yymsp[-8].minor.yy600, yymsp[-6].minor.yy600, yymsp[-5].minor.yy601, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-9].minor.yy600 = yylhsminor.yy600;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy600 = createDropTableClause(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 252: /* tag_list_opt ::= */ yytestcase(yyruleno==252);
      case 481: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==481);
      case 504: /* group_by_clause_opt ::= */ yytestcase(yyruleno==504);
      case 523: /* order_by_clause_opt ::= */ yytestcase(yyruleno==523);
{ yymsp[1].minor.yy601 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888, NULL); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-2].minor.yy888, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 410: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==410);
{ yylhsminor.yy601 = yymsp[0].minor.yy601; }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy600 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_SMA, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy600 = createAlterTableOptions(pCxt); yylhsminor.yy600 = setTableOption(pCxt, yylhsminor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 374: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==374);
{ yylhsminor.yy601 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 375: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==375);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 256: /* tag_item ::= QTAGS */ yytestcase(yyruleno==256);
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 206: /* col_name ::= column_name */
      case 257: /* tag_item ::= column_name */ yytestcase(yyruleno==257);
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy600, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy600); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600, yymsp[-3].minor.yy601); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* db_name_cond_opt ::= */
      case 250: /* from_db_opt ::= */ yytestcase(yyruleno==250);
{ yymsp[1].minor.yy600 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 246: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 247: /* like_pattern_opt ::= */
      case 307: /* subtable_opt ::= */ yytestcase(yyruleno==307);
      case 420: /* case_when_else_opt ::= */ yytestcase(yyruleno==420);
      case 450: /* from_clause_opt ::= */ yytestcase(yyruleno==450);
      case 479: /* where_clause_opt ::= */ yytestcase(yyruleno==479);
      case 488: /* twindow_clause_opt ::= */ yytestcase(yyruleno==488);
      case 494: /* sliding_opt ::= */ yytestcase(yyruleno==494);
      case 496: /* fill_opt ::= */ yytestcase(yyruleno==496);
      case 508: /* having_clause_opt ::= */ yytestcase(yyruleno==508);
      case 510: /* range_opt ::= */ yytestcase(yyruleno==510);
      case 512: /* every_opt ::= */ yytestcase(yyruleno==512);
      case 525: /* slimit_clause_opt ::= */ yytestcase(yyruleno==525);
      case 529: /* limit_clause_opt ::= */ yytestcase(yyruleno==529);
{ yymsp[1].minor.yy600 = NULL; }
        break;
      case 248: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 249: /* table_name_cond ::= table_name */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 251: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 255: /* tag_item ::= TBNAME */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 258: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 259: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 260: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy841, yymsp[-3].minor.yy600, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 261: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 262: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy600 = createIndexOption(pCxt, yymsp[-7].minor.yy601, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy600 = createIndexOption(pCxt, yymsp[-9].minor.yy601, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 266: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 272: /* sma_stream_opt ::= */
      case 300: /* stream_options ::= */ yytestcase(yyruleno==300);
{ yymsp[1].minor.yy600 = createStreamOptions(pCxt); }
        break;
      case 273: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 304: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==304);
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 274: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 275: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 276: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 277: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy77, false); }
        break;
      case 278: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[0].minor.yy77, true); }
        break;
      case 279: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, yymsp[0].minor.yy600, false); }
        break;
      case 280: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, yymsp[0].minor.yy600, true); }
        break;
      case 281: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 282: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 283: /* cmd ::= DESC full_table_name */
      case 284: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==284);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 285: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 286: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy841, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 289: /* explain_options ::= */
{ yymsp[1].minor.yy600 = createDefaultExplainOptions(pCxt); }
        break;
      case 290: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy600 = setExplainVerbose(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 291: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy600 = setExplainRatio(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 292: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-8].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy888, yymsp[0].minor.yy248); }
        break;
      case 293: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 298: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy841, &yymsp[-7].minor.yy77, yymsp[-4].minor.yy600, yymsp[-6].minor.yy600, yymsp[-3].minor.yy601, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 299: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 301: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 302: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 303: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 305: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 306: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 308: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 495: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==495);
      case 513: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==513);
{ yymsp[-3].minor.yy600 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy600); }
        break;
      case 309: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 310: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 311: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 312: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 313: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 314: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy601); }
        break;
      case 315: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 316: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 318: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 320: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy600, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 321: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 322: /* literal ::= NK_INTEGER */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 323: /* literal ::= NK_FLOAT */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 324: /* literal ::= NK_STRING */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 325: /* literal ::= NK_BOOL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 326: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 327: /* literal ::= duration_literal */
      case 337: /* signed_literal ::= signed */ yytestcase(yyruleno==337);
      case 357: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==357);
      case 358: /* expression ::= literal */ yytestcase(yyruleno==358);
      case 359: /* expression ::= pseudo_column */ yytestcase(yyruleno==359);
      case 360: /* expression ::= column_reference */ yytestcase(yyruleno==360);
      case 361: /* expression ::= function_expression */ yytestcase(yyruleno==361);
      case 362: /* expression ::= case_when_expression */ yytestcase(yyruleno==362);
      case 393: /* function_expression ::= literal_func */ yytestcase(yyruleno==393);
      case 442: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==442);
      case 446: /* boolean_primary ::= predicate */ yytestcase(yyruleno==446);
      case 448: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==448);
      case 449: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==449);
      case 452: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==452);
      case 454: /* table_reference ::= table_primary */ yytestcase(yyruleno==454);
      case 455: /* table_reference ::= joined_table */ yytestcase(yyruleno==455);
      case 459: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==459);
      case 515: /* query_simple ::= query_specification */ yytestcase(yyruleno==515);
      case 516: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==516);
      case 519: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==519);
      case 521: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==521);
{ yylhsminor.yy600 = yymsp[0].minor.yy600; }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 328: /* literal ::= NULL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 329: /* literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 330: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 331: /* signed ::= NK_INTEGER */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 332: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 333: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 334: /* signed ::= NK_FLOAT */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 335: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 336: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 338: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 339: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 340: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 341: /* signed_literal ::= duration_literal */
      case 343: /* signed_literal ::= literal_func */ yytestcase(yyruleno==343);
      case 413: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==413);
      case 475: /* select_item ::= common_expression */ yytestcase(yyruleno==475);
      case 485: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==485);
      case 520: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==520);
      case 522: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==522);
      case 535: /* search_condition ::= common_expression */ yytestcase(yyruleno==535);
{ yylhsminor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 342: /* signed_literal ::= NULL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 344: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 363: /* expression ::= NK_LP expression NK_RP */
      case 447: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==447);
      case 534: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==534);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 364: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy600));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 365: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 366: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 367: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 368: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 369: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 370: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 371: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 372: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 373: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 376: /* column_reference ::= column_name */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy77, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 377: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 378: /* pseudo_column ::= ROWTS */
      case 379: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==379);
      case 381: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= QEND */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= WEND */ yytestcase(yyruleno==385);
      case 386: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==386);
      case 387: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==387);
      case 388: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==388);
      case 389: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==389);
      case 395: /* literal_func ::= NOW */ yytestcase(yyruleno==395);
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 380: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy77)))); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 390: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 391: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==391);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 392: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy888)); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 394: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy77, NULL)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 409: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy601 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 414: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 478: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==478);
{ yylhsminor.yy600 = createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 415: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 416: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 419: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy600 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
        break;
      case 421: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
        break;
      case 422: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 427: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==427);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy666, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 423: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 424: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 425: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), NULL));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 426: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL));
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 428: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_THAN; }
        break;
      case 429: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_THAN; }
        break;
      case 430: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 431: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 432: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy666 = OP_TYPE_NOT_EQUAL; }
        break;
      case 433: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy666 = OP_TYPE_EQUAL; }
        break;
      case 434: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy666 = OP_TYPE_LIKE; }
        break;
      case 435: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_LIKE; }
        break;
      case 436: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_MATCH; }
        break;
      case 437: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_NMATCH; }
        break;
      case 438: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy666 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 439: /* in_op ::= IN */
{ yymsp[0].minor.yy666 = OP_TYPE_IN; }
        break;
      case 440: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_IN; }
        break;
      case 441: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 443: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 444: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 445: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 451: /* from_clause_opt ::= FROM table_reference_list */
      case 480: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==480);
      case 509: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==509);
{ yymsp[-1].minor.yy600 = yymsp[0].minor.yy600; }
        break;
      case 453: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 456: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 457: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 458: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy600 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 460: /* alias_opt ::= */
{ yymsp[1].minor.yy77 = nil_token;  }
        break;
      case 462: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy77 = yymsp[0].minor.yy77; }
        break;
      case 463: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 464: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==464);
{ yymsp[-2].minor.yy600 = yymsp[-1].minor.yy600; }
        break;
      case 465: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, yymsp[-4].minor.yy560, yymsp[-5].minor.yy600, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 466: /* join_type ::= */
{ yymsp[1].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 467: /* join_type ::= INNER */
{ yymsp[0].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 468: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy600 = createSelectStmt(pCxt, yymsp[-10].minor.yy841, yymsp[-9].minor.yy601, yymsp[-8].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addWhereClause(pCxt, yymsp[-11].minor.yy600, yymsp[-7].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addPartitionByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-6].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy600, yymsp[-2].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addGroupByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-1].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addHavingClause(pCxt, yymsp[-11].minor.yy600, yymsp[0].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addRangeClause(pCxt, yymsp[-11].minor.yy600, yymsp[-5].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addEveryClause(pCxt, yymsp[-11].minor.yy600, yymsp[-4].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addFillClause(pCxt, yymsp[-11].minor.yy600, yymsp[-3].minor.yy600);
                                                                                  }
        break;
      case 471: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy841 = false; }
        break;
      case 474: /* select_item ::= NK_STAR */
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 476: /* select_item ::= common_expression column_alias */
      case 486: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==486);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 477: /* select_item ::= common_expression AS column_alias */
      case 487: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==487);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 482: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 505: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==505);
      case 524: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==524);
{ yymsp[-2].minor.yy601 = yymsp[0].minor.yy601; }
        break;
      case 489: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy600 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 490: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy600 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 491: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 492: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 493: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy600 = createEventWindowNode(pCxt, yymsp[-3].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 497: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy600 = createFillNode(pCxt, yymsp[-1].minor.yy798, NULL); }
        break;
      case 498: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy600 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
        break;
      case 499: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy798 = FILL_MODE_NONE; }
        break;
      case 500: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy798 = FILL_MODE_PREV; }
        break;
      case 501: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy798 = FILL_MODE_NULL; }
        break;
      case 502: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy798 = FILL_MODE_LINEAR; }
        break;
      case 503: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy798 = FILL_MODE_NEXT; }
        break;
      case 506: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy601 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 507: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 511: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy600 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 514: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy600 = addOrderByClause(pCxt, yymsp[-3].minor.yy600, yymsp[-2].minor.yy601);
                                                                                    yylhsminor.yy600 = addSlimitClause(pCxt, yylhsminor.yy600, yymsp[-1].minor.yy600);
                                                                                    yylhsminor.yy600 = addLimitClause(pCxt, yylhsminor.yy600, yymsp[0].minor.yy600);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 517: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 518: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 526: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 530: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==530);
{ yymsp[-1].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 527: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 531: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==531);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 528: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 532: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==532);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 533: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 538: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy600 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), yymsp[-1].minor.yy32, yymsp[0].minor.yy385); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 539: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy32 = ORDER_ASC; }
        break;
      case 540: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy32 = ORDER_ASC; }
        break;
      case 541: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy32 = ORDER_DESC; }
        break;
      case 542: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy385 = NULL_ORDER_DEFAULT; }
        break;
      case 543: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_FIRST; }
        break;
      case 544: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
