/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 457
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy20;
  int8_t yy33;
  SAlterOption yy123;
  SNode* yy148;
  SToken yy199;
  EFillMode yy334;
  bool yy397;
  SNodeList* yy404;
  EJoinType yy470;
  ENullOrder yy499;
  int64_t yy525;
  SDataType yy530;
  int32_t yy706;
  EOrder yy898;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             710
#define YYNRULE              540
#define YYNTOKEN             322
#define YY_MAX_SHIFT         709
#define YY_MIN_SHIFTREDUCE   1052
#define YY_MAX_SHIFTREDUCE   1591
#define YY_ERROR_ACTION      1592
#define YY_ACCEPT_ACTION     1593
#define YY_NO_ACTION         1594
#define YY_MIN_REDUCE        1595
#define YY_MAX_REDUCE        2134
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2410)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1950,  458,  157,  459, 1631,  566,  167, 1703,  467, 2105,
 /*    10 */   459, 1631,   43,   41, 1522,  365, 1651, 2110, 1796, 1798,
 /*    20 */   360, 2105, 1373, 1595,  565,  173,  598,  332, 1850, 2106,
 /*    30 */   567, 1968, 1741, 1452,  405, 1371, 1664, 2109,  514,  581,
 /*    40 */    52, 2106, 2108, 1933, 1919,  399,  614,  122,  121,  120,
 /*    50 */   119,  118,  117,  116,  115,  114,  464, 1750, 1447,  597,
 /*    60 */    36,   35,  460,   16,   42,   40,   39,   38,   37, 1949,
 /*    70 */  1379, 1929, 1935, 1984,  318,  597,  100, 1951,  618, 1953,
 /*    80 */  1954,  613,  608,  608,  258,  597, 1526,  546,  170, 1938,
 /*    90 */  2037, 2105, 1398,  476,  354, 2033,   12, 2052, 1462, 1950,
 /*   100 */  1933,  513,  512,  511, 1398, 1968, 2111,  173,  175,  128,
 /*   110 */   507, 2106,  567,  560,  506,  505, 2063,  158,  706, 1607,
 /*   120 */   504,  510,   58, 2049,   85,  561,  503,  598, 1929, 1935,
 /*   130 */  1968, 1398, 1085, 1454, 1455, 1104, 1593, 1103,  615,  608,
 /*   140 */  2110,  123, 1846, 1919, 2105,  614,   43,   41,  497, 1558,
 /*   150 */   210,   46,  559,  181,  360, 1727, 1373, 1399, 1750, 1950,
 /*   160 */  2109,   46, 1428, 1437, 2106, 2107, 1105, 1452, 1949, 1371,
 /*   170 */   598, 1087, 1984, 1090, 1091,  100, 1951,  618, 1953, 1954,
 /*   180 */   613, 1374,  608, 1372,  123,  134,   62,  141, 2008, 2037,
 /*   190 */  1968,  502, 1447,  354, 2033,   33,  274,   16,  581,  375,
 /*   200 */  1398, 1750,  652, 1919, 1379,  614, 1377, 1378, 1398, 1427,
 /*   210 */  1430, 1431, 1432, 1433, 1434, 1435, 1436,  610,  606, 1445,
 /*   220 */  1446, 1448, 1449, 1450, 1451, 1453, 1456,    2, 1949,   97,
 /*   230 */    12, 2110, 1984, 1950, 1429,  100, 1951,  618, 1953, 1954,
 /*   240 */   613,  546,  608,  132, 1397, 2105, 1429,  170, 1400, 2037,
 /*   250 */   556, 1742,  706,  354, 2033,   42,   40,   39,   38,   37,
 /*   260 */  2111,  173,    9,  650, 1968, 2106,  567, 1454, 1455, 1797,
 /*   270 */  1798,  176,  615, 1309, 1310, 2064,   58, 1919,   58,  614,
 /*   280 */    43,   41,  146,  145,  647,  646,  645,  143,  360, 1400,
 /*   290 */  1373,   58, 1399, 1950,  509,  508, 1428, 1437, 1618,  578,
 /*   300 */   176, 1452, 1949, 1371,  457,  598, 1984,  462, 1637,  100,
 /*   310 */  1951,  618, 1953, 1954,  613, 1374,  608, 1372,  225,  178,
 /*   320 */   643, 2012,  169, 2037, 1968, 1581, 1447,  354, 2033, 1483,
 /*   330 */   131,   16,  615,  562,  557, 1790, 1750, 1919, 1379,  614,
 /*   340 */  1377, 1378, 1919, 1427, 1430, 1431, 1432, 1433, 1434, 1435,
 /*   350 */  1436,  610,  606, 1445, 1446, 1448, 1449, 1450, 1451, 1453,
 /*   360 */  1456,    2, 1949,    9,   12, 1950, 1984,  677,  675,  100,
 /*   370 */  1951,  618, 1953, 1954,  613,  398,  608,  397,   82,  320,
 /*   380 */    58, 2125,  531, 2037,  529,   80,  706,  354, 2033,  255,
 /*   390 */  2045,  577,  257,  124,  576,  441, 1968, 2105, 2071,  127,
 /*   400 */    30, 1454, 1455,  541,  612, 1256, 1257,  406, 1745, 1919,
 /*   410 */  1488,  614,  565,  173,   43,   41, 1457, 2106,  567,  585,
 /*   420 */   407, 1379,  360, 1725, 1373,  176,   47,  176, 1846,  351,
 /*   430 */  1428, 1437, 1861,  257, 1949, 1452,  185, 1371, 1984,  183,
 /*   440 */   176,  310, 1951,  618, 1953, 1954,  613,  650,  608, 1374,
 /*   450 */  2003, 1372,  466,  189,  188,  462, 1637,   36,   35,  664,
 /*   460 */  1447,   42,   40,   39,   38,   37,  146,  145,  647,  646,
 /*   470 */   645,  143, 1379,   77, 1377, 1378,   76, 1427, 1430, 1431,
 /*   480 */  1432, 1433, 1434, 1435, 1436,  610,  606, 1445, 1446, 1448,
 /*   490 */  1449, 1450, 1451, 1453, 1456,    2,  598, 1617,   44,  598,
 /*   500 */  1739, 1950, 1803,  513,  512,  511, 1398,  598, 1803,  353,
 /*   510 */   403,  128,  507,  404, 1735,  364,  506,  505, 1801, 1616,
 /*   520 */   706,  413,  504,  510, 1801,  352,  363, 1750,  503,  176,
 /*   530 */  1750,  650, 1968,  155,  155, 1454, 1455, 1104, 1750, 1103,
 /*   540 */   615, 1919, 1752, 1752,  527, 1919, 1538,  614,   43,   41,
 /*   550 */   146,  145,  647,  646,  645,  143,  360,  525, 1373,  523,
 /*   560 */  1737, 1950,  598, 1919, 1428, 1437,  394, 1173, 1105, 1452,
 /*   570 */  1949, 1371,  598,  578, 1984,  176,  427,  100, 1951,  618,
 /*   580 */  1953, 1954,  613, 1374,  608, 1372,  428,  396,  392, 2010,
 /*   590 */  1733, 2037, 1968, 1750, 1447,  354, 2033,  226,  230,    9,
 /*   600 */   615,    7, 1175, 1750,  131, 1919, 1379,  614, 1377, 1378,
 /*   610 */    80, 1427, 1430, 1431, 1432, 1433, 1434, 1435, 1436,  610,
 /*   620 */   606, 1445, 1446, 1448, 1449, 1450, 1451, 1453, 1456,    2,
 /*   630 */  1949,  167,   44, 1746, 1984,  366,  605,  100, 1951,  618,
 /*   640 */  1953, 1954,  613,  155,  608,  265,  266, 1615, 1429, 2125,
 /*   650 */   264, 2037, 1752, 1851,  706,  354, 2033, 1614, 1950, 1728,
 /*   660 */  1350, 1351,  580,  171, 2045, 2046, 2099,  129, 2050, 1454,
 /*   670 */  1455,   36,   35,    6,   29,   42,   40,   39,   38,   37,
 /*   680 */    36,   35,   43,   41,   42,   40,   39,   38,   37, 1968,
 /*   690 */   360, 1919, 1373,   91,  598,  598, 2077,  615, 1428, 1437,
 /*   700 */  1613, 1919, 1919, 1452,  614, 1371, 1803,   25,  474,  475,
 /*   710 */    39,   38,   37,  329,  600, 1743, 2009, 1374,  602, 1372,
 /*   720 */  2009,  476, 1801,  609,  155, 1750, 1750, 1949, 1447,  227,
 /*   730 */  1612, 1984, 1780, 1753,  159, 1951,  618, 1953, 1954,  613,
 /*   740 */  1379,  608, 1377, 1378, 1919, 1427, 1430, 1431, 1432, 1433,
 /*   750 */  1434, 1435, 1436,  610,  606, 1445, 1446, 1448, 1449, 1450,
 /*   760 */  1451, 1453, 1456,    2,   36,   35,   12, 1950,   42,   40,
 /*   770 */    39,   38,   37, 1846, 1919,  547, 2074,  566, 1548, 1473,
 /*   780 */   317, 2105, 1396, 2052,  187,  598,  642, 1611,  706,  435,
 /*   790 */  1610, 1609,  448, 1596, 1606,  447,  565,  173, 1968, 1747,
 /*   800 */  1726, 2106,  567, 1454, 1455, 1605,  615, 1608, 1604, 2048,
 /*   810 */   419, 1919,  449,  614,  113,  421, 1750,  112,  111,  110,
 /*   820 */   109,  108,  107,  106,  105,  104,  553, 1546, 1547, 1549,
 /*   830 */  1550, 1919, 1428, 1437, 1919, 1919,  532,  665, 1919, 1720,
 /*   840 */  1984,  598,  598,  306, 1951,  618, 1953, 1954,  613, 1919,
 /*   850 */   608, 1374, 1919, 1372, 1603,  139,  367,  333, 1661,   36,
 /*   860 */    35, 1519,  652,   42,   40,   39,   38,   37, 2109,  409,
 /*   870 */  1401, 1401, 1750, 1750, 2052, 1602, 1377, 1378, 1515, 1427,
 /*   880 */  1430, 1431, 1432, 1433, 1434, 1435, 1436,  610,  606, 1445,
 /*   890 */  1446, 1448, 1449, 1450, 1451, 1453, 1456,    2, 1919,  445,
 /*   900 */  2047, 1704,  440,  439,  438,  437,  434,  433,  432,  431,
 /*   910 */   430,  426,  425,  424,  423,  334,  416,  415,  414, 1919,
 /*   920 */   411,  410,  331,  683,  682,  681,  680,  370,  144,  679,
 /*   930 */   678,  135,  673,  672,  671,  670,  669,  668,  667,  666,
 /*   940 */   148,  662,  661,  660,  369,  368,  657,  656,  655,  654,
 /*   950 */   653,  156, 1601, 1600,  598, 1599,  294,   36,   35,  357,
 /*   960 */   356,   42,   40,   39,   38,   37, 1598, 1950,  542, 1387,
 /*   970 */   292,   66,  598,  133,   65,  644, 2008,  252, 1794, 1401,
 /*   980 */  1452,   51, 1380,   36,   35, 1750,  582,   42,   40,   39,
 /*   990 */    38,   37,  193,  454,  452,  585, 1919, 1919, 1968, 1919,
 /*  1000 */    11,   10,  337, 1750,  648, 1447,  615, 1794, 1862,  554,
 /*  1010 */  1919, 1919,  325,  614,  182,  235,  573, 1379, 1213,  640,
 /*  1020 */   639,  638, 1217,  637, 1219, 1220,  636, 1222,  633,   58,
 /*  1030 */  1228,  630, 1230, 1231,  627,  624, 1949,  209,  288,  598,
 /*  1040 */  1984, 1780, 1803,  100, 1951,  618, 1953, 1954,  613,  649,
 /*  1050 */   608,  584, 1794,  269, 1481, 2125,  216, 2037, 1802,  214,
 /*  1060 */   211,  354, 2033,  709,  338,  604,  336,  335,   99,  499,
 /*  1070 */  1750,  246, 2056,  501,  598,  162, 1906,  281, 1373, 1090,
 /*  1080 */  1091,  493,  489,  485,  481,  208, 2057, 1515,  593, 1833,
 /*  1090 */   598, 1371,  166,  546,  501,  500, 1495, 2105,  699,  695,
 /*  1100 */   691,  687,  279, 1518,  595, 1750,   74,   73,  402,  578,
 /*  1110 */  1482,  180, 2111,  173,   67,  570,  500, 2106,  567,  598,
 /*  1120 */  1382, 1750,   81,  234,  382,  206, 1379,  569, 1388,  316,
 /*  1130 */  1383, 1969,  390,  596,  388,  384,  380,  377,  374,   98,
 /*  1140 */   131,   48,  272,    3,  137, 1381,  125,  371, 1588,   60,
 /*  1150 */  1750, 1855,  113, 1391, 1393,  112,  111,  110,  109,  108,
 /*  1160 */   107,  106,  105,  104,   75,  606, 1445, 1446, 1448, 1449,
 /*  1170 */  1450, 1451,  239,  218,  706,  594,  217, 1950,  176,   45,
 /*  1180 */   598,   32,  358, 1476, 1477, 1478, 1479, 1480, 1484, 1485,
 /*  1190 */  1486, 1487,  205,  199,  275,  204, 1644, 1642,  472,  172,
 /*  1200 */  2045, 2046, 1545,  129, 2050, 1950,  220,  222, 1968,  219,
 /*  1210 */   221, 1750,  260,  262,  197,   50,  615,  140,  516,  519,
 /*  1220 */   545, 1919,  142,  614,  233,  241, 1590, 1591, 1940, 1344,
 /*  1230 */    96,  229, 1320,   11,   10, 1632, 1968, 1374,  574, 1372,
 /*  1240 */    93,  422, 1587,  144,  615, 1133, 1949,  658, 1950, 1919,
 /*  1250 */  1984,  614, 2067,  100, 1951,  618, 1953, 1954,  613,   60,
 /*  1260 */   608,   45, 1377, 1378,   83,  601,  267, 2037, 1385, 1153,
 /*  1270 */   590,  354, 2033, 1791, 1949,  271, 1950, 1942, 1984, 1968,
 /*  1280 */  1134,  101, 1951,  618, 1953, 1954,  613,  615,  608,  579,
 /*  1290 */   254,   31, 1919, 1384,  614, 2037, 1206,   36,   35, 2036,
 /*  1300 */  2033,   42,   40,   39,   38,   37,  251, 1968,   45,  622,
 /*  1310 */     1,  142, 1489,    4, 1438,  615,  144, 1949,  659, 1950,
 /*  1320 */  1919, 1984,  614, 1638,  101, 1951,  618, 1953, 1954,  613,
 /*  1330 */   376,  608,  126,  381,  330,  571,  142, 1950, 2037, 1337,
 /*  1340 */  1151,  282,  603, 2033,  186,  616,  408, 1401, 1856, 1984,
 /*  1350 */  1968,  443,  101, 1951,  618, 1953, 1954,  613,  612,  608,
 /*  1360 */   412,  287, 1234, 1919, 1238,  614, 2037,  417, 1968, 1245,
 /*  1370 */   324, 2033,  701, 1396,  429, 1848,  615,  436,  442,  444,
 /*  1380 */  1950, 1919,  190,  614,  450, 1243,  451,  453, 1949,  147,
 /*  1390 */   455, 1402, 1984,  518,  456,  310, 1951,  618, 1953, 1954,
 /*  1400 */   613,  611,  608,  599, 2002,  465, 1949, 1404,  528,  468,
 /*  1410 */  1984, 1968, 1403,  160, 1951,  618, 1953, 1954,  613,  615,
 /*  1420 */   608,  196,  224,  469, 1919,  198,  614, 1405, 1937,  470,
 /*  1430 */   201,  473,  471, 1950, 1107,  203,  477,  521, 1896, 1933,
 /*  1440 */    78, 1937,  515,   79,  496,  533,  498,  223,  494, 1949,
 /*  1450 */   207,  495, 1933, 1984, 1950,  102,  101, 1951,  618, 1953,
 /*  1460 */  1954,  613,  228,  608, 1968,  568, 2126, 1929, 1935,  343,
 /*  1470 */  2037,  319,  615,  535, 1740, 2034,  213, 1919,  608,  614,
 /*  1480 */  1929, 1935,  355,  373,   64, 1968, 1736,   63,  215,  149,
 /*  1490 */  1895,  608,  150,  615,  372, 1738, 1734,  151, 1919,  152,
 /*  1500 */   614,  536, 1949,  543,  283,  231, 1984,  550, 1950,  159,
 /*  1510 */  1951,  618, 1953, 1954,  613,  555,  608,  537,  540,  237,
 /*  1520 */   588, 2068,  578, 1949, 2078,  546,  552, 1984,  344, 2105,
 /*  1530 */   304, 1951,  618, 1953, 1954,  613,  546,  608,  240, 1968,
 /*  1540 */  2105,  558,    5,  551, 2111,  173,  564,  615,  548, 2106,
 /*  1550 */   567, 2075, 1919,  131,  614, 2111,  173,  549,  248, 2059,
 /*  1560 */  2106,  567, 1950,   36,   35,  245,  345,   42,   40,   39,
 /*  1570 */    38,   37,  250, 1515,  563,  575,  572, 1949,  130, 1950,
 /*  1580 */  2128, 1984,  249, 2083,  160, 1951,  618, 1953, 1954,  613,
 /*  1590 */  2082,  608,  163, 1968,  247, 1400,  583,  259,  349, 2104,
 /*  1600 */   253,  615, 2053,  348,  284, 1950, 1919,  586,  614,  587,
 /*  1610 */  1968, 1867,  174, 2045, 2046,  359,  129, 2050,  615,  591,
 /*  1620 */  1866, 1865,  350, 1919,   88,  614,  285,  592,  286,   57,
 /*  1630 */    90, 1949,   92, 1950, 1751, 1984, 1968, 2127,  311, 1951,
 /*  1640 */   618, 1953, 1954,  613,  615,  608, 2018, 1795, 1949, 1919,
 /*  1650 */  1721,  614, 1984,  289,  620,  311, 1951,  618, 1953, 1954,
 /*  1660 */   613,  278,  608,  702, 1968,  703,  705,   49,  298,  361,
 /*  1670 */   291,  312,  615,  313, 1949,  302, 1950, 1919, 1984,  614,
 /*  1680 */   293,  295, 1951,  618, 1953, 1954,  613, 1913,  608,  321,
 /*  1690 */   322, 1912, 1950,   71, 1911, 1910,   72, 1907,  378,  379,
 /*  1700 */  1365, 1366, 1949,  179,  383, 1905, 1984, 1968,  385,  311,
 /*  1710 */  1951,  618, 1953, 1954,  613,  615,  608,  386,  387,  154,
 /*  1720 */  1919, 1904,  614, 1968,  389, 1903, 1902,  391,  393, 1901,
 /*  1730 */  1340,  615, 1339,  395, 1878,  534, 1919, 1877,  614,  400,
 /*  1740 */   401, 1876, 1875, 1950, 1841, 1949, 1300, 1840, 1838, 1984,
 /*  1750 */   136, 1837,  296, 1951,  618, 1953, 1954,  613, 1836,  608,
 /*  1760 */  1839, 1949, 1835, 1834, 1832, 1984, 1831, 1830,  297, 1951,
 /*  1770 */   618, 1953, 1954,  613, 1968,  608,  184,  546,  418, 1829,
 /*  1780 */   420, 2105,  615, 1828, 1827, 1826, 1950, 1919, 1825,  614,
 /*  1790 */  1824, 1823, 1822, 1821, 1820, 1819, 2111,  173, 1818, 1817,
 /*  1800 */  1816, 2106,  567, 1950, 1815, 1814, 1813,  138, 1812, 1811,
 /*  1810 */  1810, 1809, 1949, 1808, 1807, 1806, 1984, 1968, 1302,  303,
 /*  1820 */  1951,  618, 1953, 1954,  613,  615,  608, 1805, 1804,  446,
 /*  1830 */  1919, 1666,  614,  191, 1968, 1665, 1181, 1663,  192, 1627,
 /*  1840 */  1093,  168,  615, 1092,  194, 1626,   69, 1919, 1891,  614,
 /*  1850 */  1939, 1885,  195, 1874, 1873, 1949, 1950,   70,  200, 1984,
 /*  1860 */   202, 1858,  307, 1951,  618, 1953, 1954,  613,  461,  608,
 /*  1870 */   463, 1729, 1949, 1950, 1662, 1660, 1984,  478,  479,  299,
 /*  1880 */  1951,  618, 1953, 1954,  613,  480,  608, 1968, 1126, 1658,
 /*  1890 */   482,  483, 1656,  486, 1654,  615,  484,  487,  488,  490,
 /*  1900 */  1919,  492,  614, 1641, 1968, 1640, 1623, 1731,  491, 1249,
 /*  1910 */  1730, 1250,  615, 1172, 1171, 1170, 1169, 1919, 1168,  614,
 /*  1920 */   212,   59, 1163, 1165, 1950, 1949,  674, 1652,  676, 1984,
 /*  1930 */  1164, 1162,  308, 1951,  618, 1953, 1954,  613,  339,  608,
 /*  1940 */  1645, 1950, 1949,  340, 1643,  341, 1984,  517,  520,  300,
 /*  1950 */  1951,  618, 1953, 1954,  613, 1968,  608, 1622, 1621,  522,
 /*  1960 */   524, 1620, 1357,  615,  526,  103, 1355, 1950, 1919, 1354,
 /*  1970 */   614,  530, 1968,   24, 1890, 1884, 1346,  538, 1872, 1870,
 /*  1980 */   615,   17,   14, 2110, 1950, 1919,   53,  614, 1560,   18,
 /*  1990 */    56,  243,   28, 1949,   26,  236,  539, 1984, 1968,  232,
 /*  2000 */   309, 1951,  618, 1953, 1954,  613,  615,  608,  342,  153,
 /*  2010 */  1949, 1919,  238,  614, 1984, 1968, 1544,  301, 1951,  618,
 /*  2020 */  1953, 1954,  613,  615,  608,  161,  544, 1537, 1919,  244,
 /*  2030 */   614,  242,   27, 1940,   84, 1950, 1949,   61,   19, 1575,
 /*  2040 */  1984, 1574,  346,  314, 1951,  618, 1953, 1954,  613, 1580,
 /*  2050 */   608, 1581, 1579, 1949, 1578,  347, 1512, 1984,  256, 1511,
 /*  2060 */   315, 1951,  618, 1953, 1954,  613, 1968,  608,   55,  164,
 /*  2070 */  1871, 1869, 1868,   20,  615,  589, 1857,  263, 1950, 1919,
 /*  2080 */   261,  614, 1542,   15,   54,  268,   86,   87,   89,  273,
 /*  2090 */    93,  270,   10,   21, 1950, 1464,    8, 1463, 1987, 1389,
 /*  2100 */  1442,  607,  165,  177, 1949, 1440,   34, 1474, 1984, 1968,
 /*  2110 */  1439, 1962, 1951,  618, 1953, 1954,  613,  615,  608,   13,
 /*  2120 */  1420,   22, 1919, 1412,  614, 1968,  617,   23,  619, 1235,
 /*  2130 */   621,  362,  623,  615, 1232,  625,  626,  628, 1919,  629,
 /*  2140 */   614, 1229, 1223,  631, 1221, 1950,  632, 1949,  634,  635,
 /*  2150 */  1227, 1984, 1212, 1226, 1961, 1951,  618, 1953, 1954,  613,
 /*  2160 */   641,  608,   94, 1949,  276,   95, 1225, 1984, 1244,   68,
 /*  2170 */  1960, 1951,  618, 1953, 1954,  613, 1968,  608, 1224, 1240,
 /*  2180 */  1124,  651, 1159, 1158,  615, 1157, 1156, 1155, 1950, 1919,
 /*  2190 */  1154,  614, 1179, 1152, 1150, 1149, 1148,  663,  277, 1146,
 /*  2200 */  1145, 1144, 1143, 1142, 1141, 1950, 1140, 1139, 1176, 1174,
 /*  2210 */  1136, 1135, 1132, 1131, 1949, 1130, 1659, 1129, 1984, 1968,
 /*  2220 */   684,  326, 1951,  618, 1953, 1954,  613,  615,  608,  686,
 /*  2230 */  1657,  685, 1919,  688,  614,  689, 1968, 1655,  690,  692,
 /*  2240 */   693,  694, 1653,  696,  615,  697,  698, 1639,  700, 1919,
 /*  2250 */  1082,  614, 1619,  280,  704,  708, 1375, 1949, 1950, 1594,
 /*  2260 */   290, 1984,  707, 1594,  327, 1951,  618, 1953, 1954,  613,
 /*  2270 */  1594,  608, 1594, 1594, 1949, 1950, 1594, 1594, 1984, 1594,
 /*  2280 */  1594,  323, 1951,  618, 1953, 1954,  613, 1594,  608, 1968,
 /*  2290 */  1594, 1594, 1594, 1594, 1594, 1594, 1594,  615, 1594, 1594,
 /*  2300 */  1594, 1594, 1919, 1594,  614, 1594, 1968, 1594, 1594, 1594,
 /*  2310 */  1594, 1594, 1594, 1594,  615, 1594, 1594, 1594, 1594, 1919,
 /*  2320 */  1594,  614, 1594, 1594, 1594, 1594, 1950, 1949, 1594, 1594,
 /*  2330 */  1594, 1984, 1594, 1594,  328, 1951,  618, 1953, 1954,  613,
 /*  2340 */  1594,  608, 1594, 1594,  616, 1594, 1594, 1594, 1984, 1594,
 /*  2350 */  1594,  306, 1951,  618, 1953, 1954,  613, 1968,  608, 1594,
 /*  2360 */  1594, 1594, 1594, 1594, 1594,  615, 1594, 1594, 1594, 1594,
 /*  2370 */  1919, 1594,  614, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*  2380 */  1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594, 1594,
 /*  2390 */  1594, 1594, 1594, 1594, 1594, 1949, 1594, 1594, 1594, 1984,
 /*  2400 */  1594, 1594,  305, 1951,  618, 1953, 1954,  613, 1594,  608,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   325,  329,  340,  331,  332,  427,  356,  345,  329,  431,
 /*    10 */   331,  332,   12,   13,   14,  367,    0,  427,  370,  371,
 /*    20 */    20,  431,   22,    0,  446,  447,  333,  377,  378,  451,
 /*    30 */   452,  356,  358,   33,  333,   35,    0,  447,   22,  364,
 /*    40 */   347,  451,  452,  369,  369,  385,  371,   24,   25,   26,
 /*    50 */    27,   28,   29,   30,   31,   32,   14,  364,   58,   20,
 /*    60 */     8,    9,   20,   63,   12,   13,   14,   15,   16,  394,
 /*    70 */    70,  397,  398,  398,  373,   20,  401,  402,  403,  404,
 /*    80 */   405,  406,  408,  408,   58,   20,   14,  427,  413,  358,
 /*    90 */   415,  431,   20,   62,  419,  420,   96,  400,   14,  325,
 /*   100 */   369,   65,   66,   67,   20,  356,  446,  447,  433,   73,
 /*   110 */    74,  451,  452,  364,   78,   79,  441,  324,  118,  326,
 /*   120 */    84,   85,   96,  426,   98,   20,   90,  333,  397,  398,
 /*   130 */   356,   20,    4,  133,  134,   20,  322,   22,  364,  408,
 /*   140 */   427,  347,  364,  369,  431,  371,   12,   13,  354,   97,
 /*   150 */    35,   96,  403,  375,   20,    0,   22,   20,  364,  325,
 /*   160 */   447,   96,  162,  163,  451,  452,   51,   33,  394,   35,
 /*   170 */   333,   43,  398,   45,   46,  401,  402,  403,  404,  405,
 /*   180 */   406,  181,  408,  183,  347,  411,    4,  413,  414,  415,
 /*   190 */   356,  354,   58,  419,  420,  416,  417,   63,  364,  385,
 /*   200 */    20,  364,   62,  369,   70,  371,  206,  207,   20,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  394,  337,
 /*   230 */    96,    3,  398,  325,  162,  401,  402,  403,  404,  405,
 /*   240 */   406,  427,  408,  351,   20,  431,  162,  413,   20,  415,
 /*   250 */   167,  359,  118,  419,  420,   12,   13,   14,   15,   16,
 /*   260 */   446,  447,  229,  108,  356,  451,  452,  133,  134,  370,
 /*   270 */   371,  245,  364,  162,  163,  441,   96,  369,   96,  371,
 /*   280 */    12,   13,  127,  128,  129,  130,  131,  132,   20,   20,
 /*   290 */    22,   96,   20,  325,  342,  343,  162,  163,  325,  333,
 /*   300 */   245,   33,  394,   35,  330,  333,  398,  333,  334,  401,
 /*   310 */   402,  403,  404,  405,  406,  181,  408,  183,  128,  347,
 /*   320 */   107,  413,  355,  415,  356,   97,   58,  419,  420,  161,
 /*   330 */   364,   63,  364,  250,  251,  368,  364,  369,   70,  371,
 /*   340 */   206,  207,  369,  209,  210,  211,  212,  213,  214,  215,
 /*   350 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   360 */   226,  227,  394,  229,   96,  325,  398,  342,  343,  401,
 /*   370 */   402,  403,  404,  405,  406,  180,  408,  182,  188,  189,
 /*   380 */    96,  413,  192,  415,  194,  339,  118,  419,  420,  423,
 /*   390 */   424,  425,  164,  427,  428,   80,  356,  431,  430,  353,
 /*   400 */   232,  133,  134,  389,  364,  133,  134,   22,  362,  369,
 /*   410 */   242,  371,  446,  447,   12,   13,   14,  451,  452,  371,
 /*   420 */    35,   70,   20,    0,   22,  245,   96,  245,  364,  381,
 /*   430 */   162,  163,  384,  164,  394,   33,   58,   35,  398,  375,
 /*   440 */   245,  401,  402,  403,  404,  405,  406,  108,  408,  181,
 /*   450 */   410,  183,  330,  138,  139,  333,  334,    8,    9,   70,
 /*   460 */    58,   12,   13,   14,   15,   16,  127,  128,  129,  130,
 /*   470 */   131,  132,   70,   95,  206,  207,   98,  209,  210,  211,
 /*   480 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   490 */   222,  223,  224,  225,  226,  227,  333,  325,   96,  333,
 /*   500 */   357,  325,  356,   65,   66,   67,   20,  333,  356,  363,
 /*   510 */   347,   73,   74,  347,  357,  363,   78,   79,  372,  325,
 /*   520 */   118,  347,   84,   85,  372,  348,  348,  364,   90,  245,
 /*   530 */   364,  108,  356,  356,  356,  133,  134,   20,  364,   22,
 /*   540 */   364,  369,  365,  365,   21,  369,   97,  371,   12,   13,
 /*   550 */   127,  128,  129,  130,  131,  132,   20,   34,   22,   36,
 /*   560 */   357,  325,  333,  369,  162,  163,  176,   35,   51,   33,
 /*   570 */   394,   35,  333,  333,  398,  245,  347,  401,  402,  403,
 /*   580 */   404,  405,  406,  181,  408,  183,  347,  197,  198,  413,
 /*   590 */   357,  415,  356,  364,   58,  419,  420,  127,  357,  229,
 /*   600 */   364,  231,   70,  364,  364,  369,   70,  371,  206,  207,
 /*   610 */   339,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   620 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   630 */   394,  356,   96,  362,  398,  348,   63,  401,  402,  403,
 /*   640 */   404,  405,  406,  356,  408,  127,  128,  325,  162,  413,
 /*   650 */   132,  415,  365,  378,  118,  419,  420,  325,  325,    0,
 /*   660 */   190,  191,  422,  423,  424,  425,  430,  427,  428,  133,
 /*   670 */   134,    8,    9,   39,    2,   12,   13,   14,   15,   16,
 /*   680 */     8,    9,   12,   13,   12,   13,   14,   15,   16,  356,
 /*   690 */    20,  369,   22,  337,  333,  333,  379,  364,  162,  163,
 /*   700 */   325,  369,  369,   33,  371,   35,  356,   44,  347,  347,
 /*   710 */    14,   15,   16,  363,  412,  359,  414,  181,  412,  183,
 /*   720 */   414,   62,  372,  357,  356,  364,  364,  394,   58,  349,
 /*   730 */   325,  398,  352,  365,  401,  402,  403,  404,  405,  406,
 /*   740 */    70,  408,  206,  207,  369,  209,  210,  211,  212,  213,
 /*   750 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   760 */   224,  225,  226,  227,    8,    9,   96,  325,   12,   13,
 /*   770 */    14,   15,   16,  364,  369,  442,  443,  427,  206,  206,
 /*   780 */    18,  431,   20,  400,  375,  333,  357,  325,  118,   27,
 /*   790 */   325,  325,   30,    0,  325,   33,  446,  447,  356,  347,
 /*   800 */     0,  451,  452,  133,  134,  325,  364,  326,  325,  426,
 /*   810 */    48,  369,   50,  371,   21,   53,  364,   24,   25,   26,
 /*   820 */    27,   28,   29,   30,   31,   32,  254,  255,  256,  257,
 /*   830 */   258,  369,  162,  163,  369,  369,  394,  344,  369,  346,
 /*   840 */   398,  333,  333,  401,  402,  403,  404,  405,  406,  369,
 /*   850 */   408,  181,  369,  183,  325,  347,  347,   95,    0,    8,
 /*   860 */     9,    4,   62,   12,   13,   14,   15,   16,    3,  107,
 /*   870 */    20,   20,  364,  364,  400,  325,  206,  207,  244,  209,
 /*   880 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   890 */   220,  221,  222,  223,  224,  225,  226,  227,  369,  137,
 /*   900 */   426,  345,  140,  141,  142,  143,  144,  145,  146,  147,
 /*   910 */   148,  149,  150,  151,  152,  153,  154,  155,  156,  369,
 /*   920 */   158,  159,  160,   65,   66,   67,   68,   69,   44,   71,
 /*   930 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   940 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   950 */    92,   18,  325,  325,  333,  325,   23,    8,    9,   12,
 /*   960 */    13,   12,   13,   14,   15,   16,  325,  325,  347,   22,
 /*   970 */    37,   38,  333,  411,   41,  366,  414,  455,  369,   20,
 /*   980 */    33,   97,   35,    8,    9,  364,  347,   12,   13,   14,
 /*   990 */    15,   16,   59,   60,   61,  371,  369,  369,  356,  369,
 /*  1000 */     1,    2,   37,  364,  366,   58,  364,  369,  384,  444,
 /*  1010 */   369,  369,   63,  371,  164,  164,   44,   70,  109,  110,
 /*  1020 */   111,  112,  113,  114,  115,  116,  117,  118,  119,   96,
 /*  1030 */   121,  122,  123,  124,  125,  126,  394,  335,  349,  333,
 /*  1040 */   398,  352,  356,  401,  402,  403,  404,  405,  406,  366,
 /*  1050 */   408,  385,  369,  347,  105,  413,  100,  415,  372,  103,
 /*  1060 */    33,  419,  420,   19,   99,  118,  101,  102,  135,  104,
 /*  1070 */   364,  438,  430,  108,  333,   48,    0,   33,   22,   45,
 /*  1080 */    46,   54,   55,   56,   57,   58,  243,  244,  347,    0,
 /*  1090 */   333,   35,   48,  427,  108,  130,   97,  431,   54,   55,
 /*  1100 */    56,   57,   58,  246,  347,  364,  173,  174,  175,  333,
 /*  1110 */   161,  178,  446,  447,  107,   44,  130,  451,  452,  333,
 /*  1120 */    35,  364,   95,  164,   48,   98,   70,  262,  181,  196,
 /*  1130 */   183,  356,  199,  347,  201,  202,  203,  204,  205,   95,
 /*  1140 */   364,   42,   98,   44,   42,   35,   44,  335,  173,   44,
 /*  1150 */   364,  379,   21,  206,  207,   24,   25,   26,   27,   28,
 /*  1160 */    29,   30,   31,   32,  157,  218,  219,  220,  221,  222,
 /*  1170 */   223,  224,   44,  100,  118,  131,  103,  325,  245,   44,
 /*  1180 */   333,  232,  233,  234,  235,  236,  237,  238,  239,  240,
 /*  1190 */   241,  242,  165,  166,  347,  168,    0,    0,  171,  423,
 /*  1200 */   424,  425,   97,  427,  428,  325,  100,  100,  356,  103,
 /*  1210 */   103,  364,  168,   44,  187,  164,  364,   44,   22,   22,
 /*  1220 */   169,  369,   44,  371,   58,   97,  133,  134,   47,  185,
 /*  1230 */    96,  187,   97,    1,    2,  332,  356,  181,  266,  183,
 /*  1240 */   106,  152,  267,   44,  364,   35,  394,   13,  325,  369,
 /*  1250 */   398,  371,  379,  401,  402,  403,  404,  405,  406,   44,
 /*  1260 */   408,   44,  206,  207,   98,  413,   97,  415,  183,   35,
 /*  1270 */    97,  419,  420,  368,  394,   97,  325,   96,  398,  356,
 /*  1280 */    70,  401,  402,  403,  404,  405,  406,  364,  408,  429,
 /*  1290 */   448,    2,  369,  183,  371,  415,   97,    8,    9,  419,
 /*  1300 */   420,   12,   13,   14,   15,   16,  421,  356,   44,   44,
 /*  1310 */   432,   44,   97,  247,   97,  364,   44,  394,   13,  325,
 /*  1320 */   369,  398,  371,    0,  401,  402,  403,  404,  405,  406,
 /*  1330 */   396,  408,   44,   48,  395,  264,   44,  325,  415,  179,
 /*  1340 */    35,  387,  419,  420,   42,  394,  376,   20,  379,  398,
 /*  1350 */   356,  161,  401,  402,  403,  404,  405,  406,  364,  408,
 /*  1360 */   376,   97,   97,  369,   97,  371,  415,  374,  356,   97,
 /*  1370 */   419,  420,   49,   20,  333,  333,  364,  376,  374,  374,
 /*  1380 */   325,  369,  333,  371,   94,   97,  341,  333,  394,   97,
 /*  1390 */   333,   20,  398,    4,  327,  401,  402,  403,  404,  405,
 /*  1400 */   406,  407,  408,  409,  410,  327,  394,   20,   19,  391,
 /*  1410 */   398,  356,   20,  401,  402,  403,  404,  405,  406,  364,
 /*  1420 */   408,  339,   33,  371,  369,  339,  371,   20,  358,  334,
 /*  1430 */   339,  334,  386,  325,   52,  339,  333,   48,  369,  369,
 /*  1440 */   339,  358,   53,  339,  327,  195,  356,   58,  336,  394,
 /*  1450 */   339,  336,  369,  398,  325,  333,  401,  402,  403,  404,
 /*  1460 */   405,  406,  337,  408,  356,  453,  454,  397,  398,  399,
 /*  1470 */   415,  327,  364,  393,  356,  420,  356,  369,  408,  371,
 /*  1480 */   397,  398,  399,  385,   95,  356,  356,   98,  356,  356,
 /*  1490 */   369,  408,  356,  364,  385,  356,  356,  356,  369,  356,
 /*  1500 */   371,  186,  394,  333,  391,  337,  398,  369,  325,  401,
 /*  1510 */   402,  403,  404,  405,  406,  253,  408,  390,  371,  382,
 /*  1520 */   252,  379,  333,  394,  379,  427,  369,  398,  369,  431,
 /*  1530 */   401,  402,  403,  404,  405,  406,  427,  408,  382,  356,
 /*  1540 */   431,  369,  259,  261,  446,  447,  172,  364,  248,  451,
 /*  1550 */   452,  443,  369,  364,  371,  446,  447,  260,  435,  440,
 /*  1560 */   451,  452,  325,    8,    9,  439,  268,   12,   13,   14,
 /*  1570 */    15,   16,  396,  244,  445,  265,  263,  394,  364,  325,
 /*  1580 */   456,  398,  434,  437,  401,  402,  403,  404,  405,  406,
 /*  1590 */   437,  408,  437,  356,  436,   20,  333,  337,  361,  450,
 /*  1600 */   449,  364,  400,  334,  382,  325,  369,  369,  371,  369,
 /*  1610 */   356,  369,  423,  424,  425,  361,  427,  428,  364,  166,
 /*  1620 */   369,  369,  369,  369,  337,  371,  382,  380,  352,   96,
 /*  1630 */   337,  394,   96,  325,  364,  398,  356,  454,  401,  402,
 /*  1640 */   403,  404,  405,  406,  364,  408,  418,  369,  394,  369,
 /*  1650 */   346,  371,  398,  333,  360,  401,  402,  403,  404,  405,
 /*  1660 */   406,  337,  408,   36,  356,  328,  327,  388,  350,  361,
 /*  1670 */   338,  350,  364,  392,  394,  350,  325,  369,  398,  371,
 /*  1680 */   323,  401,  402,  403,  404,  405,  406,    0,  408,  383,
 /*  1690 */   383,    0,  325,  188,    0,    0,   42,    0,   35,  200,
 /*  1700 */    35,   35,  394,   35,  200,    0,  398,  356,   35,  401,
 /*  1710 */   402,  403,  404,  405,  406,  364,  408,   35,  200,  164,
 /*  1720 */   369,    0,  371,  356,  200,    0,    0,   35,   22,    0,
 /*  1730 */   183,  364,  181,   35,    0,  385,  369,    0,  371,  177,
 /*  1740 */   176,    0,    0,  325,    0,  394,   47,    0,    0,  398,
 /*  1750 */    42,    0,  401,  402,  403,  404,  405,  406,    0,  408,
 /*  1760 */     0,  394,    0,    0,    0,  398,    0,    0,  401,  402,
 /*  1770 */   403,  404,  405,  406,  356,  408,  152,  427,   35,    0,
 /*  1780 */   152,  431,  364,    0,    0,    0,  325,  369,    0,  371,
 /*  1790 */     0,    0,    0,    0,    0,    0,  446,  447,    0,    0,
 /*  1800 */     0,  451,  452,  325,    0,    0,    0,   42,    0,    0,
 /*  1810 */     0,    0,  394,    0,    0,    0,  398,  356,   22,  401,
 /*  1820 */   402,  403,  404,  405,  406,  364,  408,    0,    0,  136,
 /*  1830 */   369,    0,  371,   58,  356,    0,   35,    0,   58,    0,
 /*  1840 */    14,   44,  364,   14,   42,    0,   39,  369,    0,  371,
 /*  1850 */    47,    0,   40,    0,    0,  394,  325,   39,   39,  398,
 /*  1860 */   172,    0,  401,  402,  403,  404,  405,  406,   47,  408,
 /*  1870 */    47,    0,  394,  325,    0,    0,  398,   35,   48,  401,
 /*  1880 */   402,  403,  404,  405,  406,   39,  408,  356,   64,    0,
 /*  1890 */    35,   48,    0,   35,    0,  364,   39,   48,   39,   35,
 /*  1900 */   369,   39,  371,    0,  356,    0,    0,    0,   48,   22,
 /*  1910 */     0,   35,  364,   35,   35,   22,   35,  369,   35,  371,
 /*  1920 */   103,  105,   22,   35,  325,  394,   44,    0,   44,  398,
 /*  1930 */    35,   35,  401,  402,  403,  404,  405,  406,   22,  408,
 /*  1940 */     0,  325,  394,   22,    0,   22,  398,   50,   35,  401,
 /*  1950 */   402,  403,  404,  405,  406,  356,  408,    0,    0,   35,
 /*  1960 */    35,    0,   97,  364,   22,   20,   35,  325,  369,   35,
 /*  1970 */   371,  193,  356,   96,    0,    0,   35,   22,    0,    0,
 /*  1980 */   364,   44,  249,    3,  325,  369,  164,  371,   97,  249,
 /*  1990 */    44,   44,   44,  394,   96,   96,  164,  398,  356,  166,
 /*  2000 */   401,  402,  403,  404,  405,  406,  364,  408,  164,  184,
 /*  2010 */   394,  369,   97,  371,  398,  356,   97,  401,  402,  403,
 /*  2020 */   404,  405,  406,  364,  408,   96,  170,   97,  369,   47,
 /*  2030 */   371,   96,   96,   47,   96,  325,  394,    3,   44,   35,
 /*  2040 */   398,   35,   35,  401,  402,  403,  404,  405,  406,   97,
 /*  2050 */   408,   97,   35,  394,   35,   35,   97,  398,   47,   97,
 /*  2060 */   401,  402,  403,  404,  405,  406,  356,  408,   44,   47,
 /*  2070 */     0,    0,    0,   96,  364,  167,    0,   96,  325,  369,
 /*  2080 */    97,  371,   97,  249,  243,   96,   96,   39,   96,   47,
 /*  2090 */   106,  165,    2,   44,  325,  228,  230,  228,   96,   22,
 /*  2100 */    97,   96,   47,   47,  394,   97,   96,  206,  398,  356,
 /*  2110 */    97,  401,  402,  403,  404,  405,  406,  364,  408,   96,
 /*  2120 */    22,   96,  369,   97,  371,  356,  208,   96,  107,   97,
 /*  2130 */    35,   35,   96,  364,   97,   35,   96,   35,  369,   96,
 /*  2140 */   371,   97,   97,   35,   97,  325,   96,  394,   35,   96,
 /*  2150 */   120,  398,   22,  120,  401,  402,  403,  404,  405,  406,
 /*  2160 */   108,  408,   96,  394,   44,   96,  120,  398,   35,   96,
 /*  2170 */   401,  402,  403,  404,  405,  406,  356,  408,  120,   22,
 /*  2180 */    64,   63,   35,   35,  364,   35,   35,   35,  325,  369,
 /*  2190 */    35,  371,   70,   35,   35,   35,   35,   93,   44,   35,
 /*  2200 */    35,   22,   35,   22,   35,  325,   35,   35,   70,   35,
 /*  2210 */    35,   35,   35,   35,  394,   22,    0,   35,  398,  356,
 /*  2220 */    35,  401,  402,  403,  404,  405,  406,  364,  408,   39,
 /*  2230 */     0,   48,  369,   35,  371,   48,  356,    0,   39,   35,
 /*  2240 */    48,   39,    0,   35,  364,   48,   39,    0,   35,  369,
 /*  2250 */    35,  371,    0,   22,   21,   20,   22,  394,  325,  457,
 /*  2260 */    22,  398,   21,  457,  401,  402,  403,  404,  405,  406,
 /*  2270 */   457,  408,  457,  457,  394,  325,  457,  457,  398,  457,
 /*  2280 */   457,  401,  402,  403,  404,  405,  406,  457,  408,  356,
 /*  2290 */   457,  457,  457,  457,  457,  457,  457,  364,  457,  457,
 /*  2300 */   457,  457,  369,  457,  371,  457,  356,  457,  457,  457,
 /*  2310 */   457,  457,  457,  457,  364,  457,  457,  457,  457,  369,
 /*  2320 */   457,  371,  457,  457,  457,  457,  325,  394,  457,  457,
 /*  2330 */   457,  398,  457,  457,  401,  402,  403,  404,  405,  406,
 /*  2340 */   457,  408,  457,  457,  394,  457,  457,  457,  398,  457,
 /*  2350 */   457,  401,  402,  403,  404,  405,  406,  356,  408,  457,
 /*  2360 */   457,  457,  457,  457,  457,  364,  457,  457,  457,  457,
 /*  2370 */   369,  457,  371,  457,  457,  457,  457,  457,  457,  457,
 /*  2380 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2390 */   457,  457,  457,  457,  457,  394,  457,  457,  457,  398,
 /*  2400 */   457,  457,  401,  402,  403,  404,  405,  406,  457,  408,
 /*  2410 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2420 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2430 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2440 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2450 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2460 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2470 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2480 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2490 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2500 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2510 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2520 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2530 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2540 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2550 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2560 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2570 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*  2580 */   457,  457,  457,  457,  457,
};
#define YY_SHIFT_COUNT    (709)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2252)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   933,    0,  134,    0,  268,  268,  268,  268,  268,  268,
 /*    10 */   268,  268,  268,  402,  536,  536,  670,  536,  536,  536,
 /*    20 */   536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
 /*    30 */   536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
 /*    40 */   536,  536,  536,  536,  536,  536,   55,  180,   65,  195,
 /*    50 */    26,  284,  330,  284,   65,   65,  947,  947,  284,  947,
 /*    60 */   947,  182,  284,   39,   39,  128,  128,  111,  272,   42,
 /*    70 */    42,   39,   39,   39,   39,   39,   39,   39,   39,   39,
 /*    80 */    39,   31,   39,   39,  105,   39,  137,   39,   39,  188,
 /*    90 */    39,   39,  188,   39,  188,  188,  188,   39,  140,  762,
 /*   100 */   949,  949,  438, 1131, 1056, 1056, 1056, 1056, 1056, 1056,
 /*   110 */  1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056,
 /*   120 */  1056, 1056, 1056,  965,  228,  111,  272,  659,  532,  269,
 /*   130 */   269,  269,  800,  370,  370,  532,  224,  224,  224,  213,
 /*   140 */   137,   33,  188,  351,  188,  351,  351,  213,  389,  909,
 /*   150 */   909,  909,  909,  909,  909,  909, 1044,   36,  793,  851,
 /*   160 */   975,  572,  115,   83,   72,   84,  517,  850, 1034,  986,
 /*   170 */   959,  843,  634,  865,  843, 1099,  857,  486, 1066, 1285,
 /*   180 */  1160, 1302, 1327, 1302, 1190, 1353, 1353, 1302, 1190, 1190,
 /*   190 */  1290, 1353, 1353, 1353, 1371, 1371, 1387,   31,  137,   31,
 /*   200 */  1392, 1407,   31, 1392,   31,   31,   31, 1353,   31, 1382,
 /*   210 */  1382, 1371,  188,  188,  188,  188,  188,  188,  188,  188,
 /*   220 */   188,  188,  188, 1353, 1371,  351,  351, 1250, 1387,  140,
 /*   230 */  1315,  137,  140, 1353, 1327, 1327,  351, 1262, 1268,  351,
 /*   240 */  1262, 1268,  351,  351,  188, 1283, 1374, 1262, 1282, 1297,
 /*   250 */  1300, 1066, 1298, 1310, 1313, 1329,  224, 1575, 1353, 1392,
 /*   260 */   140, 1268,  351,  351,  351,  351,  351, 1268,  351, 1453,
 /*   270 */   140,  213,  140,  224, 1533, 1536,  351,  389, 1353,  140,
 /*   280 */  1627, 1371, 2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
 /*   290 */  2410,  858, 1027,   23, 1389,   52,  663,  449,  155,  672,
 /*   300 */  1289, 1555,  423,  756,  756,  756,  756,  756,  756,  756,
 /*   310 */   756,  756,  339,  190,  243,  243,  390,  378,  315,  523,
 /*   320 */   470,  518,  518,  696,  999,  168,  696,  696,  696,  884,
 /*   330 */  1076,  385, 1102, 1007, 1089,  956, 1073, 1106, 1107,   16,
 /*   340 */  1196, 1197, 1166, 1105, 1128, 1093, 1071,  972, 1051, 1135,
 /*   350 */  1169, 1173, 1178, 1199, 1232, 1215, 1085, 1110,  573, 1217,
 /*   360 */  1181, 1264, 1265, 1267, 1272, 1288, 1292, 1134, 1234, 1305,
 /*   370 */  1210, 1323, 1687, 1691, 1505, 1694, 1695, 1654, 1697, 1663,
 /*   380 */  1499, 1665, 1666, 1668, 1504, 1705, 1673, 1682, 1518, 1721,
 /*   390 */  1524, 1725, 1692, 1726, 1706, 1729, 1698, 1547, 1551, 1734,
 /*   400 */  1737, 1562, 1564, 1741, 1742, 1699, 1744, 1747, 1748, 1708,
 /*   410 */  1751, 1758, 1760, 1762, 1763, 1764, 1766, 1767, 1624, 1743,
 /*   420 */  1779, 1628, 1783, 1784, 1785, 1788, 1790, 1791, 1792, 1793,
 /*   430 */  1794, 1795, 1798, 1799, 1800, 1804, 1805, 1765, 1806, 1808,
 /*   440 */  1809, 1810, 1811, 1796, 1813, 1814, 1815, 1693, 1827, 1828,
 /*   450 */  1801, 1831, 1775, 1835, 1780, 1837, 1839, 1802, 1807, 1797,
 /*   460 */  1803, 1826, 1821, 1829, 1823, 1845, 1812, 1818, 1848, 1851,
 /*   470 */  1853, 1819, 1688, 1854, 1861, 1871, 1824, 1874, 1875, 1842,
 /*   480 */  1830, 1846, 1889, 1855, 1843, 1857, 1892, 1858, 1849, 1859,
 /*   490 */  1894, 1864, 1860, 1862, 1903, 1905, 1906, 1907, 1816, 1817,
 /*   500 */  1876, 1887, 1910, 1878, 1879, 1893, 1881, 1883, 1882, 1884,
 /*   510 */  1888, 1895, 1900, 1896, 1927, 1916, 1940, 1921, 1897, 1944,
 /*   520 */  1923, 1913, 1957, 1924, 1958, 1925, 1961, 1942, 1945, 1931,
 /*   530 */  1934, 1778, 1865, 1877, 1974, 1822, 1941, 1975, 1825, 1955,
 /*   540 */  1832, 1833, 1978, 1979, 1844, 1856, 1980, 1937, 1733, 1898,
 /*   550 */  1891, 1899, 1915, 1946, 1919, 1929, 1935, 1936, 1930, 1947,
 /*   560 */  1982, 1986, 1938, 1948, 1740, 1952, 1954, 2034, 1994, 1834,
 /*   570 */  2004, 2006, 2007, 2017, 2019, 2020, 1959, 1962, 2011, 1841,
 /*   580 */  2024, 2022, 2070, 2071, 2072, 1977, 1983, 1985, 1981, 1989,
 /*   590 */  1908, 1990, 2076, 2048, 1926, 1992, 1984, 1803, 2042, 2049,
 /*   600 */  1867, 1866, 1869, 2090, 2077, 1901, 2002, 2003, 2005, 2008,
 /*   610 */  2010, 2013, 2055, 2023, 2025, 2056, 2026, 2098, 1918, 2031,
 /*   620 */  2021, 2032, 2095, 2096, 2036, 2037, 2100, 2040, 2044, 2102,
 /*   630 */  2043, 2045, 2108, 2050, 2047, 2113, 2053, 2030, 2033, 2046,
 /*   640 */  2058, 2130, 2052, 2066, 2120, 2069, 2133, 2073, 2120, 2120,
 /*   650 */  2157, 2116, 2118, 2147, 2148, 2150, 2151, 2152, 2155, 2158,
 /*   660 */  2159, 2160, 2161, 2122, 2104, 2154, 2164, 2165, 2179, 2167,
 /*   670 */  2181, 2169, 2171, 2172, 2138, 1882, 2174, 1884, 2175, 2176,
 /*   680 */  2177, 2178, 2193, 2182, 2216, 2185, 2183, 2190, 2230, 2198,
 /*   690 */  2187, 2199, 2237, 2204, 2192, 2202, 2242, 2208, 2197, 2207,
 /*   700 */  2247, 2213, 2215, 2252, 2231, 2233, 2234, 2238, 2241, 2235,
};
#define YY_REDUCE_COUNT (290)
#define YY_REDUCE_MIN   (-422)
#define YY_REDUCE_MAX   (2001)
static const short yy_reduce_ofst[] = {
 /*     0 */  -186, -325, -226, -166,  -32,  236,  642,  -92,  176,  852,
 /*    10 */   880,  923,  951,  994,  333, 1012, 1055, 1108, 1129, 1183,
 /*    20 */  1237,   40, 1254, 1308,  442, 1280, 1351, 1367, 1418, 1461,
 /*    30 */  1478, 1531, 1548, 1599, 1616, 1642, 1659, 1710, 1753, 1769,
 /*    40 */  1820, 1863, 1880, 1933, 1950, 2001,  -34,  350,  240, -340,
 /*    50 */   666, 1098, 1109, 1350,  776, 1189, 1070, 1083, -422, -326,
 /*    60 */  -269, -410, -287, -206, -163, -328, -321, -350, -352,  -26,
 /*    70 */   122, -307,  -28,  163,  166,  174,  229,  239,  361,  362,
 /*    80 */   452,   46,  508,  621, -251,  639,   48,  706,  741,  177,
 /*    90 */   757,  786,  146,  847,  178,  152,  287,  509, -108, -299,
 /*   100 */  -221, -221, -338, -207,  -27,  172,  194,  322,  332,  375,
 /*   110 */   405,  462,  465,  466,  469,  480,  483,  529,  550,  627,
 /*   120 */   628,  630,  641,  -33, -303,  275, -101,  271,  -48, -303,
 /*   130 */   383,  474,  356,  302,  306,   25, -222,   64,  409,  380,
 /*   140 */   624,  562,  368,  609,  686,  638,  683,  689,  493,  143,
 /*   150 */   157,  203,  233,  241,  366,  429,   14,  556,  481,  317,
 /*   160 */   522,  565,  702,  633,  775,  775,  812,  772,  903,  905,
 /*   170 */   873,  860,  860,  842,  860,  885,  878,  775,  934,  939,
 /*   180 */   954,  970,  969,  984,  993, 1041, 1042, 1001, 1004, 1005,
 /*   190 */  1045, 1049, 1054, 1057, 1067, 1078, 1018, 1082, 1052, 1086,
 /*   200 */  1095, 1046, 1091, 1097, 1096, 1101, 1104, 1103, 1111, 1112,
 /*   210 */  1115, 1117, 1090, 1118, 1120, 1130, 1132, 1133, 1136, 1139,
 /*   220 */  1140, 1141, 1143, 1122, 1144, 1069, 1121, 1080, 1113, 1125,
 /*   230 */  1127, 1147, 1168, 1170, 1142, 1145, 1138, 1146, 1137, 1157,
 /*   240 */  1153, 1156, 1159, 1172,  775, 1119, 1126, 1155, 1158, 1123,
 /*   250 */  1148, 1176, 1124, 1149, 1151,  860, 1214, 1202, 1263, 1269,
 /*   260 */  1260, 1222, 1238, 1240, 1242, 1251, 1252, 1244, 1253, 1247,
 /*   270 */  1287, 1276, 1293, 1270, 1228, 1294, 1278, 1304, 1320, 1324,
 /*   280 */  1337, 1339, 1279, 1281, 1306, 1307, 1318, 1321, 1325, 1332,
 /*   290 */  1357,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*    10 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*    20 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*    30 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*    40 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*    50 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*    60 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1849, 1592, 1592,
 /*    70 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*    80 */  1592, 1670, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*    90 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1668, 1842,
 /*   100 */  2039, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   110 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   120 */  1592, 1592, 1592, 1592, 2051, 1592, 1592, 1670, 1592, 2051,
 /*   130 */  2051, 2051, 1668, 2011, 2011, 1592, 1592, 1592, 1592, 1779,
 /*   140 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1779, 1592, 1592,
 /*   150 */  1592, 1592, 1592, 1592, 1592, 1592, 1886, 1592, 1592, 2076,
 /*   160 */  2129, 1592, 1592, 2079, 1592, 1592, 1592, 1854, 1592, 1732,
 /*   170 */  2066, 2043, 2057, 2113, 2044, 2041, 2060, 1592, 2070, 1592,
 /*   180 */  1879, 1847, 1592, 1847, 1844, 1592, 1592, 1847, 1844, 1844,
 /*   190 */  1723, 1592, 1592, 1592, 1592, 1592, 1592, 1670, 1592, 1670,
 /*   200 */  1592, 1592, 1670, 1592, 1670, 1670, 1670, 1592, 1670, 1649,
 /*   210 */  1649, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   220 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1899, 1592, 1668,
 /*   230 */  1888, 1592, 1668, 1592, 1592, 1592, 1592, 2086, 2084, 1592,
 /*   240 */  2086, 2084, 1592, 1592, 1592, 2098, 2094, 2086, 2102, 2100,
 /*   250 */  2072, 2070, 2132, 2119, 2115, 2057, 1592, 1592, 1592, 1592,
 /*   260 */  1668, 2084, 1592, 1592, 1592, 1592, 1592, 2084, 1592, 1592,
 /*   270 */  1668, 1592, 1668, 1592, 1592, 1748, 1592, 1592, 1592, 1668,
 /*   280 */  1624, 1592, 1881, 1892, 1864, 1864, 1782, 1782, 1782, 1671,
 /*   290 */  1597, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   300 */  1592, 1592, 1592, 2097, 2096, 1967, 1592, 2015, 2014, 2013,
 /*   310 */  2004, 1966, 1744, 1592, 1965, 1964, 1592, 1592, 1592, 1592,
 /*   320 */  1592, 1860, 1859, 1958, 1592, 1592, 1959, 1957, 1956, 1592,
 /*   330 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   340 */  1592, 1592, 1592, 1592, 1592, 1592, 2116, 2120, 1592, 1592,
 /*   350 */  1592, 1592, 1592, 1592, 2040, 1592, 1592, 1592, 1592, 1592,
 /*   360 */  1941, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   370 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   380 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   390 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   400 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   410 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   420 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   430 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   440 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   450 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1629,
 /*   460 */  1946, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   470 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   480 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   490 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   500 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1710, 1709,
 /*   510 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   520 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   530 */  1592, 1592, 1949, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   540 */  1592, 1592, 1592, 1592, 1592, 1592, 2112, 2073, 1592, 1592,
 /*   550 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   560 */  1592, 1941, 1592, 2095, 1592, 1592, 2110, 1592, 2114, 1592,
 /*   570 */  1592, 1592, 1592, 1592, 1592, 1592, 2050, 2046, 1592, 1592,
 /*   580 */  2042, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   590 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1940, 1592, 2001,
 /*   600 */  1592, 1592, 1592, 2035, 1592, 1592, 1986, 1592, 1592, 1592,
 /*   610 */  1592, 1592, 1592, 1592, 1592, 1592, 1949, 1592, 1952, 1592,
 /*   620 */  1592, 1592, 1592, 1592, 1776, 1592, 1592, 1592, 1592, 1592,
 /*   630 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1761, 1759, 1758,
 /*   640 */  1757, 1592, 1754, 1592, 1789, 1592, 1592, 1592, 1785, 1784,
 /*   650 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   660 */  1592, 1592, 1592, 1592, 1592, 1690, 1592, 1592, 1592, 1592,
 /*   670 */  1592, 1592, 1592, 1592, 1592, 1681, 1592, 1680, 1592, 1592,
 /*   680 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   690 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
 /*   700 */  1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592, 1592,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  269,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  269,  /*      AFTER => ABORT */
  269,  /*     ATTACH => ABORT */
  269,  /*     BEFORE => ABORT */
  269,  /*      BEGIN => ABORT */
  269,  /*     BITAND => ABORT */
  269,  /*     BITNOT => ABORT */
  269,  /*      BITOR => ABORT */
  269,  /*     BLOCKS => ABORT */
  269,  /*     CHANGE => ABORT */
  269,  /*      COMMA => ABORT */
  269,  /*    COMPACT => ABORT */
  269,  /*     CONCAT => ABORT */
  269,  /*   CONFLICT => ABORT */
  269,  /*       COPY => ABORT */
  269,  /*   DEFERRED => ABORT */
  269,  /* DELIMITERS => ABORT */
  269,  /*     DETACH => ABORT */
  269,  /*     DIVIDE => ABORT */
  269,  /*        DOT => ABORT */
  269,  /*       EACH => ABORT */
  269,  /*       FAIL => ABORT */
  269,  /*       FILE => ABORT */
  269,  /*        FOR => ABORT */
  269,  /*       GLOB => ABORT */
  269,  /*         ID => ABORT */
  269,  /*  IMMEDIATE => ABORT */
  269,  /*     IMPORT => ABORT */
  269,  /*  INITIALLY => ABORT */
  269,  /*    INSTEAD => ABORT */
  269,  /*     ISNULL => ABORT */
  269,  /*        KEY => ABORT */
  269,  /*    MODULES => ABORT */
  269,  /*  NK_BITNOT => ABORT */
  269,  /*    NK_SEMI => ABORT */
  269,  /*    NOTNULL => ABORT */
  269,  /*         OF => ABORT */
  269,  /*       PLUS => ABORT */
  269,  /*  PRIVILEGE => ABORT */
  269,  /*      RAISE => ABORT */
  269,  /*    REPLACE => ABORT */
  269,  /*   RESTRICT => ABORT */
  269,  /*        ROW => ABORT */
  269,  /*       SEMI => ABORT */
  269,  /*       STAR => ABORT */
  269,  /*  STATEMENT => ABORT */
  269,  /*     STRING => ABORT */
  269,  /*      TIMES => ABORT */
  269,  /*     UPDATE => ABORT */
  269,  /*     VALUES => ABORT */
  269,  /*   VARIABLE => ABORT */
  269,  /*       VIEW => ABORT */
  269,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "STRICT",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "TOPIC",
  /*  169 */ "WITH",
  /*  170 */ "META",
  /*  171 */ "CONSUMER",
  /*  172 */ "GROUP",
  /*  173 */ "DESC",
  /*  174 */ "DESCRIBE",
  /*  175 */ "RESET",
  /*  176 */ "QUERY",
  /*  177 */ "CACHE",
  /*  178 */ "EXPLAIN",
  /*  179 */ "ANALYZE",
  /*  180 */ "VERBOSE",
  /*  181 */ "NK_BOOL",
  /*  182 */ "RATIO",
  /*  183 */ "NK_FLOAT",
  /*  184 */ "OUTPUTTYPE",
  /*  185 */ "AGGREGATE",
  /*  186 */ "BUFSIZE",
  /*  187 */ "STREAM",
  /*  188 */ "INTO",
  /*  189 */ "TRIGGER",
  /*  190 */ "AT_ONCE",
  /*  191 */ "WINDOW_CLOSE",
  /*  192 */ "IGNORE",
  /*  193 */ "EXPIRED",
  /*  194 */ "FILL_HISTORY",
  /*  195 */ "SUBTABLE",
  /*  196 */ "KILL",
  /*  197 */ "CONNECTION",
  /*  198 */ "TRANSACTION",
  /*  199 */ "BALANCE",
  /*  200 */ "VGROUP",
  /*  201 */ "MERGE",
  /*  202 */ "REDISTRIBUTE",
  /*  203 */ "SPLIT",
  /*  204 */ "DELETE",
  /*  205 */ "INSERT",
  /*  206 */ "NULL",
  /*  207 */ "NK_QUESTION",
  /*  208 */ "NK_ARROW",
  /*  209 */ "ROWTS",
  /*  210 */ "QSTART",
  /*  211 */ "QEND",
  /*  212 */ "QDURATION",
  /*  213 */ "WSTART",
  /*  214 */ "WEND",
  /*  215 */ "WDURATION",
  /*  216 */ "IROWTS",
  /*  217 */ "CAST",
  /*  218 */ "NOW",
  /*  219 */ "TODAY",
  /*  220 */ "TIMEZONE",
  /*  221 */ "CLIENT_VERSION",
  /*  222 */ "SERVER_VERSION",
  /*  223 */ "SERVER_STATUS",
  /*  224 */ "CURRENT_USER",
  /*  225 */ "COUNT",
  /*  226 */ "LAST_ROW",
  /*  227 */ "CASE",
  /*  228 */ "END",
  /*  229 */ "WHEN",
  /*  230 */ "THEN",
  /*  231 */ "ELSE",
  /*  232 */ "BETWEEN",
  /*  233 */ "IS",
  /*  234 */ "NK_LT",
  /*  235 */ "NK_GT",
  /*  236 */ "NK_LE",
  /*  237 */ "NK_GE",
  /*  238 */ "NK_NE",
  /*  239 */ "MATCH",
  /*  240 */ "NMATCH",
  /*  241 */ "CONTAINS",
  /*  242 */ "IN",
  /*  243 */ "JOIN",
  /*  244 */ "INNER",
  /*  245 */ "SELECT",
  /*  246 */ "DISTINCT",
  /*  247 */ "WHERE",
  /*  248 */ "PARTITION",
  /*  249 */ "BY",
  /*  250 */ "SESSION",
  /*  251 */ "STATE_WINDOW",
  /*  252 */ "SLIDING",
  /*  253 */ "FILL",
  /*  254 */ "VALUE",
  /*  255 */ "NONE",
  /*  256 */ "PREV",
  /*  257 */ "LINEAR",
  /*  258 */ "NEXT",
  /*  259 */ "HAVING",
  /*  260 */ "RANGE",
  /*  261 */ "EVERY",
  /*  262 */ "ORDER",
  /*  263 */ "SLIMIT",
  /*  264 */ "SOFFSET",
  /*  265 */ "LIMIT",
  /*  266 */ "OFFSET",
  /*  267 */ "ASC",
  /*  268 */ "NULLS",
  /*  269 */ "ABORT",
  /*  270 */ "AFTER",
  /*  271 */ "ATTACH",
  /*  272 */ "BEFORE",
  /*  273 */ "BEGIN",
  /*  274 */ "BITAND",
  /*  275 */ "BITNOT",
  /*  276 */ "BITOR",
  /*  277 */ "BLOCKS",
  /*  278 */ "CHANGE",
  /*  279 */ "COMMA",
  /*  280 */ "COMPACT",
  /*  281 */ "CONCAT",
  /*  282 */ "CONFLICT",
  /*  283 */ "COPY",
  /*  284 */ "DEFERRED",
  /*  285 */ "DELIMITERS",
  /*  286 */ "DETACH",
  /*  287 */ "DIVIDE",
  /*  288 */ "DOT",
  /*  289 */ "EACH",
  /*  290 */ "FAIL",
  /*  291 */ "FILE",
  /*  292 */ "FOR",
  /*  293 */ "GLOB",
  /*  294 */ "ID",
  /*  295 */ "IMMEDIATE",
  /*  296 */ "IMPORT",
  /*  297 */ "INITIALLY",
  /*  298 */ "INSTEAD",
  /*  299 */ "ISNULL",
  /*  300 */ "KEY",
  /*  301 */ "MODULES",
  /*  302 */ "NK_BITNOT",
  /*  303 */ "NK_SEMI",
  /*  304 */ "NOTNULL",
  /*  305 */ "OF",
  /*  306 */ "PLUS",
  /*  307 */ "PRIVILEGE",
  /*  308 */ "RAISE",
  /*  309 */ "REPLACE",
  /*  310 */ "RESTRICT",
  /*  311 */ "ROW",
  /*  312 */ "SEMI",
  /*  313 */ "STAR",
  /*  314 */ "STATEMENT",
  /*  315 */ "STRING",
  /*  316 */ "TIMES",
  /*  317 */ "UPDATE",
  /*  318 */ "VALUES",
  /*  319 */ "VARIABLE",
  /*  320 */ "VIEW",
  /*  321 */ "WAL",
  /*  322 */ "cmd",
  /*  323 */ "account_options",
  /*  324 */ "alter_account_options",
  /*  325 */ "literal",
  /*  326 */ "alter_account_option",
  /*  327 */ "user_name",
  /*  328 */ "sysinfo_opt",
  /*  329 */ "privileges",
  /*  330 */ "priv_level",
  /*  331 */ "priv_type_list",
  /*  332 */ "priv_type",
  /*  333 */ "db_name",
  /*  334 */ "topic_name",
  /*  335 */ "dnode_endpoint",
  /*  336 */ "force_opt",
  /*  337 */ "not_exists_opt",
  /*  338 */ "db_options",
  /*  339 */ "exists_opt",
  /*  340 */ "alter_db_options",
  /*  341 */ "speed_opt",
  /*  342 */ "integer_list",
  /*  343 */ "variable_list",
  /*  344 */ "retention_list",
  /*  345 */ "alter_db_option",
  /*  346 */ "retention",
  /*  347 */ "full_table_name",
  /*  348 */ "column_def_list",
  /*  349 */ "tags_def_opt",
  /*  350 */ "table_options",
  /*  351 */ "multi_create_clause",
  /*  352 */ "tags_def",
  /*  353 */ "multi_drop_clause",
  /*  354 */ "alter_table_clause",
  /*  355 */ "alter_table_options",
  /*  356 */ "column_name",
  /*  357 */ "type_name",
  /*  358 */ "signed_literal",
  /*  359 */ "create_subtable_clause",
  /*  360 */ "specific_cols_opt",
  /*  361 */ "expression_list",
  /*  362 */ "drop_table_clause",
  /*  363 */ "col_name_list",
  /*  364 */ "table_name",
  /*  365 */ "column_def",
  /*  366 */ "duration_list",
  /*  367 */ "rollup_func_list",
  /*  368 */ "alter_table_option",
  /*  369 */ "duration_literal",
  /*  370 */ "rollup_func_name",
  /*  371 */ "function_name",
  /*  372 */ "col_name",
  /*  373 */ "db_name_cond_opt",
  /*  374 */ "like_pattern_opt",
  /*  375 */ "table_name_cond",
  /*  376 */ "from_db_opt",
  /*  377 */ "tag_list_opt",
  /*  378 */ "tag_item",
  /*  379 */ "column_alias",
  /*  380 */ "index_options",
  /*  381 */ "func_list",
  /*  382 */ "sliding_opt",
  /*  383 */ "sma_stream_opt",
  /*  384 */ "func",
  /*  385 */ "query_or_subquery",
  /*  386 */ "cgroup_name",
  /*  387 */ "analyze_opt",
  /*  388 */ "explain_options",
  /*  389 */ "agg_func_opt",
  /*  390 */ "bufsize_opt",
  /*  391 */ "stream_name",
  /*  392 */ "stream_options",
  /*  393 */ "subtable_opt",
  /*  394 */ "expression",
  /*  395 */ "dnode_list",
  /*  396 */ "where_clause_opt",
  /*  397 */ "signed",
  /*  398 */ "literal_func",
  /*  399 */ "literal_list",
  /*  400 */ "table_alias",
  /*  401 */ "expr_or_subquery",
  /*  402 */ "pseudo_column",
  /*  403 */ "column_reference",
  /*  404 */ "function_expression",
  /*  405 */ "case_when_expression",
  /*  406 */ "star_func",
  /*  407 */ "star_func_para_list",
  /*  408 */ "noarg_func",
  /*  409 */ "other_para_list",
  /*  410 */ "star_func_para",
  /*  411 */ "when_then_list",
  /*  412 */ "case_when_else_opt",
  /*  413 */ "common_expression",
  /*  414 */ "when_then_expr",
  /*  415 */ "predicate",
  /*  416 */ "compare_op",
  /*  417 */ "in_op",
  /*  418 */ "in_predicate_value",
  /*  419 */ "boolean_value_expression",
  /*  420 */ "boolean_primary",
  /*  421 */ "from_clause_opt",
  /*  422 */ "table_reference_list",
  /*  423 */ "table_reference",
  /*  424 */ "table_primary",
  /*  425 */ "joined_table",
  /*  426 */ "alias_opt",
  /*  427 */ "subquery",
  /*  428 */ "parenthesized_joined_table",
  /*  429 */ "join_type",
  /*  430 */ "search_condition",
  /*  431 */ "query_specification",
  /*  432 */ "set_quantifier_opt",
  /*  433 */ "select_list",
  /*  434 */ "partition_by_clause_opt",
  /*  435 */ "range_opt",
  /*  436 */ "every_opt",
  /*  437 */ "fill_opt",
  /*  438 */ "twindow_clause_opt",
  /*  439 */ "group_by_clause_opt",
  /*  440 */ "having_clause_opt",
  /*  441 */ "select_item",
  /*  442 */ "partition_list",
  /*  443 */ "partition_item",
  /*  444 */ "fill_mode",
  /*  445 */ "group_by_list",
  /*  446 */ "query_expression",
  /*  447 */ "query_simple",
  /*  448 */ "order_by_clause_opt",
  /*  449 */ "slimit_clause_opt",
  /*  450 */ "limit_clause_opt",
  /*  451 */ "union_query_expression",
  /*  452 */ "query_simple_or_subquery",
  /*  453 */ "sort_specification_list",
  /*  454 */ "sort_specification",
  /*  455 */ "ordering_specification_opt",
  /*  456 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options STRICT NK_STRING",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= STRICT NK_STRING",
 /* 119 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 120 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 121 */ "integer_list ::= NK_INTEGER",
 /* 122 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 123 */ "variable_list ::= NK_VARIABLE",
 /* 124 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 125 */ "retention_list ::= retention",
 /* 126 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 127 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 128 */ "speed_opt ::=",
 /* 129 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 130 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 131 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 132 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 133 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 134 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 135 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 136 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 137 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 138 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 140 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 142 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 144 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 145 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 146 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 147 */ "multi_create_clause ::= create_subtable_clause",
 /* 148 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 149 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 150 */ "multi_drop_clause ::= drop_table_clause",
 /* 151 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 152 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 153 */ "specific_cols_opt ::=",
 /* 154 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 155 */ "full_table_name ::= table_name",
 /* 156 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 157 */ "column_def_list ::= column_def",
 /* 158 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 159 */ "column_def ::= column_name type_name",
 /* 160 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 161 */ "type_name ::= BOOL",
 /* 162 */ "type_name ::= TINYINT",
 /* 163 */ "type_name ::= SMALLINT",
 /* 164 */ "type_name ::= INT",
 /* 165 */ "type_name ::= INTEGER",
 /* 166 */ "type_name ::= BIGINT",
 /* 167 */ "type_name ::= FLOAT",
 /* 168 */ "type_name ::= DOUBLE",
 /* 169 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TIMESTAMP",
 /* 171 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 172 */ "type_name ::= TINYINT UNSIGNED",
 /* 173 */ "type_name ::= SMALLINT UNSIGNED",
 /* 174 */ "type_name ::= INT UNSIGNED",
 /* 175 */ "type_name ::= BIGINT UNSIGNED",
 /* 176 */ "type_name ::= JSON",
 /* 177 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 178 */ "type_name ::= MEDIUMBLOB",
 /* 179 */ "type_name ::= BLOB",
 /* 180 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 183 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 184 */ "tags_def_opt ::=",
 /* 185 */ "tags_def_opt ::= tags_def",
 /* 186 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 187 */ "table_options ::=",
 /* 188 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 189 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 190 */ "table_options ::= table_options WATERMARK duration_list",
 /* 191 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 192 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 193 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 194 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 195 */ "alter_table_options ::= alter_table_option",
 /* 196 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 197 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 198 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 199 */ "duration_list ::= duration_literal",
 /* 200 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 201 */ "rollup_func_list ::= rollup_func_name",
 /* 202 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 203 */ "rollup_func_name ::= function_name",
 /* 204 */ "rollup_func_name ::= FIRST",
 /* 205 */ "rollup_func_name ::= LAST",
 /* 206 */ "col_name_list ::= col_name",
 /* 207 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 208 */ "col_name ::= column_name",
 /* 209 */ "cmd ::= SHOW DNODES",
 /* 210 */ "cmd ::= SHOW USERS",
 /* 211 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 212 */ "cmd ::= SHOW DATABASES",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 215 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 216 */ "cmd ::= SHOW MNODES",
 /* 217 */ "cmd ::= SHOW QNODES",
 /* 218 */ "cmd ::= SHOW FUNCTIONS",
 /* 219 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 220 */ "cmd ::= SHOW STREAMS",
 /* 221 */ "cmd ::= SHOW ACCOUNTS",
 /* 222 */ "cmd ::= SHOW APPS",
 /* 223 */ "cmd ::= SHOW CONNECTIONS",
 /* 224 */ "cmd ::= SHOW LICENCES",
 /* 225 */ "cmd ::= SHOW GRANTS",
 /* 226 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 227 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 228 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 229 */ "cmd ::= SHOW QUERIES",
 /* 230 */ "cmd ::= SHOW SCORES",
 /* 231 */ "cmd ::= SHOW TOPICS",
 /* 232 */ "cmd ::= SHOW VARIABLES",
 /* 233 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 234 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 235 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 236 */ "cmd ::= SHOW BNODES",
 /* 237 */ "cmd ::= SHOW SNODES",
 /* 238 */ "cmd ::= SHOW CLUSTER",
 /* 239 */ "cmd ::= SHOW TRANSACTIONS",
 /* 240 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 241 */ "cmd ::= SHOW CONSUMERS",
 /* 242 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 243 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 245 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 246 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 247 */ "db_name_cond_opt ::=",
 /* 248 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 249 */ "like_pattern_opt ::=",
 /* 250 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 251 */ "table_name_cond ::= table_name",
 /* 252 */ "from_db_opt ::=",
 /* 253 */ "from_db_opt ::= FROM db_name",
 /* 254 */ "tag_list_opt ::=",
 /* 255 */ "tag_list_opt ::= tag_item",
 /* 256 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 257 */ "tag_item ::= TBNAME",
 /* 258 */ "tag_item ::= QTAGS",
 /* 259 */ "tag_item ::= column_name",
 /* 260 */ "tag_item ::= column_name column_alias",
 /* 261 */ "tag_item ::= column_name AS column_alias",
 /* 262 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 263 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 266 */ "func_list ::= func",
 /* 267 */ "func_list ::= func_list NK_COMMA func",
 /* 268 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 269 */ "sma_stream_opt ::=",
 /* 270 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 271 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 272 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 273 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 274 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 275 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 276 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 277 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 278 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 279 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 280 */ "cmd ::= DESC full_table_name",
 /* 281 */ "cmd ::= DESCRIBE full_table_name",
 /* 282 */ "cmd ::= RESET QUERY CACHE",
 /* 283 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 284 */ "analyze_opt ::=",
 /* 285 */ "analyze_opt ::= ANALYZE",
 /* 286 */ "explain_options ::=",
 /* 287 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 288 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 289 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 290 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 291 */ "agg_func_opt ::=",
 /* 292 */ "agg_func_opt ::= AGGREGATE",
 /* 293 */ "bufsize_opt ::=",
 /* 294 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 295 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 296 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 297 */ "stream_options ::=",
 /* 298 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 299 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 300 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 301 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 302 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 303 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 304 */ "subtable_opt ::=",
 /* 305 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 306 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 307 */ "cmd ::= KILL QUERY NK_STRING",
 /* 308 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 309 */ "cmd ::= BALANCE VGROUP",
 /* 310 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 311 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 312 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 313 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 314 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 315 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 316 */ "cmd ::= query_or_subquery",
 /* 317 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 318 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 319 */ "literal ::= NK_INTEGER",
 /* 320 */ "literal ::= NK_FLOAT",
 /* 321 */ "literal ::= NK_STRING",
 /* 322 */ "literal ::= NK_BOOL",
 /* 323 */ "literal ::= TIMESTAMP NK_STRING",
 /* 324 */ "literal ::= duration_literal",
 /* 325 */ "literal ::= NULL",
 /* 326 */ "literal ::= NK_QUESTION",
 /* 327 */ "duration_literal ::= NK_VARIABLE",
 /* 328 */ "signed ::= NK_INTEGER",
 /* 329 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 330 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 331 */ "signed ::= NK_FLOAT",
 /* 332 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 333 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 334 */ "signed_literal ::= signed",
 /* 335 */ "signed_literal ::= NK_STRING",
 /* 336 */ "signed_literal ::= NK_BOOL",
 /* 337 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 338 */ "signed_literal ::= duration_literal",
 /* 339 */ "signed_literal ::= NULL",
 /* 340 */ "signed_literal ::= literal_func",
 /* 341 */ "signed_literal ::= NK_QUESTION",
 /* 342 */ "literal_list ::= signed_literal",
 /* 343 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 344 */ "db_name ::= NK_ID",
 /* 345 */ "table_name ::= NK_ID",
 /* 346 */ "column_name ::= NK_ID",
 /* 347 */ "function_name ::= NK_ID",
 /* 348 */ "table_alias ::= NK_ID",
 /* 349 */ "column_alias ::= NK_ID",
 /* 350 */ "user_name ::= NK_ID",
 /* 351 */ "topic_name ::= NK_ID",
 /* 352 */ "stream_name ::= NK_ID",
 /* 353 */ "cgroup_name ::= NK_ID",
 /* 354 */ "expr_or_subquery ::= expression",
 /* 355 */ "expression ::= literal",
 /* 356 */ "expression ::= pseudo_column",
 /* 357 */ "expression ::= column_reference",
 /* 358 */ "expression ::= function_expression",
 /* 359 */ "expression ::= case_when_expression",
 /* 360 */ "expression ::= NK_LP expression NK_RP",
 /* 361 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 362 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 363 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 364 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 365 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 366 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 367 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 368 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 369 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 370 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 371 */ "expression_list ::= expr_or_subquery",
 /* 372 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 373 */ "column_reference ::= column_name",
 /* 374 */ "column_reference ::= table_name NK_DOT column_name",
 /* 375 */ "pseudo_column ::= ROWTS",
 /* 376 */ "pseudo_column ::= TBNAME",
 /* 377 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 378 */ "pseudo_column ::= QSTART",
 /* 379 */ "pseudo_column ::= QEND",
 /* 380 */ "pseudo_column ::= QDURATION",
 /* 381 */ "pseudo_column ::= WSTART",
 /* 382 */ "pseudo_column ::= WEND",
 /* 383 */ "pseudo_column ::= WDURATION",
 /* 384 */ "pseudo_column ::= IROWTS",
 /* 385 */ "pseudo_column ::= QTAGS",
 /* 386 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 387 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 388 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 389 */ "function_expression ::= literal_func",
 /* 390 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 391 */ "literal_func ::= NOW",
 /* 392 */ "noarg_func ::= NOW",
 /* 393 */ "noarg_func ::= TODAY",
 /* 394 */ "noarg_func ::= TIMEZONE",
 /* 395 */ "noarg_func ::= DATABASE",
 /* 396 */ "noarg_func ::= CLIENT_VERSION",
 /* 397 */ "noarg_func ::= SERVER_VERSION",
 /* 398 */ "noarg_func ::= SERVER_STATUS",
 /* 399 */ "noarg_func ::= CURRENT_USER",
 /* 400 */ "noarg_func ::= USER",
 /* 401 */ "star_func ::= COUNT",
 /* 402 */ "star_func ::= FIRST",
 /* 403 */ "star_func ::= LAST",
 /* 404 */ "star_func ::= LAST_ROW",
 /* 405 */ "star_func_para_list ::= NK_STAR",
 /* 406 */ "star_func_para_list ::= other_para_list",
 /* 407 */ "other_para_list ::= star_func_para",
 /* 408 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 409 */ "star_func_para ::= expr_or_subquery",
 /* 410 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 411 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 412 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 413 */ "when_then_list ::= when_then_expr",
 /* 414 */ "when_then_list ::= when_then_list when_then_expr",
 /* 415 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 416 */ "case_when_else_opt ::=",
 /* 417 */ "case_when_else_opt ::= ELSE common_expression",
 /* 418 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 419 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 420 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 421 */ "predicate ::= expr_or_subquery IS NULL",
 /* 422 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 423 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 424 */ "compare_op ::= NK_LT",
 /* 425 */ "compare_op ::= NK_GT",
 /* 426 */ "compare_op ::= NK_LE",
 /* 427 */ "compare_op ::= NK_GE",
 /* 428 */ "compare_op ::= NK_NE",
 /* 429 */ "compare_op ::= NK_EQ",
 /* 430 */ "compare_op ::= LIKE",
 /* 431 */ "compare_op ::= NOT LIKE",
 /* 432 */ "compare_op ::= MATCH",
 /* 433 */ "compare_op ::= NMATCH",
 /* 434 */ "compare_op ::= CONTAINS",
 /* 435 */ "in_op ::= IN",
 /* 436 */ "in_op ::= NOT IN",
 /* 437 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 438 */ "boolean_value_expression ::= boolean_primary",
 /* 439 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 440 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 441 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 442 */ "boolean_primary ::= predicate",
 /* 443 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 444 */ "common_expression ::= expr_or_subquery",
 /* 445 */ "common_expression ::= boolean_value_expression",
 /* 446 */ "from_clause_opt ::=",
 /* 447 */ "from_clause_opt ::= FROM table_reference_list",
 /* 448 */ "table_reference_list ::= table_reference",
 /* 449 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 450 */ "table_reference ::= table_primary",
 /* 451 */ "table_reference ::= joined_table",
 /* 452 */ "table_primary ::= table_name alias_opt",
 /* 453 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 454 */ "table_primary ::= subquery alias_opt",
 /* 455 */ "table_primary ::= parenthesized_joined_table",
 /* 456 */ "alias_opt ::=",
 /* 457 */ "alias_opt ::= table_alias",
 /* 458 */ "alias_opt ::= AS table_alias",
 /* 459 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 460 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 461 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 462 */ "join_type ::=",
 /* 463 */ "join_type ::= INNER",
 /* 464 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 465 */ "set_quantifier_opt ::=",
 /* 466 */ "set_quantifier_opt ::= DISTINCT",
 /* 467 */ "set_quantifier_opt ::= ALL",
 /* 468 */ "select_list ::= select_item",
 /* 469 */ "select_list ::= select_list NK_COMMA select_item",
 /* 470 */ "select_item ::= NK_STAR",
 /* 471 */ "select_item ::= common_expression",
 /* 472 */ "select_item ::= common_expression column_alias",
 /* 473 */ "select_item ::= common_expression AS column_alias",
 /* 474 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 475 */ "where_clause_opt ::=",
 /* 476 */ "where_clause_opt ::= WHERE search_condition",
 /* 477 */ "partition_by_clause_opt ::=",
 /* 478 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 479 */ "partition_list ::= partition_item",
 /* 480 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 481 */ "partition_item ::= expr_or_subquery",
 /* 482 */ "partition_item ::= expr_or_subquery column_alias",
 /* 483 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 484 */ "twindow_clause_opt ::=",
 /* 485 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 486 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 487 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 488 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 489 */ "sliding_opt ::=",
 /* 490 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 491 */ "fill_opt ::=",
 /* 492 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 493 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 494 */ "fill_mode ::= NONE",
 /* 495 */ "fill_mode ::= PREV",
 /* 496 */ "fill_mode ::= NULL",
 /* 497 */ "fill_mode ::= LINEAR",
 /* 498 */ "fill_mode ::= NEXT",
 /* 499 */ "group_by_clause_opt ::=",
 /* 500 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 501 */ "group_by_list ::= expr_or_subquery",
 /* 502 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 503 */ "having_clause_opt ::=",
 /* 504 */ "having_clause_opt ::= HAVING search_condition",
 /* 505 */ "range_opt ::=",
 /* 506 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 507 */ "every_opt ::=",
 /* 508 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 509 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 510 */ "query_simple ::= query_specification",
 /* 511 */ "query_simple ::= union_query_expression",
 /* 512 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 513 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 514 */ "query_simple_or_subquery ::= query_simple",
 /* 515 */ "query_simple_or_subquery ::= subquery",
 /* 516 */ "query_or_subquery ::= query_expression",
 /* 517 */ "query_or_subquery ::= subquery",
 /* 518 */ "order_by_clause_opt ::=",
 /* 519 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 520 */ "slimit_clause_opt ::=",
 /* 521 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 522 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 523 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 524 */ "limit_clause_opt ::=",
 /* 525 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 526 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 527 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 528 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 529 */ "subquery ::= NK_LP subquery NK_RP",
 /* 530 */ "search_condition ::= common_expression",
 /* 531 */ "sort_specification_list ::= sort_specification",
 /* 532 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 533 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 534 */ "ordering_specification_opt ::=",
 /* 535 */ "ordering_specification_opt ::= ASC",
 /* 536 */ "ordering_specification_opt ::= DESC",
 /* 537 */ "null_ordering_opt ::=",
 /* 538 */ "null_ordering_opt ::= NULLS FIRST",
 /* 539 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 322: /* cmd */
    case 325: /* literal */
    case 338: /* db_options */
    case 340: /* alter_db_options */
    case 346: /* retention */
    case 347: /* full_table_name */
    case 350: /* table_options */
    case 354: /* alter_table_clause */
    case 355: /* alter_table_options */
    case 358: /* signed_literal */
    case 359: /* create_subtable_clause */
    case 362: /* drop_table_clause */
    case 365: /* column_def */
    case 369: /* duration_literal */
    case 370: /* rollup_func_name */
    case 372: /* col_name */
    case 373: /* db_name_cond_opt */
    case 374: /* like_pattern_opt */
    case 375: /* table_name_cond */
    case 376: /* from_db_opt */
    case 378: /* tag_item */
    case 380: /* index_options */
    case 382: /* sliding_opt */
    case 383: /* sma_stream_opt */
    case 384: /* func */
    case 385: /* query_or_subquery */
    case 388: /* explain_options */
    case 392: /* stream_options */
    case 393: /* subtable_opt */
    case 394: /* expression */
    case 396: /* where_clause_opt */
    case 397: /* signed */
    case 398: /* literal_func */
    case 401: /* expr_or_subquery */
    case 402: /* pseudo_column */
    case 403: /* column_reference */
    case 404: /* function_expression */
    case 405: /* case_when_expression */
    case 410: /* star_func_para */
    case 412: /* case_when_else_opt */
    case 413: /* common_expression */
    case 414: /* when_then_expr */
    case 415: /* predicate */
    case 418: /* in_predicate_value */
    case 419: /* boolean_value_expression */
    case 420: /* boolean_primary */
    case 421: /* from_clause_opt */
    case 422: /* table_reference_list */
    case 423: /* table_reference */
    case 424: /* table_primary */
    case 425: /* joined_table */
    case 427: /* subquery */
    case 428: /* parenthesized_joined_table */
    case 430: /* search_condition */
    case 431: /* query_specification */
    case 435: /* range_opt */
    case 436: /* every_opt */
    case 437: /* fill_opt */
    case 438: /* twindow_clause_opt */
    case 440: /* having_clause_opt */
    case 441: /* select_item */
    case 443: /* partition_item */
    case 446: /* query_expression */
    case 447: /* query_simple */
    case 449: /* slimit_clause_opt */
    case 450: /* limit_clause_opt */
    case 451: /* union_query_expression */
    case 452: /* query_simple_or_subquery */
    case 454: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy148)); 
}
      break;
    case 323: /* account_options */
    case 324: /* alter_account_options */
    case 326: /* alter_account_option */
    case 341: /* speed_opt */
    case 390: /* bufsize_opt */
{
 
}
      break;
    case 327: /* user_name */
    case 330: /* priv_level */
    case 333: /* db_name */
    case 334: /* topic_name */
    case 335: /* dnode_endpoint */
    case 356: /* column_name */
    case 364: /* table_name */
    case 371: /* function_name */
    case 379: /* column_alias */
    case 386: /* cgroup_name */
    case 391: /* stream_name */
    case 400: /* table_alias */
    case 406: /* star_func */
    case 408: /* noarg_func */
    case 426: /* alias_opt */
{
 
}
      break;
    case 328: /* sysinfo_opt */
{
 
}
      break;
    case 329: /* privileges */
    case 331: /* priv_type_list */
    case 332: /* priv_type */
{
 
}
      break;
    case 336: /* force_opt */
    case 337: /* not_exists_opt */
    case 339: /* exists_opt */
    case 387: /* analyze_opt */
    case 389: /* agg_func_opt */
    case 432: /* set_quantifier_opt */
{
 
}
      break;
    case 342: /* integer_list */
    case 343: /* variable_list */
    case 344: /* retention_list */
    case 348: /* column_def_list */
    case 349: /* tags_def_opt */
    case 351: /* multi_create_clause */
    case 352: /* tags_def */
    case 353: /* multi_drop_clause */
    case 360: /* specific_cols_opt */
    case 361: /* expression_list */
    case 363: /* col_name_list */
    case 366: /* duration_list */
    case 367: /* rollup_func_list */
    case 377: /* tag_list_opt */
    case 381: /* func_list */
    case 395: /* dnode_list */
    case 399: /* literal_list */
    case 407: /* star_func_para_list */
    case 409: /* other_para_list */
    case 411: /* when_then_list */
    case 433: /* select_list */
    case 434: /* partition_by_clause_opt */
    case 439: /* group_by_clause_opt */
    case 442: /* partition_list */
    case 445: /* group_by_list */
    case 448: /* order_by_clause_opt */
    case 453: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy404)); 
}
      break;
    case 345: /* alter_db_option */
    case 368: /* alter_table_option */
{
 
}
      break;
    case 357: /* type_name */
{
 
}
      break;
    case 416: /* compare_op */
    case 417: /* in_op */
{
 
}
      break;
    case 429: /* join_type */
{
 
}
      break;
    case 444: /* fill_mode */
{
 
}
      break;
    case 455: /* ordering_specification_opt */
{
 
}
      break;
    case 456: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  322,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  322,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  323,    0 }, /* (2) account_options ::= */
  {  323,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  323,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  323,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  323,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  323,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  323,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  323,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  323,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  323,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  324,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  324,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  326,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  326,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  326,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  326,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  326,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  326,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  326,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  326,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  326,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  326,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  322,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  322,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  322,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  322,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  322,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  328,    0 }, /* (29) sysinfo_opt ::= */
  {  328,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  322,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  322,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  329,   -1 }, /* (33) privileges ::= ALL */
  {  329,   -1 }, /* (34) privileges ::= priv_type_list */
  {  329,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  331,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  331,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  332,   -1 }, /* (38) priv_type ::= READ */
  {  332,   -1 }, /* (39) priv_type ::= WRITE */
  {  330,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  330,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  330,   -1 }, /* (42) priv_level ::= topic_name */
  {  322,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  322,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  322,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  322,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  322,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  322,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  322,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  322,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  335,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  335,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  335,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  336,    0 }, /* (54) force_opt ::= */
  {  336,   -1 }, /* (55) force_opt ::= FORCE */
  {  322,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  322,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  322,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  322,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  322,   -2 }, /* (68) cmd ::= USE db_name */
  {  322,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  322,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  322,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  337,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  337,    0 }, /* (73) not_exists_opt ::= */
  {  339,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  339,    0 }, /* (75) exists_opt ::= */
  {  338,    0 }, /* (76) db_options ::= */
  {  338,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  338,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  338,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  338,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  338,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  338,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  338,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  338,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  338,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  338,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  338,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  338,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  338,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  338,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  338,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  338,   -3 }, /* (92) db_options ::= db_options STRICT NK_STRING */
  {  338,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  338,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  338,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  338,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  338,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  338,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  338,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  338,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  338,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  338,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  338,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  338,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  338,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  338,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  338,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  340,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  340,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  345,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  345,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  345,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  345,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  345,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  345,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  345,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  345,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  345,   -2 }, /* (118) alter_db_option ::= STRICT NK_STRING */
  {  345,   -2 }, /* (119) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  345,   -2 }, /* (120) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  342,   -1 }, /* (121) integer_list ::= NK_INTEGER */
  {  342,   -3 }, /* (122) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  343,   -1 }, /* (123) variable_list ::= NK_VARIABLE */
  {  343,   -3 }, /* (124) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  344,   -1 }, /* (125) retention_list ::= retention */
  {  344,   -3 }, /* (126) retention_list ::= retention_list NK_COMMA retention */
  {  346,   -3 }, /* (127) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  341,    0 }, /* (128) speed_opt ::= */
  {  341,   -2 }, /* (129) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  322,   -9 }, /* (130) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  322,   -3 }, /* (131) cmd ::= CREATE TABLE multi_create_clause */
  {  322,   -9 }, /* (132) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  322,   -3 }, /* (133) cmd ::= DROP TABLE multi_drop_clause */
  {  322,   -4 }, /* (134) cmd ::= DROP STABLE exists_opt full_table_name */
  {  322,   -3 }, /* (135) cmd ::= ALTER TABLE alter_table_clause */
  {  322,   -3 }, /* (136) cmd ::= ALTER STABLE alter_table_clause */
  {  354,   -2 }, /* (137) alter_table_clause ::= full_table_name alter_table_options */
  {  354,   -5 }, /* (138) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  354,   -4 }, /* (139) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  354,   -5 }, /* (140) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  354,   -5 }, /* (141) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  354,   -5 }, /* (142) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  354,   -4 }, /* (143) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  354,   -5 }, /* (144) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  354,   -5 }, /* (145) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  354,   -6 }, /* (146) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  351,   -1 }, /* (147) multi_create_clause ::= create_subtable_clause */
  {  351,   -2 }, /* (148) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  359,  -10 }, /* (149) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  353,   -1 }, /* (150) multi_drop_clause ::= drop_table_clause */
  {  353,   -2 }, /* (151) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  362,   -2 }, /* (152) drop_table_clause ::= exists_opt full_table_name */
  {  360,    0 }, /* (153) specific_cols_opt ::= */
  {  360,   -3 }, /* (154) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  347,   -1 }, /* (155) full_table_name ::= table_name */
  {  347,   -3 }, /* (156) full_table_name ::= db_name NK_DOT table_name */
  {  348,   -1 }, /* (157) column_def_list ::= column_def */
  {  348,   -3 }, /* (158) column_def_list ::= column_def_list NK_COMMA column_def */
  {  365,   -2 }, /* (159) column_def ::= column_name type_name */
  {  365,   -4 }, /* (160) column_def ::= column_name type_name COMMENT NK_STRING */
  {  357,   -1 }, /* (161) type_name ::= BOOL */
  {  357,   -1 }, /* (162) type_name ::= TINYINT */
  {  357,   -1 }, /* (163) type_name ::= SMALLINT */
  {  357,   -1 }, /* (164) type_name ::= INT */
  {  357,   -1 }, /* (165) type_name ::= INTEGER */
  {  357,   -1 }, /* (166) type_name ::= BIGINT */
  {  357,   -1 }, /* (167) type_name ::= FLOAT */
  {  357,   -1 }, /* (168) type_name ::= DOUBLE */
  {  357,   -4 }, /* (169) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (170) type_name ::= TIMESTAMP */
  {  357,   -4 }, /* (171) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  357,   -2 }, /* (172) type_name ::= TINYINT UNSIGNED */
  {  357,   -2 }, /* (173) type_name ::= SMALLINT UNSIGNED */
  {  357,   -2 }, /* (174) type_name ::= INT UNSIGNED */
  {  357,   -2 }, /* (175) type_name ::= BIGINT UNSIGNED */
  {  357,   -1 }, /* (176) type_name ::= JSON */
  {  357,   -4 }, /* (177) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (178) type_name ::= MEDIUMBLOB */
  {  357,   -1 }, /* (179) type_name ::= BLOB */
  {  357,   -4 }, /* (180) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (181) type_name ::= DECIMAL */
  {  357,   -4 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  357,   -6 }, /* (183) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  349,    0 }, /* (184) tags_def_opt ::= */
  {  349,   -1 }, /* (185) tags_def_opt ::= tags_def */
  {  352,   -4 }, /* (186) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  350,    0 }, /* (187) table_options ::= */
  {  350,   -3 }, /* (188) table_options ::= table_options COMMENT NK_STRING */
  {  350,   -3 }, /* (189) table_options ::= table_options MAX_DELAY duration_list */
  {  350,   -3 }, /* (190) table_options ::= table_options WATERMARK duration_list */
  {  350,   -5 }, /* (191) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  350,   -3 }, /* (192) table_options ::= table_options TTL NK_INTEGER */
  {  350,   -5 }, /* (193) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  350,   -3 }, /* (194) table_options ::= table_options DELETE_MARK duration_list */
  {  355,   -1 }, /* (195) alter_table_options ::= alter_table_option */
  {  355,   -2 }, /* (196) alter_table_options ::= alter_table_options alter_table_option */
  {  368,   -2 }, /* (197) alter_table_option ::= COMMENT NK_STRING */
  {  368,   -2 }, /* (198) alter_table_option ::= TTL NK_INTEGER */
  {  366,   -1 }, /* (199) duration_list ::= duration_literal */
  {  366,   -3 }, /* (200) duration_list ::= duration_list NK_COMMA duration_literal */
  {  367,   -1 }, /* (201) rollup_func_list ::= rollup_func_name */
  {  367,   -3 }, /* (202) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  370,   -1 }, /* (203) rollup_func_name ::= function_name */
  {  370,   -1 }, /* (204) rollup_func_name ::= FIRST */
  {  370,   -1 }, /* (205) rollup_func_name ::= LAST */
  {  363,   -1 }, /* (206) col_name_list ::= col_name */
  {  363,   -3 }, /* (207) col_name_list ::= col_name_list NK_COMMA col_name */
  {  372,   -1 }, /* (208) col_name ::= column_name */
  {  322,   -2 }, /* (209) cmd ::= SHOW DNODES */
  {  322,   -2 }, /* (210) cmd ::= SHOW USERS */
  {  322,   -3 }, /* (211) cmd ::= SHOW USER PRIVILEGES */
  {  322,   -2 }, /* (212) cmd ::= SHOW DATABASES */
  {  322,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  322,   -4 }, /* (214) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  322,   -3 }, /* (215) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  322,   -2 }, /* (216) cmd ::= SHOW MNODES */
  {  322,   -2 }, /* (217) cmd ::= SHOW QNODES */
  {  322,   -2 }, /* (218) cmd ::= SHOW FUNCTIONS */
  {  322,   -5 }, /* (219) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  322,   -2 }, /* (220) cmd ::= SHOW STREAMS */
  {  322,   -2 }, /* (221) cmd ::= SHOW ACCOUNTS */
  {  322,   -2 }, /* (222) cmd ::= SHOW APPS */
  {  322,   -2 }, /* (223) cmd ::= SHOW CONNECTIONS */
  {  322,   -2 }, /* (224) cmd ::= SHOW LICENCES */
  {  322,   -2 }, /* (225) cmd ::= SHOW GRANTS */
  {  322,   -4 }, /* (226) cmd ::= SHOW CREATE DATABASE db_name */
  {  322,   -4 }, /* (227) cmd ::= SHOW CREATE TABLE full_table_name */
  {  322,   -4 }, /* (228) cmd ::= SHOW CREATE STABLE full_table_name */
  {  322,   -2 }, /* (229) cmd ::= SHOW QUERIES */
  {  322,   -2 }, /* (230) cmd ::= SHOW SCORES */
  {  322,   -2 }, /* (231) cmd ::= SHOW TOPICS */
  {  322,   -2 }, /* (232) cmd ::= SHOW VARIABLES */
  {  322,   -3 }, /* (233) cmd ::= SHOW CLUSTER VARIABLES */
  {  322,   -3 }, /* (234) cmd ::= SHOW LOCAL VARIABLES */
  {  322,   -5 }, /* (235) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  322,   -2 }, /* (236) cmd ::= SHOW BNODES */
  {  322,   -2 }, /* (237) cmd ::= SHOW SNODES */
  {  322,   -2 }, /* (238) cmd ::= SHOW CLUSTER */
  {  322,   -2 }, /* (239) cmd ::= SHOW TRANSACTIONS */
  {  322,   -4 }, /* (240) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  322,   -2 }, /* (241) cmd ::= SHOW CONSUMERS */
  {  322,   -2 }, /* (242) cmd ::= SHOW SUBSCRIPTIONS */
  {  322,   -5 }, /* (243) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  322,   -7 }, /* (244) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  322,   -3 }, /* (245) cmd ::= SHOW VNODES NK_INTEGER */
  {  322,   -3 }, /* (246) cmd ::= SHOW VNODES NK_STRING */
  {  373,    0 }, /* (247) db_name_cond_opt ::= */
  {  373,   -2 }, /* (248) db_name_cond_opt ::= db_name NK_DOT */
  {  374,    0 }, /* (249) like_pattern_opt ::= */
  {  374,   -2 }, /* (250) like_pattern_opt ::= LIKE NK_STRING */
  {  375,   -1 }, /* (251) table_name_cond ::= table_name */
  {  376,    0 }, /* (252) from_db_opt ::= */
  {  376,   -2 }, /* (253) from_db_opt ::= FROM db_name */
  {  377,    0 }, /* (254) tag_list_opt ::= */
  {  377,   -1 }, /* (255) tag_list_opt ::= tag_item */
  {  377,   -3 }, /* (256) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  378,   -1 }, /* (257) tag_item ::= TBNAME */
  {  378,   -1 }, /* (258) tag_item ::= QTAGS */
  {  378,   -1 }, /* (259) tag_item ::= column_name */
  {  378,   -2 }, /* (260) tag_item ::= column_name column_alias */
  {  378,   -3 }, /* (261) tag_item ::= column_name AS column_alias */
  {  322,   -8 }, /* (262) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  322,   -4 }, /* (263) cmd ::= DROP INDEX exists_opt full_table_name */
  {  380,  -10 }, /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  380,  -12 }, /* (265) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  381,   -1 }, /* (266) func_list ::= func */
  {  381,   -3 }, /* (267) func_list ::= func_list NK_COMMA func */
  {  384,   -4 }, /* (268) func ::= function_name NK_LP expression_list NK_RP */
  {  383,    0 }, /* (269) sma_stream_opt ::= */
  {  383,   -3 }, /* (270) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  383,   -3 }, /* (271) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  383,   -3 }, /* (272) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  322,   -6 }, /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  322,   -7 }, /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  322,   -9 }, /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  322,   -7 }, /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  322,   -9 }, /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  322,   -4 }, /* (278) cmd ::= DROP TOPIC exists_opt topic_name */
  {  322,   -7 }, /* (279) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  322,   -2 }, /* (280) cmd ::= DESC full_table_name */
  {  322,   -2 }, /* (281) cmd ::= DESCRIBE full_table_name */
  {  322,   -3 }, /* (282) cmd ::= RESET QUERY CACHE */
  {  322,   -4 }, /* (283) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  387,    0 }, /* (284) analyze_opt ::= */
  {  387,   -1 }, /* (285) analyze_opt ::= ANALYZE */
  {  388,    0 }, /* (286) explain_options ::= */
  {  388,   -3 }, /* (287) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  388,   -3 }, /* (288) explain_options ::= explain_options RATIO NK_FLOAT */
  {  322,  -10 }, /* (289) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  322,   -4 }, /* (290) cmd ::= DROP FUNCTION exists_opt function_name */
  {  389,    0 }, /* (291) agg_func_opt ::= */
  {  389,   -1 }, /* (292) agg_func_opt ::= AGGREGATE */
  {  390,    0 }, /* (293) bufsize_opt ::= */
  {  390,   -2 }, /* (294) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  322,  -11 }, /* (295) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  322,   -4 }, /* (296) cmd ::= DROP STREAM exists_opt stream_name */
  {  392,    0 }, /* (297) stream_options ::= */
  {  392,   -3 }, /* (298) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  392,   -3 }, /* (299) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  392,   -4 }, /* (300) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  392,   -3 }, /* (301) stream_options ::= stream_options WATERMARK duration_literal */
  {  392,   -4 }, /* (302) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  392,   -3 }, /* (303) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  393,    0 }, /* (304) subtable_opt ::= */
  {  393,   -4 }, /* (305) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  322,   -3 }, /* (306) cmd ::= KILL CONNECTION NK_INTEGER */
  {  322,   -3 }, /* (307) cmd ::= KILL QUERY NK_STRING */
  {  322,   -3 }, /* (308) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  322,   -2 }, /* (309) cmd ::= BALANCE VGROUP */
  {  322,   -4 }, /* (310) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  322,   -4 }, /* (311) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  322,   -3 }, /* (312) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  395,   -2 }, /* (313) dnode_list ::= DNODE NK_INTEGER */
  {  395,   -3 }, /* (314) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  322,   -4 }, /* (315) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  322,   -1 }, /* (316) cmd ::= query_or_subquery */
  {  322,   -7 }, /* (317) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  322,   -4 }, /* (318) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  325,   -1 }, /* (319) literal ::= NK_INTEGER */
  {  325,   -1 }, /* (320) literal ::= NK_FLOAT */
  {  325,   -1 }, /* (321) literal ::= NK_STRING */
  {  325,   -1 }, /* (322) literal ::= NK_BOOL */
  {  325,   -2 }, /* (323) literal ::= TIMESTAMP NK_STRING */
  {  325,   -1 }, /* (324) literal ::= duration_literal */
  {  325,   -1 }, /* (325) literal ::= NULL */
  {  325,   -1 }, /* (326) literal ::= NK_QUESTION */
  {  369,   -1 }, /* (327) duration_literal ::= NK_VARIABLE */
  {  397,   -1 }, /* (328) signed ::= NK_INTEGER */
  {  397,   -2 }, /* (329) signed ::= NK_PLUS NK_INTEGER */
  {  397,   -2 }, /* (330) signed ::= NK_MINUS NK_INTEGER */
  {  397,   -1 }, /* (331) signed ::= NK_FLOAT */
  {  397,   -2 }, /* (332) signed ::= NK_PLUS NK_FLOAT */
  {  397,   -2 }, /* (333) signed ::= NK_MINUS NK_FLOAT */
  {  358,   -1 }, /* (334) signed_literal ::= signed */
  {  358,   -1 }, /* (335) signed_literal ::= NK_STRING */
  {  358,   -1 }, /* (336) signed_literal ::= NK_BOOL */
  {  358,   -2 }, /* (337) signed_literal ::= TIMESTAMP NK_STRING */
  {  358,   -1 }, /* (338) signed_literal ::= duration_literal */
  {  358,   -1 }, /* (339) signed_literal ::= NULL */
  {  358,   -1 }, /* (340) signed_literal ::= literal_func */
  {  358,   -1 }, /* (341) signed_literal ::= NK_QUESTION */
  {  399,   -1 }, /* (342) literal_list ::= signed_literal */
  {  399,   -3 }, /* (343) literal_list ::= literal_list NK_COMMA signed_literal */
  {  333,   -1 }, /* (344) db_name ::= NK_ID */
  {  364,   -1 }, /* (345) table_name ::= NK_ID */
  {  356,   -1 }, /* (346) column_name ::= NK_ID */
  {  371,   -1 }, /* (347) function_name ::= NK_ID */
  {  400,   -1 }, /* (348) table_alias ::= NK_ID */
  {  379,   -1 }, /* (349) column_alias ::= NK_ID */
  {  327,   -1 }, /* (350) user_name ::= NK_ID */
  {  334,   -1 }, /* (351) topic_name ::= NK_ID */
  {  391,   -1 }, /* (352) stream_name ::= NK_ID */
  {  386,   -1 }, /* (353) cgroup_name ::= NK_ID */
  {  401,   -1 }, /* (354) expr_or_subquery ::= expression */
  {  394,   -1 }, /* (355) expression ::= literal */
  {  394,   -1 }, /* (356) expression ::= pseudo_column */
  {  394,   -1 }, /* (357) expression ::= column_reference */
  {  394,   -1 }, /* (358) expression ::= function_expression */
  {  394,   -1 }, /* (359) expression ::= case_when_expression */
  {  394,   -3 }, /* (360) expression ::= NK_LP expression NK_RP */
  {  394,   -2 }, /* (361) expression ::= NK_PLUS expr_or_subquery */
  {  394,   -2 }, /* (362) expression ::= NK_MINUS expr_or_subquery */
  {  394,   -3 }, /* (363) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  394,   -3 }, /* (364) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  394,   -3 }, /* (365) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  394,   -3 }, /* (366) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  394,   -3 }, /* (367) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  394,   -3 }, /* (368) expression ::= column_reference NK_ARROW NK_STRING */
  {  394,   -3 }, /* (369) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  394,   -3 }, /* (370) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  361,   -1 }, /* (371) expression_list ::= expr_or_subquery */
  {  361,   -3 }, /* (372) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  403,   -1 }, /* (373) column_reference ::= column_name */
  {  403,   -3 }, /* (374) column_reference ::= table_name NK_DOT column_name */
  {  402,   -1 }, /* (375) pseudo_column ::= ROWTS */
  {  402,   -1 }, /* (376) pseudo_column ::= TBNAME */
  {  402,   -3 }, /* (377) pseudo_column ::= table_name NK_DOT TBNAME */
  {  402,   -1 }, /* (378) pseudo_column ::= QSTART */
  {  402,   -1 }, /* (379) pseudo_column ::= QEND */
  {  402,   -1 }, /* (380) pseudo_column ::= QDURATION */
  {  402,   -1 }, /* (381) pseudo_column ::= WSTART */
  {  402,   -1 }, /* (382) pseudo_column ::= WEND */
  {  402,   -1 }, /* (383) pseudo_column ::= WDURATION */
  {  402,   -1 }, /* (384) pseudo_column ::= IROWTS */
  {  402,   -1 }, /* (385) pseudo_column ::= QTAGS */
  {  404,   -4 }, /* (386) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  404,   -4 }, /* (387) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  404,   -6 }, /* (388) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  404,   -1 }, /* (389) function_expression ::= literal_func */
  {  398,   -3 }, /* (390) literal_func ::= noarg_func NK_LP NK_RP */
  {  398,   -1 }, /* (391) literal_func ::= NOW */
  {  408,   -1 }, /* (392) noarg_func ::= NOW */
  {  408,   -1 }, /* (393) noarg_func ::= TODAY */
  {  408,   -1 }, /* (394) noarg_func ::= TIMEZONE */
  {  408,   -1 }, /* (395) noarg_func ::= DATABASE */
  {  408,   -1 }, /* (396) noarg_func ::= CLIENT_VERSION */
  {  408,   -1 }, /* (397) noarg_func ::= SERVER_VERSION */
  {  408,   -1 }, /* (398) noarg_func ::= SERVER_STATUS */
  {  408,   -1 }, /* (399) noarg_func ::= CURRENT_USER */
  {  408,   -1 }, /* (400) noarg_func ::= USER */
  {  406,   -1 }, /* (401) star_func ::= COUNT */
  {  406,   -1 }, /* (402) star_func ::= FIRST */
  {  406,   -1 }, /* (403) star_func ::= LAST */
  {  406,   -1 }, /* (404) star_func ::= LAST_ROW */
  {  407,   -1 }, /* (405) star_func_para_list ::= NK_STAR */
  {  407,   -1 }, /* (406) star_func_para_list ::= other_para_list */
  {  409,   -1 }, /* (407) other_para_list ::= star_func_para */
  {  409,   -3 }, /* (408) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  410,   -1 }, /* (409) star_func_para ::= expr_or_subquery */
  {  410,   -3 }, /* (410) star_func_para ::= table_name NK_DOT NK_STAR */
  {  405,   -4 }, /* (411) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  405,   -5 }, /* (412) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  411,   -1 }, /* (413) when_then_list ::= when_then_expr */
  {  411,   -2 }, /* (414) when_then_list ::= when_then_list when_then_expr */
  {  414,   -4 }, /* (415) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  412,    0 }, /* (416) case_when_else_opt ::= */
  {  412,   -2 }, /* (417) case_when_else_opt ::= ELSE common_expression */
  {  415,   -3 }, /* (418) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  415,   -5 }, /* (419) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  415,   -6 }, /* (420) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  415,   -3 }, /* (421) predicate ::= expr_or_subquery IS NULL */
  {  415,   -4 }, /* (422) predicate ::= expr_or_subquery IS NOT NULL */
  {  415,   -3 }, /* (423) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  416,   -1 }, /* (424) compare_op ::= NK_LT */
  {  416,   -1 }, /* (425) compare_op ::= NK_GT */
  {  416,   -1 }, /* (426) compare_op ::= NK_LE */
  {  416,   -1 }, /* (427) compare_op ::= NK_GE */
  {  416,   -1 }, /* (428) compare_op ::= NK_NE */
  {  416,   -1 }, /* (429) compare_op ::= NK_EQ */
  {  416,   -1 }, /* (430) compare_op ::= LIKE */
  {  416,   -2 }, /* (431) compare_op ::= NOT LIKE */
  {  416,   -1 }, /* (432) compare_op ::= MATCH */
  {  416,   -1 }, /* (433) compare_op ::= NMATCH */
  {  416,   -1 }, /* (434) compare_op ::= CONTAINS */
  {  417,   -1 }, /* (435) in_op ::= IN */
  {  417,   -2 }, /* (436) in_op ::= NOT IN */
  {  418,   -3 }, /* (437) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  419,   -1 }, /* (438) boolean_value_expression ::= boolean_primary */
  {  419,   -2 }, /* (439) boolean_value_expression ::= NOT boolean_primary */
  {  419,   -3 }, /* (440) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  419,   -3 }, /* (441) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  420,   -1 }, /* (442) boolean_primary ::= predicate */
  {  420,   -3 }, /* (443) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  413,   -1 }, /* (444) common_expression ::= expr_or_subquery */
  {  413,   -1 }, /* (445) common_expression ::= boolean_value_expression */
  {  421,    0 }, /* (446) from_clause_opt ::= */
  {  421,   -2 }, /* (447) from_clause_opt ::= FROM table_reference_list */
  {  422,   -1 }, /* (448) table_reference_list ::= table_reference */
  {  422,   -3 }, /* (449) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  423,   -1 }, /* (450) table_reference ::= table_primary */
  {  423,   -1 }, /* (451) table_reference ::= joined_table */
  {  424,   -2 }, /* (452) table_primary ::= table_name alias_opt */
  {  424,   -4 }, /* (453) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  424,   -2 }, /* (454) table_primary ::= subquery alias_opt */
  {  424,   -1 }, /* (455) table_primary ::= parenthesized_joined_table */
  {  426,    0 }, /* (456) alias_opt ::= */
  {  426,   -1 }, /* (457) alias_opt ::= table_alias */
  {  426,   -2 }, /* (458) alias_opt ::= AS table_alias */
  {  428,   -3 }, /* (459) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  428,   -3 }, /* (460) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  425,   -6 }, /* (461) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  429,    0 }, /* (462) join_type ::= */
  {  429,   -1 }, /* (463) join_type ::= INNER */
  {  431,  -12 }, /* (464) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  432,    0 }, /* (465) set_quantifier_opt ::= */
  {  432,   -1 }, /* (466) set_quantifier_opt ::= DISTINCT */
  {  432,   -1 }, /* (467) set_quantifier_opt ::= ALL */
  {  433,   -1 }, /* (468) select_list ::= select_item */
  {  433,   -3 }, /* (469) select_list ::= select_list NK_COMMA select_item */
  {  441,   -1 }, /* (470) select_item ::= NK_STAR */
  {  441,   -1 }, /* (471) select_item ::= common_expression */
  {  441,   -2 }, /* (472) select_item ::= common_expression column_alias */
  {  441,   -3 }, /* (473) select_item ::= common_expression AS column_alias */
  {  441,   -3 }, /* (474) select_item ::= table_name NK_DOT NK_STAR */
  {  396,    0 }, /* (475) where_clause_opt ::= */
  {  396,   -2 }, /* (476) where_clause_opt ::= WHERE search_condition */
  {  434,    0 }, /* (477) partition_by_clause_opt ::= */
  {  434,   -3 }, /* (478) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  442,   -1 }, /* (479) partition_list ::= partition_item */
  {  442,   -3 }, /* (480) partition_list ::= partition_list NK_COMMA partition_item */
  {  443,   -1 }, /* (481) partition_item ::= expr_or_subquery */
  {  443,   -2 }, /* (482) partition_item ::= expr_or_subquery column_alias */
  {  443,   -3 }, /* (483) partition_item ::= expr_or_subquery AS column_alias */
  {  438,    0 }, /* (484) twindow_clause_opt ::= */
  {  438,   -6 }, /* (485) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  438,   -4 }, /* (486) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  438,   -6 }, /* (487) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  438,   -8 }, /* (488) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  382,    0 }, /* (489) sliding_opt ::= */
  {  382,   -4 }, /* (490) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  437,    0 }, /* (491) fill_opt ::= */
  {  437,   -4 }, /* (492) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  437,   -6 }, /* (493) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  444,   -1 }, /* (494) fill_mode ::= NONE */
  {  444,   -1 }, /* (495) fill_mode ::= PREV */
  {  444,   -1 }, /* (496) fill_mode ::= NULL */
  {  444,   -1 }, /* (497) fill_mode ::= LINEAR */
  {  444,   -1 }, /* (498) fill_mode ::= NEXT */
  {  439,    0 }, /* (499) group_by_clause_opt ::= */
  {  439,   -3 }, /* (500) group_by_clause_opt ::= GROUP BY group_by_list */
  {  445,   -1 }, /* (501) group_by_list ::= expr_or_subquery */
  {  445,   -3 }, /* (502) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  440,    0 }, /* (503) having_clause_opt ::= */
  {  440,   -2 }, /* (504) having_clause_opt ::= HAVING search_condition */
  {  435,    0 }, /* (505) range_opt ::= */
  {  435,   -6 }, /* (506) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  436,    0 }, /* (507) every_opt ::= */
  {  436,   -4 }, /* (508) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  446,   -4 }, /* (509) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  447,   -1 }, /* (510) query_simple ::= query_specification */
  {  447,   -1 }, /* (511) query_simple ::= union_query_expression */
  {  451,   -4 }, /* (512) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  451,   -3 }, /* (513) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  452,   -1 }, /* (514) query_simple_or_subquery ::= query_simple */
  {  452,   -1 }, /* (515) query_simple_or_subquery ::= subquery */
  {  385,   -1 }, /* (516) query_or_subquery ::= query_expression */
  {  385,   -1 }, /* (517) query_or_subquery ::= subquery */
  {  448,    0 }, /* (518) order_by_clause_opt ::= */
  {  448,   -3 }, /* (519) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  449,    0 }, /* (520) slimit_clause_opt ::= */
  {  449,   -2 }, /* (521) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  449,   -4 }, /* (522) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  449,   -4 }, /* (523) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  450,    0 }, /* (524) limit_clause_opt ::= */
  {  450,   -2 }, /* (525) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  450,   -4 }, /* (526) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  450,   -4 }, /* (527) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  427,   -3 }, /* (528) subquery ::= NK_LP query_expression NK_RP */
  {  427,   -3 }, /* (529) subquery ::= NK_LP subquery NK_RP */
  {  430,   -1 }, /* (530) search_condition ::= common_expression */
  {  453,   -1 }, /* (531) sort_specification_list ::= sort_specification */
  {  453,   -3 }, /* (532) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  454,   -3 }, /* (533) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  455,    0 }, /* (534) ordering_specification_opt ::= */
  {  455,   -1 }, /* (535) ordering_specification_opt ::= ASC */
  {  455,   -1 }, /* (536) ordering_specification_opt ::= DESC */
  {  456,    0 }, /* (537) null_ordering_opt ::= */
  {  456,   -2 }, /* (538) null_ordering_opt ::= NULLS FIRST */
  {  456,   -2 }, /* (539) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,323,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,324,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,323,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,325,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,326,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,324,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,326,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,325,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy199, &yymsp[-1].minor.yy0, yymsp[0].minor.yy33); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy199, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy199, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy199, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy33 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy33 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy525, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy525 = yymsp[0].minor.yy525; }
  yymsp[0].minor.yy525 = yylhsminor.yy525;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy525 = yymsp[-2].minor.yy525 | yymsp[0].minor.yy525; }
  yymsp[-2].minor.yy525 = yylhsminor.yy525;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy525 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy199 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy199 = yylhsminor.yy199;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy199 = yymsp[-2].minor.yy199; }
  yymsp[-2].minor.yy199 = yylhsminor.yy199;
        break;
      case 42: /* priv_level ::= topic_name */
      case 457: /* alias_opt ::= table_alias */ yytestcase(yyruleno==457);
{ yylhsminor.yy199 = yymsp[0].minor.yy199; }
  yymsp[0].minor.yy199 = yylhsminor.yy199;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy199, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy397); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy397); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 344: /* db_name ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* table_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* column_name ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* function_name ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* table_alias ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* column_alias ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* user_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* topic_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* stream_name ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==353);
      case 392: /* noarg_func ::= NOW */ yytestcase(yyruleno==392);
      case 393: /* noarg_func ::= TODAY */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= USER */ yytestcase(yyruleno==400);
      case 401: /* star_func ::= COUNT */ yytestcase(yyruleno==401);
      case 402: /* star_func ::= FIRST */ yytestcase(yyruleno==402);
      case 403: /* star_func ::= LAST */ yytestcase(yyruleno==403);
      case 404: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==404);
{ yylhsminor.yy199 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy199 = yylhsminor.yy199;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 284: /* analyze_opt ::= */ yytestcase(yyruleno==284);
      case 291: /* agg_func_opt ::= */ yytestcase(yyruleno==291);
      case 465: /* set_quantifier_opt ::= */ yytestcase(yyruleno==465);
{ yymsp[1].minor.yy397 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 285: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==285);
      case 292: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==292);
      case 466: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==466);
{ yymsp[0].minor.yy397 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy397, &yymsp[-1].minor.yy199, yymsp[0].minor.yy148); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy148); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy706); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy397 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy397 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy148 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_KEEP, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 92: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_RETENTIONS, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-3].minor.yy148, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-3].minor.yy148, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy148 = setDatabaseOption(pCxt, yymsp[-2].minor.yy148, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy148 = createAlterDatabaseOptions(pCxt); yylhsminor.yy148 = setAlterDatabaseOption(pCxt, yylhsminor.yy148, &yymsp[0].minor.yy123); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy148 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy148, &yymsp[0].minor.yy123); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy123.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy123.type = DB_OPTION_KEEP; yymsp[-1].minor.yy123.pList = yymsp[0].minor.yy404; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_PAGES; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STRICT NK_STRING */
{ yymsp[-1].minor.yy123.type = DB_OPTION_STRICT; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_WAL; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy123.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy404 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 122: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 314: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==314);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 123: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy404 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 124: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 125: /* retention_list ::= retention */
      case 147: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==147);
      case 150: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==150);
      case 157: /* column_def_list ::= column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name */ yytestcase(yyruleno==206);
      case 255: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==255);
      case 266: /* func_list ::= func */ yytestcase(yyruleno==266);
      case 342: /* literal_list ::= signed_literal */ yytestcase(yyruleno==342);
      case 407: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==407);
      case 413: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==413);
      case 468: /* select_list ::= select_item */ yytestcase(yyruleno==468);
      case 479: /* partition_list ::= partition_item */ yytestcase(yyruleno==479);
      case 531: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==531);
{ yylhsminor.yy404 = createNodeList(pCxt, yymsp[0].minor.yy148); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 126: /* retention_list ::= retention_list NK_COMMA retention */
      case 158: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==158);
      case 202: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==202);
      case 207: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==207);
      case 256: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==256);
      case 267: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==267);
      case 343: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==343);
      case 408: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==408);
      case 469: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==469);
      case 480: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==480);
      case 532: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==532);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 127: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy148 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 128: /* speed_opt ::= */
      case 293: /* bufsize_opt ::= */ yytestcase(yyruleno==293);
{ yymsp[1].minor.yy706 = 0; }
        break;
      case 129: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 294: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==294);
{ yymsp[-1].minor.yy706 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 130: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 132: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==132);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-5].minor.yy148, yymsp[-3].minor.yy404, yymsp[-1].minor.yy404, yymsp[0].minor.yy148); }
        break;
      case 131: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 133: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 134: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy148); }
        break;
      case 135: /* cmd ::= ALTER TABLE alter_table_clause */
      case 316: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==316);
{ pCxt->pRootNode = yymsp[0].minor.yy148; }
        break;
      case 136: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy148); }
        break;
      case 137: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy148 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 138: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 139: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy148 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy148, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy199); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 140: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 141: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy148 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 142: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 143: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy148 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy148, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy199); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 144: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy148 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 145: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy148 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy148, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 146: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy148 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy148, &yymsp[-2].minor.yy199, yymsp[0].minor.yy148); }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 148: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 151: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==151);
      case 414: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==414);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-1].minor.yy404, yymsp[0].minor.yy148); }
  yymsp[-1].minor.yy404 = yylhsminor.yy404;
        break;
      case 149: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy148 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy397, yymsp[-8].minor.yy148, yymsp[-6].minor.yy148, yymsp[-5].minor.yy404, yymsp[-2].minor.yy404, yymsp[0].minor.yy148); }
  yymsp[-9].minor.yy148 = yylhsminor.yy148;
        break;
      case 152: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy148 = createDropTableClause(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy148); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 153: /* specific_cols_opt ::= */
      case 184: /* tags_def_opt ::= */ yytestcase(yyruleno==184);
      case 254: /* tag_list_opt ::= */ yytestcase(yyruleno==254);
      case 477: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==477);
      case 499: /* group_by_clause_opt ::= */ yytestcase(yyruleno==499);
      case 518: /* order_by_clause_opt ::= */ yytestcase(yyruleno==518);
{ yymsp[1].minor.yy404 = NULL; }
        break;
      case 154: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 155: /* full_table_name ::= table_name */
{ yylhsminor.yy148 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy199, NULL); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 156: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy148 = createRealTableNode(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199, NULL); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 159: /* column_def ::= column_name type_name */
{ yylhsminor.yy148 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy199, yymsp[0].minor.yy530, NULL); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 160: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy148 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy199, yymsp[-2].minor.yy530, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 161: /* type_name ::= BOOL */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 162: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 163: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 164: /* type_name ::= INT */
      case 165: /* type_name ::= INTEGER */ yytestcase(yyruleno==165);
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 166: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 167: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 168: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 169: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 171: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 172: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 173: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 174: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 175: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy530 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 176: /* type_name ::= JSON */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 177: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 178: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 179: /* type_name ::= BLOB */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 180: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 181: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy530 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy530 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy530 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 185: /* tags_def_opt ::= tags_def */
      case 406: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==406);
{ yylhsminor.yy404 = yymsp[0].minor.yy404; }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 186: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 187: /* table_options ::= */
{ yymsp[1].minor.yy148 = createDefaultTableOptions(pCxt); }
        break;
      case 188: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 189: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 190: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 191: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-4].minor.yy148, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 192: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 193: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-4].minor.yy148, TABLE_OPTION_SMA, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 194: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-2].minor.yy148, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 195: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy148 = createAlterTableOptions(pCxt); yylhsminor.yy148 = setTableOption(pCxt, yylhsminor.yy148, yymsp[0].minor.yy123.type, &yymsp[0].minor.yy123.val); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 196: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy148 = setTableOption(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy123.type, &yymsp[0].minor.yy123.val); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 197: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy123.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy123.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy123.val = yymsp[0].minor.yy0; }
        break;
      case 199: /* duration_list ::= duration_literal */
      case 371: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==371);
{ yylhsminor.yy404 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy148)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 200: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 372: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==372);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, releaseRawExprNode(pCxt, yymsp[0].minor.yy148)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 203: /* rollup_func_name ::= function_name */
{ yylhsminor.yy148 = createFunctionNode(pCxt, &yymsp[0].minor.yy199, NULL); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 204: /* rollup_func_name ::= FIRST */
      case 205: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==205);
      case 258: /* tag_item ::= QTAGS */ yytestcase(yyruleno==258);
{ yylhsminor.yy148 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 208: /* col_name ::= column_name */
      case 259: /* tag_item ::= column_name */ yytestcase(yyruleno==259);
{ yylhsminor.yy148 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy199); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 209: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 210: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 211: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 212: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy148, yymsp[0].minor.yy148, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy148, yymsp[0].minor.yy148, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy148, NULL, OP_TYPE_LIKE); }
        break;
      case 216: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 218: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 219: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy148, yymsp[-1].minor.yy148, OP_TYPE_EQUAL); }
        break;
      case 220: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 221: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 222: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 223: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 224: /* cmd ::= SHOW LICENCES */
      case 225: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==225);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 226: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 227: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy148); }
        break;
      case 228: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy148); }
        break;
      case 229: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 230: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 231: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 232: /* cmd ::= SHOW VARIABLES */
      case 233: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==233);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 235: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy148); }
        break;
      case 236: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 238: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 239: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 240: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy148); }
        break;
      case 241: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 242: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 243: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy148, yymsp[-1].minor.yy148, OP_TYPE_EQUAL); }
        break;
      case 244: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy148, yymsp[-3].minor.yy404); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 246: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 247: /* db_name_cond_opt ::= */
      case 252: /* from_db_opt ::= */ yytestcase(yyruleno==252);
{ yymsp[1].minor.yy148 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 248: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy148 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 249: /* like_pattern_opt ::= */
      case 304: /* subtable_opt ::= */ yytestcase(yyruleno==304);
      case 416: /* case_when_else_opt ::= */ yytestcase(yyruleno==416);
      case 446: /* from_clause_opt ::= */ yytestcase(yyruleno==446);
      case 475: /* where_clause_opt ::= */ yytestcase(yyruleno==475);
      case 484: /* twindow_clause_opt ::= */ yytestcase(yyruleno==484);
      case 489: /* sliding_opt ::= */ yytestcase(yyruleno==489);
      case 491: /* fill_opt ::= */ yytestcase(yyruleno==491);
      case 503: /* having_clause_opt ::= */ yytestcase(yyruleno==503);
      case 505: /* range_opt ::= */ yytestcase(yyruleno==505);
      case 507: /* every_opt ::= */ yytestcase(yyruleno==507);
      case 520: /* slimit_clause_opt ::= */ yytestcase(yyruleno==520);
      case 524: /* limit_clause_opt ::= */ yytestcase(yyruleno==524);
{ yymsp[1].minor.yy148 = NULL; }
        break;
      case 250: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 251: /* table_name_cond ::= table_name */
{ yylhsminor.yy148 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy199); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 253: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy148 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy199); }
        break;
      case 257: /* tag_item ::= TBNAME */
{ yylhsminor.yy148 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 260: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy148 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy199), &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 261: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy148 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy199), &yymsp[0].minor.yy199); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 262: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy397, yymsp[-3].minor.yy148, yymsp[-1].minor.yy148, NULL, yymsp[0].minor.yy148); }
        break;
      case 263: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy148); }
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy148 = createIndexOption(pCxt, yymsp[-7].minor.yy404, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), NULL, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 265: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy148 = createIndexOption(pCxt, yymsp[-9].minor.yy404, releaseRawExprNode(pCxt, yymsp[-5].minor.yy148), releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 268: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy148 = createFunctionNode(pCxt, &yymsp[-3].minor.yy199, yymsp[-1].minor.yy404); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 269: /* sma_stream_opt ::= */
      case 297: /* stream_options ::= */ yytestcase(yyruleno==297);
{ yymsp[1].minor.yy148 = createStreamOptions(pCxt); }
        break;
      case 270: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 301: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==301);
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 271: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 272: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 273: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy199, yymsp[0].minor.yy148); }
        break;
      case 274: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy199, &yymsp[0].minor.yy199, false); }
        break;
      case 275: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy199, &yymsp[0].minor.yy199, true); }
        break;
      case 276: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy199, yymsp[0].minor.yy148, false); }
        break;
      case 277: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy199, yymsp[0].minor.yy148, true); }
        break;
      case 278: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 279: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199); }
        break;
      case 280: /* cmd ::= DESC full_table_name */
      case 281: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==281);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy148); }
        break;
      case 282: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 283: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy397, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 286: /* explain_options ::= */
{ yymsp[1].minor.yy148 = createDefaultExplainOptions(pCxt); }
        break;
      case 287: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy148 = setExplainVerbose(pCxt, yymsp[-2].minor.yy148, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 288: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy148 = setExplainRatio(pCxt, yymsp[-2].minor.yy148, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 289: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-8].minor.yy397, &yymsp[-5].minor.yy199, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy530, yymsp[0].minor.yy706); }
        break;
      case 290: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 295: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy397, &yymsp[-7].minor.yy199, yymsp[-4].minor.yy148, yymsp[-6].minor.yy148, yymsp[-3].minor.yy404, yymsp[-2].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 296: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy199); }
        break;
      case 298: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 299: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 300: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy148)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy148)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); yylhsminor.yy148 = yymsp[-3].minor.yy148; }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 302: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy148)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy148 = yymsp[-3].minor.yy148; }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 303: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy148)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy148 = yymsp[-2].minor.yy148; }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 305: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 490: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==490);
      case 508: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==508);
{ yymsp[-3].minor.yy148 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy148); }
        break;
      case 306: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 307: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 308: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 309: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 310: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 311: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy404); }
        break;
      case 312: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 313: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy404 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 315: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 317: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy148, yymsp[-2].minor.yy404, yymsp[0].minor.yy148); }
        break;
      case 318: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy148, NULL, yymsp[0].minor.yy148); }
        break;
      case 319: /* literal ::= NK_INTEGER */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 320: /* literal ::= NK_FLOAT */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 321: /* literal ::= NK_STRING */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 322: /* literal ::= NK_BOOL */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 323: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 324: /* literal ::= duration_literal */
      case 334: /* signed_literal ::= signed */ yytestcase(yyruleno==334);
      case 354: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==354);
      case 355: /* expression ::= literal */ yytestcase(yyruleno==355);
      case 356: /* expression ::= pseudo_column */ yytestcase(yyruleno==356);
      case 357: /* expression ::= column_reference */ yytestcase(yyruleno==357);
      case 358: /* expression ::= function_expression */ yytestcase(yyruleno==358);
      case 359: /* expression ::= case_when_expression */ yytestcase(yyruleno==359);
      case 389: /* function_expression ::= literal_func */ yytestcase(yyruleno==389);
      case 438: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==438);
      case 442: /* boolean_primary ::= predicate */ yytestcase(yyruleno==442);
      case 444: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==444);
      case 445: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==445);
      case 448: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==448);
      case 450: /* table_reference ::= table_primary */ yytestcase(yyruleno==450);
      case 451: /* table_reference ::= joined_table */ yytestcase(yyruleno==451);
      case 455: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==455);
      case 510: /* query_simple ::= query_specification */ yytestcase(yyruleno==510);
      case 511: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==511);
      case 514: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==514);
      case 516: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==516);
{ yylhsminor.yy148 = yymsp[0].minor.yy148; }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 325: /* literal ::= NULL */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 326: /* literal ::= NK_QUESTION */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 327: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 328: /* signed ::= NK_INTEGER */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 329: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 330: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 331: /* signed ::= NK_FLOAT */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 332: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 333: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 335: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 336: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 337: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 338: /* signed_literal ::= duration_literal */
      case 340: /* signed_literal ::= literal_func */ yytestcase(yyruleno==340);
      case 409: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==409);
      case 471: /* select_item ::= common_expression */ yytestcase(yyruleno==471);
      case 481: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==481);
      case 515: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==515);
      case 517: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==517);
      case 530: /* search_condition ::= common_expression */ yytestcase(yyruleno==530);
{ yylhsminor.yy148 = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 339: /* signed_literal ::= NULL */
{ yylhsminor.yy148 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 341: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy148 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 360: /* expression ::= NK_LP expression NK_RP */
      case 443: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==443);
      case 529: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==529);
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 361: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy148));
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 362: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy148), NULL));
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 363: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 364: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 365: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 366: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 367: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 368: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 369: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 370: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 373: /* column_reference ::= column_name */
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy199, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy199)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 374: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199, createColumnNode(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy199)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 375: /* pseudo_column ::= ROWTS */
      case 376: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==376);
      case 378: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==378);
      case 379: /* pseudo_column ::= QEND */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==380);
      case 381: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= WEND */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==385);
      case 391: /* literal_func ::= NOW */ yytestcase(yyruleno==391);
{ yylhsminor.yy148 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 377: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy199)))); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 386: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 387: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==387);
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy199, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy199, yymsp[-1].minor.yy404)); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 388: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-1].minor.yy530)); }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 390: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy199, NULL)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 405: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy404 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 410: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 474: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==474);
{ yylhsminor.yy148 = createColumnNode(pCxt, &yymsp[-2].minor.yy199, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 411: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy404, yymsp[-1].minor.yy148)); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 412: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-2].minor.yy404, yymsp[-1].minor.yy148)); }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 415: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy148 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)); }
        break;
      case 417: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy148 = releaseRawExprNode(pCxt, yymsp[0].minor.yy148); }
        break;
      case 418: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 423: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==423);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy20, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 419: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy148), releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-4].minor.yy148 = yylhsminor.yy148;
        break;
      case 420: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy148), releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 421: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), NULL));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 422: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), NULL));
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 424: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_THAN; }
        break;
      case 425: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_THAN; }
        break;
      case 426: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 427: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 428: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy20 = OP_TYPE_NOT_EQUAL; }
        break;
      case 429: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy20 = OP_TYPE_EQUAL; }
        break;
      case 430: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy20 = OP_TYPE_LIKE; }
        break;
      case 431: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_LIKE; }
        break;
      case 432: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_MATCH; }
        break;
      case 433: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_NMATCH; }
        break;
      case 434: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy20 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 435: /* in_op ::= IN */
{ yymsp[0].minor.yy20 = OP_TYPE_IN; }
        break;
      case 436: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_IN; }
        break;
      case 437: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 439: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy148), NULL));
                                                                                  }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 440: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 441: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy148);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy148);
                                                                                    yylhsminor.yy148 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), releaseRawExprNode(pCxt, yymsp[0].minor.yy148)));
                                                                                  }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 447: /* from_clause_opt ::= FROM table_reference_list */
      case 476: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==476);
      case 504: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==504);
{ yymsp[-1].minor.yy148 = yymsp[0].minor.yy148; }
        break;
      case 449: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy148 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy148, yymsp[0].minor.yy148, NULL); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 452: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy148 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 453: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy148 = createRealTableNode(pCxt, &yymsp[-3].minor.yy199, &yymsp[-1].minor.yy199, &yymsp[0].minor.yy199); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 454: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy148 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148), &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 456: /* alias_opt ::= */
{ yymsp[1].minor.yy199 = nil_token;  }
        break;
      case 458: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy199 = yymsp[0].minor.yy199; }
        break;
      case 459: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 460: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==460);
{ yymsp[-2].minor.yy148 = yymsp[-1].minor.yy148; }
        break;
      case 461: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy148 = createJoinTableNode(pCxt, yymsp[-4].minor.yy470, yymsp[-5].minor.yy148, yymsp[-2].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-5].minor.yy148 = yylhsminor.yy148;
        break;
      case 462: /* join_type ::= */
{ yymsp[1].minor.yy470 = JOIN_TYPE_INNER; }
        break;
      case 463: /* join_type ::= INNER */
{ yymsp[0].minor.yy470 = JOIN_TYPE_INNER; }
        break;
      case 464: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy148 = createSelectStmt(pCxt, yymsp[-10].minor.yy397, yymsp[-9].minor.yy404, yymsp[-8].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addWhereClause(pCxt, yymsp[-11].minor.yy148, yymsp[-7].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addPartitionByClause(pCxt, yymsp[-11].minor.yy148, yymsp[-6].minor.yy404);
                                                                                    yymsp[-11].minor.yy148 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy148, yymsp[-2].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addGroupByClause(pCxt, yymsp[-11].minor.yy148, yymsp[-1].minor.yy404);
                                                                                    yymsp[-11].minor.yy148 = addHavingClause(pCxt, yymsp[-11].minor.yy148, yymsp[0].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addRangeClause(pCxt, yymsp[-11].minor.yy148, yymsp[-5].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addEveryClause(pCxt, yymsp[-11].minor.yy148, yymsp[-4].minor.yy148);
                                                                                    yymsp[-11].minor.yy148 = addFillClause(pCxt, yymsp[-11].minor.yy148, yymsp[-3].minor.yy148);
                                                                                  }
        break;
      case 467: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy397 = false; }
        break;
      case 470: /* select_item ::= NK_STAR */
{ yylhsminor.yy148 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 472: /* select_item ::= common_expression column_alias */
      case 482: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==482);
{ yylhsminor.yy148 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148), &yymsp[0].minor.yy199); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 473: /* select_item ::= common_expression AS column_alias */
      case 483: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==483);
{ yylhsminor.yy148 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), &yymsp[0].minor.yy199); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 478: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 500: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==500);
      case 519: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==519);
{ yymsp[-2].minor.yy404 = yymsp[0].minor.yy404; }
        break;
      case 485: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy148 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 486: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy148 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 487: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy148 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), NULL, yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 488: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy148 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy148), releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), yymsp[-1].minor.yy148, yymsp[0].minor.yy148); }
        break;
      case 492: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy148 = createFillNode(pCxt, yymsp[-1].minor.yy334, NULL); }
        break;
      case 493: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy148 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
        break;
      case 494: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy334 = FILL_MODE_NONE; }
        break;
      case 495: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy334 = FILL_MODE_PREV; }
        break;
      case 496: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy334 = FILL_MODE_NULL; }
        break;
      case 497: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy334 = FILL_MODE_LINEAR; }
        break;
      case 498: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy334 = FILL_MODE_NEXT; }
        break;
      case 501: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy404 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 502: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy148))); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 506: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy148 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy148), releaseRawExprNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 509: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy148 = addOrderByClause(pCxt, yymsp[-3].minor.yy148, yymsp[-2].minor.yy404);
                                                                                    yylhsminor.yy148 = addSlimitClause(pCxt, yylhsminor.yy148, yymsp[-1].minor.yy148);
                                                                                    yylhsminor.yy148 = addLimitClause(pCxt, yylhsminor.yy148, yymsp[0].minor.yy148);
                                                                                  }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 512: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy148 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-3].minor.yy148 = yylhsminor.yy148;
        break;
      case 513: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy148 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy148, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 521: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 525: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==525);
{ yymsp[-1].minor.yy148 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 522: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 526: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==526);
{ yymsp[-3].minor.yy148 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 523: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 527: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==527);
{ yymsp[-3].minor.yy148 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 528: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy148 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy148); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 533: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy148 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy148), yymsp[-1].minor.yy898, yymsp[0].minor.yy499); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 534: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy898 = ORDER_ASC; }
        break;
      case 535: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy898 = ORDER_ASC; }
        break;
      case 536: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy898 = ORDER_DESC; }
        break;
      case 537: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy499 = NULL_ORDER_DEFAULT; }
        break;
      case 538: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy499 = NULL_ORDER_FIRST; }
        break;
      case 539: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy499 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
