---
sidebar_label: Go
title: Connect with Go Connector
description: Connect to TDengine cloud service using Go connector
---

<!-- exclude -->
import Tabs from '@theme/Tabs';
import TabItem from '@theme/TabItem';

<!-- exclude-end -->
## Initialize Module

```
go mod init tdengine.com/example
```

## Add Dependency

add `driver-go` dependency in `go.mod` .

```go-mod title="go.mod"
{{#include docs/examples/go/connectexample/go.mod}}
```

## Config

Run this command in your terminal to save DSN(data source name) as variable:

<Tabs defaultValue="bash">
<TabItem value="bash" label="Bash">

```bash
export TDENGINE_GO_DSN="<goDSN>"
```

</TabItem>
<TabItem value="cmd" label="CMD">

```bash
set TDENGINE_GO_DSN=<goDSN>
```

</TabItem>
<TabItem value="powershell" label="Powershell">

```powershell
$env:TDENGINE_GO_DSN='<goDSN>'
```

</TabItem>
</Tabs>


<!-- exclude -->
:::note
Replace <goDSN\> with the real value, the format should be `https(<cloud_endpoint>)/?token=<token>`.
To obtain the value of `goDSN`, please log in [TDengine Cloud](https://cloud.tdengine.com) and click "Programming" on the left menu, then select "Go".

:::
<!-- exclude-end -->

## Connect

Copy code bellow to main.go.

```go title="main.go"
{{#include docs/examples/go/connectexample/main.go}}
```

Then download dependencies by execute command:

```
go mod tidy
```

Finally, test the connection:

```
go run main.go
```

The client connection is then established.  For how to write data and query data, please refer to <https://docs.tdengine.com/cloud/data-in/insert-data/> and <https://docs.tdengine.com/cloud/data-out/query-data/>.

For more details about how to write or query data via REST API, please check [REST API](https://docs.tdengine.com/cloud/programming/connector/rest-api/).
