using System;
using Test.UtilsTools;
using TDengineDriver;
using Test.UtilsTools.DataSource;

namespace Cases
{
    public class NtableSingleLine
    {
        /// <author>xiaolei</author>
        /// <Name>NtableSingleLine.Test</Name>
        /// <describe>Test stmt insert sinle line data into normal table</describe>
        /// <filename>StmtNormalTable.cs</filename>
        /// <result>pass or failed </result>  
        public void Test(IntPtr conn, string tableName)
        {
            String createTb = "create table " + tableName + "(ts timestamp,tt tinyint,si smallint,ii int,bi bigint,tu tinyint unsigned,su smallint unsigned,iu int unsigned,bu bigint unsigned,ff float ,dd double ,bb binary(200),nc nchar(200),bo bool,nullVal int);";
            String insertSql = "insert into ? values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            TAOS_BIND[] valuesRow = DataSource.getNtableRow();
            UtilsTools.ExecuteQuery(conn, createTb);

            IntPtr stmt = StmtUtilTools.StmtInit(conn);
            StmtUtilTools.StmtPrepare(stmt, insertSql);
            StmtUtilTools.SetTableName(stmt, tableName);
            StmtUtilTools.BindParam(stmt, valuesRow);
            StmtUtilTools.AddBatch(stmt);
            StmtUtilTools.StmtExecute(stmt);
            StmtUtilTools.StmtClose(stmt);
            DataSource.FreeTaosBind(valuesRow);

        }
    }

    public class NtableMutipleLine
    {
        /// <author>xiaolei</author>
        /// <Name>NtableMutipleLine.Test</Name>
        /// <describe>Test stmt insert multiple rows of data into normal table</describe>
        /// <filename>StmtNormalTable.cs</filename>
        /// <result>pass or failed </result>  
        public void Test(IntPtr conn, string tableName)
        {
            TAOS_MULTI_BIND[] mbind = DataSource.GetMultiBindArr();
            String createTb = "create table " + tableName + " (ts timestamp ,b bool,v1 tinyint,v2 smallint,v4 int,v8 bigint,f4 float,f8 double,u1 tinyint unsigned,u2 smallint unsigned,u4 int unsigned,u8 bigint unsigned,bin binary(200),blob nchar(200));";
            String insertSql = "insert into ? values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

            UtilsTools.ExecuteUpdate(conn, createTb);

            IntPtr stmt = StmtUtilTools.StmtInit(conn);
            StmtUtilTools.StmtPrepare(stmt, insertSql);
            StmtUtilTools.SetTableName(stmt, tableName);
            StmtUtilTools.BindParamBatch(stmt, mbind);
            StmtUtilTools.AddBatch(stmt);
            StmtUtilTools.StmtExecute(stmt);
            StmtUtilTools.StmtClose(stmt);
            DataSource.FreeTaosMBind(mbind);
        }
    }
    public class NtableColumnByColumn
    {
        /// <author>xiaolei</author>
        /// <Name>NtableColumnByColumn.Test</Name>
        /// <describe>Test stmt insert multiple rows of data into normal table by column after column </describe>
        /// <filename>StmtNormalTable.cs</filename>
        /// <result>pass or failed </result>  
        public void Test(IntPtr conn, string tableName)
        {
            DataSource data = new DataSource();
            TAOS_MULTI_BIND[] mbind = DataSource.GetMultiBindArr();
            String createTb = "create table " + tableName + " (ts timestamp ,b bool,v1 tinyint,v2 smallint,v4 int,v8 bigint,f4 float,f8 double,u1 tinyint unsigned,u2 smallint unsigned,u4 int unsigned,u8 bigint unsigned,bin binary(200),blob nchar(200));";
            String insertSql = "insert into ?  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";


            UtilsTools.ExecuteUpdate(conn, createTb);
            IntPtr stmt = StmtUtilTools.StmtInit(conn);

            StmtUtilTools.StmtPrepare(stmt, insertSql);

            StmtUtilTools.SetTableName(stmt, tableName);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[0], 0);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[1], 1);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[2], 2);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[3], 3);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[4], 4);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[5], 5);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[6], 6);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[7], 7);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[8], 8);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[9], 9);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[10], 10);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[11], 11);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[12], 12);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[13], 13);

            StmtUtilTools.AddBatch(stmt);
            StmtUtilTools.StmtExecute(stmt);
            StmtUtilTools.StmtClose(stmt);

            DataSource.FreeTaosMBind(mbind);

        }
    }

    public class NormalTableStmtCases
    {
        /// <author>xiaolei</author>
        /// <Name>NormalTableStmtCases.TestBindSingleLineCn</Name>
        /// <describe>Test stmt insert single line of chinese character into normal table by column after column </describe>
        /// <filename>StmtNormalTable.cs</filename>
        /// <result>pass or failed </result>  
        public void TestBindSingleLineCn(IntPtr conn, string tableName)
        {
            String createTb = "create table " + tableName + "(ts timestamp,tt tinyint,si smallint,ii int,bi bigint,tu tinyint unsigned,su smallint unsigned,iu int unsigned,bu bigint unsigned,ff float ,dd double ,bb binary(200),nc nchar(200),bo bool,nullVal int);";
            String insertSql = "insert into ? values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            TAOS_BIND[] valuesRow = DataSource.getNtableCNRow();
            UtilsTools.ExecuteUpdate(conn, createTb);

            IntPtr stmt = StmtUtilTools.StmtInit(conn);
            StmtUtilTools.StmtPrepare(stmt, insertSql);
            StmtUtilTools.SetTableName(stmt, tableName);
            StmtUtilTools.BindParam(stmt, valuesRow);
            StmtUtilTools.AddBatch(stmt);
            StmtUtilTools.StmtExecute(stmt);
            StmtUtilTools.StmtClose(stmt);
            DataSource.FreeTaosBind(valuesRow);

            string querySql = "select * from " + tableName;
            IntPtr res = UtilsTools.ExecuteQuery(conn, querySql);
            UtilsTools.DisplayRes(res);

        }

        /// <author>xiaolei</author>
        /// <Name>NormalTableStmtCases.TestBindColumnCn</Name>
        /// <describe>Test stmt insert single line of chinese character into normal table by column after column </describe>
        /// <filename>StmtNormalTable.cs</filename>
        /// <result>pass or failed </result>  
        public void TestBindColumnCn(IntPtr conn,string tableName)
        {
            DataSource data = new DataSource();
            TAOS_MULTI_BIND[] mbind = DataSource.GetMultiBindCNArr();
            String createTb = "create table " + tableName + " (ts timestamp ,b bool,v1 tinyint,v2 smallint,v4 int,v8 bigint,f4 float,f8 double,u1 tinyint unsigned,u2 smallint unsigned,u4 int unsigned,u8 bigint unsigned,bin binary(200),blob nchar(200));";
            String insertSql = "insert into ?  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";


            UtilsTools.ExecuteUpdate(conn, createTb);
            IntPtr stmt = StmtUtilTools.StmtInit(conn);

            StmtUtilTools.StmtPrepare(stmt, insertSql);

            StmtUtilTools.SetTableName(stmt, tableName);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[0], 0);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[1], 1);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[2], 2);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[3], 3);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[4], 4);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[5], 5);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[6], 6);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[7], 7);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[8], 8);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[9], 9);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[10], 10);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[11], 11);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[12], 12);
            StmtUtilTools.BindSingleParamBatch(stmt, mbind[13], 13);

            StmtUtilTools.AddBatch(stmt);
            StmtUtilTools.StmtExecute(stmt);
            StmtUtilTools.StmtClose(stmt);

            DataSource.FreeTaosMBind(mbind);

            string querySql = "select * from " + tableName;
            IntPtr res = UtilsTools.ExecuteQuery(conn, querySql);
            UtilsTools.DisplayRes(res);
        }
        /// <author>xiaolei</author>
        /// <Name>NormalTableStmtCases.TestBindMultiLineCn</Name>
        /// <describe>Test stmt insert single line of chinese character into normal table by column after column </describe>
        /// <filename>StmtNormalTable.cs</filename>
        /// <result>pass or failed </result>  
        public void TestBindMultiLineCn(IntPtr conn, string tableName)
        {
            TAOS_MULTI_BIND[] mbind = DataSource.GetMultiBindCNArr();
            String createTb = "create table " + tableName + " (ts timestamp ,b bool,v1 tinyint,v2 smallint,v4 int,v8 bigint,f4 float,f8 double,u1 tinyint unsigned,u2 smallint unsigned,u4 int unsigned,u8 bigint unsigned,bin binary(200),blob nchar(200));";
            String insertSql = "insert into ? values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

            UtilsTools.ExecuteUpdate(conn, createTb);

            IntPtr stmt = StmtUtilTools.StmtInit(conn);
            StmtUtilTools.StmtPrepare(stmt, insertSql);
            StmtUtilTools.SetTableName(stmt, tableName);
            StmtUtilTools.BindParamBatch(stmt, mbind);
            StmtUtilTools.AddBatch(stmt);
            StmtUtilTools.StmtExecute(stmt);
            StmtUtilTools.StmtClose(stmt);
            
            DataSource.FreeTaosMBind(mbind);

            string querySql = "select * from " + tableName;
            IntPtr res = UtilsTools.ExecuteQuery(conn, querySql);
            UtilsTools.DisplayRes(res);
        }
    }
}