import sys 
from util.log import *
from util.cases import *
from util.sql import *
from util.dnodes import tdDnodes
from math import inf

class TDTestCase:
    def caseDescription(self):
        '''
        case1<shenglian zhou>: [TD-14123]: fix failed test on arm64 by converting from sim tst to python test to overcome NaN value and its string representation 
        ''' 
        return
    
    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)
        self._conn = conn
        
    def restartTaosd(self, index=1, dbname="db"):
        tdDnodes.stop(index)
        tdDnodes.startWithoutSleep(index)
        tdSql.execute(f"use db0")

    def run(self):
        print("running {}".format(__file__))
        tdSql.execute("drop database if exists db0")
        tdSql.execute("create database if not exists db0")
        tdSql.execute('use db0')
        tdSql.execute('create table st0 (ts timestamp, c1 int, c2 float, c3 bigint, c4 smallint, c5 tinyint, c6 double, c7 bool, c8 nchar(5), c9 binary(10)) TAGS (tgcol int);')

        tdSql.execute('create table ct0 using st0 tags( 0 );')
        tdSql.execute('insert into ct0 values (1601481600000 , 0 , 0.25 , 0 , 0 , 0 , 0.25 , 0 , 0 , 0 );')
        for i in range(1, 50):
            tdSql.execute('insert into ct0 values ({}, {}, {}, {}, {}, {}, {}, {}, {}, {});'.format(1601481600000 + i * 60000,
                i , i , i , i , i , i , i , i , i ))

        tdSql.execute('create table ct1 using st0 tags( 1 );')
        tdSql.execute('insert into ct1 values (1601481600000 , 0 , 0.25 , 0 , 0 , 0 , 0.25 , 0 , 0 , 0 );')
        for i in range(1, 50):
            tdSql.execute('insert into ct1 values ({}, {}, {}, {}, {}, {}, {}, {}, {}, {});'.format(1601481600000 + i * 60000,
                i , i , i , i , i , i , i , i , i ))


        tdSql.query('select floor(3.0)+ceil(4.0) from  ct0;')
        tdSql.checkRows(50)
        for row in range(0, 50):
            tdSql.checkData(row, 0, 7.0)


        tdSql.query('select sum(c1)+3.0+4.0 from st0;')
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2457.0)

        tdSql.query('select sin(log(avg(c1),sum(c2))+3)%4 from st0;')
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.26507428560248714)

        tdSql.query("select log(pow(length(concat('3','4')),2),c2) from st0;")
        tdSql.checkRows(100)
        tdSql.checkData(0, 0, -1.0)
        tdSql.checkData(1, 0, inf)
        tdSql.checkData(2, 0, 2.0)
        tdSql.checkData(3, 0, 1.2618595071429148)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.8613531161467861)
        tdSql.checkData(6, 0, 0.7737056144690831)
        tdSql.checkData(7, 0, 0.7124143742160444)
        tdSql.checkData(8, 0, 0.6666666666666667)
        tdSql.checkData(9, 0, 0.6309297535714574)
        tdSql.checkData(10, 0, 0.6020599913279623)
        tdSql.checkData(11, 0, 0.5781296526357756)
        tdSql.checkData(12, 0, 0.5578858913022596)
        tdSql.checkData(13, 0, 0.5404763088546395)
        tdSql.checkData(14, 0, 0.5252990700743871)
        tdSql.checkData(15, 0, 0.511916049619631)
        tdSql.checkData(16, 0, 0.5)
        tdSql.checkData(17, 0, 0.489301084236452)
        tdSql.checkData(18, 0, 0.4796249331362629)
        tdSql.checkData(19, 0, 0.4708178267332765)
        tdSql.checkData(20, 0, 0.46275642631951835)
        tdSql.checkData(21, 0, 0.455340497393906)
        tdSql.checkData(22, 0, 0.4484876484351508)
        tdSql.checkData(23, 0, 0.4421294589150075)
        tdSql.checkData(24, 0, 0.4362085839710631)
        tdSql.checkData(25, 0, 0.43067655807339306)
        tdSql.checkData(26, 0, 0.4254921071067263)
        tdSql.checkData(27, 0, 0.42061983571430495)
        tdSql.checkData(28, 0, 0.4160291953530189)
        tdSql.checkData(29, 0, 0.4116936649208689)
        tdSql.checkData(30, 0, 0.40759009418101233)
        tdSql.checkData(31, 0, 0.4036981731641997)
        tdSql.checkData(32, 0, 0.39999999999999997)
        tdSql.checkData(33, 0, 0.39647972634112105)
        tdSql.checkData(34, 0, 0.39312326446564516)
        tdSql.checkData(35, 0, 0.3899180437875726)
        tdSql.checkData(36, 0, 0.3868528072345416)
        tdSql.checkData(37, 0, 0.3839174400131203)
        tdSql.checkData(38, 0, 0.3811028248535468)
        tdSql.checkData(39, 0, 0.37840071903374006)
        tdSql.checkData(40, 0, 0.37580364941821515)
        tdSql.checkData(41, 0, 0.3733048224778867)
        tdSql.checkData(42, 0, 0.3708980468307378)
        tdSql.checkData(43, 0, 0.36857766629741234)
        tdSql.checkData(44, 0, 0.36633850182726724)
        tdSql.checkData(45, 0, 0.3641758009398765)
        tdSql.checkData(46, 0, 0.3620851935600804)
        tdSql.checkData(47, 0, 0.3600626533133853)
        tdSql.checkData(48, 0, 0.3581044635020827)
        tdSql.checkData(49, 0, 0.3562071871080222)
        tdSql.checkData(50, 0, -1.0)
        tdSql.checkData(51, 0, inf)
        tdSql.checkData(52, 0, 2.0)
        tdSql.checkData(53, 0, 1.2618595071429148)
        tdSql.checkData(54, 0, 1.0)
        tdSql.checkData(55, 0, 0.8613531161467861)
        tdSql.checkData(56, 0, 0.7737056144690831)
        tdSql.checkData(57, 0, 0.7124143742160444)
        tdSql.checkData(58, 0, 0.6666666666666667)
        tdSql.checkData(59, 0, 0.6309297535714574)
        tdSql.checkData(60, 0, 0.6020599913279623)
        tdSql.checkData(61, 0, 0.5781296526357756)
        tdSql.checkData(62, 0, 0.5578858913022596)
        tdSql.checkData(63, 0, 0.5404763088546395)
        tdSql.checkData(64, 0, 0.5252990700743871)
        tdSql.checkData(65, 0, 0.511916049619631)
        tdSql.checkData(66, 0, 0.5)
        tdSql.checkData(67, 0, 0.489301084236452)
        tdSql.checkData(68, 0, 0.4796249331362629)
        tdSql.checkData(69, 0, 0.4708178267332765)
        tdSql.checkData(70, 0, 0.46275642631951835)
        tdSql.checkData(71, 0, 0.455340497393906)
        tdSql.checkData(72, 0, 0.4484876484351508)
        tdSql.checkData(73, 0, 0.4421294589150075)
        tdSql.checkData(74, 0, 0.4362085839710631)
        tdSql.checkData(75, 0, 0.43067655807339306)
        tdSql.checkData(76, 0, 0.4254921071067263)
        tdSql.checkData(77, 0, 0.42061983571430495)
        tdSql.checkData(78, 0, 0.4160291953530189)
        tdSql.checkData(79, 0, 0.4116936649208689)
        tdSql.checkData(80, 0, 0.40759009418101233)
        tdSql.checkData(81, 0, 0.4036981731641997)
        tdSql.checkData(82, 0, 0.39999999999999997)
        tdSql.checkData(83, 0, 0.39647972634112105)
        tdSql.checkData(84, 0, 0.39312326446564516)
        tdSql.checkData(85, 0, 0.3899180437875726)
        tdSql.checkData(86, 0, 0.3868528072345416)
        tdSql.checkData(87, 0, 0.3839174400131203)
        tdSql.checkData(88, 0, 0.3811028248535468)
        tdSql.checkData(89, 0, 0.37840071903374006)
        tdSql.checkData(90, 0, 0.37580364941821515)
        tdSql.checkData(91, 0, 0.3733048224778867)
        tdSql.checkData(92, 0, 0.3708980468307378)
        tdSql.checkData(93, 0, 0.36857766629741234)
        tdSql.checkData(94, 0, 0.36633850182726724)
        tdSql.checkData(95, 0, 0.3641758009398765)
        tdSql.checkData(96, 0, 0.3620851935600804)
        tdSql.checkData(97, 0, 0.3600626533133853)
        tdSql.checkData(98, 0, 0.3581044635020827)
        tdSql.checkData(99, 0, 0.3562071871080222)

        tdSql.query("select round(log(pow(length(concat('3','4')),2),c2)+floor(c3))+2 from st0;")
        tdSql.checkRows(100)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, inf)
        tdSql.checkData(2, 0, 6.0)
        tdSql.checkData(3, 0, 6.0)
        tdSql.checkData(4, 0, 7.0)
        tdSql.checkData(5, 0, 8.0)
        tdSql.checkData(6, 0, 9.0)
        tdSql.checkData(7, 0, 10.0)
        tdSql.checkData(8, 0, 11.0)
        tdSql.checkData(9, 0, 12.0)
        tdSql.checkData(10, 0, 13.0)
        tdSql.checkData(11, 0, 14.0)
        tdSql.checkData(12, 0, 15.0)
        tdSql.checkData(13, 0, 16.0)
        tdSql.checkData(14, 0, 17.0)
        tdSql.checkData(15, 0, 18.0)
        tdSql.checkData(16, 0, 19.0)
        tdSql.checkData(17, 0, 19.0)
        tdSql.checkData(18, 0, 20.0)
        tdSql.checkData(19, 0, 21.0)
        tdSql.checkData(20, 0, 22.0)
        tdSql.checkData(21, 0, 23.0)
        tdSql.checkData(22, 0, 24.0)
        tdSql.checkData(23, 0, 25.0)
        tdSql.checkData(24, 0, 26.0)
        tdSql.checkData(25, 0, 27.0)
        tdSql.checkData(26, 0, 28.0)
        tdSql.checkData(27, 0, 29.0)
        tdSql.checkData(28, 0, 30.0)
        tdSql.checkData(29, 0, 31.0)
        tdSql.checkData(30, 0, 32.0)
        tdSql.checkData(31, 0, 33.0)
        tdSql.checkData(32, 0, 34.0)
        tdSql.checkData(33, 0, 35.0)
        tdSql.checkData(34, 0, 36.0)
        tdSql.checkData(35, 0, 37.0)
        tdSql.checkData(36, 0, 38.0)
        tdSql.checkData(37, 0, 39.0)
        tdSql.checkData(38, 0, 40.0)
        tdSql.checkData(39, 0, 41.0)
        tdSql.checkData(40, 0, 42.0)
        tdSql.checkData(41, 0, 43.0)
        tdSql.checkData(42, 0, 44.0)
        tdSql.checkData(43, 0, 45.0)
        tdSql.checkData(44, 0, 46.0)
        tdSql.checkData(45, 0, 47.0)
        tdSql.checkData(46, 0, 48.0)
        tdSql.checkData(47, 0, 49.0)
        tdSql.checkData(48, 0, 50.0)
        tdSql.checkData(49, 0, 51.0)
        tdSql.checkData(50, 0, 1.0)
        tdSql.checkData(51, 0, inf)
        tdSql.checkData(52, 0, 6.0)
        tdSql.checkData(53, 0, 6.0)
        tdSql.checkData(54, 0, 7.0)
        tdSql.checkData(55, 0, 8.0)
        tdSql.checkData(56, 0, 9.0)
        tdSql.checkData(57, 0, 10.0)
        tdSql.checkData(58, 0, 11.0)
        tdSql.checkData(59, 0, 12.0)
        tdSql.checkData(60, 0, 13.0)
        tdSql.checkData(61, 0, 14.0)
        tdSql.checkData(62, 0, 15.0)
        tdSql.checkData(63, 0, 16.0)
        tdSql.checkData(64, 0, 17.0)
        tdSql.checkData(65, 0, 18.0)
        tdSql.checkData(66, 0, 19.0)
        tdSql.checkData(67, 0, 19.0)
        tdSql.checkData(68, 0, 20.0)
        tdSql.checkData(69, 0, 21.0)
        tdSql.checkData(70, 0, 22.0)
        tdSql.checkData(71, 0, 23.0)
        tdSql.checkData(72, 0, 24.0)
        tdSql.checkData(73, 0, 25.0)
        tdSql.checkData(74, 0, 26.0)
        tdSql.checkData(75, 0, 27.0)
        tdSql.checkData(76, 0, 28.0)
        tdSql.checkData(77, 0, 29.0)
        tdSql.checkData(78, 0, 30.0)
        tdSql.checkData(79, 0, 31.0)
        tdSql.checkData(80, 0, 32.0)
        tdSql.checkData(81, 0, 33.0)
        tdSql.checkData(82, 0, 34.0)
        tdSql.checkData(83, 0, 35.0)
        tdSql.checkData(84, 0, 36.0)
        tdSql.checkData(85, 0, 37.0)
        tdSql.checkData(86, 0, 38.0)
        tdSql.checkData(87, 0, 39.0)
        tdSql.checkData(88, 0, 40.0)
        tdSql.checkData(89, 0, 41.0)
        tdSql.checkData(90, 0, 42.0)
        tdSql.checkData(91, 0, 43.0)
        tdSql.checkData(92, 0, 44.0)
        tdSql.checkData(93, 0, 45.0)
        tdSql.checkData(94, 0, 46.0)
        tdSql.checkData(95, 0, 47.0)
        tdSql.checkData(96, 0, 48.0)
        tdSql.checkData(97, 0, 49.0)
        tdSql.checkData(98, 0, 50.0)
        tdSql.checkData(99, 0, 51.0)

        tdSql.query('select sin(pow(c1,log(c2,2))+pow(c2,2)) as val from ct0 union all select pow(c4,2)+tan(sin(c5)/cos(c6)) as val from ct1;')
        tdSql.checkRows(100)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(2, 0, -0.27941549819892586)
        tdSql.checkData(3, 0, 0.8433250578156978)
        tdSql.checkData(4, 0, 0.5514266812416906)
        tdSql.checkData(5, 0, -0.8406066116666611)
        tdSql.checkData(6, 0, 0.43616107578365054)
        tdSql.checkData(7, 0, 0.8974981847584117)
        tdSql.checkData(8, 0, -0.8859527784925297)
        tdSql.checkData(9, 0, 0.42947071474131504)
        tdSql.checkData(10, 0, -0.4990148939921768)
        tdSql.checkData(11, 0, -0.9668503083455382)
        tdSql.checkData(12, 0, -0.37127069611623675)
        tdSql.checkData(13, 0, 0.2583602129593735)
        tdSql.checkData(14, 0, -0.34510090189538883)
        tdSql.checkData(15, 0, 0.8660995395285155)
        tdSql.checkData(16, 0, 0.6937252720798969)
        tdSql.checkData(17, 0, -0.992591182028628)
        tdSql.checkData(18, 0, -0.9291960033052914)
        tdSql.checkData(19, 0, -0.011614784632622178)
        tdSql.checkData(20, 0, -0.4106856453154767)
        tdSql.checkData(21, 0, -0.36067689504566286)
        tdSql.checkData(22, 0, 0.9703087105252133)
        tdSql.checkData(23, 0, 0.3329834227491301)
        tdSql.checkData(24, 0, -0.7486629772768763)
        tdSql.checkData(25, 0, -0.971394847828127)
        tdSql.checkData(26, 0, 0.5985902145855062)
        tdSql.checkData(27, 0, -0.49186655944242286)
        tdSql.checkData(28, 0, -0.4105290272382008)
        tdSql.checkData(29, 0, -0.202908293443662)
        tdSql.checkData(30, 0, -0.9672568013002486)
        tdSql.checkData(31, 0, -0.9144905798912761)
        tdSql.checkData(32, 0, -0.930013601079518)
        tdSql.checkData(33, 0, 0.004918394988330845)
        tdSql.checkData(34, 0, 0.720122562285698)
        tdSql.checkData(35, 0, 0.931470218951081)
        tdSql.checkData(36, 0, 0.8941486584814015)
        tdSql.checkData(37, 0, 0.6498985856147372)
        tdSql.checkData(38, 0, -0.9337541085366605)
        tdSql.checkData(39, 0, -0.7860584458249767)
        tdSql.checkData(40, 0, 0.9097616965457492)
        tdSql.checkData(41, 0, 0.9262772442878136)
        tdSql.checkData(42, 0, 0.9002636423705703)
        tdSql.checkData(43, 0, 0.9333612649834834)
        tdSql.checkData(44, 0, 0.08098252188677987)
        tdSql.checkData(45, 0, -0.2669453821977269)
        tdSql.checkData(46, 0, -0.9864147915539295)
        tdSql.checkData(47, 0, 0.7905555341403578)
        tdSql.checkData(48, 0, 0.9930380419415296)
        tdSql.checkData(49, 0, -0.11973938558937497)
        tdSql.checkData(50, 0, 0.0)
        tdSql.checkData(51, 0, 75.68593339876413)
        tdSql.checkData(52, 0, 5.417928575505387)
        tdSql.checkData(53, 0, 8.85648005221507)
        tdSql.checkData(54, 0, 18.282204450191365)
        tdSql.checkData(55, 0, 24.756425180209273)
        tdSql.checkData(56, 0, 35.7004910910186)
        tdSql.checkData(57, 0, 50.188813241198766)
        tdSql.checkData(58, 0, 63.43204170645191)
        tdSql.checkData(59, 0, 80.51408573049088)
        tdSql.checkData(60, 0, 100.75762114788726)
        tdSql.checkData(61, 0, 121.24877416559158)
        tdSql.checkData(62, 0, 143.26187154057212)
        tdSql.checkData(63, 0, 169.49921715003558)
        tdSql.checkData(64, 0, 197.43268735470073)
        tdSql.checkData(65, 0, 223.84781294184071)
        tdSql.checkData(66, 0, 256.31002912578884)
        tdSql.checkData(67, 0, 289.36766325453783)
        tdSql.checkData(68, 0, 321.83943972533865)
        tdSql.checkData(69, 0, 361.1527613871425)
        tdSql.checkData(70, 0, 398.72830803672844)
        tdSql.checkData(71, 0, 417.9185722713414)
        tdSql.checkData(72, 0, 484.00885188723004)
        tdSql.checkData(73, 0, 471.3913348423639)
        tdSql.checkData(74, 0, 577.5805869142416)
        tdSql.checkData(75, 0, 624.8656743315343)
        tdSql.checkData(76, 0, 678.4187022341146)
        tdSql.checkData(77, 0, 728.8671148549121)
        tdSql.checkData(78, 0, 783.7108972216736)
        tdSql.checkData(79, 0, 842.2274126544997)
        tdSql.checkData(80, 0, 899.877243006616)
        tdSql.checkData(81, 0, 960.5271464519064)
        tdSql.checkData(82, 0, 1024.7777181923664)
        tdSql.checkData(83, 0, 1089.0854157079946)
        tdSql.checkData(84, 0, 1155.2807954785546)
        tdSql.checkData(85, 0, 1225.5127742681332)
        tdSql.checkData(86, 0, 1305.6263061095037)
        tdSql.checkData(87, 0, 1367.8826349729482)
        tdSql.checkData(88, 0, 1444.32066897418)
        tdSql.checkData(89, 0, 1521.5116974949854)
        tdSql.checkData(90, 0, 1597.9486330581901)
        tdSql.checkData(91, 0, 1681.1620533335488)
        tdSql.checkData(92, 0, 1762.8611973159218)
        tdSql.checkData(93, 0, 1835.2137045408574)
        tdSql.checkData(94, 0, 1936.0177065493942)
        tdSql.checkData(95, 0, 2004.599358732067)
        tdSql.checkData(96, 0, 2117.763602992286)
        tdSql.checkData(97, 0, 2208.874824726169)
        tdSql.checkData(98, 0, 2306.5731210183926)
        tdSql.checkData(99, 0, 2400.9686738603973)

        tdSql.query('select asin(c1) from st0 limit 1;')
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query('select pow(c1,2) from st0 limit 1 offset 2;;')
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 4.0)

        tdSql.query('select cos(c1) from db0.ct0, db0.ct1 where ct0.ts==ct1.ts;')
        tdSql.checkRows(50)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 0.5403023058681398)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.28366218546322625)
        tdSql.checkData(6, 0, 0.960170286650366)
        tdSql.checkData(7, 0, 0.7539022543433046)
        tdSql.checkData(8, 0, -0.14550003380861354)
        tdSql.checkData(9, 0, -0.9111302618846769)
        tdSql.checkData(10, 0, -0.8390715290764524)
        tdSql.checkData(11, 0, 0.004425697988050785)
        tdSql.checkData(12, 0, 0.8438539587324921)
        tdSql.checkData(13, 0, 0.9074467814501962)
        tdSql.checkData(14, 0, 0.1367372182078336)
        tdSql.checkData(15, 0, -0.7596879128588213)
        tdSql.checkData(16, 0, -0.9576594803233847)
        tdSql.checkData(17, 0, -0.27516333805159693)
        tdSql.checkData(18, 0, 0.6603167082440802)
        tdSql.checkData(19, 0, 0.9887046181866692)
        tdSql.checkData(20, 0, 0.40808206181339196)
        tdSql.checkData(21, 0, -0.5477292602242684)
        tdSql.checkData(22, 0, -0.9999608263946371)
        tdSql.checkData(23, 0, -0.5328330203333975)
        tdSql.checkData(24, 0, 0.424179007336997)
        tdSql.checkData(25, 0, 0.9912028118634736)
        tdSql.checkData(26, 0, 0.6469193223286404)
        tdSql.checkData(27, 0, -0.2921388087338362)
        tdSql.checkData(28, 0, -0.9626058663135666)
        tdSql.checkData(29, 0, -0.7480575296890003)
        tdSql.checkData(30, 0, 0.15425144988758405)
        tdSql.checkData(31, 0, 0.9147423578045313)
        tdSql.checkData(32, 0, 0.8342233605065102)
        tdSql.checkData(33, 0, -0.013276747223059479)
        tdSql.checkData(34, 0, -0.8485702747846052)
        tdSql.checkData(35, 0, -0.9036922050915067)
        tdSql.checkData(36, 0, -0.12796368962740468)
        tdSql.checkData(37, 0, 0.7654140519453434)
        tdSql.checkData(38, 0, 0.9550736440472949)
        tdSql.checkData(39, 0, 0.26664293235993725)
        tdSql.checkData(40, 0, -0.6669380616522619)
        tdSql.checkData(41, 0, -0.9873392775238264)
        tdSql.checkData(42, 0, -0.39998531498835127)
        tdSql.checkData(43, 0, 0.5551133015206257)
        tdSql.checkData(44, 0, 0.9998433086476912)
        tdSql.checkData(45, 0, 0.5253219888177297)
        tdSql.checkData(46, 0, -0.4321779448847783)
        tdSql.checkData(47, 0, -0.9923354691509287)
        tdSql.checkData(48, 0, -0.6401443394691997)
        tdSql.checkData(49, 0, 0.3005925437436371)

        tdSql.query('select sin(sin(sin(sin(sin(sin(sin(sin(sin(sin(sin(sin(sin(sin(sin(sin(c1)))))))))))))))) from st0;')
        tdSql.checkRows(100)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, 0.38515571309652635)
        tdSql.checkData(2, 0, 0.3902026038089464)
        tdSql.checkData(3, 0, 0.13455542224130787)
        tdSql.checkData(4, 0, -0.3769735598744493)
        tdSql.checkData(5, 0, -0.39322796903554574)
        tdSql.checkData(6, 0, -0.23651996268319414)
        tdSql.checkData(7, 0, 0.3636586143033131)
        tdSql.checkData(8, 0, 0.3948481297132482)
        tdSql.checkData(9, 0, 0.3013035615379907)
        tdSql.checkData(10, 0, -0.3415979020470687)
        tdSql.checkData(11, 0, -0.3953760693679444)
        tdSql.checkData(12, 0, -0.33980128729652753)
        tdSql.checkData(13, 0, 0.30435222656468974)
        tdSql.checkData(14, 0, 0.39491114169715646)
        tdSql.checkData(15, 0, 0.3625854118079003)
        tdSql.checkData(16, 0, -0.24157669718552427)
        tdSql.checkData(17, 0, -0.3933659195685728)
        tdSql.checkData(18, 0, -0.37631897787570007)
        tdSql.checkData(19, 0, 0.14207823704465328)
        tdSql.checkData(20, 0, 0.39044261434523814)
        tdSql.checkData(21, 0, 0.3847512959295267)
        tdSql.checkData(22, 0, -0.008849576117906611)
        tdSql.checkData(23, 0, -0.3855481500830306)
        tdSql.checkData(24, 0, -0.38995484687725573)
        tdSql.checkData(25, 0, -0.126893408273143)
        tdSql.checkData(26, 0, 0.37760858396391034)
        tdSql.checkData(27, 0, 0.39308462128198374)
        tdSql.checkData(28, 0, 0.23131327316607625)
        tdSql.checkData(29, 0, -0.3646985418138878)
        tdSql.checkData(30, 0, -0.3947809161937072)
        tdSql.checkData(31, 0, -0.29815291606002575)
        tdSql.checkData(32, 0, 0.3433365642562851)
        tdSql.checkData(33, 0, 0.39537224788827796)
        tdSql.checkData(34, 0, 0.3379446735775925)
        tdSql.checkData(35, 0, -0.3073019994396687)
        tdSql.checkData(36, 0, -0.3949699977540669)
        tdSql.checkData(37, 0, -0.3614777744074771)
        tdSql.checkData(38, 0, 0.24648579565525397)
        tdSql.checkData(39, 0, 0.39349857640819885)
        tdSql.checkData(40, 0, 0.37564419916566116)
        tdSql.checkData(41, 0, -0.14945748476886428)
        tdSql.checkData(42, 0, -0.3906750702498718)
        tdSql.checkData(43, 0, -0.3843345435654991)
        tdSql.checkData(44, 0, 0.017688072907053588)
        tdSql.checkData(45, 0, 0.3859289492584567)
        tdSql.checkData(46, 0, 0.38969914464525074)
        tdSql.checkData(47, 0, 0.11909715912089874)
        tdSql.checkData(48, 0, -0.3782246656581614)
        tdSql.checkData(49, 0, -0.392935768393244)
        tdSql.checkData(50, 0, 0.0)
        tdSql.checkData(51, 0, 0.38515571309652635)
        tdSql.checkData(52, 0, 0.3902026038089464)
        tdSql.checkData(53, 0, 0.13455542224130787)
        tdSql.checkData(54, 0, -0.3769735598744493)
        tdSql.checkData(55, 0, -0.39322796903554574)
        tdSql.checkData(56, 0, -0.23651996268319414)
        tdSql.checkData(57, 0, 0.3636586143033131)
        tdSql.checkData(58, 0, 0.3948481297132482)
        tdSql.checkData(59, 0, 0.3013035615379907)
        tdSql.checkData(60, 0, -0.3415979020470687)
        tdSql.checkData(61, 0, -0.3953760693679444)
        tdSql.checkData(62, 0, -0.33980128729652753)
        tdSql.checkData(63, 0, 0.30435222656468974)
        tdSql.checkData(64, 0, 0.39491114169715646)
        tdSql.checkData(65, 0, 0.3625854118079003)
        tdSql.checkData(66, 0, -0.24157669718552427)
        tdSql.checkData(67, 0, -0.3933659195685728)
        tdSql.checkData(68, 0, -0.37631897787570007)
        tdSql.checkData(69, 0, 0.14207823704465328)
        tdSql.checkData(70, 0, 0.39044261434523814)
        tdSql.checkData(71, 0, 0.3847512959295267)
        tdSql.checkData(72, 0, -0.008849576117906611)
        tdSql.checkData(73, 0, -0.3855481500830306)
        tdSql.checkData(74, 0, -0.38995484687725573)
        tdSql.checkData(75, 0, -0.126893408273143)
        tdSql.checkData(76, 0, 0.37760858396391034)
        tdSql.checkData(77, 0, 0.39308462128198374)
        tdSql.checkData(78, 0, 0.23131327316607625)
        tdSql.checkData(79, 0, -0.3646985418138878)
        tdSql.checkData(80, 0, -0.3947809161937072)
        tdSql.checkData(81, 0, -0.29815291606002575)
        tdSql.checkData(82, 0, 0.3433365642562851)
        tdSql.checkData(83, 0, 0.39537224788827796)
        tdSql.checkData(84, 0, 0.3379446735775925)
        tdSql.checkData(85, 0, -0.3073019994396687)
        tdSql.checkData(86, 0, -0.3949699977540669)
        tdSql.checkData(87, 0, -0.3614777744074771)
        tdSql.checkData(88, 0, 0.24648579565525397)
        tdSql.checkData(89, 0, 0.39349857640819885)
        tdSql.checkData(90, 0, 0.37564419916566116)
        tdSql.checkData(91, 0, -0.14945748476886428)
        tdSql.checkData(92, 0, -0.3906750702498718)
        tdSql.checkData(93, 0, -0.3843345435654991)
        tdSql.checkData(94, 0, 0.017688072907053588)
        tdSql.checkData(95, 0, 0.3859289492584567)
        tdSql.checkData(96, 0, 0.38969914464525074)
        tdSql.checkData(97, 0, 0.11909715912089874)
        tdSql.checkData(98, 0, -0.3782246656581614)
        tdSql.checkData(99, 0, -0.392935768393244)

        tdSql.execute('drop database db0;')


    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)

tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
