import * as THREE from 'three'

export function createPlane(w = 10, h = 10, position = [0, .1, 0], rotation = [90, 0, 0]) {
  const material = new THREE.MeshLambertMaterial({
    color: 0x88888888,
    side: THREE.DoubleSide,
    // wireframe: true,
  })
  const geometry = new THREE.PlaneGeometry(w, h)
  const mesh = new THREE.Mesh(geometry, material)
  mesh.position.set(...position)
  mesh.rotation.set(...rotation.map(deg => deg / 180 * Math.PI))
  return mesh
}

export function createCube() {
    const geometry = new THREE.BoxGeometry(1, 1, 1)
    const material = new THREE.MeshLambertMaterial({ color: 0xffffff })
    const cube = new THREE.Mesh(geometry, material)
    return cube
}

export function createLight(lightConstuctor, lightArgs = [0xffffff, 1], lightPos = [0, 0, 1]) {
    const light = new lightConstuctor(...lightArgs)
    light.position.set(...lightPos)
    return light
}

export function createLightHelper(light, ...helperArgs) {
    let helperType
    if (light.type === 'AmbientLight') {
    } else if (light.type === 'DirectionalLight') {
        helperType = THREE.DirectionalLightHelper
    } else if (light.type === 'PointLight') {
        helperType = THREE.PointLightHelper
    } else if (light.type === 'SpotLight') {
        helperType = THREE.SpotLightHelper
    }
    const helper = !!helperType && new helperType(light, ...helperArgs) || null
    return helper
}
