# 第一章 开源的基本概念 

## 1.1 开源的定义和特征

### 1.1.1 开源的定义

开源（Open Source）—词于1998年2月3日由Chris Peterson提出，“Open Source”的概念出自当时著名的黑客（Hacker）社区Debian的社长Bruce Perens起草的“ Debian Free Software Guidelines”（DFSG）。

1998年2月下旬，Eric Raymond和Bruce Perens共同创立"Open Source Initiative"（OSI）。OSI承担的首要任务之一是起草开源定义（OSD），并使用它来开始创建OSI批准的许可证列表。

对确立“Open Source”定义有决定意义的是在1998年4月7日在美国加州Palo Alto由18位“自由软件运动领袖”召开的Freeware高层会议，通过了传播开源的必要性。会议由Tim O'Reilly主持，Brain Behlendorf（Apache创始人）、Linus Torvalds（Linux创始人）、Guido Van Rossum（Python创始人）、Eric Raymond（著名记者、OSI首届主席）等参加。

随着时代的变迁，开源的定义内涵也在不断演进。目前的共识是：开源是促进信息技术创新的重要途径，是将源代码、设计文档或其他创作内容开放共享的一种技术开发和发行模式。技术领域的开源已包含源代码+软硬件设计文档源代码、源数据等技术和资源的开放共享，源代码仍然是开源的主要内容。 在开源模式下，通过许可证的方式，使用者在遵守许可限制的条件下，可自由获取源代码等，并可使用、复制、修改和再发布。

本质上，开源模式是一种依托互联网平台，大规模群体智慧通过共同参与和协作，不断累积智慧，实现持续创新的方法。该方法中，项目的核心开发人员与大规模的外围群体紧密合作，他们通过互联网来共享资源、开展协同开发、管理代码等，由此使得项目开发的效率、应对需求变化的能力大幅提升。

### 1.1.2 开源的特征

中国开源软件推进联盟于2016年归纳提出的（已被国际认可）开源特征包括：开放、创新、自由、共享、协同、绿色、民主（化）。开源的本质在于开放、共享、协同。

- 开放指开放标准、开放环境、开放源码；
- 创新是主轴；
- 自由指自由发布、自由传播、自由复制、自由修改、自由使用，其中，自由传播是开源运动的要义；
- 共享指共享资源；
- 协同指协同开发、协同作业、协作生产；
- 绿色指支持绿色可再生能源、绿色环境和零边际成本效应；
- 民主化指在新兴协同共享中，创新和创造力的民主化正在孵化一种新的激励机制，这种机制很少基于经济回报，而更多地基于推动人类的经济生活方式，缩小收入差距，实现全球民主化。为避免原创技术的流失，不能单纯限制孵化阶段开源代码的自由传播，可通过开源的商业模式、安全模块、运维举措、生态系统所构筑的屏蔽层来解决。

作为一种创新协作模式，开源已经不仅仅是开放源代码的软件技术开发，还包括更为广泛的开放技术领域及协同创新的理念与机制，总体包括开放科学、开源软件、开源硬件、开源技术、开源文化、开源经济等。“互联网＋基于知识社会的创新 2.0”是开源创新的基础理论（2005年由中国开源软件推进联盟提出，后来获得全球开源界领袖们的确认），与工业 4.0、工业互联网机制相通，与元宇宙（Metaverse）概念相似。利用开源渠道，将高阶社会（知识社会，虚拟化的实验空间）中的技术、管理、资源等要素，作用于低阶社会（现实的工业社会，物理空间）中的业态（生产的、技术的、经济的、社会的），促使其产生0→1的爆发性重构。
 
### 1.1.3 开源的范畴

时至今天，开源已成为开源软件、开源硬件、开源生态、开源技术、开源社区、开源经济、开源商业模式、开源理念、开源文化、开源教育、开源许可证、开源基金会、开源孵化器、开源数字化治理体系、开源标准等的总称。
 
## 1.2 世界开源发展简史

世界开源发展史，有三个里程碑时间节点：1970年、1985年、1991年，分别对应UNIX、GNU、Linux的发展。

### 1.2.1 UNIX简史

1969年之前，Bell实验室和MIT、GE合作启动开发一个多任务多用户的操作系统Multics，为UNICS操作系统诞生创造条件。

1969年，UNIX原型——UNICS（UNiplexed Information and Computing System）诞生。

1973年，Dennis Ritchie发明C语言，用C语言将UNICS重写并更名为UNIX，UNIX正式诞生。

1969-1977年，UNIX相继推出V1-V6版本，向社会开放源代码。

1977年开始进入“后UNIX”时代，UNIX演化为UNIX（闭源，即AT&T-UNIX）和BSD（开源，即BSD-UNIX）。主流的开源BSD操作系统有386BSD、FreeBSD、NetBSD、OpenBSD。

因此，世界开源的历史始自1970年开启的“前UNIX”，至今52年，开源在事实上已经历了半个世纪的发展历程。

### 1.2.2 GNU简史

GNU系统是一套向上兼容UNIX的完全自由的操作系统。GNU代表“GNU's Not UNIX”。

1983年9月27日，Richard Stallman提出了GNU工程的初始声明，意图找回在早期计算机社区中广泛存在的合作精神，通过除去专属软件所有者设置的障碍而使得合作再次成为可能。

1984年1月，Richard Stallman从MIT离职并开始编写GNU软件，同年9月开始GNU Emacs的工作。

1985年，Richard Stallman发表《GNU宣言》，吸收“前UNIX”和BSD的开源成果，开发推出Emacs等编译器等自由软件（Free Software）。同年10月，自由软件基金会（FSF）正式成立。

“Free Software”中的“Free”关乎自由，而不是价格，是指可以付费或不付费得到GNU软件。一旦得到了软件，便拥有了使用它的四项特定自由。可以自由按照自己的意愿运行该软件；可以自由复制软件并将其送给朋友和同事；可以自由通过对源代码的完全控制而改进程序；可以自由发布改进的版本从而帮助社区建设。

### 1.2.3 Linux简史

Linux的诞生、发展和成长过程始终依赖着五个重要支柱：UNIX操作系统、MINIX操作系统、GNU计划、POSIX标准和Internet网络。

1977年，UNIX的重要分支——BSD在UC Berkeley诞生。开发者是SUN公司创办者Bill Joy。

1984年，Andrew S. Tanenbaum为能续进行学术教育研究，重新开发了一个基于“前UNIX”和BSD4.3的开放源代码操作系统——Minix，这是Linux最开始的前身。

1985年，GNU开源计划和FSF基金会成立。在这个时间前后，涌现了很多重要的软件和协议，如GPL协议、GCC C编译器、Emacs编辑器、Glibc、bash shell等，为Linux后来的发展创造了肥沃的土壤。

1991年，芬兰本科生Linus Torvalds在Minix和GNU成果的基础上，开发并以GNU GPL许可方式发布了开放源代码操作系统Linux v0.01。

1992年5月21日 , Peter MacDonald发布第一个独立的Linux安装包SLS。

1993年6月17日，Slackware Linux由Patrick Volkerding发布，这是第一个取得广泛成功的Linux发行版。8月16日 ,Ian Murdock（Debian中的“ian”）发布了第一个Debian Linux发行版。Debian是最有影响力的Linux发行版之一，是MEPIS、Mint、Ubuntu等的鼻祖。8月19日 ，Matt Welsh写的《Linux Installation and Getting Started》第1版出版，这是第一本关于Linux的书籍。

1994年3月14日 ，Linux内核V1.0发布，它支持基于i386单处理器的计算机系统。8月15日 , William R. Della Croce, Jr.申请了“Linux”商标，9月进行了注册。11月3日，Red Hat共同创始人Marc Ewing宣布可以以49.95美元的零售价格获得Red Hat Software Linux的CD-ROM和30天的安装支持。

1996年5月9日 ，吉祥物Tux诞生。6月9日，Linux内核V2.0发布，这是第一个在单系统中支持多处理器的稳定内核版本。Linux从此成为很多公司的重要选择。10月14日 ，Mattias Ettrich发起KDE项目，此前UNIX和Linux都没有统一的桌面系统，编写桌面软件非常复杂。
 
1997年1月9日 ，第一个“Linux病毒”Bliss被发现。

1998年5月1日，基于Linux的Google搜索引擎面世。12月4日 ，IDC报告称1998年Linux出货量至少上升200%，以其他任何操作系统无法企及的速度增长着。

1999年3月3日，GNOME桌面系统进入Linux世界。

2000年2月4日，IDC报告表明Linux排在“最受欢迎的服务器操作系统的第2位”。10月30日 ，第一个Linux live发行版Knoppix发布。

2001年1月，Linux 2.4发布，进一步提升了SMP系统的扩展性，同时集成了很多用于支持桌面系统的特性：USB、PC卡（PCMCIA）的支持，内置的即插即用等功能。

2003年3月6日，SCO Group公司宣布正在发起对IBM高达10亿美元的诉讼，声称IBM把SCO的商业机密整合到了Linux中。12月，Linux 2.6版内核发布。

2007年8月8日，Linux基金会由开源发展实验室（OSDL）和自由标准组织（FSG）联合成立，得到了主要的Linux和开源公司，包括富士通、HP、IBM、Intel、NEC、Oracle、Qualcomm、三星以及开发者的支持。11月5日，Google发布Android，被称为“第一个真正开放的综合移动设备平台”。

2011年5月11日 ，Google I/O大会发布基于Linux内核的云操作系统Chrome OS的Chromebook。6月21日，Linus Torvalds发布Linux3.0版本。

（补充后续X.X大版本的初始发布时间）

### 1.2.4 开源基金会崛起

开源基金会是开源生态中的重要部分。对于非营利性且处于中立位置的开源基金会来说，他们拥有开源项目的知识产权，而且没有任何商业利益，这为贡献者、开发者、用户提供了良好的协作平台；基金会也会通过技术服务和项目孵化来帮助开发者和开源企业，如软件仓库、问题跟踪、技术指导、法律支持、项目投资、公共关系维护等；基金会还会提供项目日常的运营和治理，以满足在项目生命周期不同阶段对于管理项目的需求。

自20世纪80年代自由软件基金会（FSF）开始，全球各类开源基金会快速发展，在构建全球开源生态中发挥着巨大的促进作用，据不完全统计，各类开源基金会已经超过100家，其中具有代表性的包括：

- 自由软件基金会（1985年成立）
- Open Source Intiative（1998年成立）
- Apache软件基金会（1999年成立）
- GNOME基金会（2000年成立）
- Blender基金会（2002年成立）
- Mozilla基金会（2003年成立）
- Eclipse基金会（2004年成立）
- Open Invention Network（2005年成立）
- Linux基金会（2007年成立）
- 云原生计算基金会（2015年成立）
- RISC-V 基金会（2015年成立）
- OpenJS基金会（2019年成立）
- TARS 基金会（2020年成立）
- SODA 基金会（2020年成立）
- 开放原子开源基金会（2020年成立）
- 开源基础设施基金会（2020年成立）
- Rust 基金会（2021年成立）
- OpenSSF基金会

查看各基金会的详细介绍请扫描右侧二维码。

## 1.3 中国开源发展简史

1991年，中国与AT&T Bell Laboratories USL/USG合作，引进UNIX SVR 4.2版本源代码（全球唯一，但属于“后UNIX”闭源时期），并发布了中文版本，合作组建了中国UNIX公司；中方同时也引进“前UNIX”开放的源代码。

1999年，中科红旗、中软网络、冲浪平台在引进Red Hat公司Linux发行版的基础上，分别推出最早的Linux中文版本。

因此，中国开源的发展历史具有两个里程碑节点：1991年、1999年，至今31年、23年，可以分为启蒙、萌芽、发展、加速四个时代。

### 1.3.1 启蒙时代

1991年，陆首群、张克治和杨天行牵头代表中方代表团与美国AT&T USG合作，美方将最新开发的UNIX版本——UNIX SVR4.2源代码向中方开放。中方为此组织了UNIX新版本编辑委员会，由杨芙清、胡道元、仲萃豪、刘锦德、尤晋元、贾耀良、孙玉芳等国内资深软件专家组成，并邀集全国软件专家、程序员200多人，翻译、编辑、出版了UNIX SVR4.2中文版本共19册，首发式在人民大会堂举行，向全国各大图书馆、高等院校赠书，业界影响甚大。这一历史事件被Linux基金会收录，后被作为中国开源诞生的标志性事件。1991年成为中国开源元年。

1992年12月，中方与USG合资在华成立了中国UNIX公司。

1994年，已经在芬兰工作5年的宫敏博士第一次将Linux和大量自由/开源软件源码通过磁带带回中国。

1997年，宫敏第二次带回80GB的自由软件，并在国家信息中心的帮助下在中国经济信息网（https:// www.cei.gov.cn/）上建成了“中国自由软件库”，为国内技术人员了解、学习和使用Linux及相关自由/开源软件提供了便利。

1998年，在开源概念提出的这一年，在湖南长沙读博士的章文嵩在Linux2.0内核上利用课余时间开发了Linux虚拟服务系统（LVS），并在第一时间开源，在全世界引起很大反响。同一年，在北京清华大学读研的魏永明，决定开发针对实时嵌入式系统的图形界面系统并将其开源，MiniGui应运而生。同一年，在安徽合肥读大二的自动化系学生吴峰光开始接触Linux，他发现Linux的文件预读算法磁盘I/O性能较差，便尝试对Linux内核进行改进。

1998年初，北京冲浪平台软件技术有限公司成立，专注于研发Linux中文发行版，同年9月Xteam Linux收获了第一个市场用户——北京市政府政策研究室。1999年3月正式对外发布Xteam Linux中文版1.0。2001年冲浪平台在香港创业板上市。

### 1.3.2 萌芽时代

在历时8年的启蒙阶段中，自由/开源软件的理念和文化开始在中国大地生根发芽，随着UNIX、Linux在中国用户的激增，以及互联网时代的到来，中国自发地涌现出一批开源社区和开源企业。在中国开源发展的萌芽阶段，Linux技术的快速普及起到了核心的推动作用。

1999年9月，蓝点软件技术（深圳）有限公司成立，次年3月在美国纳斯达克上市。一个中国初创公司从成立到在美上市仅用不足200天，且上市当天股价暴涨400余倍，这个神话旷古绝今。

1999年底，时任中国科学院软件所副所长的孙玉芳老师牵头筹建北京中科红旗软件有限公司和北京红旗中文贰仟有限公司，分别基于Linux和OpenOffice进行中文版红旗Linux和RedOffice的研制。孙玉芳老师英年早逝，一生发表操作系统相关论文180余篇，编著和译著操作系统原理相关著作140余册，他指导过的诸多硕士/博士生现已成为开源产业的中坚力量。

1999年，中国软件开发者社区CSDN在蒋涛的努力下成立了，并于2000年创办《程序员》杂志。

2000年2月，在科技部国家高技术研究发展计划（863计划）的支持下，由一批国内高校、研究院所、IT企业联合发起成立了共创软件联盟。共创软件联盟在开源许可证规则下对863计划的软件成果进行开源培育和孵化，并提出以开放源代码的协同创新模式作为中国基础软件发展的主要路径，对我国开源产业发展起到了重要的推动作用。

2002年，黄建忠以CJacker的ID在中国Linux公社发布了基于Redhat 8再发布的Magic Linux版本——这是国内第一个Linux社区发行版。

在这个阶段，部分中国开发者开始尝试向国际上游社区贡献代码。但同时，国内Linux企业对开源技术采用拿来主义，忽视开源社区、商业模式和开源知识产权等方面的投入和积累，导致在国际社区中出现了许多针对中国Linux发行商只是开源使用者的评价，直到2008年，这种印象才得以扭转。

2004年，中国开源软件推进联盟成立，陆首群教授被推举为联盟主席，在陆首群主席的大力推进下，为推动开源在中国的发展而不懈努力，也启动了中国与日本、韩国以至全球在发展开源的方面国际合作。联盟的国际智囊团聘请了几十位全球顶级开源专家以多种形式参与和推进中国开源建设，如此规模的智囊团在全球首屈一指，是开源界公认的顶级智库。可以说，联盟的成立和陆主席的领导加速了中国开源软件发展的速度，为碎片化的国内开源产业建立了统一的根据地，为国际开源生态和中国开源生态建立了纽带。

2008年，以Kernel、Apache、GNOME、OpenOffice为代表的国际知名开源社区纷纷选择在北京召开全球技术峰会，作为他们进入亚洲的第一步（之前从未在亚洲国家召开顶级技术峰会）。这是对中国开发者在社区提交贡献的肯定。因此，我们认为2008年成了中国开源发展重要的分水岭。

### 1.3.3 发展时代

在2009年前，中国常被视为国际开源资源单纯的使用者，2009年之后，中国开发者提交的代码被Linux基金会接受，排名稳居世界前四（Kernel 2.6.27之后），中国开始成为国际开源资源的贡献者。

在2009年之后，伴随着云计算、物联网、大数据、移动互联网的快速发展，中国一批有实力有抱负的知名科技IT企业、互联网公司开始选择拥抱开源。Linux基金会执行董事Jim Zemlin曾表示：“这些中国科技公司无论从开源技术上，还是产业、经济发展上，已经走进世界领导者行列。”

在2009-2018年这十年中，中国开源呈现了百花齐放的繁荣局面，从开源开发者数量的激增，到开源社区的多样化（不再局限Linux等操作系统领域），再到知名科技企业自内而外的拥抱开源（内部实行开源治理，逐渐对外捐献开源项目，并向上游技术社区提交贡献）。2012年成立的中国开源云联盟（COSCL）和2016年成立的云计算开源产业联盟（OSCAR）就是典型的开源与云计算技术融合的产业联盟。这一阶段明显的特点在于不论是初创企业还是千百亿体量的科技巨头纷纷用开源技术来构建公司自身的技术堆栈，在技术上全面拥抱开源，并越来越重视对上游开源社区和开源基金会的投入与贡献。

### 1.3.4 加速时代

2019年至今，中国开源进入了一个新的时代一一加速阶段。

根据Linux基金会有关Kernel.org社区贡献的统计，来自中国开发者的贡献已居全世界之首（Kernel 4.14至今）。中国开源发展进入深水区，开源生态的完整性、开源社区的成熟性、开源商业模式的多样性和复合性都在发生巨大变化。

由木兰开源社区牵头、多家单位联合参与起草的“中国第一个开源协议——木兰许可证”已经正式发布，前不久还被OSGJ翻译为日文版使用。由华为、百度、腾讯、360、浪潮等发起成立的开放原子开源基金会填补了中国没有开源基金会的空白，尽管它还不能与Linux基金会、Apache软件基金会相提并论，但在开源领域备受瞩目。

在现阶段，部分领先的中国企业不满足于拥抱开源，他们正在很多创新领域跃跃欲试，希望通过开模式来对创新技术进行引领，如商汤的OpenMMLab计算机视觉开放算法、矩阵元的Rosetta隐私Al开源框架、阿里的RocketMQ海量信息中间件、京东的JD Chain开源区块链、百度的PaddlePaddle深度学习平台和Apollo自动驾驶平台、海尔卡奥斯COSMOPlat工业互联网平台的工业APP开发框架开源项目等。同时，在现阶段出现了一些原生的开源明星项目，如Apache SkyWalking、Apache Echarts、Apache loTDB、TiDB，其中一些优秀的开源项目如TiDB备受资本市场的推崇，创造了全球数据库融资历史新的里程碑。

## 1.4 开源软件与知识产权

至此，我们对开源的定义和发展史有了基本的认识，在继续深入了解之前，有必要关注开源软件与知识产权的知识。

### 1.4.1 软件知识产权的主要内涵

软件知识产权是计算机软件人员对自己的研发成果依法享有的权利。目前国际上对软件知识产权的保护法律还不是很健全，大多数国家都是通过著作权法来保护软件知识产权的，与硬件相关密切的软件设计原理还可以申请专利保护。

- 软件知识产权主要包括著作权、专利权与商标权。
- 著作权指软件的表达(如程序代码、文档等)方面的权利。
- 专利权包括软件的技术设计，如程序设计方案、处理问题的方法、各项有关技术信息等方面的权利。
- 商标权则是指软件的名称标识方面的权利。

软件需要有硬件平台的支撑才可以运行，而在硬件平台上运行的软件基本上是目标码（二进制格式），从而造成软件源码和二进制目标码的分离和割裂，而软件作为通用商品进行销售或分发时主要提供的只是二进制文件，这也成为主流的软件销售和分发方式，并主要通过随软件一起发布的最终用户许可协议（End User License Agreement，EULA）对软件的使用、修改和分享及其他相关事宜作出规定。

EULA指的是一家公司的软件与软件的使用者所达成的协议，是软件应用程序作者或者发布者与应用程序使用者之间的合法合同。

EULA一般主要规定用户不可以盗版软件，并没有对用户明确涉及对应软件源代码的处置问题——除非特定情况，销售的二进制形式的软件并不提供对应软件源代码；即使偶有提供，但对用户基于该源代码的复制、修改和二次分发等作了严格限制或者禁止。

针对上述对软件源代码的处置方式，出现了一种开放、协同、共享的软件发展模式——通过开源软件许可证对软件源代码的复制、修改、再分发等权益，对商标、专利、著作权等内容进行进一步规范，这也是对软件知识产权发展的一个重要补充。

### 1.4.2 开源软件许可证

开源许可证就是开源软件使用的许可证。对开源软件许可证的法律界定先前存在一定的争议。在美国，一些法院认为软件许可证是合同（Contract），一些法院则认为是许可（License）。两者的区别在于，许可在传统上是由地产或物主作出的，目的在于允许他人使用自己的地块或物品。因此，它是单方向的，不构成完整的合同，而是作为合同的一个要素，用来和他人交换的条件。

合同和许可之分在美国法上具有重要意义。如果是合同，那么需要适用各州不同的合同法；如果是许可，那么需要适用统一的联邦版权法。此外，合同的违约救济和版权的侵权救济也有诸多不同，比如禁令（行为保全）的适用、判赔额的确定、律师费的分担等。

不过，包括中国在内的大陆法系国家，则普遍认为开源软件许可证构成合同；只不过这种许可合同并非协商得到，而是事先规定好的标准化格式合同。具体来讲，开源许可证是涉及版权、专利、商标等一系列权利义务的格式合同，且自动生效。

法律并没有限定许可证不能包含什么条款，这导致许可证的类型极其繁多、内容也非常自由。据不完全统计，广义上的开源许可证目前有超过200种，即便是OSI批准的许可证目前也多达96种，其中包括由中国主导编制的Mulan Permissive Software License v2 (MulanPSL - 2.0)，全部许可证可参见https://opensource.org/licenses/alphabetical和https://opensource.org/licenses/category。
1.4.3 国外主流开源许可证解读

**（1）GNU通用公共许可证（GPL）**

GPL通用公共许可证是一个许可证家族的泛称，是一个被广泛使用的自由软件许可协议条款，为使用者提供了足够的复制、分发、修改的权利：

- 可自由复制；
- 可自由分发，提供他人下载；
- 可用来盈利，分发软件过程中收费（必须在收费前向客户提供该软件的GNU GPL许可协议）；
- 可自由地修改（使用了这段代码的项目也必须使用GPL协议）。

GPL当前主要有GPL v2和GPL v3两个版本。这组许可证的共同特征在于其“传染性”：任何基于GPL代码编写的软件都必须成为开源软件。换言之，使用了任何GPL代码的软件，无论GPL代码占比多少，都必须将完整的源代码公开，并允许他人修改、发布。

GPLv2许可证存在一些漏洞，例如它不能阻止一个软硬件结合的系统中，通过对硬件部分施加限制，间接阻止用户在该硬件上运行软件的修改版本；没有包括关于专利的约定，导致实践中出现Microsoft-Novell专利协议这类试图将专利申请用作于对付自由软件社群的武器的现象。

为解决这些问题，GPL v3于2007年发布。除填补上述漏洞，GPL v3兼容性更好。自由软件基金会明确表示GPL v3与Apache 2.0 许可证兼容。

目前，使用GPL许可证的重要项目包括Linux内核和MySQL等，但新兴项目一般会选用更宽松的许可证。

**（2）LGPL（Lesser General Public License）**

LGPL叫做GNU宽通用公共协议，对产品所保留的权利比GPL少，适用于非开源产品的开源类库或框架，并可以不继承LGPL协议，使用其他的开源协议。

LGPL的特点在于，链接到该软件库的软件可以不适用LGPL或GPL，换言之，可以不公开源代码。LGPL的这一特性消除了在GPL下软件商用的最大障碍。尽管如此，基于该库修改而得到的软件仍然需要遵循GPL许可证。

**（3）Mozilla Public License（MPL）**

MPL允许在其授权下的源代码与其他授权的文件进行混合，包括私有许可证。在MPL授权下的代码文件必须保持MPL授权，并且保持开源，即允许在派生项目中存在私有模块，同时保证核心文件的开源。使用MPL授权的软件并不受专利的限制，其可以自由使用、修改，并可自由的重新发布。带有专利代码的版本仍然可以使用、转让，甚至出售。

**（4）BSD许可证系列**

BSD许可证是由UC Berkeley首倡和维护的，版本繁多，目前常用版本包括原始的BSD-4、BSD-3以及简化的BSD-2。BSD属于宽松许可证，与MIT许可证接近但更加宽松，甚至跟公有领域更为接近。在最简化的BSD-2许可证下，保留著作权声明、许可证内容以及免责声明即可；只要满足许可证设定的条件，就可以自由地修改并发布代码。

BSD-3许可证在BSD-2许可证的基础上增加了禁止背书条款（未经事先书面许可不得使用原作者之名来推广衍生作品）；BSD许可证进一步增加了广告条款（衍生作品的广告材料必须说明该软件包含由UC Berkeley及其贡献者开发的软件）。

**（5）MIT许可证**

MIT许可证之名源自首倡者MIT麻省理工学院，又称“X许可协议”（X License）或“X11许可协议”（X11 License）。

据统计，2015 年GitHub上高达45%的项目使用MIT许可证。近几年MIT许可证的份额有所下滑，在2020年市场份额第一的位置被Apache 2.0取代，但仍是最受开发者欢迎的许可证之一。

MIT的特点在于条款非常简单，是开源协议中最宽松的一个：“被许可人有权利使用、复制、修改、合并、出版发行、散布、再许可和/或贩售软件及软件的副本，及授予被供应人同等权利”，加上要求被许可人保持同样的声明。

**（6）Apache许可证**

Apache许可证是一种“宽松”（Permissive）的许可证，目前常用版本是2.0，2020年成为使用最多的许可证。“宽松”是指不保证被使用软件的派生版会继续保持自由软件的形式，即：“怎么用都行，用在哪都行”。

具体而言，Apache 2.0许可要求保留版权和许可声明，但允许许可作品、修改和更大的作品在不同的条款和没有源代码的情况下分发，只是未修改的部分仍然需要保留Apache许可证。除了为用户提供版权许可之外，还有专利许可，对于那些涉及专利内容的开发者而言，该协议最适合。

由于上述利好条件，Apache 2.0成为了相当多流行的开源项目的许可证，最著名的例子之一就是Kubernetes。

不同开源许可证就许可、条件和限制的比较参见https://choosealicense.com/appendix/。主要常见开源许可证的对比汇总见下表。


常见开源许可证的对比汇总表

可以看出，除了允许商业性使用、分发和修改外等常见特征外，开源许可证还有两个共同点。一是开发者不承担保证责任（瑕疵担保责任）。开源代码通常都是免费提供的，因此开发者不应为他人使用该软件造成的损失而承担责任。二是要求保留著作权标记。开源软件并不意味着放弃著作权。相反，开源许可证的强制效力来源，恰恰来自于作者对开源软件的著作权。

因此，许可证一般都要求以适当的形式保留著作权标记（包括许可证正文以及作者署名）。

### 1.4.4 木兰开源许可证解读

木兰许可证族由中国电子标准化研究院牵头研制，已发布版本包含木兰宽松许可证（MulanPSL v1；MulanPSL v2）、木兰公共许可证（MulanPubL v1；MulanPubL v2）、木兰-白玉兰开放数据许可协议（MBODL v1）。

**木兰宽松许可证（MulanPSL）**

MulanPSL v2于2020年通过OSI认证，是全球首个由我国主导的国际通用中英文双语许可证，与Apache 2.0许可证有良好的兼容性，最大限度鼓励专利和版权开放，并于2021年发布日文版。截止2020年底，已有超过1万余项国内自主开源项目支持MulanPSL 2.0，得到Linux基金会、Apache基金会、华为、阿里、开源中国、CSDN等开源组织、公司和代码托管平台的支持应用，1万7千余代码仓应用（Gitee 11000+，Github 7000+）。其中典型应用有OpenEuler、OpenGauss、方舟编译器、XiOUS等。

**木兰公共许可证（MulanPubL）**

木兰公共许可证在宽松版基础上增加了其传染性，对开源软件的分发增加了限制性要求。木兰公共许可证和木兰宽松许可证间存在较大差异，均以第 2 版为例，其差别集中在“分发限制”上。木兰公共许可证类似GPL具有传染性，要求接受者必须开放源代码。而木兰宽松许可证的“分发限制”中仅仅要求保留代码中的许可证声明，并未要求再次分发时的许可证设置，不具有“传染”特质。

木兰宽松许可证与木兰公共许可证的共同特点是：采用中英文表述，且具有同等法律效力；遵从表述简洁原则，容易理解；明确授予版权和专利权，不授予商标权。而区别在于前者能与现有的其他许可证友好兼容，后者对开源软件的分发条件有限制性要求，对云计算和SaaS等新兴技术的分发也有条件限制。

木兰宽松许可证与国外主流许可证的异同

木兰公共许可证与国外主流许可证对分发的限制
 
## 1.2 开源与标准

### 1.2.1 开源与标准的关系

开源与标准之间既是研究对象关系、规范与实现的关系又是协同发展关系。开源与标准化协同发展是信息技术领域发展的最佳模式，共同构建开放的产业生态。

#### 1.2.1.1 开源与标准的关系

开源与标准关系分三种：一是研究对象关系，开源作为标准化对象开展标准化工作；二是规范与实现关系，标准是技术的抽象规范，开源是标准的具体实现；三是协同发展关系，开源与标准以协同发展、相互促进的方式，共同支撑产业创新、助力产业发展。
 
图 开源与标准关系图

研究对象的关系

开源作为标准化对象。标准化对象是指需要标准化的主题。通常，标准化对象包括两方面的内容：一是标准化学的研究对象，二是标准化工作的对象。前者也称为总体对象，它是各工作对象的总和构成的总体，主要是研究各种具体对象的共同属性、本质和普遍规律；后者也称为具体对象，它是需要制定标准的对象或各专业标准化工作的对象。

研究对象和工作对象是一般与具体的关系，是共性与个性的关系。不能没有工作对象，也不能没有研究对象，工作对象是研究对象的基础，研究对象则是工作对象的指南。由于研究对象从宏观角度出发，研究事物的共性，更适合制定为国家标准。

作为研究对象的开源规则和社区治理部分因其关注本质、基础共性理论和普遍规律等层面的研究，应当从国家标准层面制定标准；作为工作对象的开源项目和技术部分因其关注技术架构、接口定义与互联互通等层面的研究，可以制定为团体标准。

规范与实现的关系

标准是技术的抽象规范，开源则是以“开源方式”对于标准所定义规范的具体实现。

标准的实现方式不仅限于开源实现，还可以通过“闭源”方式实现。

协同发展的关系

标准是基于开放流程的、以实现兼容性和互操作为目标的技术规范的开发过程。开源是基于开放合作和代码共享为特征的技术实现过程。开源与标准是构建开放的信息技术生态的两种重要工具，两者相互补充，相互促进，协同发展，缺一不可。
 
图 开源与标准协同，共筑开放的技术和产业生态

#### 1.2.1.2 开源与标准协同发展

标准化是开源治理的重要手段，以开源为对象的治理，是专注于开源活动体系及其效能和风险管理的一系列治理规则，由治理主客体、组织结构和过程组成，以确保参与开源活动能够支撑组织的目标。Linux、OpenInfra、Apache等全球代表性开源基金会均将标准化作为开源社区建设和发展的重点任务之一，主要围绕开源社区治理、技术开发以及推动实现互操作等方面。国内已着手布局构建自主开源规则体系，但当前开源生态仍面临基础共性理论统一、技术互联互通困难、社区治理能力尚待完善等问题，需要标准化手段推进开源运营治理规则体系建设。

开源和标准协同发展，是推动开源和标准规则研究、技术及应用发展的重要基础性工作，可以共同构筑开放有序的产业生态，预防独家垄断与技术锁定；为客户提供更多选择；促进产业包容式发展；持续推动开放式创新。

#### 1.2.1.3 开源标准化价值

图 开源标准化价值

开源规则和社区治理标准化的价值

在规则层面，标准化对开源的价值体现于统一产业界认识，如开源术语、元数据、许可证等。针对开源技术和应用的相关概念，是认识、理解开源技术的基础，为开源领域其他标准研制提供支撑，旨在形成行业基础共识。由我国官方推出的首个开源协议木兰宽松许可证”（MulanPSL）在此方面迈出了坚实的一步，但还需要后续更多的系列行动；

在社区层面，标准化对开源的价值体现于保障社区的健康与稳定。社区文化、领导及治理能力是维护社区可持续发展的基础。社区治理遵循开放、透明、平等、共识、协作的原则，以法律法规、社区机制、治理流程、运营流程、基础设施、社区评估六大域建立开源社区治理、运营和技术框架，支撑社区可持续发展。通过建立开源社区治理机构，协调内外资源，对开源软件的许可模式和开源的知识产权保护提供法律和法理的保障；通过制定开源项目的治理流程和合规规范来保障项目健康发展。

开源项目和技术标准化的价值

在项目和技术层面，标准化对开源的价值体现在以下几个方面：

（1）开源通过实施标准并在标准的支持下实现与现有技术生态的互操作，促进开源的快速、广泛应用。

（2）标准化可以支持开源技术形成稳定演进的技术框架和外部接口，与外部系统的互联互通，防止社区分裂，推动生态发展。

（3）标准可以支撑开源所定义的技术成为稳定的规范，同时支持闭源实现，共同构建产业生态，保证开源项目的可持续发展。

（4）标准化可以开源项目构建稳定的技术品牌的建设。例如Open Infrastructure Foundation通过DefCore标准的制定，并结合基于标准的合格评定，定义OpenStack技术品牌。

通过为开源建立标准，可以解决四个方面的问题：

（1）统一概念和认识

当前OSD的本质是定义了开源软件的授权协议的主要特征，并非定义开源本身。同时关于开源软件、开源硬件、开源社区、开源产品、开源基金会等概念，也一直没有明确、无歧义、相互之间协调一致的定义。
而概念与概念之间的关系，也需要清晰的定义，如：开源基金会、开源社区与开源产品，开源项目与软件版本，开源代码仓库与开源制品等，都应建立某种符合逻辑、能够涵盖各种情况的关联关系。我国亟需一套完整的定义，将各种相关的概念统一在一个框架之下。开源作为标准化对象，对于其基础共性理论及方法论，可以从国家标准层面进行统一。

（2）构建互联互通的技术生态体系

开源必须通过实现标准才能完成与外部系统兼容和互联互通，实现多平台的可移植性和进入技术生态系统的目标。例如，如果一个开源项目如果不实施TCP/IP标准，就会被孤立在互联网之外。不仅如此，实现版本化的标准可以支持开源系统稳定迭代发展；基于标准建设合格评定机制，确定开源技术品牌。

开源与标准化协同发展过程中，将做到以团体标准为抓手，构建协调一致的技术生态体系并连接尚未联通的断点，减少行业内上下游的重复工作，同时用标准化的方式持续推进制定互联互通的标准。

（3）构建技术品牌，防止社区分裂

针对开源项目核心技术接口，通过标准化机制制定和发布团体标准，并基于标准建设合格评定机制，构建技术品牌。稳定的技术品牌发展路径和版本更新机制，可以增强技术社区的向心力，有助于维护开源项目统一演进，防止技术社区分裂

（4）建立评估体系

在开源标准制定过程中，将关注如何计算、评估以及测量各种指标，如一个GitHub仓库中可以看到的stars数量、其数量背后的价值、开源项目的热门程度、技术难度、质量高低、社区健康度等指标。同时基于开源标准构建评估体系，更好服务开源生态建设。

（5）整理最佳实践

建设评估体系和整理最佳实践是当前构建良好开源治理体系、可持续健康运营开源社区的两个有力抓手，应相互兼顾，互相补充，以实现最优。例如ISO 9000标准是质量管理领域的最佳实践总结。

当前开源发展过程中，以标准体系化方式汇集最佳实践，并不断修订以帮助开源社区健康成长，是开源标准化工作重点关注的方向之一。

#### 1.2.1.4 标准开源化价值

标准是“通过标准化活动，按照规定的程序经协商一致制定，为各种活动或其结果提供规则、指南或特性，供共同使用和重复使用的文件”。标准对于开源的价值在于提供可移植性和互操作性，从而提高开源软件的开发和部署效率，节省成本；同时标准制定、优化和推广也与开源项目的研发、升级和应用密切相关。
 
图 标准开源化价值

（1）开源是标准制定需求的来源

标准制定的需求来源于多个途径，开源作为广泛应用的软件是重要的需求来源之一。开源可以把在研发和推广过程中的客户需求和技术需求反馈到标准化流程中，通过开放的讨论形成共识，形成标准化文本，并通过标准化体系广泛推广，支持更多形式的标准实现，包括其他的开源项目、闭源软件，共同构造产业生态。

（2）开源是标准优化的基础

标准通过版本演进实现不断优化。开源在广泛应用过程中积累发现的问题不仅通过代码实现即时改进，对于影响兼容性和互操作的技术模块也应当及时反馈到标准化，实现标准的持续优化，提高标准的质量，并通过标准化体系为开源生态的扩展提供更大的支撑。

（3）开源帮助验证标准的可行性

标准作为抽象的技术要求需要得到验证，开源可以提供代码实现验证标准的可实现性，并将实现过程中遇到的问题回馈标准化流程，有利于提高标准的质量。

目前很多标准化组织，例如W3C等，开发流程要求标准发布之前必须有两个以上的实现，验证标准的可实现性，否则标准无法发布。目前很多W3C标准的是实现都是通过开源方式完成的。JCP标准开发流程同样要求标准必须有开源实现来验证标准的可实现性，这些开源代码构成了OpenJDK开源社区的基础。

（4）开源帮助推广标准

标准通过开源代码的实现加速了标准的快速应用。一般的标准都立足于技术的高层定义，以满足多种实现方式的需求，而无法直接通过代码方式使用。开源作为代码的直接实现，可以快速实现标准，大幅度提高了标准的易用性，可以推动标准的广泛使用。在一些领域的标准化工作中，采用包括XML在内的建模语言形成标准文本，支持通过自动化的方式完成代码转换，从而大幅度提高了代码实现的效率，也为标准与开源协调发展提供了技术工具支撑。

当然标准不仅支持开源实现，也支持闭源实现。例如，TCP/IP协议栈的实现，有开源的版本，也有闭源的版本，特点不同，面对不同用户的需求，满足在使用标准过程中对于多样性的需求。

### 1.2.2 开源与标准协同发展现状

开源与标准之间既是研究对象关系、规范与实现的关系又是协同发展关系。开源与标准化协同发展是信息技术领域发展的最佳模式，共同构建开放的产业生态。以国家标准结合团体标准的方式来共同促进开源生态可持续健康发展。

#### 1.2.2.1 开源的标准化需求

一是开源规则和社区治理的标准化。

开源要素包括术语、概念和规则等需要通过标准化达成共识，否则会埋下混淆的隐患。目前开源的一些重要要素由“开放源代码促进会”（Open Source Initiative，OSI）定义，符合其发布的“开源定义”（Open Source Definition，OSD）已经成为业界广泛应用的、用于确定“开源许可证”的标准；在OSD的基础上OSI发布的“开源许可证”在业界应用广泛[ ]；同时，OSI还建立了许可证审查流程，“确保标记为开源的许可证和软件符合现有的社区规范和期望”。OSI标准在开源领域内达成了共识，防止开源的滥用。

开源要素的标准化需求还体现在其他很多方面，例如开源知识产权方面以及金融行业为保障开源软件的安全应用在国家标准层面开展研制等。

二是开源项目和技术的标准化。

大量开源社区建设标准化流程，围绕开源项目和技术制定团体标准，并基于团体标准推动国际标准的制定。
例如，Linux Foundation建立了标准化组织Joint Development Foundation（JDF）[ ]，2020年经ISO/IEC JTC1批准，成为公开可用规范（PAS）提交者[ ]；Eclipse Foundation设立Eclipse Foundation Specification Process[ ],“为制定开源社区驱动的、开源友好的规范提供开放和透明的框架”；OpenInfra Foundation为OpenStack技术品牌的定义成立了DefCore标准项目，用于“确定如何授予OpenStack的商业实施使用商标的指导原则”。

#### 1.2.2.2 标准的开源化需求

标准化组织建设开源项目，围绕标准的验证、实施和推广开发开源代码。

例如，万维网联盟（World Wide Web Consortium，W3C）建立开源项目W3C Open Source Software, 认为“W3C标准的自然补充是可运行的代码，实现和测试是标准开发的重要组成部分，发布代码促进了开发人员社区的思想交流”；结构化信息标准促进组织（Organization for the Advancement of Structured Information Standards，OASIS）建立开源项目Open Projects[ ]，支持社区“在开源许可证下开发所需技术——代码、API、标准、参考实现”；致力于Java语言标准开发的Java Community Process标准组织建设OpenJDK开源社区，“为JavaSE JSRs标准提供开源参考实现”。

### 1.2.3 开源与标准协同发展的挑战与机遇

开源与标准协同发展的过程中既有挑战也有机遇，推进开源与标准的协同发展既要制定策略迎接挑战，解决问题，同时也要抓住机遇，推进发展。在新发展趋势下，OSD对于开源的定义已显露其局限性。

#### 1.2.3.1 挑战

开源社区的标准化不足问题

1. 在开源规则和社区治理领域的标准化不足

一是当前整个开源领域里的各种概念不明晰。如开源、开源软件、开源硬件、开源社区、开源产品、开源基金会等定义，不能简单的从OSD进一步推理得出。定义的模糊会增加政策制定的困难，从而导致开源软件、开源开发者等要素间界面的模糊不清。

二是当前相关标准的制定过程较为零散。开源标准的研制过程中有些为公开进行，有些仍在企业内部孵化酝酿阶段，可以预期在未来很长一段时期，开源标准将会层出不穷。

三是当前大量开源领域人士更愿意凭“事实标准”说话。结果将导致，标准往往只能事后追认业界的主流形态，无法起到凝聚共识，引领创新的作用。

在开源规则和社区治理领域的标准化不足带来的问题包括开源社区的质量和安全挑战等等。

- 质量挑战。随着开源软件数量的增长越来越快，开源社区的治理无法支持高质量管理，大量开源项目的质量将会缺乏保障。建立开源软件的质量管理标准将是提高社区治理能力的重要工具。

- 安全挑战。随着开源软件应用越来越广泛，其出现安全漏洞时可能造成的风险与损失也会越来越大。例如之前爆发的OpenSSL心脏滴血漏洞与大规模Log4j2漏洞。面对当前国内外开源领域可能产生的安全风险，需要从生态层面系统性的加以解决，应当以标准为抓手针对开源项目安全风险进行防范，以创造更好的开源生态环境。

2. 在开源技术领域以代码作为“标准”

开源社区对于标准化的价值理解不足，通常会简单认为可以以代码作为“标准”。

开源通过开放式的代码开发和共享迅速推动技术的广泛应用，在达到一定应用规模和影响力后，可以完成一部分“标准”的功能，例如支持系统之间的互操作。但是必须注意到这种互操作仅通过源代码实现的，只能保证采用这套源码的系统之间的互操作，而对于与其它的竞争开源项目、竞争私有系统以及同一生态体系的其他系统之间的互操作是无法保证的；而且，利用代码实现标准的过程一般由于缺乏开放、公开、透明的流程支撑，导致生态发展缺乏开放性，也为未来产业生态的持续健康发展带来危机。

因此，以代码作为“标准”，在实现“标准”的价值方面是极其有限的。而标准化可以在更广泛的范围内实现互操作，在更高的抽象级别定义互操作需求，通过接口实现互操作，而不仅仅提供源代码实现。

- 标准化组织对于开源的价值认识尚需提高

一些传统的标准化组织对于开源在标准化工作中的重要性认识不足，仍然坚持以传统的方式制定技术和技术类标准，不能借助开源实现的契机提高标准质量，推动标准应用，这些组织可能会在竞争中受到较大挑战。

- 标准中的知识产权问题是与开源协同过程中的重大挑战

传统的标准组织都是以Free Reasonable and Non-Discriminatory（FRAND）实施标准中的专利授权，而这种授权模式无法支持开源的商业模式。一些标准组织，例如W3C，为了支持开源模式制定了Royalty Free的专利处置规则，很好的促进的开源的标准实现和应用。

一些开源组织也无法避免在代码实施标准的过程中，由于标准中知识产权的处置问题而无法实现某些标准，严重的阻碍了开源代码的开发与推广。开源组织已经开始采取措施应对这一挑战，例如Linux Foundation与Open Innovation Network合作，期望通过专利池的管理来保障标准实施过程中不受知识产权的影响。
解决标准中的知识产权问题是促进开源与标准系统发展的重要制度性挑战。

#### 1.2.3.2 机遇

当前国际开源领域的发展也为我国带来重大机遇，一是我国应积极参与、甚至主动引领某些开源标准的制定工作，在国际领域贡献我国对于开源的看法，成为全球开源生态更加有力的领导者和协作者；二是改变开源领域事后追认的标准形式，并进一步探索柔性、可组合和前瞻性的标准，为我国将来的开源竞争力打下坚实基础。

- 开源规则和社区治理标准化的机遇

开源源自软件开发，意指开放源代码，最初指一种开放共享软件代码的开发模式。OSI对开源软件进行了定义，符合其发布的OSD即为开源软件，是目前国内外较公认的、权威的开源定义。但是OSD的本质是定义了开源软件授权协议的主要特征，并非定义了开源本身。作为一种“事实标准”，业界通常认为：采用了符合OSD的授权协议的软件，就是开源软件；也有观点认为：只要放在GitHub上的，就是开源软件。在开源发展的过程中以上观点已逐渐显露其局限性，均亟待完善与补充。

1. 开源内涵与外延

开源本质上是一种开发模式，开源最初的内涵和外延都是围绕软件代码开发，范围主要在软件层面，但随着开源模式在各技术领域和行业的逐渐发展，其内涵和外延已发生变化，除软件领域，开源的模式和精神已延伸至硬件、数据、信息共享、开源文档、开源情报等方面。同时OSI对于开源的定义只涉及开源软件，不能满足现有开源发展的涵盖领域，需要对其进行补充，基于此需求，国内开源产学研用各界以标准化语言体系为基础，分析凝练开源本质和关键特征，在OSD基础上提出开源的新定义：

开源是一种在软硬件开发、数据与信息共享中广泛采用的开放式协作模式，协作的产出物应该符合开源许可证条款的要求。具有开源规则、开源对象、参与主体、开源基础设施四个基本要素。

2. 开源生态四要素
 
图 开源生态四要素

（1）开源规则

开源规则是维持开源世界运转的基石，包括但不限于开源许可证、开源运营治理规则和应用评价规则等。较为人知的显性开源规则是开源许可证。开源许可证本质上是“非标准”的授权合同文本，规定了企业或开发者基于共同遵守的一类或几类代码分发、应用和知识产权许可条款，共同开发和使用开源软硬件源代码、数据和信息等，遇到纠纷需经法院判决才能生效。

除开源许可证之外，开源运营治理规则和应用评价规则是长期存在于开源世界，对于开源应用和生态发展至关重要的隐性规则，是各方从事开源实践时所遵从的一套方法论。

（2）开源对象

开源对象是开源群智化创新的内核。开源对象，包含开源代码、以及构建于开源代码之上的开源项目。目前，开源的内涵和外延已大大扩展，开源对象已延伸至硬件、数据信息等方面，可概括为开源软件、开源硬件、开放数据集、开放文档等类型。此外，开源对象的外延也发生变化，从技术层面向其他层面发散，涌现出开放科学、开源经济、现代服务业等。

对开源对象这一部分的研究工作还在持续进行中，将会随着开源在中国的不断发展而越来越清晰、成熟和丰富。

（3）参与主体

开源参与主体是推进开源不断向前发展的源动力，包括但不限于贡献者（个人/企业）、使用者（最终用户）、运营者（组织者/管理者）、和合作者（法律/监管）。开源生态系统汇聚了企业、开发者、开源基金会、开源社区、政府、科研院校等众多参与主体, 持续吸纳来自全球各界的贡献，具有极快的发展速度和极大的创新潜力。开源生态的发展还与国家政策的倾向有密切关系。我国开源参与主体存量大，近几年一直持续增长，未来在主导技术、引领创新和培育生态等方面具备较突出的后发优势。

（4）开源基础设施

开源基础设施是开展活动的载体，是指以服务开源项目、开源社区、开源生态为目标提供的软、硬件类平台、工具和服务。最常见的是开源代码托管平台，主要用于代码开发、管理、交流、修改、以及提出新开发需求等，覆盖开源软件生产全生命周期，开源基础设施还包括用于技术开发、社区交流、开发者汇聚、宣传推广等的邮件列表和问题追踪系统等。

开源基础设施是开源要素的汇聚承载枢纽。开源基础设施建设水平的高低，一定程度上会影响开源对象发展速度、参与主体使用黏性和开源生态的汇聚建设等，也是目前我国在发展开源过程中正在发力建设的重要因素。

- 开源项目技术标准化的机遇

利用标准化支撑开源项目的可持续发展以及开源技术生态的建设在业界已经有了丰富的实践，标准化对于开源项目的价值也逐步得到更多重视，应当抓住这个机遇大力推进开源项目的技术标准化。

- 标准化组织建设开源项目的机遇

标准化组织中建设开源项目已经成为业界领先的标准化组织的基本形式。随着我国国家标准化纲要的推进，借助团体标准化发展的契机以及大力推进标准实施的战略要求，在标准化组织中建设开源项目也将成为提升标准化能力的重要手段。
 
## 1.3 开放科学和开放获取

### 1.3.1 开放科学的发展历程

开放科学的思想最早萌芽于中世纪的欧洲宫廷资助系统，资助者采用同行评议、开放交流的方式鉴别受资助成果的质量。开放科学的发展大致经历了三个阶段。欧洲一直走在开放科学的前沿，2009年欧盟第七框架计划（FP7）资助了欧洲科研开放获取基础设施项目OpenAire，致力于建设开放和可持续的学术交流基础设施。2014年，在欧洲“地平线2020计划”下提出了欧洲开放科学培训项目（FOSTER）。2018年，欧盟支持发起开放获取S计划，旨在使得受公共和私人支持的，经过同行评议的出版物能够完全和立即开放获取 。美国开放科学中心（COS）于2013年发布了开放科学框架（OSF），旨在协助科研团队管理项目和公开成果 。《中华人民共和国科学技术进步法》（2021年修订）第九十五条规定“推动开放科学的发展，促进科学技术交流和传播”。

### 1.3.2 开放科学概念和框架

根据联合国教科文组织（UNESCO）在2021年11月发布的《开放科学建议书》，开放科学被定义为一种包容性的结构，它结合了各种运动和实践，旨在使多语言科学知识对所有人开放、可访问和可重复使用，以增加科学合作和信息共享，以造福于科学与社会，并向传统科学界之外的社会行为者开放科学知识创造、评估和交流的过程。开放科学包括所有科学学科和学术实践的各个方面，包括基础科学和应用科学、自然科学和社会科学以及人文科学，它建立在开放科学知识、开放科学基础设施、科学传播、社会行为者的开放参与并与其他知识系统进行公开对话的框架之上。

### 1.3.3 开放科学的核心价值观、指导原则、行动领域和监测

《开放科学建议书》概述了开放科学的四大核心价值观、六项指导原则、七个行动领域。

#### 1.3.3.1 开放科学的核心价值

（1）质量和完整性：开放科学应该尊重学术自由和人权，支持高质量的研究，方法是汇集多种知识来源，广泛提供研究方法和成果，供严格审查和透明的评估过程使用。

（2）集体利益：科学知识应该是公开且普遍共享的。科学实践应该是包容的、可持续的和公平的，也应该是科学教育和能力发展的机会。

（3）公平公正：开放科学应发挥重要作用，确保发达国家和发展中国家科学家之间的公平，实现科学投入和产出的公平互惠共享，使知识的生产者和消费者都能平等获得科学知识。

（4）多样化与包容性：开放科学应该包含知识、实践、工作流程、语言、研究成果和研究主题的多样性，以支持科学界作为一个整体的需求和知识多元化，支持多样化的研究团体和学者，支持传统科学界之外的更广泛的公众和知识持有者，包括土著人民和当地社区，以及不同国家和地区的社会行动者。

#### 1.3.3.2 开放科学的指导原则

（1）透明度、审查、批评和可重复性：应该在科学努力的所有阶段促进增加开放，以加强科学成果的强度和严谨性，增强科学的社会影响，并提高整个社会解决复杂的相互关联的问题的能力。

（2）机会均等：所有科学家和其他开放科学行为者和利益攸关方都有平等的机会接触开放科学，为开放科学作出贡献并从开放科学中受益。

（3）责任、尊重和问责：与公共问责、对利益冲突的敏感、对研究活动可能产生的社会和生态后果的警惕、知识产权和对与研究有关的伦理原则和影响的尊重一起，应该构成开放科学良好治理的基础。

（4）合作、参与和包容：超越地理、语言、世代和资源界限的各级科学进程的合作应成为规范，学科之间的合作应得到促进，社会行为体的充分和有效参与，并吸收边缘社区的知识，以解决具有社会重要性的问题。

（5）灵活性：鼓励向开放科学过渡和实践的不同途径，同时坚持上述核心价值，并最大限度地遵守在此提出的其他原则。

（6）持续性：开放科学应该建立在长期实践、服务、基础设施和资助模式的基础上，以确保来自弱势机构和国家的科学生产者的平等参与。

#### 1.3.3.3 开放科学的行动领域

为实现开放科学建议书的目标，建议成员国根据国际法并考虑到各自的政治、行政和法律框架，在以下七个领域同时采取行动。

（1）促进对开放科学、相关利益和挑战以及开放科学的多种途径的共同理解；

（2）为开放科学营造有利的政策环境；

（3）投资开放科学基础设施和服务；

（4）投资于开放科学的人力资源、培训、教育、数字素养和能力建设；

（5）培育开放科学文化，调整开放科学激励机制；

（6）在科学进程的不同阶段促进开放科学的创新方法；

（7）在开放科学的背景下促进国际和多方利益攸关方合作，以减少数字、技术和知识差距。

#### 1.3.3.4 开放科学的监测

（1）部署监测和评估机制，以衡量开放科学政策和激励措施对既定目标的有效性和效率。采用多方利益攸关方的方法，收集和传播开放科学及其影响方面的进展、良好做法、创新和研究报告。

（2）制定监测指标和框架，考虑在国家战略计划范围内制定一个具有质量和数量指标并在国际一级共享的监测框架，为执行本建议制定短期、中期和长期的目标和行动。

（3）制定战略以监测开放科学的有效性和长期效率，其中包括多方利益攸关方的参与方法。

### 1.3.2 开放获取

#### 1.3.2.1 开放获取的发展历程

2002年，《布达佩斯开放获取倡议》（BOAI）正式提出开放获取概念 。2003年，德国马普学会等机构发起开放获取柏林会议，并发表《柏林宣言》，呼吁免费公开更多的科学资源，鼓励科学家以OA方式出版论文 。2004年，Springer出版集团开始在其1000多种订阅期刊上向作者提供开放获取选项，带动期刊向符合开放获取期刊转换。2006年，高能物理开放获取联盟SCOAP3建立，推动学科内大多数期刊向开放获取出版转换 。2007年，南非开普敦开放教育会议发布了《开普敦开放教育宣言》 。2009年，开放获取知识库联盟COAR成立，旨在联合遍布五大洲的机构知识库并建立一个全球协作网络，提高存储成果的可见度和利用度。2013年，全球研究理事会发布《出版物开放获取行动计划》。

#### 1.3.2.2 开放获取的主要方式

《布达佩斯开放获取倡议》提出了实现开放获取的两条路径，即开放获取期刊（Open-access Journals）和开放存储（Self-archiving），这两种方式分别被称为金色OA和绿色OA。除这两种主要方式外，在实际出版过程中还有其他的开放获取模式。

金色OA（Gold OA）：指论文的最终版本在网络上立即开放获取，读者不需要付费。金色OA的论文一般发表在完全开放获取或向开放获取转换的期刊上，遵循CC BY或CC BY-NC-ND的版权许可协议，由作者、研究机构或基金资助机构缴纳论文处理费（article processing charge，APC） 。

绿色OA（Green OA）：指作者在订购期刊上发表论文后, 将论文一定版本存到开放获取知识库中并在一定时间后（Embargo period, 开放时滞期）开放获取 。

青铜OA（Bronze OA）：指科研论文的许可并不明确，出版商可能限时授予文献免费访问权限的获取方式 。

钻石OA（Diamond OA）：指在不收取作者费用的情况下，发布开放获取的期刊，即作者和读者双向免费。2022年3月2日，Science Europe、S联盟（cOAlition S）、人文学科开放学术交流研究基础设施服务联盟项目（OPERAS）和法国国家研究机构（ANR）共同提出了“钻石OA行动计划” 。

黑色OA（Black OA）：是较新的说法，指的是从学术社交网（如Mendeley、Research Gate、Academia.edu等）或非法提供学术论文全文的网站（如Sci-Hub）上可以免费下载大量本应交费浏览的学术文章 。

#### 1.3.2.3 开放获取的载体

CORE（https://core.ac.uk/）是全球最大的开放获取研究论文库，其使命是索引全球所有开放获取研究，并为所有人提供不受限制的访问。CORE目前包含2.61亿篇从全球11,000数据提供商收集的开放获取文章。

Dimensions是最全面的研究资助数据库，它将资助与数百万种由此产生的出版物、临床试验和专利联系起来。截至2023年5月Dimensions有135,517,255出版物、6,595,673基金、12,245,864数据集、938,422政策文本、770,634临床试验、153,152,401项专利 。其中，开放获取论文共有42,747,022，约占31.5%。该平台收录的中国出版物总量为4,203,610、数据集为405,693、基金项目619,635、临床试验10,249，其中开放获取论文共1,265,665，占比30.11%。

Web of Science（https://www.webofscience.com/wos）是全球最受信赖且独立于出版方的全球引文数据库。平台全面收录了超过 17 亿条被引文献和 1.59 亿条记录，可以跟踪跨学科和时间的科研想法。截至2023年5月，Web of Science核心合集中收录的中国论文共有7,776,949篇，其中开放获取论文2,195,823篇，占28.23%。

- 开放获取期刊

开放获取期刊指用户可以在法律允许的范围内最大限度地接近学术资源，打破传统学术期刊的限制和门槛，排除经济、地域等因素，按照个体需求进行阅读和分享学术期刊 。开放获取期刊强调自由、免费、开放、共享的理念，减少了获取学术信息的阻碍和交流的时滞性，为快速传播科研成果提供了有利条件。美国科研出版社（Scientific Research Publishing，简称SCIRP）是全球最大的开放获取期刊出版商之一。目前已出版超过200多种开放获取、在线、同行评审的期刊，涵盖了广泛的学术学科。此外，国际上开放出版期刊平台还有PLOS、Cogent OA 、Dove Medical Press 、Copernicus Publications 、ELCVIA 、Frontiers 等。DOAJ是全球开放获取期刊索引，只接受开放获取期刊，期刊应遵守学术出版的透明度和最佳实践原则，期刊必须有自己的专用URL和主页，必须至少有一个ISSN，期刊必须有编辑和编委会，所有文章在发表前必须通过同行评审 。截至2023年4月，DOAJ共收录来自131个国家的19,233种期刊，其中中国期刊有256种，占1.33% 。GoOA是开放获取论文一站式发现平台，是由中国科学院资助、中科院文献情报中心建设推出的开放资源。它收录了经严格遴选的来自144家知名出版社的2500余种OA期刊及其全文，学科领域涉及自然科学领域及部分社会科学领域。

- 机构知识库

机构知识库（Institutional Repository，简称IR）又称机构典藏库、机构仓储、机构库等，通常情况下指的是，某个机构实体为保存和管理本机构智力成果资源（包括本机构成员创作的学术成果、科研数据、课件教程、软件工具等），自主或借助第三方机构建立的集提交、组织、检索、分析、利用等为一体的学术存储与服务系统 。OpenDOAR是开放获取存储库全球目录，截至2023年4月，OpenDOAR平台注册的机构知识库总数达6025个，其中美国（925个）、日本（657个）、英国（324个）排名前三位，中国65个，占比1.08% 。2019年4月4日在美国宾夕法尼亚州费城举行的RDA第十三届全体会议上提出了维护数字存储库可信性的TRUST原则，即Transparency（透明度）、Responsibility（承担责任）、User Focus（用户导向）、Sustainability（可持续性）、Technology（技术能力）。国际上机构知识库联盟主要包括：开放获取知识库联盟（COAR）、法国FAL、荷兰DAREnet、澳大利亚ARROW、日本JAIRO、德国OA-Network、英国JISC RepositoryNet、欧盟DRIVER 。我国的机构知识库联盟主要有中国科学院机构知识库网络（CAS IR GRID）、中国高校机构知识库联盟（Confederation of China Academic Institutional Repository，简称 CHAIR）和农业机构知识库联盟。其中，CAS IR GRID共有期刊论文908,684篇，会议论文139,822篇，专利数据114,490条，其他数据132,784条 。CHAIR共有会员机构51家，元数据总量2,868,428，访问量248,935 。农业机构知识库联盟共有下属机构36个，专家学者7514位，科研成果197,697篇 。

- 预印本平台

预印本（preprint）是作者在提交期刊出版前未经严格同行评议的手稿（投稿版、录用稿），经过初步的评议审核后，即借助于预印本平台在最短的时间内以开放获取的形式发布，为作者获得最新研究成果的网络首发权，为学术交流系统提供最新、最快速的研究成果传播与利用渠道。

1961—1967年，在美国国立卫生研究院（NIH）的支持下，由相同领域或共同研究兴趣的科学家组成了“信息交换小组”（Information Exchange Groups，IEGs），该小组吸引了3600名研究人员并产生了2500篇预印本。第一个电子化预印本平台arXiv由物理学家保罗·金斯帕（Paul Ginsparg）于1991年在美国洛斯阿拉莫斯（Los Alamos）国家实验室建立，arXiv 起初主要收录高能物理领域的预印本，如今，学科领域扩展到数学、计算机、计量生物、计量金融、统计学等。２013年，美国开放科学中心 （Center for Open Science）推出了免费、开源的预印 本集成平台OSF（Open Science Framwork），目前平台数量达到30个，预印本及其由作者保存在预印本平台上的文献达220万篇。２017年Science将预印本评为当年十大科技进展之一，生物学bioRxiv和化学Chemrxiv在更大范围内受到关注。

学术论文出版的预印本平台有：arXiv、BioRxiv、medRxiv、 ChemRxiv、F1000、figshare、Peerage of Science、engrXiv、PeerJ Preprints等 。其中，arXiv于1991年发起，涉及物理学、数学、计算机科学、定量生物学、定量金融学、统计学、电气工程和系统科学以及经济学领域的超过200万篇学术论文。BioXiv、MedXiv和ChemXiv分别是生命科学、医学和化学领域的预印本平台。ChinaXiv是中国科学院文献情报中心于2016年开始运营的预印本交流平台，支持中英文科技论文预印本的发布、传播、下载和评论。ChinaXiv还有面向具体学科领域的12个共建子平台，如中国心理学、生物工程、岩土力学、语音乐律、数学、天文学、光学、核物理、信息资源管理、护理学、法学和数字出版预印本平台。ChinaXiv-Global是由ChinaXiv提供的全球预印本服务，索引由全球重要的预印本平台发布的论文，帮助科研人员更好更快第发现最新的研究产出。