# 第五章 中国开源社区发展现状

当前我们所身处的数字化时代几乎都是由开源代码所构建的，伴随着开源运动在中国的落地与发展，中国的开源社区从最初单一且独立的社区不断演进，呈现出今天百花齐放的繁荣景象。本篇集中呈现当前国内各类社区发展的现状和特点。

## 4.1 中国开源社区的起源与发展历程

十几年前，很多人认为“开源=Linux”，因为当时的Linux操作系统、桌面办公软件（GNOME、OpenOffice）和浏览器（Mozilla）作为开源项目的主战场，掀起了第一波开源的浪潮。随着开源项目规模的不断壮大，开源社区也逐渐形成。

国内的开源社区起初以Linux爱好者为主导，最早出现于1998年。不过，早期国内社区多为个人爱好者兴办，社区的发展规模和影响力有很大的局限性，因此中国第一代社区的持续发展能力不足，大多销声匿迹。如，于1998年在清华大学成立的阿卡社区（AKA），2000年前后发展到顶峰，但此后受骨干成员出国、成家、创业等影响，逐渐进入低潮期，其中部分人员转型嵌入式培训，AKA转变为亚嵌公司。AKA早期的多数成员后来成为了中国最早的一批Linux精英。2001年创立的灰狐动力社区，最初只是一个关于中间件技术研究和应用纯个人网站，到2002年已经成为国内中间件行业极具权威性的站点。但在2010年5月19日，灰狐动力和开源力量宣布合并。创始于2006年12月的哲思社区，在当时是中国知名的自由软件社区，也已于多年前停更。而其中只有少数幸运的优秀社区因得到企业和产业的广泛认可而找到生存模式获得新生，如CSDN逐渐成长为中国最大开发者社区，ChinaUnix社区被IT168公司收购，PHPChina社区被康盛创想公司收购（后期被腾讯整体收购），开源中国社区被恒拓开源公司收购等。
    
后来，随着互联网的兴起，开源的项目和技术呈现百花齐放之盛况，从数据库到中间件、从前端到后端、从编程语言到编译器、从物联网到微服务、从大数据到人工智能，开源的技术和项目越来越丰富和多样化。在此趋势下，自2008年起，中国第二代开源社区纷纷登场。在吸取了一代的教训后，第二代社区的典型特征是更加聚焦、更加务实，通常是围绕一个公司的特定产品，且该公司作为社区的唯一或最大赞助商。这类社区包括深度操作系统社区、Ubuntu麒麟社区、龙芯俱乐部、OpenEuler社区等。这些社区的发起团队普遍具有全球开源视野，同时也认识到知名科技企业在开源生态发展中的核心作用，与企业合作共赢是开源社区发展的关键路径，第二代社区开始有意识地吸纳开源布道者、市场专业人士和法律专业人士成为社区的骨干人员。
    
近几年，随着移动互联网和云计算、AI在中国的蓬勃发展，中国开始涌现出大量开源项目的开发者，国内开源社区进入第三代。典型代表包括开放原子开源基金会、开源中国社区、木兰开源社区、GitCode、确实（Trustie）开源社区、OpenI启智开源社区等。第三代社区的典型特征是在社区运营和管理上更加中立和平衡，且社区内包含不同来源的众多开源项目。目前中国第三代开源社区仍处于起步阶段，在开源治理、社区运营等方面尚显稚嫩。能够坚持中立立场、平衡诸多赞助商之间以及与开发者之间的关系，吸引开源治理专家、培养社区运营骨干是第三代社区当前面对的主要挑战。
    
中国第一代技术社区至今仍坚持运营的屈指可数，最成功的典范就是CSDN开发者社区，作为目前世界第二大的开发者社区，20多年来CSDN为中国培养了几代开源开发者，同时也见证了中国开源快速发展的20年。2022年4月，CSDN成为开放原子开源基金会黄金捐赠人。也通过扩大对开发者服务内容（开源知识库、培训、猎头、代码托管平台、开源项目孵化和开源创投），身体力行地推进开源产业的发展，正在积极地向第三代开源社区转型。

由企业主导的第二代社区正在积极的与第三代社区（含国际开源社区和开源基金会）合作，通过开源捐赠或发起新项目等多种形式融入第三代社区，如华为将欧拉开源操作系统（openEuler, 简称“欧拉”）捐赠给开放原子开源基金会，携程捐赠Apollo项目到Apollo开源社区，百度捐赠HugeGraph图数据库给Apache软件基金会，华为将开源的云原生多云容器编排项目Karmada捐赠给CNCF等。


## 4.2 中国开源社区的现状特征

据中国开源软件联盟不完全统计，截止2022年3月，国内各类开源社区已经超过xxx个，按照项目型社区、本地化社区、开发者社区和代码托管社区四类进行汇总，项目型社区增速最为显著。

从开发者规模和开发者合作参与层次上，部分开源社区已经发展到非常大的规模，在社区生态上取得了显著的成绩。


概要--opendigeer
### 4.2.1 项目型社区
欧拉，龙蜥，OpenCloudOS，OpenKylin，深度社区。。。

### 4.2.2 本地化社区-李明康（小明）
LinuxFans、Ceph中国社区、GoCN社区、Python中国社区、物联网自动化社区iot.cechina、Linux人社区、K8S中文社区


### 4.2.3 开发者社区-李明康（小明）

#### CSDN

官网：https://www.csdn.net/

简介：CSDN（中国开发者网络）创立于1999年，是全球知名中文开发者网站。秉承成就一亿技术人的使命，为IT技术人成长及科技企业发展，提供开发者生态的全方位服务。CSDN在社区基础上，通过知识云、人才云、开发云三大服务，赋能开发者、研发团队及科技企业在IT知识学习、人才招聘、研发效能与协同管理等方面的高速成长与发展。

#### 开源社
官网：https://kaiyuanshe.cn/

简介：开源社成立于 2014 年，是由志愿贡献于开源事业的个人成员，依 “贡献、共识、共治” 原则所组成，始终维持厂商中立、公益、非营利的特点，是最早以 “开源治理、国际接轨、社区发展、项目孵化” 为使命的开源社区联合体。开源社积极与支持开源的社区、企业以及政府相关单位紧密合作，以 “立足中国、贡献全球” 为愿景，旨在共创健康可持续发展的开源生态，推动中国开源社区成为全球开源体系的积极参与及贡献者。2017 年，开源社转型为完全由个人成员组成，参照 ASF 等国际顶级开源基金会的治理模式运作。近九年来，链接了数万名开源人，集聚了上千名社区成员及志愿者、海内外数百位讲师，合作了数百家赞助、媒体、社区伙伴。

#### 木兰开源社区
官网：https://portal.mulanos.cn/

简介：“木兰开源社区”建立于2019年8月，是国家重点研发计划重点专项“云计算和大数据开源社区生态系统”的核心成果。旨在促进产学研用各方开源领域的交流，推动国家科技创新成果开源，加强企业、科教研单位和行业用户之间的沟通，推动开源成果转化落地，同时为各类开源项目提供中立托管，保证开源项目的持续发展不受第三方影响，通过更加开放的方式来打造和完善开源社区生态。

#### 可信开源社区
官网：http://caicttrustedopensource.org.cn/

简介：可信开源社区共同体（TWOS）由众多开源项目和开源社区组成，目的是引导建立健康可信且可持续发展的开源项目和开源社区。可信开源社区共同体（TWOS）旨在搭建交流平台，提供全套的开源风险监测与生态监测服务。

#### SegmentFault 思否 
官网：https://segmentfault.com/

简介：SegmentFault 思否 (segmentfault.com) 是中国领先的新一代技术问答社区，也是中国最大的黑客马拉松（Hackathon）组织者。我们为中文开发者提供一个纯粹、高质量的技术交流平台以及前沿的技术行业动态。目前已经覆盖和服务了超过 1000 万开发者和 IT 信息从业者，帮助开发者解决了数百万个技术问题。

#### 开源中国
官网：https://www.oschina.net/

简介：OSCHINA（Open Source China，OSC）成立于 2008 年 8 月，目前已建立了相当完善的开源软件分类数据库，收录全球知名开源项目近 5 万款，涉及几百个不同的分类。围绕这些开源项目，OSCHINA 为中国开发者提供了最新开源资讯、软件更新资讯、技术分享和交流的技术平台。2013 年，OSCHINA 建立了代码托管与 DevOps 平台“码云 Gitee”，为广大开发者提供团队协作、源码托管、代码质量分析、代码评审、测试、CI/CD 与代码演示等功能。经过在开源领域超过十年的深耕，以及与中国本土开源环境的结合，推动了中国开源领域的快速发展。OSCHINA 目前已发展成为国内知名的开源技术社区，社区有 600 万开发者活跃，长期致力于推动国内开源软件的应用和发展，提升本土开源能力，以及为开源生态环境的优化提供支持。


#### 稀土掘金
官网：https://juejin.cn/

简介：稀土掘金是一款面向全球中文开发者的技术社区，是基于数据挖掘技术的个性化推荐引擎产品。它为每一位热爱技术的人提供有价值、成体系的技术内容，并搭建了一个聚焦开发者、温暖有爱、快速迭代、激励成长的垂类内容社区。掘金打通了技术内容、技术人才与技术服务企业的路径，未来将持续为开发者生态提供知识输出、技术交流、产业合作等全维度的支持。

#### infoQ
官网：https://www.infoq.cn/

简介： InfoQ 是一家全球性社区网站，基于实践者驱动的社区模式建立。软件正在改变世界。促进软件开发及相关领域知识与创新的传播是我们的使命。为此，我们致力于提供中立的、由技术实践者主导的会议以及文章、视频演讲和采访等资讯服务，面向 5 至 8 年工作经验的研发团队领导者、CTO、架构师、项目经理、工程总监和高级软件开发者等中高端技术人群，提供中立的、由技术实践主导的技术资讯及技术会议，搭建连接中国技术高端社区与国际主流技术社区的桥梁。

#### 开源雨林
官网：https://www.osrainforest.org/

简介：开源雨林是由华为技术有限公司和开放原子开源基金会、中国软件行业协会、中国科学院软件研究所、中国信息通信研究院、开源社等组织共同发起，围绕开源通识、开源治理和开源使用实践等方向构建一个用于收集、分享开源知识分享社区的经验。

#### 腾源会
官网：https://cloud.tencent.com/act/pro/weopen-home

简介：腾源会是腾讯云成立的汇聚开源项目、开源爱好者、开源领导者的开放社区，致力于帮助开源项目健康成长、开源爱好者能交流协助、开源领导者能发挥领袖价值，让全球开源生态变得更加繁荣。



### 4.2.4 代码托管社区-耿航
GitCode，Gitee，Gitea，Gitlink，Coding

代码托管社区平台是指具备开源代码、项目孵化、开源治理、媒体等多种服务功能的社区，其他垂直小众社区也在该社区平台构建自己的影响力。具有代表性的服务型社区如下。

#### GitCode
官网：https://gitcode.net

简介：GitCode是专业开发者社区CSDN推出的开源项目协作管理平台，Gitcode提供了开源代码托管、开源教学、开发云、开源百科等服务，通过打造符合中文开发者使用习惯的开源项目协作产品，推动国内开发者学习开源、参与开源、贡献开源，助力中国开源产业生态的创新与繁荣。GitCode拥有CSDN 3500万的开发者用户基础，具有海量的开源文档资源库，是国内开源开发者用户量、互动量极高的社区。同时，Gitcode通过MyGitHub功能，支持社区内的开源软件、开源开发者与国际开源社区联动。GitCode定期组织开源技术沙龙、主题会议、中国开源发展蓝皮书等，普及开源技术，弘扬开源文化。

#### Gitee
官网：https://gitee.com

简介：Gitee是OSCHINA推出的代码托管协作开发平台，支持Git和SVN，提供免费的私有仓库托管。2021年Gitee新增用户数超过了180万，达到800万。新增活跃的仓库数超过了200万，自2019年开始保持着大幅增长的趋势。

#### 鹏城汇智
官网：https://www.ihub.org.cn

简介：鹏城汇智平台是由鹏城实验室建立并运营的完全公益性的开源代码托管平台，主要聚焦于人工智能及RISC-V领域，旨在服务广大开发者及科研工作者群体，建设一个具有专业的代码托管功能、稳定易用的开源平台，展示国内外优质的开源项目，促进我国开源及人工智能领域的发展。

#### GitLink
官网：https://www.gitlink.org.cn

简介：GitLink（确实开源）是CCF官方指定的开源创新服务平台，截至目前，已有5万开发者、1000+组织入驻，仓库数量累计140万。它为我国创新型软件产业发展提供了关键技术支撑和实践指南，支持了我国航空、航天、国防等多个关键领域的可信软件生产，为包括新一代人工智能启智社区、ARM绿色计算社区、云计算与大数据木兰社区、科技委可控开源创造行动红山社区等的建设提供关键技术支撑，为我国关键领域开源社区生态建设发挥了重要作用。

#### Coding
官网：https://coding.net

简介：Coding是深圳市腾云扣钉科技有限公司推出的产品，其重点面向团队和企业的代码协作开发服务。Coding的项目管理包含任务、讨论、文件等功能，支持多成员协作，并且深度集成了代码仓库的操作与状态。

## 4.3 中国开源社区发展的挑战和趋势
