# 第七章 开源商业现状

> 作者 | 狄安，OpenTEKr创始人

2022年对于开源商业化来说无疑是一个极具挑战的一年。无论在全球资本市场上，还是在国内市场上，由于Covid-19疫情的影响以及全球政治形势的影响，经济的缓慢复苏和资本的骤冷，让开源生态里的商业公司都经历着各种考验。

全球市场上，2022年有MariaDB 通过SPAC方式上市，但不到半年的时间市值腰斩。在国内市场上，相比资本市场的谨慎观望，国家和政府则对于开源逐渐重视，并不断推出利好政策。

**本年度重要事件 【尚待收集整理完成】**

Apache 基金会成员、Apache Dolphin Scheduler PMC郭炜（郭大侠）在2022年10月25日开源中国的博客《史上最全！全球 22 种开源商业收入模式 》一文中总结了全球大部分开源项目形成收入的商业模式，一共 22 种的模式，具体如下图：

![](https://img-blog.csdnimg.cn/910e23dc2df1408c97938921d61e424e.jpeg#pic_center) 

通过上表可以看出，一些是开源下的直接服务模式，一些看起来还是面向软件的许可模式。 那么，这些开源软件的商业模式和闭源软件的商业模式究竟有多大差别呢？ 我们就用下表来做个简单的分析：		
				
| 序号 | 闭源的业务模式 | 具体内容 | 开源 | 两者收费模式的区别 |
| :--: | :-- | :-- | :--: | :-- |
| 1 | 软件许可制 | 按照软件许可证的授权规定来收费 | 存在 | 闭源为纯商业软件许可证，开源的可以有开放核心或者双许可模式Open Core/Duallicense） |
| 2 | 项目交付制 | 按照约定的项目需求范围，以闭源或者开源软件为基础提供项目的方案设计和开发服务成果交付。按项目交付成果和项目工作量收费 | 存在 | 若使用开源技术则免去额外许可费，其他无区别 |
| 3 | 运维服务制 | 以约定的服务响应的等级水平（SLA）向客户提供维护和支持服务。按服务等级和服务时间收费 | 存在 | 无 |
| 4 | 人力外包制 | 以员工的技能等级水平向客户提供人天或人月服务按能力等级和服务时间收费 | 存在 | 无 |
| 5 | SaaS订阅制 | 按照软件的使用消费量如功能，用户数结合数据量或者时间来收费 | 存在 | 无 |
| 6 | 云平台服务制（Iaas/Paas）| 软件以平台的方式来提供，按照在平台上销费的各项能力如硬件或者算力等	存在	无

注：第5，6项模式现在流行成混合模式即云SAAS订阅服务模式。

综合上表的比较，我们几乎可以得出一个结论：开源本身并没有创造更多新的业务模式。存在差异的部分只是原来可以按照纯商业软件许可来收费的软件，现在开源后，就无法收费了或最多按照部分的许可收费了。所以，开源对于软件业货币化影响的实质是弱化了软件许可的货币化，同时把货币化更多的推向了服务收费。 虽然在开源下，有些看起来还是软件许可模式，但它们的软件许可并不是面向开源代码本身，而更多是针对开源代码之外的代码形成的许可，实际上是把开源下服务演变成一类新的软件产品。可以称作是开源服务的一种间接形式。

但对于最初从 “软件是商品，服务是免费”的理念为起步的中国软件市场及这个市场下的从业者们来说，就以“软件服务收费”这一命题而言，尤其在企业级服务领域，实际上至今还很难被市场充分接受。从网上随便搜索下有关软件采购的企业或者相关部门招投标公告就很容易看到，动辄就要求供应方提供的软件包含少则三年，长则五年的免费维护类才能入围的条件还比比皆是。

更大胆一点说，这就是要把很多还在试图让“软件变成可售卖的标准商品”国内软件创业企业和还在期待服务免费的国内客户们，一下转变到“软件可以免费，但开源服务要收费“的另一条轨道上，无论对于那些年轻而充满激情的中国开源软件从业者们来说，还是对于那些已经习惯于服务免费的企业消费方来说，观念的冲击和实践的挑战无疑都是巨大的。

但随着全球商业软件巨头纷纷拥抱开源，开源已是无法避免的趋势。那么，如何寻求一个有效的开源收费模式，也就成为了每个开源创业无法避免的问题。，虽然开源本身没有产生更新的商业化模式，但开源支撑了商业模式的产生。当然我们基于开源去辨别一个商业模式的真伪时，我们会发现两个事实早就显而易见地摆在了那里：
1. 开源生态里会允许商业模式的建立和存在发展；而开源生态也需要有商业模式来帮助进一步拓展开源。但，开源里也绝不会只有商业模式的单一存在，一定还有其他非商业因素的成分存在，比如开源作为数字公共品存在的属性，开源作为开发者的爱好追求等；

2. 企业的商业模式里当然可以考虑将开源作为企业的商业策略之一，并且设计到企业的商业模式中。但，企业的商业模式也绝不是说必须要有开源。开源是企业商业模式设计中的一项可选要素之一。

在2018年，Linux基金会曾经发布过一本《企业开源实践指南》。对于开源可以支撑的商业模式，书中有过明确的论述。开源可以用来支撑四大类型的商业模式构建。即：1）在开源里构建 2）与开源伴随构建 3）为开源而构建 4）在开源上构建。

这四大类型的开源和商业模式之间的关系具体如下图所示：
 


2 开源支撑的四大业务模型
自开源一词从1998年正式诞生以来的25年时间里，开源和商业共生发展的过程中，上图这些业务模型或者这些模型的混合态都曾经在业内出现并被很多企业实践过，有成功的经验，也有失败的教训。而这些模型在商业企业中的运用则主要取决于每个公司对自己产品的定位或服务策略的定义。在《企业开源实践指南》中也对这四类业务模型做了具体的阐述和展开如下：
#01. 在开源里构建（Building open source）这是一种最基本但最也具挑战性的商业模型。它的策略是创建开源软件本身，同时为了获得直接的回报而进行软件的开源。企业的目的是专注于构建开源软件，然后通过专家服务和对于产品部署包的商业支持来向客户提供价值后获得经济回报。红帽公司也许就是利用这种模式并取得成功的最佳案例。
#02.与开源伴随构建（Building with open source）此模型能够创建与开源一起使用或基于开源的专有软件或服务。通过此策略，公司可以使用开源软件进行构建，或依靠开源软件来提供基本的底层库和组件。这是一个在业界被广泛使用的模型，在当今市场上已经很难找到一个不包含开源软件的软件产品。
#03.为开源而构建（Building for open source）从历史上看，这种模式需要创建软件将其作为开源来提供，并通过加入增值服务来创造收入。遵循这种方法，公司构建产品或服务的目标是使其成为开源并围绕它建立业务。另一个例子是为开源而创建源代码的公司。
#04. 在开源上构建（Building on open source）通过这种策略，公司可以在开源软件的基础上构建产品，其中开源提供了基础，并且提供了技术栈中实际商业价值较高的那一部分。在这种模式下，专有软件或服务对开源软件会有很强的依赖性，今天几乎任何新业务都将严重依赖这种开发模式和开源生态系统。


在了解和掌握了上述开源和商业模式的四大构建关系后，每个企业就可以根据自己的实际情况去建立和衍生自己的业务模式。差异更多在于软件部分的开源和闭源之间。如此而言，开源的边界决策，无疑就是影响开源货币化的一个关键战略决策。即：哪些开源，哪些闭源？
 
从开源项目供应方角度来说的话, 选择那些可以帮助企业建立市场竞争策略的软件来开源是值得考虑的。雷蒙德在《魔法锅》第4.11节-用开放源码做战略武器，曾经建议了有建设性的四点开源考量，概括后我们可以简述如下：

１）能够”分摊研发成本“后去和对手进行竞争的软件。他以APACH而为例，指出了对于基础架构的开源是有意义的，因为它使每个参与者能以较低成本研发生产并扩展自己的产品和服务，而同时参与者的市场定位又可以让购买的用户不再担心被供应商锁定。 
2）能够帮助企业”重置竞争“的软件。他以Dec公司和SUN公司在图形窗口软件为例，来说明把别人有优势，而自己并没有优势的那部分软件来开源，进而把竞争对手拉入到自己的优势领域重置竞争。
3）能够帮助企业”扩大水池“的软件。他以红帽公司资助RPM软件包的开发，指出通过可以让自己参与到公开技术标准软件的开源是对抗竞争对手的一项有利武器。
4）能够防范竞争对手“锁喉“的软件。如果企业担心竞争对手对某项技术的控制要比自己控制该项技术来得更垄断性，那么将此部分软件拿来开源就可以建立一个合作联盟并使这部分软件成为公开代码将可以有效解除被竞争对手控制的潜在风险。

而从开源消费者的角度来观察的话，他们往往会喜欢以下三种类型的开源：
1）	能够切实解决他们某一方面问题且基本功能完整的软件。
2）	重要关键业务能够接触供应商锁定的软件。
3）	能够很容易安装并使用起来的软件。

对于面向开发者用户而言的基础技术类软件或者插件而言，应该能够快速上手进行开发的。对于应用级软件的开源，应该做到即使让非技术人员也能很容易使用和操作的。降低开源软件的使用门槛，会让那些试图通过开源获得更多用户或者开发者关注的企业来更容易获得关注度。

另外近年来一些实践还表明，另外两种类型的边界决策 ：
1）对于一些关键功能或者技术的实现方法本来就是属于公共知识的而闭源软件实际也不会给企业带来多大竞争优势的是完全可以考虑开源的。

2）能够帮助企业获得市场杠杆效应的软件功能。许多已经成功的开源公司采用的一个关键经验法则是将可以帮助用户快速有效地构建关键技术等以执行日常工作的功能放在开源中。开源的使用方因为对这些日常功能的经常使用后产生额外的需求，就可以帮助开源企业提取附加价值的功能（如安全性、治理和高可用性）会进入商业收费框架内。

我们以Gitlab对于开源边界决策的案例来分析一下。

GItlab采取的是开放核心(Open Core)模式。但在考虑什么时候货币化开源项目的时候。 Gitlab考虑的不是什么时候，而是该考虑哪些功开源。在开源的货币化问题上，关注的是预算控制者所关注的那些能，而不是哪些下载开源的个人所关注的功能。虽然开源的适用性要求更多的是来自个人，他们因为自身的需要来下载这些开源软件解决自己工作或者业务中的问题，但企业中控制预算并能花钱购买的往往是他们的部门主管或者高级管理层。 所以，Gitlab就因此设计了一个免费层和两个付费层的货币化模式。第一层是免费的，另外两个收费层则是Premium和ultimate模式，收费层是面向部门主管和总监级的，相比而言，他们会更多关注的是自己的项目是否在有效的控制和管理之内，所以他们不大会关注行业趋势或者能省多少钱，他们更多关注的是稳定性，扩展性和控制性，同时不要让自己的项目和管理陷入到各种麻烦中就是他们很直接的诉求。 而对于公司的高级管理层，他们会关注企业级层面的动态掌握如项目统计分析和仪表盘管理等功能。 这样在Gitlab的货币化模型中，就把有付费能力的购买者所关注的功能放在付费层里，把没有付费能力的使用者的关注功能放在免费层里。 并把这称作购买者基准的开放核心(Buyer based Open Core)模式。

而Gitlab一旦把某项功能放在开放核心中免费提供，他们的策略就是让它始终保留在那里， Gitlab认为对这个功能在之后做的其他任何不当处理，有可能会被社区当成是诱饵或者陷进而惹恼社区，由此引发社区的溃败。GitLab的CEOSid建议就是要从项目初期开始，考虑规划好哪些功能将永远是免费的，哪些功能将是付费级的，并和社区参与者沟通清楚这样的计划。甚至可以对于一些还没开发完成或者还并不存在的设置付费条件和标准而根本无需担心给社区会带去影响。 因为在这里更加重要的关键是要让你的开源公司在哪里划清开源的界限，更在于他们对于既定的开源要始终如一地、保持透明地这样做。

从Gitlab的业务实践总结出了开源软件一定要给用户提供有实际使用价值的功能，而非一些无实际使用价值表面功能。他们认为只有这样才能获得开发人员的喜欢并可以围绕社区团结起来，并有机会创造出一批狂热的用户。所以，千万不要让开源成为客户的诱饵，更不能让用户产生开源是诱饵的感觉。一旦开发人员-最终用户社区围绕开源的使用价值而蓬勃发展，那么开源公司就能安心的对那些可以吸引预算持有者的高级功能进行收费。毕竟，管理者永远不想拿走开发人员喜欢的开源工具，他们更多考虑的是进行一些管理控制在这点上。

Gitlab在过去几年付费客户群的不断扩大和收入的快速增长，并21年成功登陆纳斯达克受到资本市场热捧。这一事实，也验证了他们的开源边界策略的有效性。
二、问题与挑战
相比全球的开源市场而言，如我们前面所言，国内依然是一个刚起步并很不成熟的开源市场，盲目而冲动下的开源是不可取的。企业在开源边界决策过程中，如果希望建立一个拥抱开源但对于企业是稳妥的策略，那么“安全，保护，营销，共研”的四大原则是可以参考的。即：在确保企业经营安全和保护自己核心竞争优势不受入侵的前提下，使用开源来社会化研发和和使用开源扩大用户基础下的营销策略。如果不能实现以上四点，那么开源也未必是一个好的选择。


而2022年，开源世界的人们也似乎置身一片火海。如在Nginx 对俄罗斯的制裁中，我们看到了政治局势对于开源的渗透；乌克兰战争声援中对于开源的武器化使用中，我们看到了意识型态对于开源的挟持等等。凡此种种，不一而足。除了听到人们的惊呼：开源怎么了？开源世界里商业化所面临的冲突与秩序，自由和规制。

开源下被忽略的公共属性
是的，依然会有一些乌托邦的理想主义者坚守在那片想象中的热土上。但也正是我们自己的每个选择让现实如飓风般呼啸而来，一切美好的愿望都随之被卷入无情的漩涡，终将把开源带到一个也许连我们都未知的地方。其中一些可能会让我们无比失望，也会有一些让人欢欣鼓舞。历史也总是这样上演。
正是因为不管尽头在何处，我们也许才更需要了解那些背后的真实：是什么在决定着开源的改变？而这些改变又将如何决定着开源的未来？其实，开源软件作为公共资源，除了作前面提到的公开的代码属性之外，实际上还有另外两个隐藏的而可能被我们忽略的更为重要的公共属性：

	公开代码所包含的开放和共享的思想及知识经验
	公开代码所提供的公共和平等的创新及竞争机会
	
与因特网现象类似，开源同样如莱斯格所说的。它与文化和代码的特性密不可分。它的出现是因为文化和代码特性，而今的那些改变背后的原因也正是因为文化和代码特性。 

直接原因一：开源文化价值观-反 “公地悲剧”
对传统公共资源的保护目标一般是为了防止公共资源的过度使用而免于 Hardin提及的 “公地悲剧”的发生。但开源，由于代码的零成本可复制性，它实际上是一个反公地模型，即最初的黑客精英们关注的是软件代码自由，倡导的是将软件代码无限扩大使用共享和提供更多公共平等的创新机会。所以，开源文化价值观中对于软件代码作为公共资源的保护实际上不是限制使用，而是在努力防止代码的使用受限制以避免“开源悲剧”的发生。 

直接原因二：代码特性下的开源生产者经济激励问题
开源，本质上是在财产私有制下，开源生产者以私有的生产要素来向社会提供具有公共资源属性的软件代码。那么，开源生产者出于自身的经济学模型构建和经济激励问题需要，必然会产生对于代码权利再分配的冲动。

所以，正是基于这两个直接原因导致了今天的开源世界中不地发生着矛盾和冲突，并最终反映在以下几个争议上：
1）代码使用的受限和不受限之间
2）代码分发时义务的强制性与非强制性之间
3）开源生产者经济激励设定的控制和非控制之间

虽然争议的具体表现形式各异，但冲突之后利益平衡构建的一般特征基本就可以概括在下面这个表内：
     类别	代码的使用	生产者激励
	使用权利	分发义务	经济
自由软件	不受限使用	强制性“传染”	不控制
OSI标准	不受限使用	局部	不控制
社区开源	局部受限使用	局部或自定义	部分控制
商业闭源	受限使用	自定义	完全控制

而这些争端的最终都指向开源软件中被我们忽略的那两个公共属性问题上：即通过利益再平衡，来重新设置公共代码下思想和知识的开放共享程度以及公共和平等创新机会的供给程度，并因此达到各自的经济和政治等方面的诉求。
即使在某个阶段这些冲突会通过各类博弈而得到缓解或平衡，但只要外部条件一发生变化，平衡就会随即被打破，利益格局也就将被再次重建。

开源世界的规制体系
开源作为一种社会形态，它从出生到现在，不过三十年，人类历史长河中的一瞬间而已，它的进化程度也还是在很初级阶段，所以我们需要理性看待当下发生的各类开源乱象，需要重视，但无需恐惧。它在冲突中秩序和规则的重建，也无疑遵循着人类社会活动的一般规律。

罗伯特•C•埃里克森（Robert C. Ellickson）在《无需法律的秩序 (相邻者如何解决纠纷)》中对于此类社会活动的逻辑和控制体系有着全面的论述，如他所言，“在这个世界偏僻角落里发生的事情可能是社会中心的问题。”他是通过在加州一个偏僻小县夏斯塔县里牧人们在解决牧区农场中日常争端现象的研究，揭示了一个密切群体中的相邻方中解决问题的方法，人们往往依赖于社会生活中通过长期博弈形成的规范而非法律来解决自己的争端。在此基础上结合博弈论、经济学和社会学，更好的发现了人类社会治理控制体系的框架。

数字化时代下的开源，程序员们可能分布世界不同的角落，但通过互联网以 GitHub，网络论坛和社交媒体等形式事实上地紧密联系在一起构成了密切群体中相邻方，在开源社区所发生的一切似乎也完印证了埃里克森发现的社会控制体系理论。

如果按照他的理论框架来解释开源世界的规范和秩序的话，那么当下开源社区实际是由五种控制者构成，即第一方控制者，第二方控制者和三种第三方控制者。

	开源的贡献方对自我实施规则和管理，这是在行使第一方控制
	开源项目的拥有方对使用方强制执行的开源许可或者对贡献者执行的贡献者协议，这是在行使第二方控制
	而开源社区的第三方控制者则可以是一般社区力量，或者是非政府性质的社会组织（如开源基金会或者协会），当然也可以是国家或者政府。

由社区第一方控制者发布执行的规则为伦理，由第二方控制者发布执行的叫合约或许可，由第三方控制者社区力量发布执行的叫规范，由社会组织发布的称为组织规则，由政府发布的就叫法律。

同时，这五类控制者在开源社区提供了各自的行为准则，并实施了具体的管理行为，可以分别称为：自我管理，个人自助，替代自助，组织执行以及政府执法。这样开源项目的贡献方，开源项目的拥有方，开源社区力量，基金会或者OSI等行业非政府组织以及政府最终相互结合起来，形成了对于整个开源世界的运作和治理控制体系及至关重要的奖惩执行。而这个控制体系可以用下面的简表予以示意说明：

控制者	规则	奖惩管理	结合体系
1	第一方控制行动者	开源贡献方	个人伦理	自我约束	自我控制
2	第二方控制
合约行动者	开源项目拥有方	合约	个人自助	开源许可/贡献者协议
3	第三方控制
	社会力量	开源社区力量	规范	替代自助	非正式控制（如社区谴责）
	非政府组织	基金会/行业组织,如ASF	组织规则	组织执法	组织控制
	政府	法律	国家执法	法律控制

证明开源许可协议的存在，只要发布就行。但要证明开源社区规范的存在，其实并不仅仅是发布就行，而只有在对于违反社区规范的人予以恒常处罚才能证明社区规范的存在。所以，如果社区中有一方违反了规范，却完全由没有对于这种违反的强制行动，那就证明了规范的无效。对于基金会组织规则的有效性亦是同理类推。

开源是人类的一次社会活动实践
在了解到 Ellickson 对于人类社会的控制体系的思想应用于开源的各类社会实践之后，我们完全可以对本文开始描述的各类现象产生以及走向足够理解和释然。
比如说对于 Marak 删库行为就可以这样理解：开源贡献者作为第一方控制者在个人伦理上的自我约束失败，使得第三方控制者开源社区力量以社区谴责的非正式控制进行了一次替代自助执行。又比如说 Elasticsearch 修改协议的行为可以这样来解释：Elasticsearch 开源项目拥有方修改了开源许可而违反了 OSI 组织规则结果导致第三方控制者 OSI 采取了组织执法宣布对其开源许可协议的不予认可。 以此，我们似乎也完全有理由可以预言说，
开源，正在发生的事情，可能就是人类历史中一类社会活动的再一次重现。

关于开源社区参与方在这些规则体系的相互作用下产生的冲突和博弈，以及在这些情况下的最终结果指向，我们未必一定知道在哪里。但我们基于 Ellickson 的原则所采取的行动就可以成为影响未来的一部分。如果结果可以预测的话，那么有一个预测是可能的：
开源的未来不一定是由谁的批评声音最大，或者谁获得了最大经济激励来决定的。开源的未来也不是由通过哪一种类型的开源存在而证明的，更会以那些与现实最终不相容的事物永久的消亡而来证明的。

更进一步而言，开源规制的设计原则，从根本上说是为了解决两个问题：
1. 如何将开源这个社会公共资源价值最大化
鉴于开源代码的零成本复制属性，我们已经无需顾虑代码的过度使用，“如何最大限度地扩大使用” 才是让我们设计开源规制的原则。由斯托曼倡议的GPL协议无疑做到了有利于代码最大程度上的开放和最低损耗系数下的传递。
2. 如何以最佳方式激励开源的生产者持续贡献
这就是开源的生产激励问题。开源促进会（OSI）定义的十条标准对于保持开源纯粹性的确有利，但另一方面却对开源生产者持续贡献的激励性显然不足够。所以这也就导致了如 MongoDB、Elastic 社区宁愿弃OSI标准而不顾，转而制定自己的社区开源协议来重置开源权力的根本性原因。
就开源的演化进程而言，我们现在正经历着的的事实，已经足以证明了埃里克森的社会控制体系理论的描述，因为开源也的确经过了这几个阶段：
第一阶段：技术精英和理想主义者在意识觉醒下的道德追求和伦理；
第二阶段：开源的贡献方和使用方在契约精神下的合同责任履行；
第三阶段：社区和行业自治组织在群体交互下的规范及规则约束；
如果 Ellickson 的社会控制体系理论是继续客观的话，那么理论所推演的将是：
第四阶段：政府或者国家对开源的法律的强制力。
即使我不是一个权力中心主义者，也可能无法清晰预见到开源的将来。但无论是按照埃里克森的社会控制体系理论，还是以开源的公共资源品的社会共享性特征，如同互联网规制主义的支持者 劳伦斯•莱斯格（Lawrence Lessig）在他的《代码2.0-网络空间中的法律》里所论述并相信的对于互联网的政府规制是必要的那样，对于开源必要的政府规制自然也将是不可避免地。而关于这一点，即使现在没有发生，将来的某一天也是会发生的。
Lessig 在《思想的未来》一书中还曾引用了美国首任专利局长托马斯•杰斐逊(Thomas Jefferson) 在1813年谈到专利权的特点时说过的一句话：
他从我这里得到一个构想，我自己的并不因此减少，正如他从我这里对火，点燃了他的蜡烛，照亮他自己的同时也不会使我陷入黑暗一样。
他叙述的“构想”是一种非竞争性的资源，托马斯其实也不是在反对专利保护，他只是在驳斥专利保护是一种自然的观点。同样，开源代码因为代码资源的非竞争性，那么控制体系所需要的唯一任务是确保资源的再生产，这是一个供应的问题。在那儿既然自然不保护，那么设计一种可能的控制方式来保证人们有足够的动力来生产和提供这些资源是必要的。
事实上，类似这种规制在扩大开源使用和促进开源供应方面，是有利于开源更好发展的。当然，这最后的影响取决于政策制定者们的远见和智慧。如 Ellickson 在他的书中所描述的，不管怎样地规制，也不一定是规制越多，就越有秩序。它的原则不是越多越好，而是只有真正符合社会和人们实际需求的规制才是最终胜出的理由。 
。 
中国的开源先驱陆首群教授在其最近发布的《开源创新：数字化转型与智能化重构》一书中记录了一段Apache创始人Brian Behlendorf在2007年第二届“开源中国，开源世界”高峰论坛上所作的《你可能不知道的关于开源的八件事》的报告摘要，在其报告摘要中的第六点提到了Brian对于开源和商业的观点，他是这样认为的：开源需要利他主义和获利主义结合在一起，才能使人们更好地为开源做贡献。陆老对于Brian观点是这样解读的，“没有商业模式的开源社区的前期开发和具有商业模式的开源软件发布商的后续开发结合在一起，才有可能为开源做贡献。”从这些记录中可以看出，无论Apache的创始人，还是中国的开源先驱，他们有一个共同的共识，陆老在书中是如此来表述的：开源是利他主义（Altruism）或者说是共产主义（communism）,专有软件或私有软件是利己主义（Egoism）或者说是资本主义（Captialism）,而开源的商业模式也是利己主义的。但利他主义的开源与利己主义的商业模式结合在一起才能为开源做贡献。开源既包含共产主义因素也包含资本主义因素，既是商业的又是公益的或个人爱好的，而且还是学术的。



--------------------------------

本章基本方向：


1）开源商业模式汇总

2）开源投融资案例汇总

3）开源创业风向标

4）值得关注的开源新星企业

相较往年，今年更新的重点：强化商业描述

1. 开源商业化模式和成功案例
2. 开源基金
3. 历年成功的标志性项目
4. 目前在孵化的开源项目列表
5. 推动商业化机构（apache基金会，原子基金会，CCF开源........，开源社，长风联盟，上海开源协会等）
