# 第四章 开源行业发展现状

## 开源在重点行业的应用

### 开源在金融行业的应用

> 作者：
> 
> 罗文江，招商银行资深云计算架构师、开放原子开源基金会TOC成员
> 
> 刘建珍，中国农业银行研发中心高级专员

一、2022-2023 年金融行业开源发展现状

1.金融行业积极布局开源发展，陆续出台多项政策，提供金融业开源治理和生态建设基本遵循

2021 年 10 月，人民银行办公厅、中央网信办秘书局、工业 和信息化部办公厅、银保监会办公厅、证监会办公厅联合发布《关 于规范金融业开源技术应用与发展的意见》(以下简称《意见》)。 整体从金融机构使用开源、自发开源、开源生态构建、构建标准和法律体系等4个方面提出了指导意见，并鼓励“金融机构将开源技术应用作为提高核心技术自主可控能力的重要手段”、鼓励“金融机构积极参与开源生态建设”和“开展开源项目合作，实现优势互补、互利共赢、共同发展”。同年人行发布的《金融科技发展规划（2022-2025）》提出了要在开源生态方面“依法合规参与数字技术开源社区等创新联合体”。行业相关政策陆续出台，规范和鼓励了金融机构安全合规应用开源技术，促进了金融行业开源生态培育和发展，推动了金融机构的数字化转型。

2.开源技术已渗透金融全场景，机遇与挑战并存

金融行业在强化技术掌控和提质增效的双重压力下，越来越多地选择开源技术产品作为其基础技术架构组成部分。金融行业通过开源技术支持企业核心技术框架，既能保证接轨国际主流技术，又能确保以深度参与的方式完成金融信息建设，实现从“可用”到“好用”的转变。根据北京金融科技产业联盟调研报告显示，90%的金融机构已官方应用和试用开源软件。开源技术已成为金融服务的重要技术支撑。据金融行业开源技术应用社区的“2022金融行业开源技术应用调查”显示，47.06%的金融机构开源架构资产库系统使用开源组件和软件的清单列表数量在1000至10000之间，35.29%的金融机构开源架构资产库系统使用开源组件和软件的清单列表数量小于1000，另有11.76%的金融机构使用开源组件和软件的清单列表数量在1万至10万之间，5.88%的公司开源架构资产库系统使用开源组件和软件的清单列表数量在10万以上。

以农业银行为例，农业银行已规范使用超过2万多个，7000多种开源软件，涉及30多种开源许可证，有力支撑了本行的金融科技创新，例如，基于Spring Boot框架建设了综合应用平台，提供完善的基础架构降低开发技术难度，让研发人员能够专注业务，快速开发出复杂的业务功能；基于Nginx建设了综合网管平台，为应用系统提供多样的软负载均衡能力，支持TCP/HTTP/HTTPS等多种协议。基于Hudi、Alluxion、Flink、Atlas等6项开源技术，创新融合存算分离、流批一体、湖仓一体多元技术，探索构建了存储云+计算云+工具云的大数据新型技术架构，验证了大数据新型技术栈在金融场景的可行性，为金融同业提供了可借鉴的示范案例。

开源技术为金融机构带来科技创新、业务赋能等积极成效的同时，也带来了包括技术风险、法律风险、供应链风险在内的诸多挑战。日益增多的开源安全漏洞、恶意软件植入、开源许可证冲突、关键组件瓶颈等，已成为金融企业广泛运用开源技术亟待解决的问题。

3.政策环境推动金融行业开源进入良性循环，促进了金融行业开源生态的培育和发展，为金融业推进安全合规应用、开源生态建设与开源治理提供了基本遵循

2022年1月国务院印发的《“十四五”数字经济发展规划》提出“支持具有 自主核心技术的开源社区、开源平台、开源项目发展，推动创新 资源共建共享，促进创新模式开放化演进”“鼓励开源社区、开 发者平台等新型协作平台发展，培育大中小企业和社会开发者开 放协作的数字产业创新生态，带动创新型企业快速壮大”;2021年11月工业 和信息化部发布《“十四五”软件和信息技术服务业发展规划》， 系统布局“十四五”开源生态发展，将“繁荣国内开源生态”作 为主要任务之一，从开源基金会、开源文化、开源基础设施、开源项目、开源人才等多个方面提出了发展要求。随着系列国家政 策的出台，开源已经成为重构软件产业生态的国家战略，社会各行各业紧跟规划，加快开源工作部署。“

4.金融行业开源技术应用覆盖领域广泛，头部企业逐步开展开源治理和对外开源

在开源治理方面，超70%的金融机构具有开源相关治理流程，其中41.18%的企业有多个开源相关治理流程，29.41%的企业有1个开源治理流程。另有29.41%的企业尚无开源治理相关流程。70.59%的公司无单独开源管理团队，17.65%的公司拥有单独开源管理团队，其中1人专职，5-10人兼职；11.76%的公司具备2-3人专职，10-20人兼职的单独开源管理团队。

在内部开源方面，64.71%的金融机构实施了企业或集团内部开源，35.29%的企业还未实施。缺乏专门的开源管理团队和企业级的开源文化认同以及安全、商务、法律因素是内部开源的最大阻力。

在对外开源和合作方面，以微众银行、网商银行、蚂蚁金服为代表的互联网银行主动拥抱开源技术，积极也参与开源社区，同时，反哺社区，通过将内部孵化的产品进行开源，捐赠给开源社区，2022年蚂蚁开源可信隐私计算开源框架“隐语”、高性能图数据库TuGraph单机版、SOFAStack 云原生项目。微众银行在人工智能、区块链、云计算、大数据等多个领域开源33个项目。

工商银行、 中国银行、招商银行、浦发银行、浙商银行等参与区块链跨链陆羽开源项目;工商银行等与科技企业合作开展 MySQL 数据库金融分支版本项目;招商银行参与KubeVela和对外开源EasyBaas项目；光大银行与趣链科技合作开展区块链 BaaS 平台 跨链子平台项目。

5.金融行业对外开展开源标准、 制度建设，护航金融业参与开源生态行稳致远

在行业标准方面，《金融业开源软件应用管理指南》《金融信息系统开源软件应用 评估规范》《金融业开源技术 术语》为进一步规范金融 机构开源软件的资产管理提供了宝贵的经验。《金融行业开源软件评测规范》、《金融行业开源软件服务商评测 规范》为银行机构评估和选择合适的开源软件及服务商提供参考依据，保障银行业开源软件的应用安全，促使开源软件服务商 提升企业竞争。《金融技术产品开源项目管理指南》 保障金融技术产品开源管理流程的规范性和可行性，促进金融机构合法合规、拥抱开源。

二、金融行业开源发展的问题与挑战

金融行业开源要得到长足发展，必然面临开源领域普遍会遇到的开源许可证合规风险、供应链风险、代码安全风险、自主创新风险和运维服务支持风险，各家金融机构也面临自身IT转型过程中的开源发展问题与挑战。

1.开源许可证合规风险高

许可证合规性是金融机构引入、使用、治理开源软件面临的首要问题。同时，也需要保护金融机构自身的知识产权免遭传染性许可证侵害。目前，国际公认的开源许可证91种，主流使用的许可证也有9种（截至2020年12月19日，OSI），其中大多采用英文编写，只有木兰许可证采用中文编写。金融机构需要有具备熟悉许可证特性与要求的法律法规团队支持，并建设在开源软件全生命周期内动态管理、定期扫描，发挥监控、评估等能力。

2.缺少运维支持服务风险

开源软件相较闭源商业软件缺少完善的运维保障支持。对开源软件应用中出现的安全漏洞、隐私风险，金融机构需要自行分析解决。此外，金融机构对开源软件二次开发的代码，因其针对金融特定场景不具有通用性，在开源软件进行大版本升级后，金融机构仍需要重复开发、测试、上线。

3.开源商业模式运营公司的不可持续服务风险

开源软件独特的商业运营模式，使成功的开源软件几乎都由成熟商业组织推动，在无法为其商业模式带来流量、关注度等回报，或开源软件的存在对其盈利造成影响时，开源软件将面临人员投入、资金支持、代码贡献调整的风险。

4.缺少统一安全管理风险

金融行业普遍应用了成千上万的开源软件，开源软件之间的依赖关系趋于复杂，管理成本较高。开源软件间安全漏洞、后门风险的连锁传播，须进行有效漏洞管理。

5.对外参予和对外开源程度不足

金融机构整体上在开源产业生态链中贡献度较低。传统银行科技团队面的挑战更多，对外开源的内部流程更复杂、孵化时间更长。

三、金融行业开源发展前景与趋势

1.和开源供给侧合作更加紧密

金融行业开源已广泛应用，开源软件方面的专业服务需求日益旺盛，和开源商业公司、开源技术服务公司、开源软件安全服务公司、开源治理咨询公司的合作将更加紧密。

四、金融行业开源发展建议

1.金融机构应合理制定开源规划

金融机构应在IT顶层规划设计，加强开源软件使用、开源治理、开源人才队伍建设方面的规划，实现开源核心技术的自主可控。

2.金融机构应加强开源安全管理

金融机构应加强开源风险意识，提升开源工作认知度和参与度，建立统一安全管理机制，破除开源引入障碍，规范开源全生命周期管理，推动适合开源的组织架构调整，指导金融机构建立开源办公室，配备相应的开源法律合规团队，彻实掌握开源使用规模、复杂度，对已存在的安全漏洞、许可证合规风险主动防控处理。

3.金融机构应积极参与开源生态建设，加强开源社区互动

金融机构应走出以使用为主的单方模式，在贡献开源、主动开源、开源慈善捐赠等方面主动投入和布局，加强与协会、联盟、基金会等社会组织合作和开源社区互动，推动开源供给侧参与金融开源工作，积极参加编制开源标准，促进金融行业开源生态可持续健康发展。

### 开源在汽车行业的应用

> 作者：滕召智，OpenSDV汽车软件开源联盟生态负责人

2022-2023 全球汽车软件开源生态

一、年度洞察
整体汽车软件技术方向现状洞察
年度重要事件
年度数据 ( 引用报告)
汽车行业OSPO建设情况
发展特点以及趋势


二、问题、机遇与挑战
开源合规与供应链安全
开源贡献参与度与生态建设
亟需解决的基础技术问题
基础设施的挑战
新技术探索

三、发展建议
芯片、EE架构与操作系统
主要问题的解决思路及建议

### 开源在工业互联网的应用

> 作者：郑伟波，浪潮国际CTO、开放原子基金会TOC副主席

一、2022-2023 年工业互联网开源发展现状

工业互联网自2017年上升为国家战略以来，在政策与市场双轮驱动下，呈现快速发展态势，国家级双跨平台从最初的10家已经发展到29家，面向行业和专业领域的工业互联网平台更是达到几百家，体系架构也从1.0进化到2.0，功能视图体系架构如下：

![](https://img-blog.csdnimg.cn/3d95b467bb0f4997b400b60420d57795.png#pic_center)

图：工业互联网功能视图平台体系框架

工业互联网高速发展，部分功劳应归功于开源软硬件的助力。目前，工业互联网通用技术领域开源项目较多、成熟度相对高，但不可忽视的是，深入到OT层、传统制造领域，开源项目相对少、成熟度也较低，且核心开源项目以国外为主。推动开源开放技术体系，对加快我国工业互联网发展具有重大意义。近年来，我国也涌现了一批优秀的工业互联网开源项目，整体呈增长态势。

1.工业互联网边缘侧碎片化程度高，开源技术发展空间广阔

工业互联网边缘侧主要是通过物联网技术实现工业设备数据接入能力、协议解析与数据预处理，整个服务市场呈现碎片化的形态，为开源技术提供了更广阔的发展空间。从通信网络、连接协议到物联软件、时序数据库，都存在大量优秀开源项目，我国开源项目表现也相当亮眼。

在网络方面，5G开源项目较多，包括Open5Gs、Free5GC和Magma等，NB-IoT、LoRa、ZigBee等相对少。在连接协议方面，MQTT、CoAP、OPC UA、AMQP、XMPP、DDS等都是开源协议，基于标准协议的开源项目也较多，其中，中国的开源物联网 MQTT 服务器EMQX的全球下载量已超千万。工业协议方面，由于传统工业厂家的市场格局和商业利益，大多数工业协议都是封闭化设计，较少开源。在物联软件方面，从组件到整个平台软件都有典型开源项目，包括消息队列Kafka、Pulsar，规则引擎Node-RED、EMQ X IoT Rule Engine，开源物联网平台ThingsBoard、IOT DC3、Kaa等。此外，为了物联网边缘计算构建通用开放框架，2017年6月，Linux基金会主持成立开源边缘计算框架EdgeX Foundry，提供开源微服务的集合，用于统一工业互联网边缘计算解决方案的生态系统。在时序数据库方面，近几年一直处于高速发展阶段，开源项目更是层出不穷，权威排名DB-Engines TimeSeries热度前五中，包括第一名InfluxDB在内的4个都是开源项目，国内的开源时序数据库TDengine、Apache IoT DB排名也比较靠前。

2.开源生态极大推动了云资源管理领域主流技术的更新迭代与快速应用

以微服务、容器化为代表的云原生技术架构被认为是工业互联网云资源管理的最佳选择。相较于传统的虚拟化技术，基于容器和Kubernetes的云原生解决方案在简化应用部署、重组微服务能力、建立云边一体化资源调度等方面具有敏捷、灵活、高效率的技术优势。

纵观过去几年云原生技术的发展历程，开源为云原生技术带来了前所未有的发展浪潮，极大的加速了云原生在全球范围内快速应用。2015 年云原生基金会 CNCF 成立，为云原生在全行业广泛应用奠定了基础，拥有上百个全球开源项目。云原生开源项目从早期开源的容器引擎项目 Docker出发，不断扩展应用领域，对边缘、异构等各类场景的适配能力不断深入，包括Google开源的容器编排引擎Kubernetes，已经成为了容器编排领域的事实标准；开源的监控告警系统Prometheus，已经成为了云原生监控领域的事实标准；开源的服务网格框架Istio，提供了流量管理、安全、可观察性等功能，已经成为了服务网格领域的事实标准。
全球云计算厂商都在积极布局云原生开源项目，国内也涌现出大量的优质开源项目，包括腾讯开源的微服务框架TARS、阿里开源的容器镜像仓库项目Harbor 已经从 CNCF毕业。可以看出，开源社区是云原生技术的创新根据地，是加速云原生与行业融合、推动各行业创新的助推器。

3.工业应用开发环境逐渐转向低代码模式，开源项目正在兴起

工业互联网的价值在于重构工业知识创造、扩散、复用新体系。工业知识往往掌握在专业技术人员手中，低代码、零代码的工业应用开发环境为这些技术人员提供一个标准化、易用的编程环境，通过统一的编程语言，实现流程、逻辑、经验、算法、规律等工业知识的快速封装，已经成为填补技术人员的开发技能的有效工具。

目前，国内低代码、零代码创业型公司和产品众多，开源项目较少，正处于兴起阶段。百度开源了amis前端框架，阿里巴巴开源低代码引擎LowCodeEngine。浪潮开源低代码内核UBML，并发布了具有完整企业级应用能力的海岳低代码平台inBuilder社区版。虽然国内低代码平台目前取得了很多不错的成果，在低代码平台开发类型上对OT类应用仍支撑不足，期待开源社区带动在这方面的持续深化发展。

4.工业数据管理领域以开源为主导，多种技术和架构并存

工业数据管理与服务通过大数据技术提供面向海量工业数据提供数据治理、数据共享、数据可视化等服务，是工业互联网发挥工业大数据价值的重要一环。大数据技术与开源之间有着密不可分的关系，目前市场上应用最广泛的大数据技术栈还是以开源大数据框架Hadoop与开源通用内存并行计算框架Spark为核心的生态系统。

近年来，以Hadoop为核心的开源大数据体系，逐渐向多元化技术并行发展。一方面，原有Hadoop体系的产品迭代趋于稳定，一些常见的开源组合，比如 Flink+Kafka、Spark+HDFS 等，经过开源生态市场的检验，已经成为相对固定的标准化选择。另一方面，大数据技术生态也在向流处理、数据可视化、交互式分析等方面探索，例如，近几年流行的开源大数据可视化工具 Apache Superse。随着云原生的发展，与云原生结合更紧密的 Airbyte、Flink CDC、 SeaTunnel、 InLong 等项目也得到了飞速发展。《2022开源大数据热力报告》显示，云原生数据集成在 2018 年超越了传统数据集成。

5.工业数字化工具成熟开源项目少，主要集中在欧美发达国家

工业数字化工具融合数字建模、数字仿真、数字孪生等技术，提供产品、设备、工艺和系统的三维设计、仿真、展现、优化等，是工业自主可控的关键，是工业互联网的重要工具，其中，几何内核、约束求解器、3D引擎是工业数字化工具核心技术，属于高技术含量、高研发投入、高应用门槛产业，成熟技术高度集中在欧美发达国家。

目前全球市场上只有少数内核厂商，其中，CGM、ACIS、Parasolid、Granite属于第一梯队，分别属于法国达索（前两个）、德国西门子、美国PTC，这些技术虽然闭源，但应用广泛；Open CASCADE（OCC）是目前世界上为数不多的开源几何内核，由法国Matra Datavision公司开发，基于OCC的CAD软件有FreeCAD、HeeksCAD、AnyCAD等。

在约束求解器方面，西门子的DCM是全球最成功的商用几何约束求解器，处于垄断地位，其他还包括达索的CGM、俄罗斯LEDAS的 LGS，知名度也较高。因此市面上的开源约束求解器也众多，但是大多数是限定于某些细分领域或来自于研究性项目，例如OpenFOAM、FEniCS、Elmer、Salome-Meca等。

在3D引擎方面，国内开源项目处于空缺状态，目前主流的引擎包括商业引擎Unity Technologies公司的Unity，和开源引擎Epic Games公司的UE、Analytical Graphics公司的Cesium、Mr.doob个人开发的Three.js等，其中，UE以逼真的渲染效果著称，在游戏开发中应用较多，工业领域也有一些项目在应用UE；Unity、Cesium、Three.js在工业领域应用较广泛。

6.国内积极探索工业模型开源开放，促进工业知识的沉淀、复用和迭代创新

工业互联网的核心资源是工业模型，即工业知识的模型化、标准化表达。工业模型的跨系统流转、交付、应用，极大的促进了工业知识的共享与发展。统一建模语言具有领域无关的通用模型描述能力，基于统一建模语言的方法能够实现复杂系统的不同领域子系统模型间的无缝集成。欧洲仿真协会EUROSIM于1996年推出多领域统一建模语言Modelica，经过多年发展，目前Modelica标准库已经包括了不同物理领域的1600多个模型组件，基于Modelica发展出来的商业软件、开源软件也非常多，Modelica模型可以在这些软件中自由流转。除了Modelica外，工业界大部分成熟的建模工具都建有自己的模型库，例如Simulink 建模工具在产业界、学术界被广泛应用，自带对象模型库、算法库、控制系统、环境模型、基础元器件模型库等，但这些模型并不是免费开放的。国内工业互联网发展始终提倡加速工业知识的沉淀、复用和迭代创新，其中，同元软控通过打造工业知识模型互联平台MoHub，构建了一个覆盖函数库、模型库、APP库服务的模型社区，开发者以开源方式分享到社区的模型库，支持海量用户参与到工业知识模型的开发、分享、创新应用过程。

7.工业APP基于应用商店模式加快开源开放步伐

工业APP是基于工业互联网，承载工业知识和经验，满足特定需求的工业应用软件，本质是企业知识和技术诀窍的模型化、模块化、标准化和软件化。开发者社区是开发工业APP的主要推动力，平台和微服务框架降低了工业APP开发的难度和门槛，大量的开发者都可以参与开发工业APP。面向特定工业应用场景，激发全社会资源形成生态，推动工业技术、经验、知识和最佳实践的模型化、软件化和封装，形成海量工业APP。
应用商店是向企业用户提供的工业APP分发渠道，是促进工业APP应用生态繁荣发展的有力支撑。在应用商店模式下，来自不同制造商的工业APP可以跨平台运行，相互交互，具有一致的语义，按照共同的标准工作，并且对所有社区开发者开放。目前开发工业APP的核心技术主要由国外公司把控，国内整体开源产品较弱。开源可成为颠覆传统工业APP的重要武器，国内企业开始布局探索，开源意识逐渐增强，传统优势企业和创新性企业加快开源布局。在应用商店模式下形成开放的应用程序生态系统后，工业APP领域会向传统PC软件市场一样取得蓬勃发展。

8.开源工业软件成果丰富，国内积极探索破局之路

工业软件是工业互联网的核心力量，近年来均涌现了大量开源工业软件。在研发设计类软件方面，有开源免费的用于3D建模的FreeCAD、2D建模QCAD社区版以及基于QCAD的一个开源分支发布的LibreCAD等开源软件。目前开源CAD软件供个人使用表现的比较出色，但仍然无法在大型企业直接代替AutoCAD 的直接模拟。在工业设备中常见的生产控制类软件可编程逻辑控制器（PLC）方面，OpenPLC、Beremiz、Apache PLC4X等都是非常优秀的开源PLC软件。开源的ERP、CRM类业务管理软件数量也已形成规模化生态，如Odoo。我国工业软件在国家的大力扶持以及各类企业的不懈努力之下，发展步伐明显加快，但仍存在高端工业软件缺位、本土工业软件应用困难等问题。工业软件的破局之路艰难，开源不失为一种新的思路。2022年7月，开放原子全球开源峰会成立OpenAtom openCAX工作委员会，在开源领域布局了一批共性关键技术，联合构建OpenDACS开源EDA平台，聚集国内优势力量，共同探索工业软件发展新路径。

9.工业互联网开源社区整体发展良好，与实际产业联系仍需加强

目前工业互联网领域应用比较广泛的开源项目，其社区发展也比较活跃，如Eclipse IoT、Linux Foundation、OPC Foundation、FreeRTOS、Zephyr等。其中，Eclipse IoT提供了基于Eclipse的开源工具，包括开发工具、测试工具、运维工具等，这些工具都能够支持工业领域的物联网应用开发和测试。Eclipse IoT的社区正在快速成长，145+的创新组织都致力于加速采用由 Eclipse IoT 社区开发的商业级、生产就绪的开源技术。OPC Foundation推动了OPC UA协议的发展和普及，积极参与了各种工业物联网协议的制定，提高了标准的普适性和实用性。仅2019-2022年，OPC Foundation基金会成员就增加了150多名。截至目前，全球已有超过 920 家 OPC 基金会成员和数千个符合 OPC 标准的产品。

但是，许多其他工业互联网领域的开源项目，由于没有形成实际的产业应用，发展相对滞后，仍需要进一步改进与完善。如EdgeX Foundry项目，由于其与实际工业应用场景不够贴合，该项目会员数发展至今仍低于100，且在GitHub上仅三十多人贡献了代码仓库。

二、工业互联网开源发展的问题与挑战

工业互联网开源要得到长足发展，必然面临开源领域普遍会遇到的供应链风险、代码安全风险、知识产权风险、自主创新风险，同时，还要解决自身领域存在的开源发展问题与挑战。

1.平台层工具软件开源运营成本高、传统商业模式获利难

工业互联网平台发展迅速，国内头部厂商纷纷搭建了双跨平台，我们仔细研究这些平台，就会发现重要部件几乎都用到了开源软件。但平台型软件商业巨头，往往体量大，在市场竞争中处于优势地位，通过采用开源软件、工具搭建商业工业互联网解决方案，实现快速推广并获利，而这些开源软件、工具的创新型厂商由于体量小、整合能力有限，没有提前布局商业，再加之开源运营成本高、难以获利，往往给别人做了嫁衣，自身发展后劲不足，长此以往不利于工业互联网基础软件开源生态发展。

2.工业互联网技术门槛高，跨大量开源组件构建平台往往导致深度整合和优化不够

工业互联网融合OT、IT、CT等多个领域技术，实现深度整合和优化是一件非常复杂且困难的事情，开源项目在这方面存在非常多的市场机会，开源软件、工具可以免费获取源代码，对于有一定IT能力的企业来说，具有较好的经济效益。例如大部分软件厂商、工业企业往往会选择Kubernetes、Istio、Docker等快速搭建工业互联网平台。开源软件虽然使用简单、经济，但往往也面临着“免费即最贵”的尴尬局面，开源技术的大规模商用需要充分的评估与实践，需要技术团队同时掌握很多不同领域的开源组件，并且能融会贯通、知道如何将这些组件更好地组合到一起。但大部分中小软件厂商或传统企业没有足够的专业人才，缺少融合多个开源软件系统的一整套解决方案，往往面临因软件版本不统一的兼容问题、因参数配置不合适的性能问题、因缺少技术支持的运维优化困境，导致深度整合和优化不够。

3.工业互联网各子技术领域开源发展不均，缺乏核心工具的开源

工业互联网边缘层、PaaS层、应用层，由于各层功能与技术差异，其开源发展不均，国内更是少见核心工具的开源。边缘层主要提供协议解析、工业数据接入及预处理等能力，国内外开源项目较多，如设备网关接入方面有NEURON、MQTT、ThingsBoard、EMQX等开源项目，但受制于工业协议的多样性，多数开源项目都无法做到协议适配的通用性。PaaS层主要提供工业数字化工具、工业数据管理服务、工业模型管理服务等工具及通用能力，因商业用途及专业工具的技术门槛高，厂商往往选择封闭发展，构建技术壁垒，核心开源项目较少，尤其三维设计、仿真优化。不过，近几年随着Open CASCADE等开源数字化工具的出现，逐渐打破了AutoCAD等主流封闭软件的垄断局面。应用层方面，传统研发设计类软件、生产控制类软件、业务管理类软件和工业数据软件中，均涌现出了大量开源软件，如开源ERP Odoo、Apache基金会旗下的Apache OFBiz项目，已经有了较大的应用生态。但从整体发展来看，工业设计类软件、工具仍需加强布局。

4.边缘侧工控系统、协议相对封闭，影响设备的互联互通

边缘侧工控设备（PLC、DCS等）以及工控协议经过20年间的发展，一方面激烈的市场竞争刺激了西门子、施耐德、欧姆龙等国际厂商产品快速迭代升级，另一方面也构筑了设备互联互通的壁垒，各家厂商所采用的PLC编程和通讯交互方式不尽相同，衍生出不同类型的通信协议，虽然极大的增强了自身向上层的数据传输能力，但这些协议大部分是采用封闭设计，彼此不兼容，用户无法扩展或自定义系统、协议以满足其特定需求。
目前边缘侧工控系统、协议的开源程度虽然不是很高，但还是有一些有影响力的开源项目，例如，OpenPLC是一个开源的可编程逻辑控制器，Open Industrial Linux是一个基于Linux的开源工业操作系统，还提供PLC、HMI工业自动化应用程序。

三、工业互联网开源发展前景与趋势

当前，开源已成为工业互联网领域的重要开发模式，工业互联网各技术领域越来越多的采用开源代码，自身的开源化趋势也越来越明显。工业互联网开源正在向垂直行业解决方案、海量工业APP、工业技术为主的OT层渗透。

1.工业互联网依托开源社区与生态发展垂直行业解决方案

我国石化、钢铁、电子信息、家电、机械、汽车、装备、航空航天等垂直行业广泛应用了工业互联网技术能力。各垂直行业的工业互联网实施业务场景相对独立、应用领域不尽相同，应用深度参差不齐，实施路径也存在差异，如何打造更多的垂直行业解决方案，将单独部署的工业互联网项目拓展和融合达到行业规模化，是工业互联网高速发展必须解决的问题。
开源社区可以使跨地区、跨领域的专业人才之间通过开放式的创新生态实现深度交互与智慧共享，让更多的人参与到垂直行业解决方案构建中，从而提高项目的数量和质量。面向垂直行业的工业模型、插件类开源项目将逐渐增多。

2.工业APP需求繁杂，低代码工具开源能够加速创新效率

工业APP涉及研发设计、生产制造、运维服务和经营管理等不同领域与环节，个性化强，对象众多，关系非常复杂，体系庞大且需求繁杂。低代码开发工具沉淀过去十几年策划、开发、应用工业APP的经验，参考工业产品制造模式形成一些典型模型和架构模式，提供低门槛应对复杂需求的开发方案。

低代码开发工具通过生态联盟，由多家企业专注其擅长的部分，彼此协同发展，可以不断积累工业APP模式，构建领先的产业集群。开源是建立这个生态联盟的有效方式，通过开放源代码，聚集各个行业工业APP的领先厂商，彼此打通、串联，共同推动沉淀工业软件、智慧城市、智能制造等领域的低代码模型，应对繁杂的工业APP需求，提供低门槛开发方案，加速工业互联网领域创新效率。

3.工业互联网技术开源由IT层迈向OT层

IT层主要涉及计算机、互联网、应用软件等，其软件系统相互连接，通常运行在iOS和Windows等流行的操作系统上，缺乏自主性，软件开发规范、使用标准解决方案以及流行的通信协议，应用场景广泛，因此开源项目较多。相比之下，OT层主要涉及机械、工控网络、工控系统以及跨工业协议的通信，系统一般是自治的、隔离的、自包含的，运行在专有软件上，与传统计算机编程不同，应用场景也涉及更多专业知识和技能，因此OT层开源项目一直发展缓慢。

随着IT与OT融合越来越深，OT层也开始寻求标准化的发展道路，IT与OT之间的界限正在被引入连接设备的OT系统和物联网的兴起所模糊，OT层的开源项目也会逐渐增多。

4.工业互联网通过开源社区培养专业人才

工业互联网领域开源项目蓬勃发展，开源软件的易获取性让众多高校学生、企业人才可以低成本的接受并使用开源软件，同时开源社区中汇聚了众多有着开源精神和探索精神的开源贡献者，开发者可以在社区中获取到软件源代码、与更多的业内优秀从业者进行协作、扩充个人技术图谱和技术栈等，因此开源社区也成为了工业互联网领域人才培养的重要基地。

高校是人才培养的重要来源，高校学生也可以通过开源社区开拓技术视野，锻炼协作能力。通过一系列的开源校园行活动可以有效推进开源文化、开源实践在高校的普及，促进高校开源人才培养、加强高校人才参与到企业开源实践，为工业互联网行业提供源源不断的人才供给。

四、工业互联网开源发展建议

1.鼓励龙头厂商积极参与工业互联网开源发展，布局重点领域的开源项目

工业互联网龙头厂商是产业技术创新的主要推动者，是产业高质量发展的重要依托。工业互联网龙头厂商应积极发挥产业创新过程中的融通引领作用，参与开放原子开源基金会组织的重点开源活动、开源项目，共同营造良好的工业开源文化氛围，开展产业开源顶层设计与总体规划布局，打造中国工业互联网顶级开源社区，组织引导产业链上下游企业围绕核心技术领域孵化CAX、PLC等优质工业互联网开源项目，加快形成我国工业互联网发展新优势。

2.开源社区倡导开源文化，激发工业领域的开源氛围

T层和OT层的开源空间都很广阔，但是由于两者的应用场景和技术需求不同，开源社区的重心和方向也有所不同。在IT层，由于其应用范围广泛，开源也更加活跃。比如，开放原子开源基金会、Linux、Docker、Kubernetes等受众广的基金会，以及Apache 基金会下的Apache Hadoop、Apache Spark项目等大型开源项目。而在OT层，出于优先保护商业利益，以及应用场景和技术需求相对专业等原因，导致整个领域的对开源的认识和开源氛围不足。

未来，工业互联网各方力量应积极利用开源社区的资源和平台，重点推动工业互联网领域OT层开源活动的普及和推广，为工业企业提供更好的开源解决方案和技术支持。其次，注重高校活动实践，开展校园行、组织开源软件开发比赛、提供技术讲座等活动，提高对开源文化的认知和参与度，进而推动整个领域的开源氛围。

### 开源在风洞等场景的应用

作者：李光杰，红山开源平台技术组负责人
