# 直播答疑第一期

### 答疑全程回放可以通过链接下载观看：https://pan.baidu.com/s/168ouju4MxN5XJEb-GU1iAw 提取码: 92mw

## PaddleDetection框架/API问题

#### Q1. warmup能详细讲解下吗？
A1. warmup是在训练初期学习率从0调整至预设学习率的过程，设置可以参考[源码](https://github.com/PaddlePaddle/PaddleDetection/blob/release/2.4/ppdet/optimizer.py#L156)，可以设置step数或epoch数

#### Q2. 如果类别不匹配 也能用pretrain weights吗？
A2. 可以，类别不匹配时，模型会自动不加载shape不匹配的权重，通常和类别数相关的权重位于head层

#### Q3. 请问nms_eta怎么用呀，源码上没有写的很清楚，API文档也没有细说
A3. 针对密集的场景，nms_eta会在每轮动态的调整nms阈值，避免过滤掉两个重叠程度很高但是属于不同物体的检测框，具体可以参考[源码](https://github.com/PaddlePaddle/Paddle/blob/develop/paddle/fluid/operators/detection/multiclass_nms_op.cc#L139)，默认为1，通常无需设置

#### Q4. 请问anchor_cluster.py中的--size 是模型的input size 还是 实际使用图片的size？
A4. 是实际推理时的图片尺寸，一般可以参考TestReader中的image_shape的设置。

#### Q5. 请问为什么预测的坐标会出现负的值？
A5. 模型算法中是有可能负值的情况，首先需要判断模型预测效果是否符合预期，如果正常可以考虑在后处理中增加clip的操作限制输出box在图像中；如果不正常，说明模型训练效果欠佳，需要进一步排查问题或调优

#### Q6. PaddleDetection 人脸检测blazeface模型，一键式预测时load_params没有参数文件，从哪里下载?
A6. blazeface的模型可以在[模型库](https://github.com/PaddlePaddle/PaddleDetection/tree/release/2.4/configs/face_detection#%E6%A8%A1%E5%9E%8B%E5%BA%93)中下载到，如果想部署需要参考[步骤](https://github.com/PaddlePaddle/PaddleDetection/blob/release/2.4/deploy/EXPORT_MODEL.md) 导出模型

## PP-YOLOE问题
#### Q1. 训练PP-YOLOE的时候，loss是越训练越高这种情况 是数据集的问题吗？
A1. 可以从以下几个方面排查

1. 数据: 首先确认数据集没问题，包括标注，类别等
2. 超参数：base_lr根据batch_size调整，遵守线性原则；warmup_iters根据总的epoch数进行调整
3. 预训练参数：可以加载官方提供的自在coco数据集上的预训练参数
4. 网络结构方面：分析下box的分布情况 适当调整dfl的参数

#### Q2. 检测模型选型问题：PicoDet、PP-YOLO系列如何选型
A2. PicoDet是针对移动端设备设计的模型，是针对arm，x86等低算力设备上设计；PP-YOLO是针对服务器端设计的模型，英伟达N卡，百度昆仑卡等。手机端，无gpu桌面端，优先PicoDet；有高算力设备，如N卡，优先PP-YOLO系列；对延时不敏感的场景，更注重高精度，优先PP-YOLO系列

#### Q3. ConvBNLayer中BN层的参数都不会使用L2Decay；PP-YOLOE-s的其它部分都会按照配置文件的设置使用0.0005的L2Decay。是这样吗
A3. PP-YOLOE的backbone和neck部分使用了ConvBNLayer，其中BN层不会使用L2Decay，其他部分使用全局设置的0.0005的L2Decay

#### Q4. PP-YOLOE的Conv的bias也不使用decay吗？
A4. PP-YOLOE的backbone和neck部分的Conv是没有bias参数的，head部分的Conv bias使用全局decay

#### Q5. 在测速时，为什么要用PaddleInference而不是直接加载模型测时间呢
A5. PaddleInference会将paddle导出的预测模型会前向算子做融合，从而实现速度优化，并且实际部署过程也是使用PaddleInference实现

#### Q6. PP-YOLOE系列在部署的时候，前后处理是不是一样的啊？
A6. PP-YOLO系列模型在部署时的前处理都是 decode-resize-nomalize-permute的流程，后处理方面PP-YOLOv2使用了Matrix NMS，PP-YOLOE使用的是普通的NMS算法

#### Q7. 针对小目标和类别不平衡的数据集，PP-YOLOE有什么调整策略吗
A7 针对小目标数据集，可以适当增大ppyoloe的输入尺寸，然后在模型中增加注意力机制，目前基于PP-YOLOE的小目标检测正在开发中；针对类别不平衡问题，可以从数据采样的角度处理，目前PP-YOLOE还没有专门针对类别不平衡问题的优化

## PP-Human问题
#### Q1. 请问pphuman用导出的模型18个点（不是官方17个点）去预测时，报错是问什么
A1. 这个问题是关键点模型输出点的数量与行为识别模型不一致导致的。如果希望用18点模型预测，除了关键点用18点模型以外，还需要自建18点的动作识别模型。

#### Q2. 为什么官方导出模型设置的window_size是50
A2. 导出模型的设置与训练和预测的输入数据长度是一致的；我们主要采用的数据集是ntu、企业提供的实际数据等等。在训练这个模型的时候，我们对这些数据中摔倒的片段做了统计分析，基本上每个动作片段持续的帧数大约是40~80左右。综合考虑到实际使用的延迟以及预测效果，我们选择了50这个量级，在我们的这部分数据上既能完整描述一个完整动作，又不会使得延迟过大。

总的来说，这个window_size的数值最好还是根据实际动作以及设备的情况进行选择。例如在某种设备上，50帧的长度根本不足以包含一个完整的动作，那么这个数值就需要扩大；又或者某些动作持续时间很短，50帧的长度包含了太多不相关的其他动作，容易造成误识别，那么这个数值可以适当缩小。


#### Q3. PP-Human中如何替换检测、跟踪、关键点模型
A3. 我们使用的模型都是PaddleDetection中模型进行导出得到的。理论上PP-Human所使用的模型都是可以直接替换的，但是需要注意是流程和前后处理一样的模型。

#### Q4. PP-Human中的数据标注问题（检测、跟踪、关键点、行为、属性）标注工具推荐和标注步骤
A4. 标注工具：检测 labelme, labelImg, cvat； 跟踪darklabel，cvat；关键点 labelme，cvat。检测标注可以使用tools/x2coco.py转换成coco格式

#### Q5. PP-Human中如何更改label（属性和动作识别）
A5. 在PPHuman中，动作识别被定义为基于骨骼点序列的分类问题，目前我们已经开源的摔倒动作识别是一个二分类问题；属性方面我们当前还暂时没有开放训练，正在建设中

#### Q6. PP-Human的哪些功能支持单人、哪些支持多人
A6. PP-Human的功能实现基于一套流程：检测->跟踪->具体功能。当前我们的具体功能模型每次处理的是单人的，即属性、动作等都是属于图像中每一个具体人的。但是基于这套流程下来，图像中的每一个人都得到了处理的。所以单人、多人实际都是一样支持的。

#### Q7. PP-Human对视频流预测的支持及服务化部署
A7. 目前正在建设当中，下个版本会支持这部分功能

#### Q8. 在使用pphuman训练自己的数据集时，训练完进行测试时，可视化的标签如何更改，没有更改的情况下还是falling

A8. 可视化的函数位于https://github.com/PaddlePaddle/PaddleDetection/blob/release/2.4/deploy/python/visualize.py#L368，这里在可视化的时候将 action_text替换为期望的类别即可。

#### Q9. 关键点检测可以实现一个连贯动作的检测吗，比如健身规范
A9. 基于关键点是可以实现的。这里可以有不同思路去做：

1. 如果是期望判定动作规范的程度，且这个动作可以很好的描述。那么可以在关键点模型获得的坐标的基础上，人工增加逻辑判断即可。这里我们提供一个安卓的健身APP示例：https://github.com/zhiboniu/pose_demo_android ，其中实现判定各项动作的逻辑可以参考https://github.com/zhiboniu/pose_demo_android/blob/release/1.0/app/src/main/cpp/pose_action.cc 。

2. 当一个动作较难用逻辑去描述的时候，可能参考现有摔倒检测的案例，训练一个识别健身动作的模型，但对收集数据的要求会比较高。


#### Q10. 有遮挡的生产环境中梯子，可以用关键点检测判断人员上下梯动作是否合规
A10. 这个问题需要视遮挡的程度而定，如果遮挡过于严重时关键点检测模型的效果会大打折扣，从而导致行为的判断失准。此外，由于基于关键点的方案抹去了外观信息，如果只是从人物本身的动作上去做判断，那么在遮挡不严重的场景下是可以的。反之，如果梯子这个物体是判断动作是否合规的必要元素，那么这个方案其实不一定是最佳选择。

#### Q11. 关键点做的行为识别并不是时序上的动作识别吗
A11. 是时序的动作识别。这里是将一定时间范围内的每一帧关键点坐标组成一个时序的关键点序列，再通过行为识别模型去预测这个序列所属的行为类别。


## 检测算法问题
#### Q1. 大图片小目标   最终推理的图片也是大图片 怎么预处理呀
A1. 小目标问题常见的处理方式是切图以及增大网络输入尺寸，如果使用基于anchor的检测算法，可以通过对目标物体大小聚类生成anchor，参考[脚本](https://github.com/PaddlePaddle/PaddleDetection/blob/release/2.4/tools/anchor_cluster.py)； 目前基于PP-YOLOE的小目标检测正在开发中

#### Q2. 想问下大的目标对象怎么检测，比如发票
A2. 如果使用基于anchor的检测算法，可以通过对目标物体大小聚类生成anchor，参考[脚本](https://github.com/PaddlePaddle/PaddleDetection/blob/release/2.4/tools/anchor_cluster.py)；另外可以增强深层特征提升大物体检测效果

#### Q3. 在做预测时发现预测框特别多，有的框的置信度甚至低于0.1，请问如果将这种框过滤掉？也就是训练模型时就把这些极低置信度的预测结果过滤掉，避免在推理部署时，做不必要的计算，从而影响推理速度。
A3. 后处理部分有两个过滤，1）是提取置信度最高的Top 100个框做nms。2）是根据设定阈值threshold进行过滤。如果你可以确认图片上目标相对比较少<10个，可以调整Top 100这个值到50或者更低，这样可以加速nms部分的计算。其次调整threshold这个影响最终检测的准确度和召回率的效果。

#### Q4. 正负样本的比例一般怎么设计
A4. 在PaddleDetection中，支持负样本训练，TrainDataset下设置allow_empty: true即可，通过数据集测试，负样本比例在0.3时对模型提升效果最明显。

## 压缩部署问题
#### Q1. PaddleDetection训练的模型导出inference model后，在做推理部署的时候，前后处理相关代码如何编写，有什么参考教程吗？
A1. 目前PaddleDetection下的网络模型大部分都能够支持c++ inference，不同的处理方式针对不同功能，例如：PP-YOLOE速度测试不包含后处理，PicoDet为支持不同的第三方推理引擎会设置是否导出nms

object_detector.cc是针对所有检测模型的流程，其中前处理大部分都是decode-resize-nomalize-permute 部分网络会加入padding的操作；大部分模型的后处理操作都放在模型里面了，picodet有单独提供nms的后处理代码

检测模型的输入统一为image，im_shape，scale_factor ，如果模型中没有使用im_shape，输出个数会减少，但是整套预处理流程不需要额外开发

#### Q2. 针对TensorRT的加速问题，fp16在v100确实可以，但是耗时好像有点偏差，我在1080ti上，单张图片跑1000次，耗时50s，还是float32的，可是在v100上，float16耗时97
A2. 目前PPYOLOE等模型的速度都有在V100上使用TensorRT FP16测试，关于速度测试有以下几个方面可以排查：

1. 速度测试时是否正确设置warmup，以避免过长的启动时间影响速度测试准确度
2. 在开启TensorRT时，生成engine文件的过程耗时较长，可以在https://github.com/PaddlePaddle/PaddleDetection/blob/release/2.4/deploy/python/infer.py#L745 中将use_static设置为True


#### Q3. PaddleDetection已经支持了在线量化一些模型，比如想训练其他的一个新模型，是不是可以轻松用起来qat？如果不能，为什么只能支持很有限的模型，而qat其他模型总会出各种各样的问题，原因是什么？
A3. 目前PaddleDetection模型很多，只能针对部分模型开源了QAT的config，其他模型也是支持QAT的，只是配置文件没有覆盖到，如果量化报错，通常是配置问题。检测模型一般建议跳过head最后一个conv。如果想要跳过某些层量化，可以设置skip_quant，参考[代码](https://github.com/PaddlePaddle/PaddleDetection/blob/release/2.4/ppdet/modeling/heads/yolo_head.py#L97)
