package com.kwan.shuyu.watch;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * Watcher监听
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/5/15 10:29
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class Watcher_03_TreeCache {

    @Autowired
    private CuratorFramework client;

    /**
     * 演示 TreeCache：监听某个节点自己和所有子节点们
     */
    @Test
    public void testTreeCache() throws Exception {
        //1. 创建监听器
        TreeCache treeCache = new TreeCache(client, "/app2");
        //2. 注册监听
        treeCache.getListenable().addListener(new TreeCacheListener() {
            @Override
            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                System.out.println("节点变化了");
                System.out.println(event);
            }
        });
        //3. 开启
        treeCache.start();
        while (true) {
        }
    }
}