package com.kwan.shuyu.crud;

import org.apache.curator.framework.CuratorFramework;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * 基本修改数据
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/5/15 09:54
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class CuratorTest_08_Set {

    @Autowired
    private CuratorFramework client;

    /**
     * 修改数据
     * 1. 基本修改数据：setData().forPath()
     * 2. 根据版本修改: setData().withVersion().forPath()
     * * version 是通过查询出来的。目的就是为了让其他客户端或者线程不干扰我。
     *
     * @throws Exception
     */
    @Test
    public void testSet() throws Exception {
        client.setData().forPath("/app1", "itcast".getBytes());
    }
}