package com.kwan.shuyu.crud;

import org.apache.curator.framework.CuratorFramework;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * 查询数据
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/5/15 09:54
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class CuratorTest_05_Get {

    @Autowired
    private CuratorFramework client;

    /**
     * 查询节点：
     * 1. 查询数据：get: getData().forPath()
     * 2. 查询子节点： ls: getChildren().forPath()
     * 3. 查询节点状态信息：ls -s:getData().storingStatIn(状态对象).forPath()
     */
    @Test
    public void testGet1() throws Exception {
        //1. 查询数据：get
        byte[] data = client.getData().forPath("/app5");
        System.out.println(new String(data));
    }
}