import Vue from 'vue'
import App from './App.vue'
// 导入路由模块
import router from '@/router'
// 引入element
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
// 导入样式
import './assets/css/bootstrap.css'
import './index.css'
// 引入 dayjs 时间处理
import dayjs from "dayjs";
Vue.prototype.$dayjs = dayjs;

// 声明格式化时间的全局过滤器
Vue.filter("dateFormat", function (time) {
  // 1. 对 time 进行格式化处理，得到 YYYY-MM-DD HH:mm:ss
  // 2. 把 格式化的结果，return 出去

  // 直接调用 dayjs() 得到的是当前时间
  // dayjs(给定的日期时间) 得到指定的日期
  const dtStr = dayjs(time).format("YYYY-MM-DD HH:mm:ss");
  return dtStr;
});
Vue.use(ElementUI);
Vue.config.productionTip = false

new Vue({
  render: h => h(App),
  router
}).$mount('#app')
