import Vue from 'vue'
import VueRouter from 'vue-router'
import pathArr from '@/router/pathArr.js'

// 导入需要的组件
import Login from '@/components/MyLogin.vue'
import Home from '@/components/MyHome.vue'

import Pic from '@/components/menus/MyPic.vue'
import Chat from '@/components/menus/MyChat.vue'
import Interview from '@/components/menus/MyInterview.vue'
import Algorithmic from '@/components/menus/MyAlgorithmic.vue'
import AphorismPoetry from '@/components/menus/MyAphorismPoetry.vue'
import MyCsdnUser from '@/components/menus/MyCsdnUser.vue'
import MyFansInfo from '@/components/menus/MyFansInfo.vue'
import MyAccountManagement from '@/components/menus/MyAccountManagement.vue'
import MyMessage from '@/components/menus/MyMessage.vue'
import MyArticleInfo from '@/components/menus/MyArticleInfo.vue'
import MyTripletDayInfo from '@/components/menus/MyTripletDayInfo.vue'
import MyChatDetail from '@/components/user/MyChatDetail.vue'
import AddChatDetail from '@/components/user/AddChatDetail.vue'

Vue.use(VueRouter)

const router = new VueRouter({
	routes: [
		{
			path: '/',
			redirect: '/login',
		},
		// 登录的路由规则
		{
			path: '/login',
			component: Login,
			meta: {
				title: '登录',
			},
		},
		// 后台主页的路由规则
		{
			path: '/home',
			component: Home,
			redirect: '/home/tripletDayInfo',
			children: [
				{
					path: 'tripletDayInfo',
					component: MyTripletDayInfo,
					meta: {
						title: '三连管理',
					},
				},
				{
					path: 'csdnUser',
					component: MyCsdnUser,
					meta: {
						title: '用户管理',
					},
				},
				{
					path: 'articleInfo',
					component: MyArticleInfo,
					meta: {
						title: '文章管理',
					},
				},
				{
					path: 'accountManagement',
					component: MyAccountManagement,
					meta: {
						title: '余额管理',
					},
				},
				{
					path: 'message',
					component: MyMessage,
					meta: {
						title: '私信管理',
					},
				},
				{
					path: 'fansInfo',
					component: MyFansInfo,
					meta: {
						title: '粉丝管理',
					},
				},
				{
					path: 'interview',
					component: Interview,
					meta: {
						title: '面试题',
					},
				},
				{
					path: 'algorithmic',
					component: Algorithmic,
					meta: {
						title: '算法题',
					},
				},
				{
					path: 'aphorismpoetry',
					component: AphorismPoetry,
					meta: {
						title: '名言警句',
					},
				},
				{
					path: 'chat',
					component: Chat,
					meta: {
						title: 'chatgpt记录',
					},
				},
				{
					path: 'pic',
					component: Pic,
					meta: {
						title: '图片',
					},
				},
				{
					path: 'chatinfo/:id',
					component: MyChatDetail,
					props: true,
					meta: {
						title: 'chat信息',
					},
				},
				{
					path: 'addChat',
					component: AddChatDetail,
					meta: {
						title: '添加chat信息',
					},
				},
			],
		},
	],
})

// 全局前置守卫
router.beforeEach(function (to, from, next) {
	if (pathArr.indexOf(to.path) !== -1) {
		const token = localStorage.getItem('token')
		if (token) {
			next()
		} else {
			next('/login')
		}
	} else {
		next()
	}
})

export default router
