import axios from 'axios'

const BASE_URL = 'http://localhost:80'
// 创建一个名为 ApiService 的对象，包含您的异步方法
const ApiService = {
	// 三连日管理
	async tripletDayInfoPage(currentPage, pageSize, formInline) {
		return await axios.post(BASE_URL + '/dayInfo/page', {
			page: currentPage,
			pageSize: pageSize,
			startDate: formInline.tripletDate != null ? formInline.tripletDate[0] : '',
			endDate: formInline.tripletDate != null ? formInline.tripletDate[1] : '',
			weekInfo: formInline.weekInfo != null ? formInline.weekInfo : '',
		})
	},
	async dayRedPackageInfoPage(currentPage, pageSize, tripletDate) {
		return await axios.post(BASE_URL + '/csdn/csdnDayInfoRedPackage/page', {
			page: currentPage,
			pageSize: pageSize,
			startDate: tripletDate != null ? tripletDate[0] : '',
			endDate: tripletDate != null ? tripletDate[1] : '',
		})
	},

	async tripletDayReset() {
		return await axios.get(BASE_URL + '/dayInfo/add')
	},
	async sevenDay() {
		return await axios.get(BASE_URL + '/dayInfo/sevenDayOverview')
	},
	// 文章管理
	async triplet(articleId) {
		return await axios.get(BASE_URL + '/csdnArticleInfo/triplet?articleId=' + articleId)
	},

	async syncMyBlog() {
		return await axios.get(BASE_URL + '/csdnArticleInfo/syncMyBlog')
	},
	async resetLikes() {
		return await axios.get(BASE_URL + '/csdnArticleInfo/fixLikesStatus')
	},
	async allTriplet(articleIds) {
		return await axios.post(BASE_URL + '/csdnArticleInfo/multiTriplet', articleIds)
	},
	async articleInfoDelete(id) {
		return await axios.get(BASE_URL + '/csdnArticleInfo/delete', {
			params: {
				id: id,
			},
		})
	},

	//红包管理
	async dealViewCount(id) {
		return await axios.get(BASE_URL + '/csdn/redPackage/getViewCountById?id=' + id)
	},
	async receiveRedPacketByOrderNo(id) {
		return await axios.get(BASE_URL + '/csdn/redPackage/receiveRedPacketByOrderNo?id=' + id)
	},
	async syncDetailInfo(id) {
		return await axios.get(BASE_URL + '/csdn/redPackage/detail/syncDetailInfo?id=' + id)
	},
	async redPackagePage(currentPage, pageSize, formInline) {
		return await axios.post(BASE_URL + '/csdn/redPackage/page', {
			page: currentPage,
			pageSize: pageSize,
			nickName: formInline.nickName,
			myAmountStart: formInline.myAmountStart,
			myAmountEnd: formInline.myAmountEnd,
			startDate: formInline.startDate,
			orderNo: formInline.orderNo,
			itemType: formInline.itemType == '全部' ? null : formInline.itemType,
			msg: formInline.msg == '全部' ? null : formInline.msg,
		})
	},
	async getTodayRedPackageDetailInfo(ids) {
		return await axios.post(BASE_URL + '/csdn/redPackage/detail/getTodayRedPackageDetailInfo', ids)
	},
	async redPackageDetailList(currentPage, pageSize, orderNo, communityId, postId) {
		return await axios.post(BASE_URL + '/csdn/redPackage/detail/page', {
			page: currentPage,
			pageSize: pageSize,
			orderNo: orderNo,
			communityId: communityId == 'null' || communityId == -1 ? '' : communityId,
			postId: postId == 'null' || postId == -1 ? '' : postId,
		})
	},

	//粉丝管理
	async fansInfoPage(currentPage, pageSize, formInline) {
		return await axios.post(BASE_URL + '/csdn/followFans/page', {
			page: currentPage,
			pageSize: pageSize,
			relationType: formInline.relationType,
			userName: formInline.userName,
		})
	},
	async syncFansInfo() {
		return await axios.get(BASE_URL + '/csdn/followFans/saveFans')
	},
	async cancleFansNoArticle() {
		return await axios.get(BASE_URL + '/csdn/followFans/deleteNoArticle')
	},
	async syncFollowInfo() {
		return await axios.get(BASE_URL + '/csdn/followFans/saveFollow')
	},
	async cancleFollowInfo() {
		return await axios.get(BASE_URL + '/csdn/followFans/deleteFollow')
	},
	//我的图片
	async queryPic(currentPage, pageSize, formInline) {
		return await axios.post(BASE_URL + '/picInfo/page', {
			page: currentPage,
			pageSize: pageSize,
			type: formInline.type == '全部' ? '' : formInline.type,
			picName: formInline.picName,
		})
	},
	async editPicConfirm(currentRowId, type, picName) {
		return await axios.post(BASE_URL + '/picInfo/update', {
			id: currentRowId,
			type: type,
			picName: picName,
		})
	},

	async batchUpdatePic(ids, type) {
		return await axios.post(BASE_URL + '/picInfo/batchUpdatePic', {
			ids: ids,
			type: type,
		})
	},
	//余额管理
	async accountManagementPage(currentPage, pageSize, formInline) {
		return await axios.post(BASE_URL + '/csdnAccountManagement/page', {
			page: currentPage,
			pageSize: pageSize,
			startDate: formInline.accountDate != null ? formInline.accountDate[0] : '',
			endDate: formInline.accountDate != null ? formInline.accountDate[1] : '',
			operateType: formInline.operateType != -1 ? formInline.operateType : null,
			productName: formInline.productName != '全部' ? formInline.productName : null,
			code: formInline.code,
		})
	},
	async addAccountInfo() {
		return await axios.get(BASE_URL + '/csdnAccountManagement/addAccountInfo')
	},
	async add5AccountInfo() {
		return await axios.get(BASE_URL + '/csdnAccountManagement/add5AccountInfo')
	},
	//累计红包管理
	async totalIncomePage(currentPage, pageSize, formInline) {
		return await axios.post(BASE_URL + '/csdn/totalIncome/page', {
			page: currentPage,
			pageSize: pageSize,
			startDate: formInline.accountDate != null ? formInline.accountDate[0] : '',
			endDate: formInline.accountDate != null ? formInline.accountDate[1] : '',
		})
	},
	//用户管理
	async multiTriplet(userNames) {
		return await axios.post(BASE_URL + '/csdn/multiTriplet', userNames)
	},
	async autoReply() {
		return await axios.get(BASE_URL + '/csdn/autoReply')
	},
	async singleTriplet(userName) {
		return await axios.get(BASE_URL + '/csdn/singleTriplet?username=' + userName)
	},

	//私信管理
	async dealMessageOne(userName) {
		return await axios.get(BASE_URL + '/csdn/message/dealMessageOne?userName=' + userName)
	},
	async dealMessage() {
		return await axios.get(BASE_URL + '/csdn/message/dealMessage')
	},
	async dealLikeCollect() {
		return await axios.get(BASE_URL + '/csdn/likeCollect/dealLikeCollect')
	},
	async acquireMessage() {
		return await axios.get(BASE_URL + '/csdn/message/acquireMessage')
	},
	async messagePage(currentPage, pageSize, formInline) {
		return await axios.post('http://localhost:80/csdn/message/page', {
			page: currentPage,
			pageSize: pageSize,
			userName: formInline.userName,
			nickName: formInline.nickName,
			hasReplied: formInline.hasRepliedInfo == -1 ? null : formInline.hasRepliedInfo,
		})
	},
}
export default ApiService
