package com.kwan.springcloudalibaba.controller;

import com.kwan.springcloudalibaba.api.FeignUserService;
import com.kwan.springcloudalibaba.common.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;


@RefreshScope
@RestController
@RequestMapping("/nacos/consumer")
public class ConsumerUserController {

    @Autowired
    private LoadBalancerClient loadBalancerClient;

    @Autowired
    private RestTemplate restTemplate;

    /**
     * feign方式调用
     */
    @Autowired
    private FeignUserService computeClient;


    @Autowired
    private DiscoveryClient discoveryClient;

    @GetMapping(value = "/loadBalancerClient/{id}", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    public Result loadBalancerClient(@PathVariable("id") Integer id) {
        //使用LoadBalanceClient和RestTemplate结合的方式来访问
        ServiceInstance serviceInstance = loadBalancerClient.choose("nacos-server-producer");
        String url = String.format("http://%s:%s/user/%s", "nacos-server-producer", serviceInstance.getPort(), id);
        System.out.println("request url:" + url);
        return Result.ok(restTemplate.getForObject(url, Object.class));
    }

    /**
     * http://127.0.0.1:8085/nacos/consumer/1
     * <p>
     * http://localhost:9091/user/1
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    public Result getUserById(@PathVariable Integer id) {
        return Result.ok(computeClient.selectOne(id));
    }

    /**
     * 获取配置的变量
     */
    @GetMapping(value = "/nameInfo", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    public Result nameInfo() {
        return Result.ok();
    }

}

