package com.kwan.springcloudalibaba.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.kwan.springcloudalibaba.entity.User;
import com.kwan.springcloudalibaba.mapper.UserMapper;
import com.kwan.springcloudalibaba.service.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service
public class UserServiceImpl extends ServiceImpl<UserMapper, User> implements IUserService {

    @Autowired
    private UserMapper userMapper;

    @Override
    public List<User> getUsers() {
        return userMapper.selectList(null);
    }

    @Override
    public User getUserById(Integer id) {
        return userMapper.selectById(id);
    }

    @Override
    public User getUserByName(String sex) {
        User userByName = userMapper.getUserByName(sex);
        if (Objects.isNull(userByName)) {
            userByName = new User();
        }
        return userByName;
    }
}