package com.kwan.springcloudalibaba;

import com.alibaba.cloud.nacos.ribbon.NacosRule;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.PingUrl;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;


@EnableFeignClients
@EnableDiscoveryClient
@SpringBootApplication
public class NacosConsumerApplication {

    @LoadBalanced
    @Bean
    @ConditionalOnMissingBean({RestTemplate.class})
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public IRule randomRule() {
        return new NacosRule(); //nacos的策略
//        return new RandomRule(); //随机
        //return new RoundRobinRule(); //轮训
        //return new BestAvailableRule();
        //return new ZoneAvoidanceRule(); //新版本默认的策略
    }

    @Bean
    public IPing iping() {
        return new PingUrl();
    }


    public static void main(String[] args) {
        SpringApplication.run(NacosConsumerApplication.class, args);
    }
}
