package com.kwan.springcloudalibaba.controller;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.kwan.springcloudalibaba.common.Result;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * http://localhost:18088/sentinel/nameInfo
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/2/2 17:13
 */
@RestController
@RequestMapping("/sentinel")
public class SentinelController {

    @Value("${user.name}")
    private String nameInfo;

    /**
     * 获取配置的变量
     */
    @GetMapping(value = "/nameInfo", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    public Result nameInfo() {
        return Result.ok(nameInfo);
    }


    /**
     * http://localhost:18088/sentinel/world
     *
     * @return
     */
    @GetMapping("/world")
    @SentinelResource(value = "helloWorld", blockHandler = "helloBlock")
    public String helloWorld() {
        return "Hello world";
    }

    public String helloBlock(BlockException e) {
        return "你已被流控";
    }

}

