package com.kwan.springcloudalibaba.controller;

import com.kwan.springcloudalibaba.api.ComputeClient;
import com.kwan.springcloudalibaba.common.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RefreshScope
@RestController
@RequestMapping("/nacos/consumer")
public class ConsumerUserController {

    @Autowired
    private ComputeClient computeClient;


    /**
     * http://127.0.0.1:8085/nacos/consumer/1
     * <p>
     * http://localhost:9091/user/1
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    public Result getUserById(@PathVariable Integer id) {
        return Result.ok(computeClient.selectOne(id));
    }

    /**
     * 获取配置的变量
     */
    @GetMapping(value = "/nameInfo", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    public Result nameInfo() {
        return Result.ok();
    }

}

