package com.kwan.springcloudalibaba.api;

import com.kwan.springcloudalibaba.common.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 使用feign配置goods-service服务
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/1/10 13:45
 */
@FeignClient(value = "nacos-server-producer", path = "/user")
public interface ComputeClient {

    @RequestMapping(method = RequestMethod.GET, value = "/{id}", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    Result selectOne(@PathVariable Integer id);

}
