package com.kwan.springcloudalibaba.controller;


import com.kwan.springcloudalibaba.common.Result;
import com.kwan.springcloudalibaba.entity.User;
import com.kwan.springcloudalibaba.service.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 用户相关
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2022/12/19 16:08
 */
@Slf4j
@RestController
@RequestMapping("/user")
public class UserController {

    @Autowired
    private IUserService userService;

    /**
     * 通过主键查询单条数据
     *
     * http://localhost:9091/user/1
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping(value = "/{id}", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    public Result selectOne(@PathVariable Integer id) {
        return Result.ok(userService.getUserById(id));
    }


    @RequestMapping(value = "/all", method = RequestMethod.GET)
    public List<User> addAdvertise() {
        log.info("测试日志={}", "success");
        return userService.getUsers();
    }

    @RequestMapping(value = "/getUserByName", method = RequestMethod.GET)
    public User getUserByName(@RequestParam String sex) {
        return userService.getUserByName(sex);
    }
}