package com.kwan.springcloudalibaba.common;

import com.kwan.springcloudalibaba.constant.CommonConstant;
import lombok.Data;

import java.io.Serializable;

/**
 * 接口返回数据格式
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/1/8 10:48
 */
@Data
public class Result<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 成功标志
     */
    private boolean success = true;
    /**
     * 返回处理消息
     */
    private String message = "操作成功！";
    /**
     * 返回代码
     */
    private Integer code = 0;
    /**
     * 返回数据对象 data
     */
    private T result;
    /**
     * 时间戳
     */
    private long timestamp = System.currentTimeMillis();

    public Result() {
    }

    public Result<T> success(String message) {
        this.message = message;
        this.code = CommonConstant.SC_OK_200;
        this.success = true;
        return this;
    }

    public Result<T> good(T t) {
        this.setResult(t);
        this.code = CommonConstant.SC_OK_200;
        this.success = true;
        return this;
    }

    public Result<T> good() {
        this.code = CommonConstant.SC_OK_200;
        this.success = true;
        this.setMessage("成功");
        return this;
    }

    public Result<T> fail(String msg) {
        this.setCode(CommonConstant.SC_INTERNAL_SERVER_ERROR_500);
        this.setMessage(msg);
        this.setSuccess(false);
        return this;
    }

    public static Result<Object> ok() {
        Result<Object> r = new Result<>();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setMessage("成功");
        return r;
    }

    public static Result<Object> ok(String msg) {
        Result<Object> r = new Result<>();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setMessage(msg);
        return r;
    }

    public static Result<Object> ok(Object data) {
        Result<Object> r = new Result<Object>();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setResult(data);
        return r;
    }

    public static Result<Object> error(String msg) {
        return error(CommonConstant.SC_INTERNAL_SERVER_ERROR_500, msg);
    }

    public static Result<Object> error(int code, String msg) {
        Result<Object> r = new Result<Object>();
        r.setCode(code);
        r.setMessage(msg);
        r.setSuccess(false);
        return r;
    }

    public Result<T> error500(String message) {
        this.message = message;
        this.code = CommonConstant.SC_INTERNAL_SERVER_ERROR_500;
        this.success = false;
        return this;
    }

    /**
     * 无权限访问返回结果
     */
    public static Result<Object> noauth(String msg) {
        return error(CommonConstant.SC_JEECG_NO_AUTHZ, msg);
    }
}