package com.kwan.springcloudalibaba.controller;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.kwan.springcloudalibaba.api.FeignUserService;
import com.kwan.springcloudalibaba.common.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * http://localhost:18088/sentinel/nameInfo
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/2/2 17:13
 */
@RestController
@RequestMapping("/sentinel")
public class SentinelController {

    @Autowired
    private FeignUserService feignUserService;

    /**
     * feign调用
     * http://127.0.0.1:8085/nacos/consumer/1
     * <p>
     * http://localhost:9091/user/1
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    public Result getUserById(@PathVariable Integer id) {
        return Result.ok(feignUserService.selectOne(id));
    }


    /**
     * 获取配置的变量
     * http://localhost:8086/sentinel/nameInfo
     */
//    @SentinelResource(value = "SentinelExceptionHandler",
//            blockHandlerClass = SentinelExceptionHandler.class,
//            blockHandler = "handleRRException")
    @GetMapping(value = "/nameInfo", produces = MediaType.APPLICATION_PROBLEM_JSON_VALUE)
    public Result nameInfo() {
        return Result.ok();
    }

    /**
     * http://localhost:8086/sentinel/world
     *
     * @return
     */
    @GetMapping("/world")
    @SentinelResource(value = "helloWorld", blockHandler = "helloBlock")
    public String helloWorld() {
        return "Hello world";
    }

    /**
     * 回调地址
     *
     * @param e
     * @return
     */
    public String helloBlock(BlockException e) {
        return "你已被流控";
    }

}

