package com.kwan.springcloudalibaba.util;


import cn.hutool.core.date.StopWatch;
import com.alibaba.fastjson2.JSON;
import com.google.common.base.Charsets;
import com.google.common.io.Files;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 字符串是否存在文件中
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/2/8 10:45
 */
public class FileContains {

    /**
     * 默认不存在
     */
    private static boolean IS_EXIST = false;
    /**
     * 图片路径
     */
    private static final String PIC_PATH = "/Users/qinyingjie/Documents/idea-workspace/blogimg/";
    /**
     * 博客路径
     */
    private static final String BLOG_FOLDER = "/Users/qinyingjie/Documents/idea-workspace/blog/";

    public static void main(String[] args) throws IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        final List<String> isNotExist = new ArrayList<>();
        //获取picPath下面所有的文件名
        final List<String> picNames = getPicName(PIC_PATH);
        System.out.println("图片总数为" + picNames.size());
        for (String word : picNames) {
            IS_EXIST = false;
            //指定类型的文件
            String suffix = ".md";
            //包含某个字符串
            traverseFolder(BLOG_FOLDER, suffix, word);
            //文件不存在
            if (!IS_EXIST) {
                isNotExist.add(word);
                deletePic(PIC_PATH + word);
            }
        }
        System.out.println("不存在图片总数为" + isNotExist.size());
        stopWatch.stop();
        //毫秒输出
        System.out.println(JSON.toJSONString(stopWatch.getTaskInfo()));
    }

    /**
     * 获取文件
     *
     * @param path
     * @param suffix
     * @param word
     * @throws IOException
     */
    public static void traverseFolder(String path, String suffix, String word) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            //获取文件夹下的文件
            File[] files = file.listFiles();
            if (null != files && files.length != 0) {
                for (File file2 : files) {
                    //是否是文件夹
                    if (file2.isDirectory()) {
                        traverseFolder(file2.getAbsolutePath(), suffix, word);
                    } else {
                        //包含md结尾的文件
                        if (file2.getAbsolutePath().contains(suffix)) {
                            getParams(file2.getAbsolutePath(), word);
                        }
                    }
                }
            }
        }
    }

    /**
     * 判断文件是否存在
     *
     * @param classPath
     * @param word
     * @throws IOException
     */
    public static void getParams(String classPath, String word) throws IOException {
        File file = new File(classPath);
        //每行作为一个字符串，存为列表元素
        List<String> strings = Files.readLines(file, Charsets.UTF_8);
        for (String string : strings) {
            //判断是否包含方法名称，即指定字符串
            if (string.contains(word)) {
                //文件存在
                IS_EXIST = true;
            }
        }
    }

    /**
     * 获取图片名称
     *
     * @param path
     * @return
     */
    public static List<String> getPicName(String path) {
        List<String> picNames = new ArrayList<>();
        File file = new File(path);
        if (file.exists()) {
            //获取文件夹下的文件
            File[] files = file.listFiles();
            if (null != files && files.length != 0) {
                for (File file2 : files) {
                    //是否是文件夹
                    if (!file2.isDirectory()) {
                        //包含md结尾的文件
                        final String name = file2.getName();
                        picNames.add(name);
                    }
                }
            }
        }
        return picNames;
    }

    /**
     * 删除文件
     *
     * @param picPath
     */
    public static void deletePic(String picPath) {
        File file = new File(picPath);
        try {
            file.delete();
            System.out.printf("删除文件成功:%s%n", picPath);
        } catch (Exception e) {
            System.err.printf("无法删除的路径 %s%n%s", picPath, e);
        }
    }
}