package com.kwan.springbootkwan.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kwan.springbootkwan.entity.Result;
import com.kwan.springbootkwan.entity.VueChat;
import com.kwan.springbootkwan.service.VueChatService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.List;

/**
 * vue购物车项目(VueChat)表控制层
 *
 * @author makejava
 * @since 2023-07-09 15:12:55
 */
@RestController
@RequestMapping("vueChat")
public class VueChatController {
    /**
     * 服务对象
     */
    @Resource
    private VueChatService vueChatService;

    /**
     * 获取所有数据
     *
     * @return
     */
    @GetMapping
    public Result selectAll() {
        return Result.ok(this.vueChatService.list());
    }

    /**
     * 分页查询所有数据
     *
     * @param page    分页对象
     * @param vueChat 查询实体
     * @return 所有数据
     */
    @GetMapping("/page")
    public Result selectPage(Page<VueChat> page, VueChat vueChat) {
        return Result.ok(this.vueChatService.page(page, new QueryWrapper<>(vueChat)));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("{id}")
    public Result selectOne(@PathVariable Serializable id) {
        return Result.ok(this.vueChatService.getById(id));
    }

    /**
     * 新增数据
     *
     * @param vueChat 实体对象
     * @return 新增结果
     */
    @PostMapping
    public Result insert(@RequestBody VueChat vueChat) {
        return Result.ok(this.vueChatService.save(vueChat));
    }

    /**
     * 修改数据
     *
     * @param vueChat 实体对象
     * @return 修改结果
     */
    @PutMapping
    public Result update(@RequestBody VueChat vueChat) {
        return Result.ok(this.vueChatService.updateById(vueChat));
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @DeleteMapping
    public Result delete(@RequestParam("idList") List<Long> idList) {
        return Result.ok(this.vueChatService.removeByIds(idList));
    }
}

