package com.kwan.springbootkwan.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * 方法上跨域配置
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2022/12/19 16:10
 */
@Api(description = "书籍信息", tags = "BookController")
@RestController
public class BookController {

    @ApiOperation(value = "添加书籍", notes = "添加书籍")
    @CrossOrigin(value = "http://localhost:8081", maxAge = 1800, allowedHeaders = "*")
    @PostMapping("addBook")
    public String addBook(String name) {
        return "receive：" + name;
    }

    @ApiOperation(value = "删除书籍", notes = "删除书籍")
    @CrossOrigin(value = "http://localhost:8081", maxAge = 1800, allowedHeaders = "*")
    @DeleteMapping("deleteBook/{id}")
    public String deleteBook(@PathVariable(value = "id") String id) {
        return "receive：" + id;
    }
}
