package com.kwan.springbootkwan.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.StopWatch;
import com.alibaba.fastjson2.JSON;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 删除博客中不存在的照片
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/2/8 10:45
 */
@Slf4j
public class FileContainsUtil {
    /**
     * 默认图片不存在
     */
    private static boolean IS_EXIST = false;
    /**
     * 图片路径
     */
    private static final String PIC_PATH = "/Users/qinyingjie/Documents/idea-workspace/blogimg/";
    /**
     * 博客路径1
     */
    private static final String BLOG_FOLDER1 = "/Users/qinyingjie/Documents/vscode-workspace/blog/";
    /**
     * 博客路径2
     */
    private static final String BLOG_FOLDER2 = "/Users/qinyingjie/Documents/idea-workspace/study/blog/";
    /**
     * 博客路径3
     */
    private static final String BLOG_FOLDER3 = "/Users/qinyingjie/Documents/idea-workspace/study/belle_blog/";
    /**
     * 图片白名单
     */
    private static final List<String> PIC_PATH_WHITELISTS = Arrays.asList(
            "http://qinyingjie.top/blogImg/image-20230324112725149.png"
            , "http://qinyingjie.top/blogImg/logo.png"
            , "http://qinyingjie.top/blogImg/image-20230601124308164.png"
            , "http://qinyingjie.top/blogImg/image-20230822102858692.png"
    );

    public static void main(String[] args) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("删除未用到的图片");
        //不存在的图片集合
        final List<String> isNotExist = new ArrayList<>();
        //获取所有图片名称
        final List<String> picNames = getPicName(PIC_PATH);
        log.info("图片总数为{}", picNames.size());
        if (CollectionUtil.isNotEmpty(picNames)) {
            outerloop:
            for (int i = 0; i < picNames.size(); i++) {
                String picName = picNames.get(i);
                //是白名单里面的图片,直接忽略
                for (String picPathWhitelist : PIC_PATH_WHITELISTS) {
                    if (picPathWhitelist.contains(picName)) {
                        continue outerloop;
                    }
                }
                //默认不存在
                IS_EXIST = false;
                //指定类型的文件
                List<String> suffix = new ArrayList<>();
                suffix.add(".md");
                //包含某个字符串
                traverseFolder(BLOG_FOLDER1, suffix, picName);
                traverseFolder(BLOG_FOLDER2, suffix, picName);
                traverseFolder(BLOG_FOLDER3, suffix, picName);
                //文件不存在
                if (!IS_EXIST) {
                    isNotExist.add(picName);
                    deletePic(PIC_PATH + picName);
                }
            }
        }
        log.info("不存在图片总数为{}", isNotExist.size());
        stopWatch.stop();
        //毫秒输出
        log.info("耗时统计信息:{}", JSON.toJSONString(stopWatch.getTaskInfo()));
        log.info("耗时秒数:{}", JSON.toJSONString(stopWatch.getTotalTimeSeconds()));
        log.info("耗时分钟数:{}", JSON.toJSONString(stopWatch.getTotalTimeSeconds() / 60));
    }

    /**
     * 获取文件
     *
     * @param path
     * @param suffixs
     * @param word
     * @throws IOException
     */
    public static void traverseFolder(String path, List<String> suffixs, String word) throws Exception {
        File file = new File(path);
        if (file.exists()) {
            //获取文件夹下的文件
            File[] files = file.listFiles();
            if (null != files && files.length != 0) {
                for (File file2 : files) {
                    //是否是文件夹
                    if (file2.isDirectory()) {
                        traverseFolder(file2.getAbsolutePath(), suffixs, word);
                    } else {
                        for (String suffix : suffixs) {
                            //包含md结尾的文件
                            if (file2.getAbsolutePath().contains(suffix)) {
                                getParams(file2.getAbsolutePath(), word);
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 判断文件是否存在
     *
     * @param classPath
     * @param word
     * @throws IOException
     */
    public static void getParams(String classPath, String word) throws IOException {
        File file = new File(classPath);
        //每行作为一个字符串，存为列表元素
        List<String> strings = Files.readLines(file, Charsets.UTF_8);
        for (String string : strings) {
            //判断是否包含方法名称，即指定字符串
            if (string.contains(word)) {
                //文件存在
                IS_EXIST = true;
            }
        }
    }

    /**
     * 获取图片名称
     *
     * @param path
     * @return
     */
    public static List<String> getPicName(String path) {
        List<String> picNames = new ArrayList<>();
        File file = new File(path);
        if (file.exists()) {
            //获取文件夹下的文件
            File[] files = file.listFiles();
            if (null != files && files.length != 0) {
                for (File file2 : files) {
                    //是否是文件夹
                    if (!file2.isDirectory()) {
                        //包含md结尾的文件
                        final String name = file2.getName();
                        picNames.add(name);
                    }
                }
            }
        }
        return picNames;
    }

    /**
     * 删除文件
     *
     * @param picPath
     */
    public static void deletePic(String picPath) {
        File file = new File(picPath);
        try {
            file.delete();
            System.out.printf("删除文件成功:%s%n", picPath);
        } catch (Exception e) {
            System.err.printf("无法删除的路径 %s%n%s", picPath, e);
        }
    }
}