package com.kwan.springbootkwan.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.kwan.springbootkwan.constant.CommonConstant;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 时间工具类
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/7/21 23:29
 */
@Slf4j
public class DateUtils {

    /**
     * 获取前7天日期
     */
    public static String inMonth() {
        // 获取当前日期时间
        DateTime now = DateUtil.date();
        // 获取当前日期所在的月份，并格式化为两位数字
        return String.format("%02d", DateUtil.month(now) + 1);
    }

    /**
     * 获取前7天日期
     */
    public static int inWeek() {
        // 获取当前日期时间
        DateTime now = DateUtil.date();
        // 获取当前日期所在的周数
        return DateUtil.weekOfYear(now);
    }

    /**
     * 获取指定天的3天数据
     *
     * @param date
     * @return
     */
    public static List<String> before3Days(String date) {
        List<String> dates = new ArrayList<>();
        dates.add(date);
        for (int i = 1; i < CommonConstant.THREE; i++) {
            final DateTime dateTime = DateUtil.offsetDay(str2Date(date), -i);
            dates.add(DateUtil.formatDate(dateTime));
        }
        return dates;
    }

    /**
     * 获取前7天日期
     */
    public static List<String> before7Days() {
        List<String> dates = new ArrayList<>();
        final DateTime yesterdayDate = DateUtil.yesterday();
        final String yesterday = DateUtil.formatDate(yesterdayDate);
        dates.add(yesterday);
        for (int i = 1; i < CommonConstant.SEVEN; i++) {
            final DateTime dateTime = DateUtil.offsetDay(yesterdayDate, -i);
            dates.add(DateUtil.formatDate(dateTime));
        }
        return dates;
    }

    /**
     * 获取日期的集合
     *
     * @param start
     * @param end
     * @return
     */
    public static List<LocalDate> getDateRangeList(String start, String end) {
        LocalDate startDate = LocalDate.parse(start);
        LocalDate endDate = LocalDate.parse(end);
        List<LocalDate> dateList = new ArrayList<>();
        LocalDate currentDate = startDate;
        while (!currentDate.isAfter(endDate)) {
            dateList.add(currentDate);
            currentDate = currentDate.plusDays(1);
        }
        return dateList;
    }


    /**
     * 字符串转日期
     *
     * @param str
     * @return
     */
    public static Date str2Date(String str) {
        return DateUtil.parse(str);
    }

    /**
     * 日期转字符串
     *
     * @param date
     * @return
     */
    public static String date2Str(Date date) {
        return DateUtil.format(date, "yyyy-MM-dd");
    }
}