package com.kwan.springbootkwan.filter;

import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;


/**
 * 添加过滤器
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/8/26 11:06
 */
@Component
@Order(2) // 设置过滤器的优先级为1,值越小,优先级越高
public class MyFilter implements Filter {
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        // 过滤器逻辑
        chain.doFilter(request, response);
    }
}

