package com.kwan.springbootkwan.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kwan.springbootkwan.entity.InterviewQuestion;
import com.kwan.springbootkwan.entity.Result;
import com.kwan.springbootkwan.entity.dto.InterviewQuestionDTO;
import com.kwan.springbootkwan.service.InterviewQuestionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.List;

/**
 * 面试题(InterviewQuestion)表控制层
 *
 * @author makejava
 * @since 2023-09-08 16:31:51
 */
@RestController
@RequestMapping("interviewQuestion")
public class InterviewQuestionController {
    /**
     * 服务对象
     */
    @Resource
    private InterviewQuestionService interviewQuestionService;

    /**
     * 导入问题
     *
     * @return 所有数据
     */
    @GetMapping("/upload")
    public Result uploadFile(@RequestParam String path) {
        return Result.ok(this.interviewQuestionService.uploadFile(path));
    }

    /**
     * 分页查询所有数据,本地缓存的使用
     *
     * @return 所有数据
     */
    @GetMapping("/page")
    public Result selectAll(@RequestParam Integer page
            , @RequestParam Integer pageSize
            , @RequestParam String question) {
        Page<InterviewQuestion> pageParm = new Page<>();
        pageParm.setCurrent(page);
        pageParm.setSize(pageSize);
        QueryWrapper<InterviewQuestion> wrapper = new QueryWrapper<>();
        wrapper.orderByDesc("id");
        wrapper.eq("is_delete", 0);
        if (StringUtils.isNotEmpty(question)) {
            wrapper.like("question", question);
        }
        return Result.ok(InterviewQuestionDTO.Converter.INSTANCE.from(this.interviewQuestionService.page(pageParm, wrapper)));
    }

    /**
     * 分页查询所有数据
     *
     * @param page              分页对象
     * @param interviewQuestion 查询实体
     * @return 所有数据
     */
    @GetMapping
    public Result selectAll(Page<InterviewQuestion> page, InterviewQuestion interviewQuestion) {
        return Result.ok(this.interviewQuestionService.page(page, new QueryWrapper<>(interviewQuestion)));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("{id}")
    public Result selectOne(@PathVariable Serializable id) {
        return Result.ok(this.interviewQuestionService.getById(id));
    }

    /**
     * 新增数据
     *
     * @param interviewQuestion 实体对象
     * @return 新增结果
     */
    @PostMapping
    public Result insert(@RequestBody InterviewQuestion interviewQuestion) {
        return Result.ok(this.interviewQuestionService.save(interviewQuestion));
    }

    /**
     * 修改数据
     *
     * @param interviewQuestion 实体对象
     * @return 修改结果
     */
    @PutMapping
    public Result update(@RequestBody InterviewQuestion interviewQuestion) {
        return Result.ok(this.interviewQuestionService.updateById(interviewQuestion));
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @DeleteMapping
    public Result delete(@RequestParam("idList") List<Long> idList) {
        return Result.ok(this.interviewQuestionService.removeByIds(idList));
    }
}

