package com.kwan.springbootkwan.aop;

import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.*;
import org.springframework.stereotype.Component;

/**
 * AOP 实现方法拦截
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2022/12/19 16:17
 */
@Component
@Aspect
@Slf4j
public class LogAspect {

    @Pointcut(value = "execution(* com.kwan.springbootkwan.service.*.*(..)) && !execution(* com.kwan.springbootkwan.service.WebSocketServer.*(..))")

    public void pcl() {
    }

    @Before(value = "pcl()")
    public void before(JoinPoint point) {
        String name = point.getSignature().getName();
        log.info(name + "方法开始执行 ．．．");
    }

    @After(value = "pcl()")
    public void after(JoinPoint point) {
        String name = point.getSignature().getName();
        log.info(name + "方法执行结束 ．．．");
    }

    @AfterReturning(value = "pcl()", returning = "result")
    public void afterReturning(JoinPoint point, Object result) {
        String name = point.getSignature().getName();
        log.info(name + "方法返回值为：" + result);
    }

    @AfterThrowing(value = "pcl()", throwing = "e")
    public void afterThrowing(JoinPoint point, Exception e) {
        String name = point.getSignature().getName();
        log.info(name + "方法抛异常了，异常是：" + e.getMessage());
    }

    @Around("pcl()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return pjp.proceed();
    }
}