package com.kwan.springbootkwan.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.kwan.springbootkwan.constant.CsdnConstant;
import com.kwan.springbootkwan.entity.CsdnArticleInfo;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.query.CsdnUserInfoQuery;
import com.kwan.springbootkwan.entity.resp.BusinessInfoResponse;
import com.kwan.springbootkwan.enums.CollectStatus;
import com.kwan.springbootkwan.enums.CommentStatus;
import com.kwan.springbootkwan.enums.LikeStatus;
import com.kwan.springbootkwan.mapper.CsdnUserInfoMapper;
import com.kwan.springbootkwan.service.CsdnArticleInfoService;
import com.kwan.springbootkwan.service.CsdnCollectService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service("csdnUserInfoService")
public class CsdnUserInfoServiceImpl extends ServiceImpl<CsdnUserInfoMapper, CsdnUserInfo> implements CsdnUserInfoService {

    @Autowired
    private CsdnCollectService csdnCollectService;
    @Autowired
    private CsdnArticleInfoService csdnArticleInfoService;

    @Override
    public CsdnUserInfo getUserByUserName(String username) {
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        wrapper.eq("user_name", username)
                .last("limit 1");
        return this.getOne(wrapper);
    }

    @Override
    public List<CsdnUserInfo> getAllUser() {
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        wrapper.orderByAsc("rand()");
        return this.list(wrapper);
    }

    @Override
    public void resetAllCurrentStatus() {
        final List<CsdnUserInfo> allUser = this.getAllUser();
        if (CollectionUtil.isNotEmpty(allUser)) {
            for (CsdnUserInfo csdnUserInfo : allUser) {
                this.resetCsdnUserInfo(csdnUserInfo);
            }
        }
    }

    @Override
    public void resetCsdnUserInfo(CsdnUserInfo csdnUserInfo) {
        final Integer commentStatus = csdnUserInfo.getCommentStatus();
        final String userName = csdnUserInfo.getUserName();
        final String articleType = csdnUserInfo.getArticleType();
        final List<BusinessInfoResponse.ArticleData.Article> articles = csdnArticleInfoService.getArticles(userName);
        if (CollectionUtil.isNotEmpty(articles)) {
            final BusinessInfoResponse.ArticleData.Article article = articles.get(0);
            final String type = article.getType();
            if (StringUtils.equals(type, CsdnConstant.ARTICLE_TYPE)) {
                final String articleUrl = article.getUrl();
                String articleId = articleUrl.substring(articleUrl.lastIndexOf("/") + 1);
                final Boolean collect = csdnCollectService.isCollect(articleId, csdnUserInfo);
                if (!collect || CommentStatus.COMMENT_TOO_FAST.getCode().equals(commentStatus) || !StringUtils.equals(articleType, type)) {
                    csdnUserInfo.setLikeStatus(LikeStatus.UN_PROCESSED.getCode());
                    csdnUserInfo.setCollectStatus(CollectStatus.UN_PROCESSED.getCode());
                    csdnUserInfo.setCommentStatus(CommentStatus.UN_PROCESSED.getCode());
                    csdnUserInfo.setArticleType(type);
                    this.updateById(csdnUserInfo);
                }
            } else {
                csdnUserInfo.setLikeStatus(LikeStatus.UN_PROCESSED.getCode());
                csdnUserInfo.setCollectStatus(CollectStatus.UN_PROCESSED.getCode());
                csdnUserInfo.setCommentStatus(CommentStatus.UN_PROCESSED.getCode());
                csdnUserInfo.setArticleType(type);
                this.updateById(csdnUserInfo);
            }
        }
    }

    @Override
    public void add(CsdnUserInfoQuery addInfo) {
        final String userName = addInfo.getUserName();
        final Integer addType = addInfo.getAddType();
        if (StringUtils.isNotEmpty(userName)) {
            //批量添加
            if (addType == 1) {
                final String[] split = userName.split("\n");
                for (String str : split) {
                    str = str.trim();
                    if (StringUtils.isNotEmpty(str)) {
                        CsdnUserInfo csdnUserInfo = this.getUserByUserName(str);
                        if (csdnUserInfo == null) {
                            csdnUserInfo = new CsdnUserInfo();
                            BeanUtils.copyProperties(addInfo, csdnUserInfo);
                            csdnUserInfo.setUserName(str);
                            csdnUserInfo.setUserHomeUrl("https://blog.csdn.net/" + str);
                            this.save(csdnUserInfo);
                        }
                        addInfo.setNickName(csdnUserInfo.getNickName());
                    }
                }
            } else {
                CsdnUserInfo csdnUserInfo = this.getUserByUserName(userName);
                if (csdnUserInfo == null) {
                    csdnUserInfo = new CsdnUserInfo();
                    BeanUtils.copyProperties(addInfo, csdnUserInfo);
                    csdnUserInfo.setUserHomeUrl("https://blog.csdn.net/" + userName);
                    this.save(csdnUserInfo);
                }
                addInfo.setNickName(csdnUserInfo.getNickName());
            }
        }
    }

    @Override
    public void add10Blog(String username) {
        final CsdnUserInfo csdnUserInfo = this.getUserByUserName(username);
        final List<BusinessInfoResponse.ArticleData.Article> blogs = csdnArticleInfoService.getBlogs(username);
        for (BusinessInfoResponse.ArticleData.Article article : blogs) {
            CsdnArticleInfo csdnArticleInfo = this.csdnArticleInfoService.getArticleByArticleId(article.getArticleId().toString());
            if (Objects.isNull(csdnArticleInfo)) {
                csdnArticleInfo = new CsdnArticleInfo();
                csdnArticleInfo.setArticleId(article.getArticleId().toString());
                csdnArticleInfo.setArticleUrl(article.getUrl());
                csdnArticleInfo.setArticleTitle(article.getTitle());
                csdnArticleInfo.setArticleDescription(article.getDescription());
                csdnArticleInfo.setUserName(username);
                csdnArticleInfo.setNickName(csdnUserInfo.getNickName());
                this.csdnArticleInfoService.saveArticle(csdnArticleInfo);
            }
        }
    }

    @Override
    public void resetUserDayStatus() {
        final List<CsdnUserInfo> allUser = this.getAllUser();
        if (CollectionUtil.isNotEmpty(allUser)) {
            for (CsdnUserInfo csdnUserInfo : allUser) {
                final String userName = csdnUserInfo.getUserName();
                final List<BusinessInfoResponse.ArticleData.Article> articles = csdnArticleInfoService.getArticles(userName);
                if (CollectionUtil.isNotEmpty(articles)) {
                    final BusinessInfoResponse.ArticleData.Article article = articles.get(0);
                    final String type = article.getType();
                    if (StringUtils.equals(type, "blog")) {
                        //看看之前的状态
                        final Integer likeStatus = csdnUserInfo.getLikeStatus();
                        if (!LikeStatus.HAVE_ALREADY_LIKED.getCode().equals(likeStatus) && !LikeStatus.LIKE_SUCCESSFUL.getCode().equals(likeStatus)) {
                            csdnUserInfo.setLikeStatus(LikeStatus.UN_PROCESSED.getCode());
                        }
                        final Integer collectStatus = csdnUserInfo.getCollectStatus();
                        if (!CollectStatus.COLLECT_SUCCESSFUL.getCode().equals(collectStatus) && !CollectStatus.HAVE_ALREADY_COLLECT.getCode().equals(collectStatus)) {
                            csdnUserInfo.setCollectStatus(CollectStatus.UN_PROCESSED.getCode());
                        }
                        final Integer commentStatus = csdnUserInfo.getCommentStatus();
                        if (!CommentStatus.COMMENT_SUCCESSFUL.getCode().equals(commentStatus) && !CommentStatus.HAVE_ALREADY_COMMENT.getCode().equals(commentStatus)) {
                            csdnUserInfo.setCommentStatus(CommentStatus.UN_PROCESSED.getCode());
                        }
                        this.updateById(csdnUserInfo);
                    }
                }
            }
        }
    }
}