package com.kwan.springbootkwan.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.Result;
import com.kwan.springbootkwan.service.CsdnAutoReplyService;
import com.kwan.springbootkwan.service.CsdnService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Objects;

@Slf4j
@RestController
@Api(tags = "csdn三连用户管理")
@RequestMapping("/csdn")
public class CsdnController {

    @Autowired
    private CsdnService csdnService;
    @Autowired
    private CsdnAutoReplyService csdnAutoReplyService;
    @Autowired
    private CsdnUserInfoService csdnUserInfoService;

    @ApiOperation(value = "单人三连", nickname = "单人三连")
    @GetMapping("/singleTriplet")
    public Result singleTriplet(@Param("username") String username) {
        CsdnUserInfo csdnUserInfo = csdnUserInfoService.getUserByUserName(username);
        if (Objects.nonNull(csdnUserInfo)) {
            csdnService.singleArticle(csdnUserInfo);
        }
        return Result.ok("单人三连完成");
    }

    @ApiOperation(value = "多人三连", nickname = "多人三连")
    @PostMapping("/multiTriplet")
    public Result multiTriplet(@RequestBody List<String> userNames) {
        if (CollectionUtil.isNotEmpty(userNames)) {
            for (String userName : userNames) {
                singleTriplet(userName);
            }
        }
        return Result.ok("多人三连完成");
    }

    @ApiOperation(value = "全员三连", nickname = "全员三连")
    @GetMapping("/allTriplet")
    public Result allTriplet() {
        csdnService.allTriplet();
        return Result.ok("全员三连完成");
    }

    @ApiOperation(value = "自动回复", nickname = "自动回复")
    @GetMapping("/autoReply")
    public Result autoReply() {
        csdnAutoReplyService.commentSelf();
        return Result.ok("自动回复完成");
    }

    @ApiOperation(value = "重置全员新博客状态", nickname = "重置全员新博客状态")
    @GetMapping("/resetAllCurrentStatus")
    public Result resetAllCurrentStatus() {
        csdnUserInfoService.resetAllCurrentStatus();
        return Result.ok("重置全员新博客状态完成");
    }

    @ApiOperation(value = "重置指定人员新博客状态", nickname = "重置指定人员新博客状态")
    @GetMapping("/resetCsdnUserInfo")
    public Result resetCsdnUserInfo(@Param("username") String username) {
        CsdnUserInfo csdnUserInfo = csdnUserInfoService.getUserByUserName(username);
        if (Objects.nonNull(csdnUserInfo)) {
            csdnUserInfoService.resetCsdnUserInfo(csdnUserInfo);
        }
        return Result.ok("重置指定人员新博客状态完成");
    }

    @ApiOperation(value = "重置多个人员新博客", nickname = "重置多个人员新博客")
    @PostMapping("/resetCsdnUserInfo")
    public Result resetCsdnUserInfo(@RequestBody List<String> userNames) {
        if (CollectionUtil.isNotEmpty(userNames)) {
            for (String userName : userNames) {
                resetCsdnUserInfo(userName);
            }
        }
        return Result.ok("重置多个人员新博客状态完成");
    }

    @ApiOperation(value = "重置新一天用户状态", nickname = "重置新一天用户状态")
    @GetMapping("/resetUserDayStatus")
    public Result resetUserDayStatus() {
        csdnUserInfoService.resetUserDayStatus();
        return Result.ok("重置新一天用户状态完成");
    }

    @ApiOperation(value = "给指定人员添加10篇博客", nickname = "给指定人员添加10篇博客")
    @GetMapping("/add10Blog")
    public Result add10Blog(@Param("username") String username) {
        csdnUserInfoService.add10Blog(username);
        return Result.ok("给指定人员添加10篇博客完成");
    }

}
