package com.kwan.springbootkwan.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kwan.springbootkwan.entity.CsdnArticleInfo;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.Result;
import com.kwan.springbootkwan.entity.dto.CsdnArticleInfoDTO;
import com.kwan.springbootkwan.entity.query.CsdnArticleInfoQuery;
import com.kwan.springbootkwan.entity.query.CsdnUserInfoQuery;
import com.kwan.springbootkwan.entity.resp.BusinessInfoResponse;
import com.kwan.springbootkwan.service.CsdnArticleInfoService;
import com.kwan.springbootkwan.service.CsdnService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

@Slf4j
@Api(tags = "csdn文章管理")
@RestController
@RequestMapping("/csdnArticleInfo")
public class CsdnArticleInfoController {

    @Resource
    private CsdnService csdnService;
    @Resource
    private CsdnUserInfoService csdnUserInfoService;
    @Resource
    private CsdnArticleInfoService csdnArticleInfoService;

    @ApiOperation(value = "分页查询所有数据", nickname = "分页查询所有数据")
    @PostMapping("/page")
    public Result selectAll(@RequestBody CsdnArticleInfoQuery query) {
        final String articleId = query.getArticleId();
        final String nickName = query.getNickName();
        final String userName = query.getUserName();
        final Integer likeStatus = query.getLikeStatus();
        final Integer collectStatus = query.getCollectStatus();
        final Integer commentStatus = query.getCommentStatus();
        Page<CsdnArticleInfo> pageParm = new Page<>();
        pageParm.setCurrent(query.getPage());
        pageParm.setSize(query.getPageSize());
        QueryWrapper<CsdnArticleInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        if (StringUtils.isNotEmpty(articleId)) {
            wrapper.eq("article_id", articleId);
        }
        if (StringUtils.isNotEmpty(userName)) {
            wrapper.eq("user_name", userName);
        }
        if (Objects.nonNull(likeStatus)) {
            wrapper.eq("like_status", likeStatus);
        }
        if (Objects.nonNull(collectStatus)) {
            wrapper.eq("collect_status", collectStatus);
        }
        if (Objects.nonNull(commentStatus)) {
            wrapper.eq("comment_status", commentStatus);
        }
        if (StringUtils.isNotEmpty(nickName)) {
            wrapper.like("nick_name", nickName);
        }
        wrapper.orderByDesc("update_time");
        return Result.ok(CsdnArticleInfoDTO.Converter.INSTANCE.from(this.csdnArticleInfoService.page(pageParm, wrapper)));
    }

    @ApiOperation(value = "新增文章", nickname = "新增文章")
    @PostMapping("/add")
    public Result add(@RequestBody CsdnArticleInfoQuery addInfo) {
        final String userName = addInfo.getUserName();
        final String articleId = addInfo.getArticleId();
        if (StringUtils.isNotEmpty(userName) && StringUtils.isNotEmpty(articleId)) {
            final List<BusinessInfoResponse.ArticleData.Article> articles = this.csdnArticleInfoService.getBlogs(userName);
            for (BusinessInfoResponse.ArticleData.Article article : articles) {
                if (articleId.equals(article.getArticleId().toString())) {
                    //首先查询用户
                    CsdnUserInfoQuery addUserInfo = new CsdnUserInfoQuery();
                    addUserInfo.setUserName(userName);
                    addUserInfo.setAddType(0);
                    csdnUserInfoService.add(addUserInfo);
                    CsdnArticleInfo csdnArticleInfo = this.csdnArticleInfoService.getArticleByArticleId(articleId);
                    if (csdnArticleInfo == null) {
                        csdnArticleInfo = new CsdnArticleInfo();
                        csdnArticleInfo.setArticleId(articleId);
                        csdnArticleInfo.setUserName(userName);
                        csdnArticleInfo.setArticleTitle(article.getTitle());
                        csdnArticleInfo.setArticleDescription(article.getDescription());
                        csdnArticleInfo.setArticleUrl(article.getUrl());
                        csdnArticleInfo.setNickName(addUserInfo.getNickName());
                        this.csdnArticleInfoService.saveArticle(csdnArticleInfo);
                    }
                    break;
                }
            }
        }
        return Result.ok();
    }

    @ApiOperation(value = "更新用户", nickname = "更新用户")
    @PostMapping("/update")
    public Result update(@RequestBody CsdnArticleInfoQuery query) {
        CsdnArticleInfo csdnUserInfo = new CsdnArticleInfo();
        csdnUserInfo.setId(query.getId());
        csdnUserInfo.setUserName(query.getUserName());
        csdnUserInfo.setNickName(query.getNickName());
        csdnUserInfo.setArticleUrl(query.getArticleUrl());
        csdnUserInfo.setArticleId(query.getArticleId());
        return Result.ok(this.csdnArticleInfoService.updateById(csdnUserInfo));
    }

    @ApiOperation(value = "删除用户", nickname = "删除用户")
    @GetMapping("/delete")
    public Result delete(@RequestParam("id") Integer id) {
        CsdnArticleInfo csdnArticleInfo = new CsdnArticleInfo();
        csdnArticleInfo.setIsDelete(1);
        QueryWrapper<CsdnArticleInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("id", id);
        return Result.ok(this.csdnArticleInfoService.update(csdnArticleInfo, wrapper));
    }

    @ApiOperation(value = "单篇文章三连", nickname = "单篇文章三连")
    @GetMapping("/triplet")
    public Result triplet(@RequestParam("articleId") Integer articleId) {
        final CsdnArticleInfo csdnArticleInfo = this.csdnArticleInfoService.getArticleByArticleId(articleId.toString());
        if (csdnArticleInfo != null) {
            final String userName = csdnArticleInfo.getUserName();
            CsdnUserInfo csdnUserInfo = csdnUserInfoService.getUserByUserName(userName);
            BusinessInfoResponse.ArticleData.Article article = new BusinessInfoResponse.ArticleData.Article();
            article.setDescription(csdnArticleInfo.getArticleDescription());
            article.setTitle(csdnArticleInfo.getArticleTitle());
            article.setUrl(csdnArticleInfo.getArticleUrl());
            csdnService.tripletByArticle(csdnUserInfo, article, csdnArticleInfo);
        }
        return Result.ok("单篇文章三连完成");
    }

    @ApiOperation(value = "多条blog三连", nickname = "多条blog三连")
    @PostMapping("/multiTriplet")
    public Result multiTriplet(@RequestBody List<String> articleIds) {
        if (CollectionUtil.isNotEmpty(articleIds)) {
            for (String articleId : articleIds) {
                triplet(Integer.valueOf(articleId));
            }
        }
        return Result.ok("重置多个人员新博客状态完成");
    }
}