package com.kwan.springbootkwan.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.query.CsdnUserInfoQuery;

import java.util.List;

/**
 * csdn用户信息(CsdnUserInfo)表服务接口
 *
 * @author makejava
 * @since 2023-10-23 16:03:14
 */
public interface CsdnUserInfoService extends IService<CsdnUserInfo> {


    /**
     * 通过用户名获取user信息
     *
     * @return
     */
    CsdnUserInfo getUserByUserName(String username);

    /**
     * 通过用户名获取user信息
     *
     * @return
     */
    List<CsdnUserInfo> getAllUser();


    /**
     * 重置新文章的状态
     */
    void resetAllCurrentStatus();

    /**
     * 重置新一天的状态
     */
    void resetUserDayStatus();

    /**
     * 重置某个人某一天的状态
     *
     * @param csdnUserInfo
     */
    void resetCsdnUserInfo(CsdnUserInfo csdnUserInfo);

    /**
     * 新增用户
     *
     * @param addInfo
     */
    void add(CsdnUserInfoQuery addInfo);

    /**
     * 给指定人员添加10篇博客
     *
     * @param username
     */
    void add10Blog(String username);

}

