package com.kwan.springbootkwan.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.kwan.springbootkwan.entity.CsdnArticleInfo;
import com.kwan.springbootkwan.entity.resp.BusinessInfoResponse;

import java.util.List;

/**
 * csdn文章信息(CsdnArticleInfo)表服务接口
 *
 * @author makejava
 * @since 2023-10-28 01:58:46
 */
public interface CsdnArticleInfoService extends IService<CsdnArticleInfo> {
    /**
     * 通过文章id获取文章信息
     *
     * @return
     */
    CsdnArticleInfo getArticleByArticleId(String articleId);

    /**
     * 保存文章Blog
     *
     * @return
     */
    void saveArticle(CsdnArticleInfo csdnArticleInfo);


    /**
     * 获取最新的10篇文章
     *
     * @param username
     * @return
     */
    List<BusinessInfoResponse.ArticleData.Article> getArticles(String username);

    /**
     * 获取最新的10篇博客(只能是blog类型)
     *
     * @param username
     * @return
     */
    List<BusinessInfoResponse.ArticleData.Article> getBlogs(String username);
}

