package com.kwan.springbootkwan.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.Result;
import com.kwan.springbootkwan.entity.dto.CsdnUserInfoDTO;
import com.kwan.springbootkwan.entity.query.CsdnUserInfoQuery;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

@Slf4j
@Api(tags = "csdn每日三连监控")
@RestController
@RequestMapping("/csdn/user")
public class CsdnUserController {

    @Autowired
    private CsdnUserInfoService csdnUserInfoService;

    @ApiOperation(value = "分页查询所有数据", nickname = "分页查询所有数据")
    @PostMapping("/page")
    public Result selectAll(@RequestBody CsdnUserInfoQuery query) {
        final Integer userWeight = query.getUserWeight();
        final String nickName = query.getNickName();
        final String userName = query.getUserName();
        final String articleType = query.getArticleType();
        final Integer likeStatus = query.getLikeStatus();
        final Integer collectStatus = query.getCollectStatus();
        final Integer commentStatus = query.getCommentStatus();
        Page<CsdnUserInfo> pageParm = new Page<>();
        pageParm.setCurrent(query.getPage());
        pageParm.setSize(query.getPageSize());
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        if (StringUtils.isNotEmpty(userName)) {
            wrapper.eq("user_name", userName);
        }
        if (StringUtils.isNotEmpty(articleType)) {
            wrapper.eq("article_type", articleType);
        }
        if (Objects.nonNull(userWeight)) {
            wrapper.eq("user_weight", userWeight);
        }
        if (Objects.nonNull(likeStatus)) {
            wrapper.eq("like_status", likeStatus);
        }
        if (Objects.nonNull(collectStatus)) {
            wrapper.eq("collect_status", collectStatus);
        }
        if (Objects.nonNull(commentStatus)) {
            wrapper.eq("comment_status", commentStatus);
        }
        if (StringUtils.isNotEmpty(nickName)) {
            wrapper.like("nick_name", nickName);
        }
        wrapper.orderByDesc("update_time");
        return Result.ok(CsdnUserInfoDTO.Converter.INSTANCE.from(this.csdnUserInfoService.page(pageParm, wrapper)));
    }

    @ApiOperation(value = "新增用户", nickname = "新增用户")
    @PostMapping("/add")
    public Result add(@RequestBody CsdnUserInfoQuery addInfo) {
        csdnUserInfoService.add(addInfo);
        return Result.ok();
    }

    @ApiOperation(value = "更新用户", nickname = "更新用户")
    @PostMapping("/update")
    public Result update(@RequestBody CsdnUserInfoQuery query) {
        CsdnUserInfo csdnUserInfo = new CsdnUserInfo();
        csdnUserInfo.setId(query.getId());
        csdnUserInfo.setUserName(query.getUserName());
        csdnUserInfo.setNickName(query.getNickName());
        csdnUserInfo.setUserWeight(query.getUserWeight());
        csdnUserInfo.setUserHomeUrl(query.getUserHomeUrl());
        return Result.ok(this.csdnUserInfoService.updateById(csdnUserInfo));
    }

    @ApiOperation(value = "删除用户", nickname = "删除用户")
    @GetMapping("/delete")
    public Result delete(@RequestParam("id") Integer id) {
        CsdnUserInfo csdnUserInfo = new CsdnUserInfo();
        csdnUserInfo.setIsDelete(1);
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("id", id);
        return Result.ok(this.csdnUserInfoService.update(csdnUserInfo, wrapper));
    }
}