package com.kwan.springbootkwan.annotation;

import org.springframework.core.annotation.AliasFor;
import org.springframework.stereotype.Component;

import java.lang.annotation.*;

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Component
public @interface RedisLock {
    String value() default "";

    @AliasFor("key")
    String name() default "";

    @AliasFor("name")
    String key() default "";

    long expire() default 30000; // 默认锁的过期时间，单位毫秒

    long timeout() default 0; // 默认获取锁的超时时间，单位毫秒

    boolean fair() default false; // 是否使用公平锁
}
