package com.kwan.springbootkwan.entity.dto;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.mapstruct.FromConverter;
import lombok.Data;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.Date;


@Data
public class CsdnUserInfoDTO extends Model<CsdnUserInfoDTO> {
    /**
     * 主键id
     */
    private Integer id;
    /**
     * 用户code
     */
    private String userName;
    /**
     * CSDN用户名称
     */
    private String nickName;
    /**
     * 点赞状态
     */
    private Integer likeStatus;
    /**
     * 收藏状态
     */
    private Integer collectStatus;
    /**
     * 评论状态
     */
    private Integer commentStatus;
    /**
     * 用户权重
     */
    private Integer userWeight;
    /**
     * 文章类型
     */
    private String articleType;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 逻辑删除,0未删除,1已删除
     */
    private Integer isDelete;

    @Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
    public interface Converter extends FromConverter<CsdnUserInfoDTO, CsdnUserInfo> {
        Converter INSTANCE = Mappers.getMapper(Converter.class);
    }
}