package com.kwan.springbootkwan.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


/**
 * 线程池工具类
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/8/17 09:38
 */
public class ThreadPoolUntil {
    private static final int THREAD_POOL_SIZE = 10;
    private static ExecutorService executorService = Executors.newFixedThreadPool(THREAD_POOL_SIZE);

    public static void executeTask(Runnable task) {
        executorService.submit(task);
    }

    public static void shutdown() {
        executorService.shutdown();
    }
}