package com.kwan.springbootkwan.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.Result;
import com.kwan.springbootkwan.enums.CollectStatus;
import com.kwan.springbootkwan.enums.CommentStatus;
import com.kwan.springbootkwan.enums.LikeStatus;
import com.kwan.springbootkwan.service.CsdnCommentService;
import com.kwan.springbootkwan.service.CsdnService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Objects;

@Slf4j
@RestController
@RequestMapping("/csdn")
public class CsdnController {

    @Autowired
    private CsdnService csdnService;
    @Autowired
    private CsdnCommentService csdnCommentService;
    @Autowired
    private CsdnUserInfoService csdnUserInfoService;

    @GetMapping("/singleTriplet")
    public Result singleTriplet(@Param("username") String username) {
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        wrapper.eq("user_name", username).last("limit 1");
        final CsdnUserInfo csdnUserInfo = csdnUserInfoService.getOne(wrapper);
        if (Objects.nonNull(csdnUserInfo)) {
            csdnService.singleArticle(csdnUserInfo);
        }
        return Result.ok("单人三连完成");
    }

    @GetMapping("/multiTriplet")
    public Result multiTriplet() {
        csdnService.multiTriplet();
        return Result.ok("多人三连完成");
    }

    @GetMapping("/autoReply")
    public Result autoReply() {
        csdnCommentService.commentSelf();
        return Result.ok("自动回复完成");
    }

    @GetMapping("/resetCurrentStatus")
    public Result resetCurrentStatus() {
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        final List<CsdnUserInfo> list = csdnUserInfoService.list(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            for (CsdnUserInfo csdnUserInfo : list) {
                csdnUserInfo.setLikeStatus(LikeStatus.UN_PROCESSED.getCode());
                csdnUserInfo.setCollectStatus(CollectStatus.UN_PROCESSED.getCode());
                csdnUserInfo.setCommentStatus(CommentStatus.RESTRICTED_COMMENTS.getCode());
                csdnUserInfoService.updateById(csdnUserInfo);
            }
        }
        return Result.ok("重置当天状态完成");
    }
}
