package com.kwan.springbootkwan.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.resp.BusinessInfoResponse;
import com.kwan.springbootkwan.enums.CommentStatus;
import com.kwan.springbootkwan.service.CsdnArticleService;
import com.kwan.springbootkwan.service.CsdnCollectService;
import com.kwan.springbootkwan.service.CsdnCommentService;
import com.kwan.springbootkwan.service.CsdnLikeService;
import com.kwan.springbootkwan.service.CsdnService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


@Slf4j
@Service
public class CsdnServiceImpl implements CsdnService {

    @Value("${csdn.num_of_articles_per_person}")
    private Integer numOfArticlesPerPerson;

    @Autowired
    private CsdnUserInfoService csdnUserInfoService;
    @Autowired
    private CsdnArticleService csdnArticleService;
    @Autowired
    private CsdnCollectService csdnCollectService;
    @Autowired
    private CsdnCommentService csdnCommentService;
    @Autowired
    private CsdnLikeService csdnLikeService;

    @Override
    public void singleArticle(CsdnUserInfo csdnUserInfo) {
        final String username = csdnUserInfo.getUserName();
        List<BusinessInfoResponse.ArticleData.Article> list = csdnArticleService.getArticles(username);
        if (list == null) {
            return;
        }
        final int size = list.size();
        numOfArticlesPerPerson = size < numOfArticlesPerPerson ? size : numOfArticlesPerPerson;
        for (int i = 0; i < numOfArticlesPerPerson; i++) {
            final BusinessInfoResponse.ArticleData.Article article = list.get(i);
            final String type = article.getType();
            if (!StringUtils.equals("blog", type)) {
                csdnUserInfo.setArticleType(type);
                continue;
            }
            final String urlInfo = article.getUrl();
            String articleId = urlInfo.substring(urlInfo.lastIndexOf("/") + 1);
            //点赞
            final Boolean isLike = csdnLikeService.isLike(articleId, csdnUserInfo);
            if (!isLike) {
                csdnLikeService.like(articleId, csdnUserInfo);
            }
            //查看已经评论总数量
            QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
            wrapper.eq("is_delete", 0);
            wrapper.eq("comment_status", 9);
            final List<CsdnUserInfo> comments = csdnUserInfoService.list(wrapper);
            if (CollectionUtil.isEmpty(comments) || comments.size() < 49) {
                //评论
                final Boolean comment = csdnCommentService.isComment(article, csdnUserInfo);
                if (!comment) {
                    csdnCommentService.comment(articleId, csdnUserInfo);
                }
            }
            if (CollectionUtil.isNotEmpty(comments) && comments.size() >= 49) {
                csdnUserInfo.setCommentStatus(CommentStatus.COMMENT_NUM_49.getCode());
            }
            //收藏
            final Boolean collect = csdnCollectService.isCollect(articleId, csdnUserInfo);
            if (!collect) {
                csdnCollectService.collect(article, csdnUserInfo);
            }
        }
        csdnUserInfo.setUpdateTime(new Date());
        csdnUserInfoService.updateById(csdnUserInfo);
    }


    @Override
    public void multiTriplet() {
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        wrapper.orderByDesc("user_weight");
        final List<CsdnUserInfo> list = csdnUserInfoService.list(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            for (CsdnUserInfo csdnUserInfo : list) {
                singleArticle(csdnUserInfo);
            }
        }
        log.info("全部三连完成");
    }
}