package com.kwan.springbootkwan.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kwan.springbootkwan.entity.resp.BusinessInfoResponse;
import com.kwan.springbootkwan.service.CsdnArticleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;


@Slf4j
@Service
public class CsdnArticleServiceImpl implements CsdnArticleService {

    @Value("${csdn.cookie}")
    private String csdnCookie;
    @Value("${csdn.url.user_article_url}")
    private String url;

    @Override
    public List<BusinessInfoResponse.ArticleData.Article> getArticles(String username) {
        HttpResponse response = HttpUtil.createGet(url)
                .header("Cookie", csdnCookie)
                .form("page", 1)
                .form("size", 5)
                .form("businessType", "lately")
                .form("noMore", false)
                .form("username", username)
                .execute();
        final String body = response.body();
        ObjectMapper objectMapper = new ObjectMapper();
        BusinessInfoResponse businessInfoResponse;
        List<BusinessInfoResponse.ArticleData.Article> list = null;
        try {
            businessInfoResponse = objectMapper.readValue(body, BusinessInfoResponse.class);
            final BusinessInfoResponse.ArticleData data = businessInfoResponse.getData();
            list = data.getList();
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list;
    }
}
