package com.kwan.springbootkwan.schedule;


import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.enums.CollectStatus;
import com.kwan.springbootkwan.enums.CommentStatus;
import com.kwan.springbootkwan.enums.LikeStatus;
import com.kwan.springbootkwan.service.CsdnCommentService;
import com.kwan.springbootkwan.service.CsdnService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;


@Slf4j
@Component
public class CsdnSchedule {

    @Autowired
    private CsdnService csdnService;
    @Autowired
    private CsdnCommentService csdnCommentService;
    @Autowired
    private CsdnUserInfoService csdnUserInfoService;

    @Scheduled(cron = "0 0 8,10,12,14,16,18,20 * * ?")
    public void execute() {
        log.info("execute task is running ... ...");
        csdnService.multiTriplet();
        log.info("execute task is finish ... ...");
    }

    @Scheduled(cron = "0 0/30 0 * * ?")
    public void executeReply() {
        log.info("executeReply task is running ... ...");
        csdnCommentService.commentSelf();
        log.info("executeReply task is finish ... ...");
    }

    @Scheduled(cron = "0 0/30 * * * ?")
    public void executeInit() {
        log.info("executeInit task is running ... ...");
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        final List<CsdnUserInfo> list = csdnUserInfoService.list(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            for (CsdnUserInfo csdnUserInfo : list) {
                csdnUserInfo.setLikeStatus(LikeStatus.UN_PROCESSED.getCode());
                csdnUserInfo.setCollectStatus(CollectStatus.UN_PROCESSED.getCode());
                csdnUserInfo.setCommentStatus(CommentStatus.RESTRICTED_COMMENTS.getCode());
                csdnUserInfoService.updateById(csdnUserInfo);
            }
        }
        log.info("executeInit task is finish ... ...");
    }
}

