package com.kwan.springbootkwan.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kwan.springbootkwan.entity.AdsDimFinancialYearWeekInfo;
import com.kwan.springbootkwan.service.AdsDimFinancialYearWeekInfoService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * (AdsDimFinancialYearWeekInfo)表控制层
 *
 * @author makejava
 * @since 2022-12-22 17:25:11
 */
@RestController
@RequestMapping("adsDimFinancialYearWeekInfo")
public class AdsDimFinancialYearWeekInfoController {
    /**
     * 服务对象
     */
    @Resource
    private AdsDimFinancialYearWeekInfoService adsDimFinancialYearWeekInfoService;

    /**
     * 通过主键查询单条数据
     */
    @GetMapping("/{financialYear}/{financialYearWeek}")
    public List<AdsDimFinancialYearWeekInfo> selectOne(@PathVariable Integer financialYear, @PathVariable Integer financialYearWeek) {
        return this.adsDimFinancialYearWeekInfoService.list(new QueryWrapper<AdsDimFinancialYearWeekInfo>()
                .eq("financial_year", financialYear)
                .eq("financial_year_week", financialYearWeek)
        );
    }
}