package com.kwan.springbootkwan.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kwan.springbootkwan.entity.CsdnArticleInfo;
import com.kwan.springbootkwan.entity.CsdnTripletDayInfo;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.resp.BusinessInfoResponse;
import com.kwan.springbootkwan.enums.CommentStatus;
import com.kwan.springbootkwan.service.CsdnArticleInfoService;
import com.kwan.springbootkwan.service.CsdnCollectService;
import com.kwan.springbootkwan.service.CsdnCommentService;
import com.kwan.springbootkwan.service.CsdnLikeService;
import com.kwan.springbootkwan.service.CsdnService;
import com.kwan.springbootkwan.service.CsdnTripletDayInfoService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;


@Slf4j
@Service
public class CsdnServiceImpl implements CsdnService {

    @Value("${csdn.num_of_articles_per_person}")
    private Integer numOfArticlesPerPerson;
    @Autowired
    private CsdnLikeService csdnLikeService;
    @Autowired
    private CsdnUserInfoService csdnUserInfoService;
    @Autowired
    private CsdnArticleInfoService csdnArticleInfoService;
    @Autowired
    private CsdnCollectService csdnCollectService;
    @Autowired
    private CsdnCommentService csdnCommentService;
    @Autowired
    private CsdnTripletDayInfoService csdnTripletDayInfoService;

    @Override
    public void singleArticle(CsdnUserInfo csdnUserInfo) {
        final String username = csdnUserInfo.getUserName();
        List<BusinessInfoResponse.ArticleData.Article> list = csdnArticleInfoService.getArticles(username);
        if (CollectionUtil.isNotEmpty(list)) {
            final int size = list.size();
            numOfArticlesPerPerson = size < numOfArticlesPerPerson ? size : numOfArticlesPerPerson;
            for (int i = 0; i < numOfArticlesPerPerson; i++) {
                final BusinessInfoResponse.ArticleData.Article article = list.get(i);
                final String type = article.getType();
                if (!StringUtils.equals("blog", type)) {
                    csdnUserInfo.setArticleType(type);
                    csdnUserInfo.setUpdateTime(new Date());
                    csdnUserInfoService.updateById(csdnUserInfo);
                    continue;
                }
                //先去查询文章,没有查到的话就插入文章
                QueryWrapper<CsdnArticleInfo> wrapper = new QueryWrapper<>();
                final String articleUrl = article.getUrl();
                String articleIdFormUrl = articleUrl.substring(articleUrl.lastIndexOf("/") + 1);
                final Object articleId = article.getArticleId();
                if (Objects.isNull(articleId)) {
                    article.setArticleId(articleIdFormUrl);
                }
                wrapper.eq("article_id", article.getArticleId().toString());
                wrapper.eq("is_delete", 0);
                CsdnArticleInfo csdnArticleInfo = this.csdnArticleInfoService.getOne(wrapper);
                if (csdnArticleInfo == null) {
                    csdnArticleInfo = new CsdnArticleInfo();
                    csdnArticleInfo.setArticleId(article.getArticleId().toString());
                    csdnArticleInfo.setArticleUrl(articleUrl);
                    csdnArticleInfo.setArticleTitle(article.getTitle());
                    csdnArticleInfo.setArticleDescription(article.getDescription());
                    csdnArticleInfo.setUserName(username);
                    csdnArticleInfo.setNickName(csdnUserInfo.getNickName());
                    this.csdnArticleInfoService.save(csdnArticleInfo);
                }
                this.tripletByArticle(csdnUserInfo, article, csdnArticleInfo);
            }
        }
    }


    /**
     * 根据文章三连
     *
     * @param csdnUserInfo
     * @param article
     */
    @Override
    public void tripletByArticle(CsdnUserInfo csdnUserInfo, BusinessInfoResponse.ArticleData.Article article, CsdnArticleInfo csdnArticleInfo) {
        //获取每日三连总信息
        final CsdnTripletDayInfo csdnTripletDayInfo = csdnTripletDayInfoService.todayInfo();
        final String urlInfo = article.getUrl();
        String articleId = urlInfo.substring(urlInfo.lastIndexOf("/") + 1);
        //点赞
        final Boolean isLike = csdnLikeService.isLike(articleId, csdnUserInfo);
        if (!isLike) {
            csdnLikeService.like(articleId, csdnUserInfo, csdnTripletDayInfo);
        }
        final Integer commentNum = csdnTripletDayInfo.getCommentNum();
        if (commentNum < 49) {
            //评论
            final Boolean comment = csdnCommentService.isComment(article, csdnUserInfo);
            if (!comment) {
                csdnCommentService.comment(articleId, csdnUserInfo, csdnTripletDayInfo);
            }
        } else {
            csdnUserInfo.setCommentStatus(CommentStatus.COMMENT_NUM_49.getCode());
        }
        //收藏
        final Boolean collect = csdnCollectService.isCollect(articleId, csdnUserInfo);
        if (!collect) {
            csdnCollectService.collect(article, csdnUserInfo, csdnTripletDayInfo);
        }

        csdnTripletDayInfo.setUpdateTime(new Date());
        csdnTripletDayInfoService.updateById(csdnTripletDayInfo);

        csdnUserInfo.setUpdateTime(new Date());
        csdnUserInfoService.updateById(csdnUserInfo);

        csdnArticleInfo.setUpdateTime(new Date());
        csdnArticleInfo.setLikeStatus(csdnUserInfo.getLikeStatus());
        csdnArticleInfo.setCollectStatus(csdnUserInfo.getCollectStatus());
        csdnArticleInfo.setCommentStatus(csdnUserInfo.getCommentStatus());
        csdnArticleInfoService.updateById(csdnArticleInfo);
    }

    @Override
    public void multiTriplet() {
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        wrapper.orderByDesc("user_weight");
        final List<CsdnUserInfo> list = csdnUserInfoService.list(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            for (CsdnUserInfo csdnUserInfo : list) {
                singleArticle(csdnUserInfo);
            }
        }
        log.info("全部三连完成");
    }
}